/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.promotion.visuals.connections;

import com.sas.metadata.promotion.visuals.connections.MetalEnhancedComboBoxUI;
import com.sas.metadata.promotion.visuals.connections.MotifEnhancedComboBoxUI;
import com.sas.metadata.promotion.visuals.connections.WindowsEnhancedComboBoxUI;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JScrollPane;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.plaf.basic.ComboPopup;

public class EnhancedComboBox
extends JComboBox {
    private static final String uiClassID = "EnhancedComboBoxUI";
    public static final int STEPPED_POPUP_STYLE = 5;
    public static final int SCROLLING_POPUP_STYLE = 6;
    private int _popupStyle;

    public EnhancedComboBox() {
        this.initialize();
    }

    public EnhancedComboBox(ComboBoxModel aModel) {
        super(aModel);
        this.initialize();
    }

    public EnhancedComboBox(Object[] items) {
        super(items);
        this.initialize();
    }

    public EnhancedComboBox(Vector items) {
        super(items);
        this.initialize();
    }

    protected void initialize() {
        this._popupStyle = 6;
        this.updateUI();
    }

    @Override
    public void processComponentKeyEvent(KeyEvent e) {
        if (e.getKeyCode() == 40 && e.getID() == 401) {
            if (!this.isPopupVisible()) {
                this.showPopup();
            }
        } else {
            super.processComponentKeyEvent(e);
        }
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    @Override
    public void updateUI() {
        BasicComboBoxUI comboUI = null;
        LookAndFeel lnf = UIManager.getLookAndFeel();
        String lnfName = lnf.getName();
        comboUI = lnfName.equals("Windows") ? new WindowsEnhancedComboBoxUI() : (lnfName.equals("Metal") ? new MetalEnhancedComboBoxUI() : (lnfName.equals("CDE/Motif") ? new MotifEnhancedComboBoxUI() : new MetalEnhancedComboBoxUI()));
        this.setUI(comboUI);
    }

    protected static ComboPopup createPopup(JComboBox comboBox) {
        BasicComboPopup popup = new BasicComboPopup(comboBox){

            @Override
            public void show() {
                int style = 5;
                if (this.comboBox instanceof EnhancedComboBox) {
                    style = ((EnhancedComboBox)this.comboBox).getPopupStyle();
                }
                Dimension popupSize = this.comboBox.getPreferredSize();
                boolean horizontalScrollBarPresent = false;
                if (popupSize.width > this.comboBox.getSize().width && style == 6) {
                    horizontalScrollBarPresent = true;
                }
                if (horizontalScrollBarPresent && this.scroller.getHorizontalScrollBar().getHeight() != 0) {
                    popupSize.setSize(this.comboBox.getSize().width, this.getPopupHeightForRowCount(this.comboBox.getMaximumRowCount()) + this.scroller.getHorizontalScrollBar().getHeight());
                } else {
                    popupSize.setSize(this.comboBox.getSize().width, this.getPopupHeightForRowCount(this.comboBox.getMaximumRowCount()));
                }
                final Rectangle popupBounds = this.computePopupBounds(0, this.comboBox.getBounds().height, popupSize.width, popupSize.height);
                this.scroller.setMaximumSize(popupBounds.getSize());
                this.scroller.setPreferredSize(popupBounds.getSize());
                this.scroller.setMinimumSize(popupBounds.getSize());
                this.list.revalidate();
                int selectedIndex = this.comboBox.getSelectedIndex();
                if (selectedIndex == -1) {
                    this.list.clearSelection();
                } else {
                    this.list.setSelectedIndex(selectedIndex);
                    this.list.ensureIndexIsVisible(selectedIndex);
                }
                if (horizontalScrollBarPresent && this.scroller.getHorizontalScrollBar().getHeight() == 0) {
                    this.setVisible(true);
                    Dimension dims = new Dimension(popupBounds.getSize());
                    dims.height += this.scroller.getHorizontalScrollBar().getHeight();
                    this.scroller.setMaximumSize(dims.getSize());
                    this.scroller.setPreferredSize(dims.getSize());
                    this.scroller.setMinimumSize(dims.getSize());
                    this.list.revalidate();
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        this.show(comboBox, popupBounds.x, popupBounds.y);
                    }
                });
            }

            @Override
            protected JScrollPane createScroller() {
                int style = 5;
                if (this.comboBox instanceof EnhancedComboBox) {
                    style = ((EnhancedComboBox)this.comboBox).getPopupStyle();
                }
                if (style == 6) {
                    JScrollPane scrollPane = new JScrollPane(this.list, 20, 30);
                    return scrollPane;
                }
                return super.createScroller();
            }

            @Override
            protected void configureScroller() {
                int style = 5;
                if (this.comboBox instanceof EnhancedComboBox) {
                    style = ((EnhancedComboBox)this.comboBox).getPopupStyle();
                }
                if (style == 6) {
                    this.scroller.setFocusable(false);
                    this.scroller.getHorizontalScrollBar().setFocusable(false);
                    this.scroller.getVerticalScrollBar().setFocusable(false);
                    this.scroller.setBorder(null);
                } else {
                    super.configureScroller();
                }
            }
        };
        return popup;
    }

    public int getPopupStyle() {
        return this._popupStyle;
    }

    public void setPopupStyle(int popupStyle) {
        if (popupStyle != 5 && popupStyle != 6) {
            return;
        }
        if (this._popupStyle != popupStyle) {
            int oldValue = this._popupStyle;
            this._popupStyle = popupStyle;
            this.firePropertyChange("popupStyle", oldValue, popupStyle);
            this.updateUI();
        }
    }
}

