/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.promotion.visuals.connections;

import com.sas.metadata.promotion.ConnectionPropertiesInterface;
import com.sas.metadata.promotion.DefaultConnectionPropertiesInterface;
import com.sas.metadata.promotion.SourceConnectionInterface;
import com.sas.metadata.promotion.TargetConnectionInterface;
import com.sas.metadata.promotion.visuals.connections.AbstractPropertiesTableModel;
import com.sas.metadata.promotion.visuals.connections.RB;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.PrimaryType;
import java.rmi.RemoteException;
import java.util.Map;

public class ConnectionPropertiesTableModel
extends AbstractPropertiesTableModel {
    private static final String NAME_LABEL = RB.getStringResource("ConnectionPropertiesTableModel.NameLabel.txt");
    private static final String DESC_LABEL = RB.getStringResource("ConnectionPropertiesTableModel.DescLabel.txt");
    private static final String PATH_LABEL = RB.getStringResource("ConnectionPropertiesTableModel.PathLabel.txt");
    private DefaultConnectionPropertiesInterface _properties;

    public ConnectionPropertiesTableModel(DefaultConnectionPropertiesInterface properties) {
        this._properties = properties;
    }

    @Override
    protected void initializeProperties() {
        Map propertyNames;
        this._propertyEntries.put("PROP_NAME", new AbstractPropertiesTableModel.PropertyEntry(NAME_LABEL));
        this._propertyEntries.put("PROP_DESC", new AbstractPropertiesTableModel.PropertyEntry(DESC_LABEL));
        this._propertyEntries.put("PROP_PATH", new AbstractPropertiesTableModel.PropertyEntry(PATH_LABEL));
        if (this._properties instanceof ConnectionPropertiesInterface && (propertyNames = ((ConnectionPropertiesInterface)this._properties).getPropertyNames()) != null && propertyNames.size() > 0) {
            for (String propName : propertyNames.keySet()) {
                this._propertyEntries.put(propName, new AbstractPropertiesTableModel.PropertyEntry((String)propertyNames.get(propName)));
            }
        }
    }

    @Override
    protected void setSourceProperties(Object source) throws MdException, RemoteException {
        if (source instanceof SourceConnectionInterface) {
            this.setSourceProperties((SourceConnectionInterface)source);
        }
    }

    private void setSourceProperties(SourceConnectionInterface source) throws MdException, RemoteException {
        AbstractPropertiesTableModel.PropertyEntry pathEntry;
        AbstractPropertiesTableModel.PropertyEntry descEntry;
        AbstractPropertiesTableModel.PropertyEntry nameEntry;
        Map sourceProperties = null;
        if (this._properties instanceof ConnectionPropertiesInterface) {
            sourceProperties = ((ConnectionPropertiesInterface)this._properties).getSourcePropertyValues(source);
        }
        if (!(sourceProperties != null && sourceProperties.containsKey("PROP_NAME") || (nameEntry = (AbstractPropertiesTableModel.PropertyEntry)this._propertyEntries.get("PROP_NAME")) == null)) {
            nameEntry.setSourceValue(source.getDisplayName());
        }
        if (!(sourceProperties != null && sourceProperties.containsKey("PROP_DESC") || (descEntry = (AbstractPropertiesTableModel.PropertyEntry)this._propertyEntries.get("PROP_DESC")) == null || source.containsMultipleConnectionPoints())) {
            descEntry.setSourceValue(source.getConnectionPoint().getDescription());
        }
        if (!(sourceProperties != null && sourceProperties.containsKey("PROP_PATH") || (pathEntry = (AbstractPropertiesTableModel.PropertyEntry)this._propertyEntries.get("PROP_PATH")) == null)) {
            String path = this.getDisplayablePath(source.getSourcePath(), source.getConnectionPoint().getPublicType());
            pathEntry.setSourceValue(path);
        }
        if (sourceProperties != null) {
            for (String propertyName : sourceProperties.keySet()) {
                AbstractPropertiesTableModel.PropertyEntry entry = (AbstractPropertiesTableModel.PropertyEntry)this._propertyEntries.get(propertyName);
                if (entry == null) continue;
                entry.setSourceValue((String)sourceProperties.get(propertyName));
            }
        }
    }

    @Override
    protected void setTargetProperties(Object target) throws MdException, RemoteException {
        if (target instanceof TargetConnectionInterface) {
            this.setTargetProperties((TargetConnectionInterface)target);
        }
    }

    private void setTargetProperties(TargetConnectionInterface target) throws MdException, RemoteException {
        AbstractPropertiesTableModel.PropertyEntry pathEntry;
        AbstractPropertiesTableModel.PropertyEntry descEntry;
        AbstractPropertiesTableModel.PropertyEntry nameEntry;
        Map targetProperties = null;
        if (this._properties instanceof ConnectionPropertiesInterface) {
            targetProperties = ((ConnectionPropertiesInterface)this._properties).getTargetPropertyValues(target);
        }
        CMetadata meta = target.getMetadataObject();
        if (!(targetProperties != null && targetProperties.containsKey("PROP_NAME") || (nameEntry = (AbstractPropertiesTableModel.PropertyEntry)this._propertyEntries.get("PROP_NAME")) == null)) {
            nameEntry.setTargetValue(target.getDisplayName());
        }
        if (!(targetProperties != null && targetProperties.containsKey("PROP_DESC") || (descEntry = (AbstractPropertiesTableModel.PropertyEntry)this._propertyEntries.get("PROP_DESC")) == null)) {
            descEntry.setTargetValue(meta.getDesc());
        }
        if ((targetProperties == null || !targetProperties.containsKey("PROP_PATH")) && (pathEntry = (AbstractPropertiesTableModel.PropertyEntry)this._propertyEntries.get("PROP_PATH")) != null && meta instanceof PrimaryType) {
            MdObjectStore store = (MdObjectStore)meta.getObjectStore();
            MdFactory factory = store.getFactory();
            String path = factory.getOMIUtil().getObjectPath(store, (PrimaryType)meta, false);
            pathEntry.setTargetValue(path);
        }
        if (targetProperties != null) {
            for (String propertyName : targetProperties.keySet()) {
                AbstractPropertiesTableModel.PropertyEntry entry = (AbstractPropertiesTableModel.PropertyEntry)this._propertyEntries.get(propertyName);
                if (entry == null) continue;
                entry.setTargetValue((String)targetProperties.get(propertyName));
            }
        }
    }

    private String getDisplayablePath(String path, String type) {
        int index;
        String suffix;
        if (path != null && type != null && path.endsWith(suffix = "(" + type + ")") && (index = path.lastIndexOf(suffix)) > -1) {
            return path.substring(0, index);
        }
        return path;
    }
}

