/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.promotion.visuals.connections;

import com.sas.metadata.promotion.ImportOperationInterface;
import com.sas.metadata.promotion.Log;
import com.sas.metadata.promotion.PromptingTypeInterface;
import com.sas.metadata.promotion.visuals.AbstractPromotionPanel;
import com.sas.metadata.promotion.visuals.SuppressibleMessageDialog;
import com.sas.metadata.promotion.visuals.connections.DependentObjectsComponent;
import com.sas.metadata.promotion.visuals.connections.EnhancedComboBox;
import com.sas.metadata.promotion.visuals.connections.PromotionTable;
import com.sas.metadata.promotion.visuals.connections.PromotionTableCellRenderer;
import com.sas.metadata.promotion.visuals.connections.PromptingPanelInterface;
import com.sas.metadata.promotion.visuals.connections.RB;
import com.sas.swing.models.CollectionToComboBoxModelAdapter;
import com.sas.swing.models.MapToTableModelAdapter;
import com.sas.swing.models.SortableTableModelAdapter;
import com.sas.swing.visuals.tableview.DefaultTableCellEditor;
import com.sas.swing.visuals.util.Util;
import com.sas.util.GenericComparator;
import com.sas.util.transforms.IdentityTransform;
import com.sas.util.transforms.ObjectToStringTransform;
import com.sas.util.transforms.TransformException;
import com.sas.util.transforms.TransformInterface;
import com.sas.visuals.AutoSizingGridLayout;
import com.sas.visuals.adapters.EqualSpacePartitioner;
import com.sas.visuals.adapters.ProportionalSpacePartitioner;
import com.sas.visuals.adapters.SpacePartitionerInterface;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WsDescriptionWizardTab;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public abstract class AbstractPromptingPanel
extends WsDescriptionWizardTab
implements PromptingPanelInterface,
ListSelectionListener,
ChangeListener {
    protected static final String NONE_SELECTION = RB.getStringResource("AbstractConnectionPanel.none.txt");
    protected DependentObjectsComponent _dependentComponent;
    protected PromptingTypeInterface _promptingType;
    protected ImportOperationInterface _importOperation;
    protected Log _log;
    protected TransformInterface _tableTransform;
    protected JPanel _mainPanel;
    protected JLabel _sourceLabel;
    protected JLabel _sourceLabelValue;
    protected JLabel _targetLabel;
    protected JLabel _targetLabelValue;
    protected TableCellEditor _cellEditor;
    protected TableCellRenderer _tableRenderer;
    protected DefaultComboBoxModel _comboModel;
    protected PromotionTable _mappingTable;
    protected AbstractTableModel _tableModel;
    protected JTabbedPane _infoTabber;
    protected String _borderLabel;
    protected Border _mappingBorder;
    protected JPanel _mappingPanel;
    protected JPanel _mappingTablePanel;
    protected JPanel _mappingLabelPanel;
    protected JPanel _targetLabelComponentPanel;
    protected EnhancedComboBox _comboBox;
    protected ProportionalSpacePartitioner rowPartitioner;
    protected AutoSizingGridLayout mappingLayout;
    private Map _infoComponentsMap;

    public AbstractPromptingPanel(ImportOperationInterface operation, PromptingTypeInterface type) {
        this._importOperation = operation;
        this._log = operation.getLogger();
        this._promptingType = type;
    }

    public abstract String getHelpTopicSuffix();

    public abstract String getPanelDescription();

    @Override
    public abstract String getPanelTitle();

    public abstract String getPanelBorderLabel();

    public abstract String getDefaultSelectionValue();

    public abstract void setTableSelectionType();

    public String getTableSourceColumnName() {
        return RB.getStringResource("AbstractConnectionPanel.SourceColumn.txt");
    }

    public String getTableTargetColumnName() {
        return RB.getStringResource("AbstractConnectionPanel.TargetColumn.txt");
    }

    @Override
    public String getPanelName() {
        return this._promptingType.getPanelName();
    }

    public final void addInformativeComponent(AbstractPromotionPanel component) {
        Map componentsMap = this.getInformativeComponents();
        if (componentsMap != null) {
            componentsMap.put(component.getLabel(), component);
        }
    }

    public Map getInformativeComponents() {
        if (this._infoComponentsMap == null) {
            this._infoComponentsMap = new LinkedHashMap(2);
        }
        if (this._dependentComponent == null) {
            this._dependentComponent = new DependentObjectsComponent();
            this._infoComponentsMap.put(this._dependentComponent.getLabel(), this._dependentComponent);
        }
        return this._infoComponentsMap;
    }

    public void initialize() {
        this.setDescription(this.getPanelDescription());
        super.initialize();
        this.setHelpProduct("promotion");
        String prefix = this._importOperation.getPromotionType() == 3 ? "pastespec_" : "imp_";
        this.setHelpTopic(prefix + this.getHelpTopicSuffix());
        this._mainPanel = new JPanel();
        this._sourceLabel = new JLabel();
        this._sourceLabelValue = new JLabel();
        this._targetLabel = new JLabel();
        this._targetLabelValue = new JLabel();
        this._infoTabber = new JTabbedPane();
    }

    public void layoutWidgets() {
        super.layoutWidgets();
        this.setLayout(new BorderLayout());
        AutoSizingGridLayout mainLayout = new AutoSizingGridLayout(1, 1, 5, 5, true, true, true);
        mainLayout.setIgnoreSizeOfNonVisibleComponents(true);
        this._mainPanel.setLayout((LayoutManager)mainLayout);
        this._mappingPanel = new JPanel();
        this.mappingLayout = new AutoSizingGridLayout(3, 1, 5, 5, true, true, true);
        this.mappingLayout.setIgnoreSizeOfNonVisibleComponents(true);
        this.rowPartitioner = new ProportionalSpacePartitioner(new double[]{-2.0, 0.5, 0.5}, new int[]{0, 75, 75}, new int[]{Integer.MAX_VALUE, 125, Integer.MAX_VALUE}, true);
        this.mappingLayout.setRowSpacePartitioner((SpacePartitionerInterface)this.rowPartitioner);
        this._mappingPanel.setLayout((LayoutManager)this.mappingLayout);
        this._mappingBorder = Util.getGroupBoxBorder((String)this._borderLabel, (int)0, (int)5, (int)5, (int)5);
        this._mappingPanel.setBorder(this._mappingBorder);
        this._mappingLabelPanel = new JPanel();
        AutoSizingGridLayout mappingLabelLayout = new AutoSizingGridLayout(1, 2, 5, 5, true, true, true);
        mappingLabelLayout.setIgnoreSizeOfNonVisibleComponents(true);
        mappingLabelLayout.setColumnSpacePartitioner((SpacePartitionerInterface)new EqualSpacePartitioner(true));
        this._mappingLabelPanel.setLayout((LayoutManager)mappingLabelLayout);
        JPanel sourceMappingPanel = new JPanel();
        AutoSizingGridLayout sourceMappingLabelLayout = new AutoSizingGridLayout(1, 2, 5, 5, true, true, true);
        sourceMappingLabelLayout.setIgnoreSizeOfNonVisibleComponents(true);
        sourceMappingPanel.setLayout((LayoutManager)sourceMappingLabelLayout);
        sourceMappingPanel.add(this._sourceLabel);
        sourceMappingPanel.add(this._sourceLabelValue);
        JPanel targetMappingPanel = new JPanel();
        AutoSizingGridLayout targetMappingLabelLayout = new AutoSizingGridLayout(1, 2, 5, 5, true, true, true);
        targetMappingLabelLayout.setIgnoreSizeOfNonVisibleComponents(true);
        targetMappingPanel.setLayout((LayoutManager)targetMappingLabelLayout);
        targetMappingPanel.add(this._targetLabel);
        this._targetLabelComponentPanel = new JPanel();
        AutoSizingGridLayout targetLabelComponentLayout = new AutoSizingGridLayout(1, 1, 5, 5, true, true, true);
        targetLabelComponentLayout.setIgnoreSizeOfNonVisibleComponents(true);
        this._targetLabelComponentPanel.setLayout((LayoutManager)targetLabelComponentLayout);
        this._targetLabelComponentPanel.add(this._targetLabelValue);
        targetMappingPanel.add(this._targetLabelComponentPanel);
        this._mappingLabelPanel.add(sourceMappingPanel);
        this._mappingLabelPanel.add(targetMappingPanel);
        this._mappingPanel.add(this._mappingLabelPanel);
        this._mappingTablePanel = new JPanel();
        AutoSizingGridLayout mappingTableLayout = new AutoSizingGridLayout(1, 1, 5, 5, true, true, true);
        mappingTableLayout.setIgnoreSizeOfNonVisibleComponents(true);
        this._mappingTablePanel.setLayout((LayoutManager)mappingTableLayout);
        this._mappingPanel.add(this._mappingTablePanel);
        this._mappingPanel.add(this._infoTabber);
        this._mainPanel.add(this._mappingPanel);
        this.add(this._mainPanel, "Center");
    }

    protected void configureComboBox() {
        this._tableRenderer = this.getTableCellRenderer();
        this._comboBox = new EnhancedComboBox();
        this._comboBox.setPopupStyle(6);
        MappingComboListCellRenderer comboRenderer = new MappingComboListCellRenderer(this.getTargetTableTransform());
        this._comboBox.setRenderer(comboRenderer);
        this._comboModel = new DefaultComboBoxModel();
        this._comboBox.setModel(this._comboModel);
        this._cellEditor = this.getTableCellEditor();
    }

    public boolean doDataExchange(boolean bSaveToModel) throws RemoteException {
        if (!bSaveToModel) {
            this.populatePanel();
        }
        return true;
    }

    protected boolean displayErrorMessage(String message) {
        MessageUtil.displayMessage((String)message, (String)RB.getStringResource("AbstractConnectionPanel.Error.txt"), (int)0, (int)-1);
        return false;
    }

    protected boolean displayWarningMessage(String message) {
        int result = MessageUtil.displayMessage((String)message, (String)RB.getStringResource("AbstractConnectionPanel.Warning.txt"), (int)2, (int)0);
        return result == 0;
    }

    protected boolean displayValidationWarningMessage(String message) {
        return this.displayWarningMessage(message);
    }

    protected boolean displaySuppressibleWarningMessage(String message, String confirmationKey) {
        String confirmationText = RB.getStringResource("AbstractPromptingPanel.DoNotShowAgain.txt");
        int result = SuppressibleMessageDialog.displayWarningDialog(message, confirmationText, confirmationKey, this._importOperation);
        return result == 0;
    }

    protected boolean displaySuppressibleErrorMessage(String message, String confirmationKey) {
        String confirmationText = RB.getStringResource("AbstractPromptingPanel.DoNotShowAgain.txt");
        SuppressibleMessageDialog.displayErrorDialog(message, confirmationText, confirmationKey, this._importOperation);
        return false;
    }

    public abstract Map getMappingsForTarget();

    protected abstract void updateMap(Map var1);

    protected abstract List getTargetValuesList(Object var1);

    public void populatePanel() {
        String borderLabel = this.getPanelBorderLabel();
        this.setBorderLabel(borderLabel);
        String sourceColumnName = this.getTableSourceColumnName();
        String targetColumnName = this.getTableTargetColumnName();
        this._mappingTablePanel.removeAll();
        Map mapping = this.getMappingsForTarget();
        if (mapping != null) {
            this.updateMap(mapping);
            AbstractTableModel model = this.getTableModel();
            if (model == null) {
                this._tableModel = new MapToTableModelAdapter(mapping);
                ((MapToTableModelAdapter)this._tableModel).setColumnName(sourceColumnName, 0);
                ((MapToTableModelAdapter)this._tableModel).setColumnName(targetColumnName, 1);
                ((MapToTableModelAdapter)this._tableModel).setTableEditable(true);
            } else {
                this._tableModel = model;
            }
            if (this._mappingTable == null) {
                this._mappingTable = new PromotionTable();
            }
            this._mappingTable.setPreferredScrollableViewportSize(new Dimension(200, 75));
            this.setTableSelectionType();
            SortableTableModelAdapter sortingModel = new SortableTableModelAdapter((TableModel)this._tableModel);
            MyComparator myComparator = new MyComparator();
            sortingModel.setDefaultComparator((Comparator)((Object)myComparator));
            this._mappingTable.setModel((TableModel)sortingModel);
            int rowCount = this._mappingTable.getRowCount();
            if (rowCount > 0) {
                this._mappingTable.setRowSelectionInterval(0, 0);
            }
            JScrollPane tableScroll = new JScrollPane((Component)((Object)this._mappingTable));
            this._mappingTablePanel.add(tableScroll);
            this._mappingTable.getRowHeader().sizeRowsToFit(false, true);
        }
        this.getInfoTabber().removeAll();
        Map comps = this.getInformativeComponents();
        if (comps != null) {
            Set keyset = comps.keySet();
            int count = 0;
            for (String key : keyset) {
                JPanel tabPanel = new JPanel();
                tabPanel.setLayout((LayoutManager)new AutoSizingGridLayout(1, 1, 5, 5, true, true, true));
                tabPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
                tabPanel.add((JComponent)comps.get(key));
                String label = Util.getLabelWithoutMnemonic((String)key);
                int index = Util.getDisplayedMnemonicIndex((String)key);
                this.getInfoTabber().addTab(label, tabPanel);
                if (index != -1) {
                    int mnemonic = Util.getDisplayedMnemonic((String)key);
                    this.getInfoTabber().setDisplayedMnemonicIndexAt(count, index);
                    this.getInfoTabber().setMnemonicAt(count, mnemonic);
                }
                ++count;
            }
        }
        PromotionTable compToGetFocus = null;
        this._targetLabel.setLabelFor(this._targetLabelValue);
        this._targetLabelComponentPanel.removeAll();
        this._targetLabelComponentPanel.add(this._targetLabelValue);
        compToGetFocus = this.getCurrentMappingTable();
        if (compToGetFocus != null && !this.hasBeenShown()) {
            MappingFocusAdapter focusListener = new MappingFocusAdapter();
            ((Component)((Object)compToGetFocus)).addFocusListener(focusListener);
        }
        int prefSize = 0;
        PromotionTable table = this.getCurrentMappingTable();
        if (table != null) {
            prefSize = table.getPreferredSize().height + table.getTableHeader().getPreferredSize().height + 4;
        }
        this.rowPartitioner = new ProportionalSpacePartitioner(new double[]{-2.0, 0.5, 0.5}, new int[]{0, 75, 75}, new int[]{Integer.MAX_VALUE, Math.max(75, prefSize), Integer.MAX_VALUE}, true);
        this.mappingLayout.setRowSpacePartitioner((SpacePartitionerInterface)this.rowPartitioner);
        if (!this.hasBeenShown()) {
            this._infoTabber.getModel().addChangeListener(this);
            this.updateTab();
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AbstractPromptingPanel.this._mappingTable.getRowModel().getSelectionModel().addListSelectionListener(AbstractPromptingPanel.this);
            }
        });
        this.setHasBeenShown(true);
    }

    protected AbstractTableModel getTableModel() {
        return null;
    }

    protected TableCellEditor getTableCellEditor() {
        if (this._comboBox == null) {
            return null;
        }
        MappingTableEditor editor = new MappingTableEditor(this._comboBox);
        editor.setClickCountToStart(1);
        editor.setTransform(this.getTargetTableTransform());
        editor.setOutputTransform((TransformInterface)IdentityTransform.identityTransform);
        return editor;
    }

    protected TableCellRenderer getTableCellRenderer() {
        PromotionTableCellRenderer renderer = new PromotionTableCellRenderer();
        renderer.setTransform(this.getTargetTableTransform());
        return renderer;
    }

    protected TransformInterface getTargetTableTransform() {
        if (this._tableTransform == null) {
            this._tableTransform = new ObjectToStringTransform();
            ((ObjectToStringTransform)this._tableTransform).setNullString(this.getDefaultSelectionValue());
        }
        return this._tableTransform;
    }

    public JTabbedPane getInfoTabber() {
        return this._infoTabber;
    }

    public JPanel getMainPanel() {
        return this._mainPanel;
    }

    protected void setBorderLabel(String borderLabel) {
        this._borderLabel = borderLabel;
        this._mappingBorder = Util.getGroupBoxBorder((String)this._borderLabel, (int)0, (int)5, (int)5, (int)5);
        this._mappingPanel.setBorder(this._mappingBorder);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e != null && !e.getValueIsAdjusting()) {
            Object source = e.getSource();
            PromotionTable pt = this.getCurrentMappingTable();
            if (pt != null && source == pt.getRowModel().getSelectionModel()) {
                this.updateTab();
            }
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        Object source;
        if (e != null && (source = e.getSource()) == this._infoTabber.getModel()) {
            this.updateTab();
        }
    }

    protected void updateTab() {
        int row;
        PromotionTable table;
        JPanel panel;
        Component comp = this.getInfoTabber().getSelectedComponent();
        if (comp instanceof JPanel && (panel = (JPanel)comp).getComponentCount() > 0 && (comp = panel.getComponent(0)) instanceof AbstractPromotionPanel && (table = this.getCurrentMappingTable()) != null && (row = table.getSelectedRow()) != -1) {
            ((AbstractPromotionPanel)comp).loadComponent(table.getValueAt(row, 0), table.getValueAt(row, 1));
        }
    }

    protected PromotionTable getCurrentMappingTable() {
        return this._mappingTable;
    }

    protected class MappingComboListCellRenderer
    extends DefaultListCellRenderer {
        private TransformInterface _transform;

        public MappingComboListCellRenderer(TransformInterface transform) {
            this._transform = transform;
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (this._transform != null) {
                try {
                    value = this._transform.transform(value);
                }
                catch (TransformException transformException) {
                    // empty catch block
                }
            }
            return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        }

        public TransformInterface getTransform() {
            return this._transform;
        }

        public void setTransform(TransformInterface transform) {
            this._transform = transform;
        }
    }

    class MappingTableEditor
    extends DefaultTableCellEditor {
        private CollectionToComboBoxModelAdapter comboAdapter;

        public MappingTableEditor(JComboBox comboBox) {
            super(comboBox);
            this.comboAdapter = new CollectionToComboBoxModelAdapter();
            comboBox.setModel(this.comboAdapter);
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            List listData = AbstractPromptingPanel.this.getTargetValuesList(table.getValueAt(row, 0));
            this.comboAdapter.setModel((Collection)listData);
            Component comp = super.getTableCellEditorComponent(table, value, isSelected, row, column);
            JComboBox combo = (JComboBox)comp;
            if (listData.contains(value)) {
                combo.setSelectedItem(value);
            } else if (value != null) {
                for (Object availItem : listData) {
                    if (availItem != null && availItem.toString().trim().equals(value.toString().trim())) {
                        combo.setSelectedItem(availItem);
                        break;
                    }
                    if (AbstractPromptingPanel.this.getTargetTableTransform() == null) continue;
                    try {
                        Object transformedValue = AbstractPromptingPanel.this.getTargetTableTransform().transform(availItem);
                        if (transformedValue == null || !transformedValue.toString().trim().equals(value.toString().trim())) continue;
                        combo.setSelectedItem(availItem);
                        break;
                    }
                    catch (TransformException transformException) {
                    }
                }
            } else {
                combo.setSelectedItem(value);
            }
            return combo;
        }
    }

    protected class MyComparator
    extends GenericComparator {
        public int compare(Object a, Object b) {
            int compare = super.compare(a, b);
            if (compare == Integer.MAX_VALUE) {
                Object compA = this.makeObjectsComparable(a);
                Object compB = this.makeObjectsComparable(b);
                if (compA != null && compB != null) {
                    return this.compare(compA, compB);
                }
            }
            return compare;
        }

        private Object makeObjectsComparable(Object a) {
            if (a != null) {
                return a.toString();
            }
            return null;
        }
    }

    class MappingFocusAdapter
    extends FocusAdapter {
        private boolean callRepaint;

        MappingFocusAdapter() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            if (!e.isTemporary() && !this.callRepaint) {
                e.getComponent().repaint();
            }
        }
    }
}

