/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.promotion.visuals.connections;

import com.sas.metadata.promotion.AbstractConnectionType;
import com.sas.metadata.promotion.ConnectionManagerInterface;
import com.sas.metadata.promotion.ConnectionPointInterface;
import com.sas.metadata.promotion.ConnectionSearchInterface;
import com.sas.metadata.promotion.ConnectionTypeInterface;
import com.sas.metadata.promotion.DefaultConnectionPropertiesInterface;
import com.sas.metadata.promotion.DependentConnectionInterface;
import com.sas.metadata.promotion.DependentConnectionMapping;
import com.sas.metadata.promotion.DependentConnectionTypeInterface;
import com.sas.metadata.promotion.ImportOperationInterface;
import com.sas.metadata.promotion.PromotionUtil;
import com.sas.metadata.promotion.SearchCriteria;
import com.sas.metadata.promotion.SourceConnectionInterface;
import com.sas.metadata.promotion.TargetConnectionInterface;
import com.sas.metadata.promotion.ValidationResponse;
import com.sas.metadata.promotion.visuals.VisualsUtil;
import com.sas.metadata.promotion.visuals.connections.AbstractPromptingPanel;
import com.sas.metadata.promotion.visuals.connections.ConnectionPanelInterface;
import com.sas.metadata.promotion.visuals.connections.ConnectionPropertiesComponent;
import com.sas.metadata.promotion.visuals.connections.ConnectionPropertiesTableModel;
import com.sas.metadata.promotion.visuals.connections.RB;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.PrimaryType;
import com.sas.metadata.remote.Root;
import com.sas.services.user.UserContextInterface;
import com.sas.swing.models.MapToTableModelAdapter;
import com.sas.swing.visuals.tableview.DefaultTableCellEditor;
import com.sas.swing.visuals.util.Util;
import com.sas.text.Message;
import com.sas.util.transforms.TransformException;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsUIUtilities;
import com.sas.workspace.models.SimpleObject;
import com.sas.workspace.models.impl.SimpleObjectImpl;
import com.sas.workspace.visuals.objectselector.ObjectSelectorPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public abstract class AbstractConnectionPanel
extends AbstractPromptingPanel
implements ConnectionPanelInterface {
    public static final int SELECTION_TYPE_COMBOBOX = 0;
    public static final int SELECTION_TYPE_OBJECTSELECTOR = 1;
    protected static final String VALUES_KEY = "#VALUES#";
    protected ConnectionTypeInterface _connectionType;
    protected List _connectionPoints;
    protected DependentConnectionInterface _dependentConnection;
    private boolean _dependentConnectionPanel = false;
    protected Comparator _tableComparator;
    protected ConnectionPropertiesComponent _propertiesComponent = null;
    private int _panelCounter = 0;
    private Map _targetMapping;
    protected Map _originalParentMapping;
    protected Map _targetValueMap;
    protected String[] _publicTypes;
    protected ObjectSelectorPanel _selectorPanel;
    protected WAStandardDialog _selectorDialog;
    protected ButtonCellRenderer _selectorRenderer;
    protected ButtonCellEditor _selectorEditor;

    public AbstractConnectionPanel(ImportOperationInterface operation, ConnectionTypeInterface type) {
        super(operation, type);
        this._connectionType = type;
        this._connectionPoints = type.getSourceConnections();
        this.initialize();
        this.layoutWidgets();
    }

    public AbstractConnectionPanel(ImportOperationInterface operation, DependentConnectionTypeInterface type, Integer counter) {
        super(operation, type);
        this._connectionType = type;
        this._panelCounter = counter;
        DependentConnectionMapping map = type.getDependentConnectionMapping();
        this._dependentConnection = map.getDependentConnection(counter);
        this._dependentConnectionPanel = true;
        this.initialize();
        this.layoutWidgets();
    }

    @Override
    public abstract String getHelpTopicSuffix();

    @Override
    public abstract String getPanelDescription();

    @Override
    public abstract String getPanelTitle();

    @Override
    public abstract String getPanelBorderLabel();

    @Override
    public abstract String getDefaultSelectionValue();

    @Override
    public final String getPanelName() {
        if (this._dependentConnectionPanel) {
            return this._connectionType.getPanelName() + "_" + this._panelCounter;
        }
        return super.getPanelName();
    }

    public int getSelectionType() {
        return 0;
    }

    public void setSupportedPublicTypes(String[] types) {
        this._publicTypes = types;
    }

    public Comparator getSourceTargetComparator() {
        return null;
    }

    public void setTargetSelectionValue(SourceConnectionInterface source, TargetConnectionInterface target, boolean override) {
        Map mapping = this._targetMapping;
        if (mapping.containsKey(source)) {
            Object value = this._targetMapping.get(source);
            if (override || value == null) {
                mapping.put(source, target);
                if (this._tableModel != null) {
                    this._targetMapping = new LinkedHashMap(mapping);
                    ((MapToTableModelAdapter)this._tableModel).setModel(this._targetMapping);
                }
                if (this._mappingTable.isEditing()) {
                    this._mappingTable.getCellEditor().cancelCellEditing();
                }
            }
            if (this._targetValueMap != null) {
                this._targetValueMap.clear();
            }
        }
    }

    @Override
    public final ConnectionTypeInterface getConnectionType() {
        return this._connectionType;
    }

    @Override
    public final List getConnectionPoints() {
        return this._connectionPoints;
    }

    @Override
    public void setTableSelectionType() {
        ConnectionSearchInterface search;
        int selectionType = 0;
        selectionType = this._connectionType instanceof ConnectionSearchInterface ? ((search = (ConnectionSearchInterface)((Object)this._connectionType)).isContainedByFolder() ? 1 : 0) : this.getSelectionType();
        if (selectionType == 0) {
            if (this._tableRenderer == null) {
                this.configureComboBox();
            }
            this._mappingTable.setCellRenderer(-1, -1, this._tableRenderer);
            this._mappingTable.setCellEditor(-1, 2, this._cellEditor);
        } else if (selectionType == 1) {
            if (this._selectorRenderer == null) {
                this.configureObjectSelector();
            }
            this._mappingTable.setCellRenderer(-1, 2, this._selectorRenderer);
            this._mappingTable.setCellEditor(-1, 2, (TableCellEditor)((Object)this._selectorEditor));
        } else {
            throw new IllegalArgumentException("Invalid target selection type");
        }
    }

    @Override
    public void initialize() {
        this._targetValueMap = new HashMap();
        super.initialize();
    }

    private void configureObjectSelector() {
        List<SourceConnectionInterface> connections = this._connectionType.getSourceConnections();
        HashSet<String> publicTypeSet = new HashSet<String>(2);
        for (SourceConnectionInterface source : connections) {
            ConnectionPointInterface pt = source.getConnectionPoint();
            String publicType = pt.getPublicType();
            if (publicType == null) continue;
            publicTypeSet.add(publicType);
        }
        if (this._publicTypes != null && this._publicTypes.length > 0) {
            for (int i = 0; i < this._publicTypes.length; ++i) {
                if (publicTypeSet.contains(this._publicTypes[i])) continue;
                publicTypeSet.add(this._publicTypes[i]);
            }
        }
        this._publicTypes = publicTypeSet.toArray(new String[publicTypeSet.size()]);
        this._selectorRenderer = new ButtonCellRenderer();
        this._selectorEditor = new ButtonCellEditor();
        this._selectorEditor.setClickCountToStart(1);
    }

    public boolean validateData() {
        try {
            if (this._targetMapping != null) {
                for (SourceConnectionInterface sourceValue : this._targetMapping.keySet()) {
                    List<ConnectionPointInterface> connections = sourceValue.getConnectionPoints();
                    int len = connections.size();
                    for (int i = 0; i < len; ++i) {
                        ConnectionPointInterface pt = connections.get(i);
                        pt.setTargetID(null);
                        pt.setTargetPath(null);
                    }
                    Object targetValue = this._targetMapping.get(sourceValue);
                    if (targetValue == null) {
                        if (this._connectionType.isConnectionRequired(sourceValue)) {
                            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"AbstractConnectionPanel.SelectTarget.fmt.txt", (Object)this._connectionType.getLocalizedTypeName());
                            this.displayErrorMessage(msg);
                            return false;
                        }
                        this._connectionType.addConnectionMapping(sourceValue, null);
                    } else if (targetValue instanceof TargetConnectionInterface) {
                        TargetConnectionInterface target = (TargetConnectionInterface)targetValue;
                        boolean mapped = false;
                        int len2 = connections.size();
                        for (int i = 0; i < len2; ++i) {
                            ConnectionPointInterface pt = connections.get(i);
                            String targetID = this._connectionType.getTargetConnectionID(pt, target);
                            if (targetID == null) continue;
                            mapped = true;
                            pt.setTargetID(targetID);
                            CMetadata meta = target.getMetadataObject();
                            if (!(meta instanceof PrimaryType) || !PromotionUtil.isTypeContainedByFolder(((PrimaryType)meta).getPublicType())) continue;
                            MdFactory factory = this._importOperation.getMetadataFactory();
                            MdObjectStore store = this._importOperation.getStore();
                            String path = factory.getOMIUtil().getObjectPath(store, (PrimaryType)meta, true);
                            if (path == null || path.length() <= 0) continue;
                            pt.setTargetPath(path);
                        }
                        if (mapped) {
                            this._connectionType.addConnectionMapping(sourceValue, target);
                        }
                    } else if (targetValue instanceof String && targetValue.equals(NONE_SELECTION)) {
                        this._connectionType.addConnectionMapping(sourceValue, null);
                    }
                    ConnectionManagerInterface manager = this._importOperation.getConnectionManager();
                    ValidationResponse response = manager.validateConnection(this._importOperation, sourceValue);
                    boolean result = true;
                    switch (response.getReturnCode()) {
                        case 0: {
                            break;
                        }
                        case 1: {
                            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"AbstractConnectionPanel.WarningWithContinue.fmt.txt", (Object)response.getMessage());
                            result = this.displayValidationWarningMessage(msg);
                            if (result) break;
                            return result;
                        }
                        case 2: {
                            result = this.displayErrorMessage(response.getMessage());
                            return result;
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            this.displayErrorMessage(e.getLocalizedMessage());
            return false;
        }
        return true;
    }

    public String getDependentSourceValue() {
        if (this._dependentConnectionPanel) {
            SourceConnectionInterface dependentConnection = this._dependentConnection.getDependentConnection();
            return dependentConnection.getDisplayName();
        }
        return null;
    }

    public String getDependentTargetValue() {
        if (this._dependentConnectionPanel) {
            TargetConnectionInterface target;
            SourceConnectionInterface dependentConnection = this._dependentConnection.getDependentConnection();
            ConnectionTypeInterface dependentType = ((DependentConnectionTypeInterface)this._connectionType).getDependentType();
            if (dependentType != null && (target = dependentType.getTargetConnection(dependentConnection)) != null) {
                return target.getDisplayName();
            }
            return "";
        }
        return null;
    }

    public String getDependentSourceLabel() {
        if (this._connectionType instanceof DependentConnectionTypeInterface) {
            String typeName = ((DependentConnectionTypeInterface)this._connectionType).getDependentType().getLocalizedTypeName();
            return Message.format((ResourceBundle)RB.getResources(), (String)"AbstractConnectionPanel.OriginalLabelWithType.txt", (Object)typeName);
        }
        return RB.getStringResource("AbstractConnectionPanel.original.txt");
    }

    public String getDependentTargetLabel() {
        if (this._connectionType instanceof DependentConnectionTypeInterface) {
            String typeName = ((DependentConnectionTypeInterface)this._connectionType).getDependentType().getLocalizedTypeName();
            return Message.format((ResourceBundle)RB.getResources(), (String)"AbstractConnectionPanel.TargetLabelWithType.txt", (Object)typeName);
        }
        return RB.getStringResource("AbstractConnectionPanel.target.txt");
    }

    @Override
    public Map getMappingsForTarget() {
        if (this._targetMapping == null) {
            this._targetMapping = new LinkedHashMap();
            List connections = null;
            connections = this._dependentConnectionPanel ? this._dependentConnection.getChildConnections() : this._connectionPoints;
            if (connections != null) {
                for (Object obj : connections) {
                    if (!(obj instanceof SourceConnectionInterface)) continue;
                    SourceConnectionInterface source = (SourceConnectionInterface)obj;
                    this._targetMapping.put(source, null);
                }
            }
        }
        return this._targetMapping;
    }

    @Override
    protected List getTargetValuesList(Object sourceKey) {
        SourceConnectionInterface parentSource;
        if (!this._dependentConnectionPanel && this._targetValueMap.containsKey(VALUES_KEY)) {
            return (List)this._targetValueMap.get(VALUES_KEY);
        }
        if (this._dependentConnectionPanel) {
            TargetConnectionInterface parentTarget;
            parentSource = this._dependentConnection.getDependentConnection();
            ConnectionTypeInterface dependentType = ((DependentConnectionTypeInterface)this._connectionType).getDependentType();
            if (dependentType != null && this._targetValueMap.containsKey(parentTarget = dependentType.getTargetConnection(parentSource))) {
                return (List)this._targetValueMap.get(parentTarget);
            }
        }
        try {
            if (this._dependentConnectionPanel) {
                parentSource = this._dependentConnection.getDependentConnection();
                List values = ((DependentConnectionTypeInterface)this._connectionType).getTargetValues(parentSource);
                this.sortTargetValues(values);
                ConnectionTypeInterface dependentType = ((DependentConnectionTypeInterface)this._connectionType).getDependentType();
                if (dependentType != null) {
                    TargetConnectionInterface parentTarget = dependentType.getTargetConnection(parentSource);
                    this._targetValueMap.put(parentTarget, values);
                }
                return values;
            }
            List<TargetConnectionInterface> values = this._connectionType.getTargetConnections();
            this.sortTargetValues(values);
            this._targetValueMap.put(VALUES_KEY, values);
            return values;
        }
        catch (Exception e) {
            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"AbstractConnectionPanel.RetrieveTargetValues.Error.txt", (Object)e.getLocalizedMessage());
            this.displayErrorMessage(msg);
            this._importOperation.getLogger().error(msg);
            return new ArrayList();
        }
    }

    protected void sortTargetValues(List values) {
        if (values == null || values.size() <= 1) {
            return;
        }
        Comparator comp = new Comparator(){

            public int compare(Object obj1, Object obj2) {
                String name1 = null;
                if (obj1 instanceof TargetConnectionInterface) {
                    name1 = ((TargetConnectionInterface)obj1).getDisplayName();
                }
                if (name1 == null) {
                    return -1;
                }
                String name2 = null;
                if (obj2 instanceof TargetConnectionInterface) {
                    name2 = ((TargetConnectionInterface)obj2).getDisplayName();
                }
                if (name2 == null) {
                    return 1;
                }
                return name1.compareToIgnoreCase(name2);
            }
        };
        Collections.sort(values, comp);
    }

    @Override
    public void populatePanel() {
        if (this.shouldResetTargetSelections()) {
            this._targetMapping = null;
        }
        if (this._connectionType instanceof DefaultConnectionPropertiesInterface) {
            ConnectionPropertiesTableModel model = new ConnectionPropertiesTableModel((DefaultConnectionPropertiesInterface)((Object)this._connectionType));
            this._propertiesComponent = new ConnectionPropertiesComponent(model);
            this.addInformativeComponent(this._propertiesComponent);
        }
        String sourceValue = this.getDependentSourceValue();
        this.setDependentSourceLabel(this.getDependentSourceLabel());
        this.setDependentSourceValue(sourceValue);
        this.setDependentTargetLabel(this.getDependentTargetLabel());
        this.setDependentTargetValue(this.getDependentTargetValue());
        if (sourceValue == null) {
            this.setDependentLabelsVisible(false);
        } else {
            this.setDependentLabelsVisible(true);
        }
        this._tableComparator = this.getSourceTargetComparator();
        super.populatePanel();
        if (this._connectionType instanceof DependentConnectionTypeInterface) {
            String borderLabel = this.getPanelBorderLabel();
            int size = ((DependentConnectionTypeInterface)this._connectionType).getDependentConnectionMapping().size();
            if (size > 1) {
                String formattedName;
                String type = ((DependentConnectionTypeInterface)this._connectionType).getDependentType().getLocalizedTypeName();
                borderLabel = formattedName = Message.format((String)RB.getStringResource("AbstractConnectionPanel.PanelDisplayCount.fmt.txt"), (Object)borderLabel, (Object)type, (Object)(this._panelCounter + 1), (Object)size);
            }
            this.setBorderLabel(borderLabel);
        }
    }

    protected boolean shouldResetTargetSelections() {
        boolean reset = false;
        if (this._connectionType instanceof DependentConnectionTypeInterface) {
            ConnectionTypeInterface parentType = ((DependentConnectionTypeInterface)this._connectionType).getDependentType();
            Map<SourceConnectionInterface, TargetConnectionInterface> parentTargetMapping = parentType.getConnectionMapping();
            if (this._originalParentMapping == null) {
                reset = true;
            } else {
                boolean changesMade = this.compareTargetMappings(this._originalParentMapping, parentTargetMapping);
                if (changesMade) {
                    reset = true;
                }
            }
            if (parentTargetMapping != null) {
                this._originalParentMapping = new LinkedHashMap<SourceConnectionInterface, TargetConnectionInterface>(parentTargetMapping);
            }
        }
        return reset;
    }

    protected boolean compareTargetMappings(Map originalMapping, Map newMapping) {
        if (originalMapping == null || newMapping == null || this._originalParentMapping == null) {
            return true;
        }
        for (SourceConnectionInterface sourceValue : newMapping.keySet()) {
            Object targetValue = newMapping.get(sourceValue);
            if (this._originalParentMapping.containsKey(sourceValue)) {
                Object originalTarget = originalMapping.get(sourceValue);
                if (originalTarget == null && targetValue == null || originalTarget == null || originalTarget.equals(targetValue)) continue;
                return true;
            }
            return true;
        }
        return false;
    }

    private void setDependentSourceLabel(String sourceLabel) {
        this._sourceLabel.setText(sourceLabel);
    }

    private void setDependentSourceValue(String sourceLabelValue) {
        this._sourceLabelValue.setText(sourceLabelValue);
    }

    private void setDependentTargetLabel(String targetLabel) {
        Util.configureMnemonicForLabel((JLabel)this._targetLabel, (String)targetLabel);
    }

    private void setDependentTargetValue(String targetLabelValue) {
        this._targetLabelValue.setText(targetLabelValue);
    }

    private void setDependentLabelsVisible(boolean visible) {
        this._mappingLabelPanel.setVisible(visible);
    }

    protected TargetConnectionInterface getTargetValue(SearchCriteria criteria) {
        TargetConnectionInterface target = null;
        try {
            ConnectionManagerInterface manager = this._importOperation.getConnectionManager();
            target = manager.searchForTargetConnection(this._importOperation, criteria);
        }
        catch (Exception e) {
            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"AbstractConnectionPanel.RetrieveTargetValues.Error.txt", (Object)e.getLocalizedMessage());
            this.displayErrorMessage(msg);
            this._importOperation.getLogger().error(msg);
        }
        return target;
    }

    private void setTargetValues(ConnectionSearchInterface search, Map sourceTargetMap) {
        ConnectionManagerInterface manager = this._importOperation.getConnectionManager();
        boolean error = false;
        for (Object sourceValue : sourceTargetMap.keySet()) {
            Object targetValue = sourceTargetMap.get(sourceValue);
            if (targetValue != null || !(sourceValue instanceof SourceConnectionInterface)) continue;
            SourceConnectionInterface source = (SourceConnectionInterface)sourceValue;
            try {
                SearchCriteria criteria = search.generateSearchCriteria(source, source.getDisplayName());
                TargetConnectionInterface target = manager.searchForTargetConnection(this._importOperation, criteria);
                if (target == null) continue;
                sourceTargetMap.put(source, target);
            }
            catch (Exception e) {
                error = true;
                String msg = Message.format((ResourceBundle)RB.getResources(), (String)"AbstractConnectionPanel.RetrieveTargetValues.Error.txt", (Object)e.getLocalizedMessage());
                this._importOperation.getLogger().error(msg);
            }
        }
        if (error) {
            String msg = RB.getStringResource("AbstractConnectionPanel.MappingFailure.txt");
            VisualsUtil.displayMessageDialog(RB.getStringResource("Common.ImportError.txt"), msg, 0);
        }
    }

    @Override
    protected void updateMap(Map map) {
        if (map != null) {
            if (this._connectionType instanceof ConnectionSearchInterface) {
                ConnectionSearchInterface search = (ConnectionSearchInterface)((Object)this._connectionType);
                this.setTargetValues(search, map);
            } else {
                Set keys = map.keySet();
                block2: for (Object sourceValue : keys) {
                    List availableItems;
                    Object targetValue = map.get(sourceValue);
                    if (targetValue != null || (availableItems = this.getTargetValuesList(sourceValue)) == null) continue;
                    if (availableItems.contains(sourceValue)) {
                        map.put(sourceValue, sourceValue);
                        continue;
                    }
                    String sourceValueString = sourceValue.toString().trim();
                    boolean foundMatch = false;
                    for (Object availItem : availableItems) {
                        if (this._tableComparator != null) {
                            if (this._tableComparator.compare(sourceValue, availItem) != 0) continue;
                            foundMatch = true;
                            map.put(sourceValue, availItem);
                            break;
                        }
                        if (availItem != null && availItem.toString().trim().equals(sourceValueString)) {
                            foundMatch = true;
                            map.put(sourceValue, availItem);
                            break;
                        }
                        if (this.getTargetTableTransform() == null) continue;
                        try {
                            Object transformedValue = this.getTargetTableTransform().transform(availItem);
                            if (transformedValue == null || !transformedValue.toString().trim().equals(sourceValueString)) continue;
                            foundMatch = true;
                            map.put(sourceValue, availItem);
                            break;
                        }
                        catch (TransformException transformException) {
                        }
                    }
                    if (this._tableComparator == null || foundMatch) continue;
                    for (Object availItem : availableItems) {
                        if (availItem == null || !availItem.toString().trim().equals(sourceValueString)) continue;
                        map.put(sourceValue, availItem);
                        continue block2;
                    }
                }
            }
        }
    }

    protected Object openObjectSelector(Object value) {
        UserContextInterface user = Workspace.getWorkspace().getUserContext();
        this._selectorPanel = new ObjectSelectorPanel(user, -1, null, true);
        this._selectorPanel.setSelectionOptional(true);
        this._selectorPanel.setSelectableTypes(this._publicTypes);
        this._selectorPanel.setVisibleTypes(this._publicTypes);
        this._selectorPanel.setInventoryTypes(this._publicTypes);
        this._selectorPanel.setAdditionalHierarchyModel(null);
        if (value instanceof TargetConnectionInterface) {
            TargetConnectionInterface targetValue = (TargetConnectionInterface)value;
            String targetID = targetValue.getTargetID();
            String metadataType = targetValue.getMetadataType();
            if (targetID != null && metadataType != null) {
                MdFactory factory = this._importOperation.getMetadataFactory();
                try {
                    Map objectMap = factory.getOMIUtil().getMetadataNoCache(metadataType, targetID, null, 8);
                    if (objectMap != null) {
                        String name = (String)objectMap.get("Name");
                        String publicType = (String)objectMap.get("PublicType");
                        if (publicType != null) {
                            SimpleObjectImpl selected = new SimpleObjectImpl(name, targetID, metadataType, publicType);
                            this._selectorPanel.setSelectedObject((SimpleObject)selected);
                        }
                    }
                }
                catch (Exception objectMap) {
                    // empty catch block
                }
            }
        }
        String sImportDialogTitle = Message.format((ResourceBundle)RB.getResources(), (String)"AbstractConnectionPanel.ObjectSelectorTitle.fmt.txt", (Object)this._connectionType.getLocalizedTypeName());
        this._selectorDialog = new WAStandardDialog((Frame)Workspace.getWorkspace(), sImportDialogTitle, true, (WAPanel)this._selectorPanel);
        this._selectorDialog.setResizable(true);
        this._selectorDialog.setHelpProduct("promotion");
        this._selectorDialog.setHelpTopic("selecttargetobjectwin");
        this._selectorDialog.show();
        if (this._selectorDialog.getReturnValue() == 1) {
            SimpleObject o = this._selectorPanel.getSelectedObject();
            if (o != null && o instanceof SimpleObject) {
                SimpleObject targetObject = o;
                if (this._connectionType instanceof AbstractConnectionType) {
                    TargetConnectionInterface target = null;
                    try {
                        MdFactory factory = this._importOperation.getMetadataFactory();
                        CMetadata meta = factory.getOMIUtil().getMetadataAllDepths((MdStore)this._importOperation.getStore(), targetObject.getMetadataType(), targetObject.getID(), null, null, "", 8);
                        target = ((AbstractConnectionType)this._connectionType).createTargetConnection(meta, targetObject.getName());
                    }
                    catch (Exception e) {
                        String msg = Message.format((ResourceBundle)RB.getResources(), (String)"AbstractConnectionPanel.RetrieveTargetValue.Error.fmt.txt", (Object)targetObject.getName(), (Object)e.getLocalizedMessage());
                        VisualsUtil.displayMessageDialog(RB.getStringResource("Common.ImportError.txt"), msg, 0);
                    }
                    return target;
                }
            }
            return NONE_SELECTION;
        }
        return null;
    }

    class ButtonCellEditor
    extends DefaultTableCellEditor {
        Object m_Value;
        int m_iRow;
        int m_iCol;
        JLabel m_lblEditor = new JLabel();
        JButton m_btnBrowse = WsUIUtilities.createBrowseButton();
        JPanel m_pnlEditor = new JPanel();

        ButtonCellEditor() {
            this.m_lblEditor.setOpaque(true);
            this.m_lblEditor.setBackground(SystemColor.window);
            this.m_lblEditor.setForeground(SystemColor.windowText);
            this.m_btnBrowse.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Object value = AbstractConnectionPanel.this.openObjectSelector(ButtonCellEditor.this.m_Value);
                    if (value != null) {
                        ButtonCellEditor.this.m_Value = value;
                        if (ButtonCellEditor.this.m_Value instanceof TargetConnectionInterface) {
                            TargetConnectionInterface target = (TargetConnectionInterface)ButtonCellEditor.this.m_Value;
                            ButtonCellEditor.this.m_lblEditor.setText(target.getDisplayName());
                        } else {
                            ButtonCellEditor.this.m_lblEditor.setText((String)ButtonCellEditor.this.m_Value);
                        }
                        AbstractConnectionPanel.this._mappingTable.setValueAt(ButtonCellEditor.this.m_Value, ButtonCellEditor.this.m_iRow, ButtonCellEditor.this.m_iCol);
                        AbstractConnectionPanel.this.updateTab();
                    }
                }
            });
            this.m_pnlEditor.setLayout(new BorderLayout());
            this.m_pnlEditor.add((Component)this.m_lblEditor, "Center");
            this.m_pnlEditor.add((Component)this.m_btnBrowse, "East");
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean flag, int row, int column) {
            this.m_Value = value;
            this.m_iRow = row;
            this.m_iCol = column;
            String sText = AbstractPromptingPanel.NONE_SELECTION;
            if (value != null) {
                if (value instanceof String) {
                    sText = (String)value;
                } else if (value instanceof TargetConnectionInterface) {
                    TargetConnectionInterface target = (TargetConnectionInterface)value;
                    sText = target.getDisplayName();
                } else if (value instanceof Root) {
                    try {
                        sText = ((Root)value).getName();
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                }
            }
            this.m_lblEditor.setText(sText);
            return this.m_pnlEditor;
        }

        public Object getCellEditorValue() {
            return this.m_Value;
        }
    }

    class ButtonCellRenderer
    implements TableCellRenderer {
        JPanel m_pnlRenderer = new JPanel();
        JLabel m_lblRenderer = new JLabel();
        JButton m_btnBrowse = WsUIUtilities.createBrowseButton();

        ButtonCellRenderer() {
            this.m_lblRenderer.setOpaque(true);
            this.m_lblRenderer.setBackground(SystemColor.window);
            this.m_lblRenderer.setForeground(SystemColor.windowText);
            this.m_pnlRenderer.setLayout(new BorderLayout());
            this.m_pnlRenderer.add((Component)this.m_lblRenderer, "Center");
            this.m_pnlRenderer.add((Component)this.m_btnBrowse, "East");
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            String sLabel = AbstractPromptingPanel.NONE_SELECTION;
            Object myValue = table.getValueAt(row, column);
            if (myValue != null) {
                if (myValue instanceof String) {
                    sLabel = (String)myValue;
                } else if (myValue instanceof TargetConnectionInterface) {
                    TargetConnectionInterface target = (TargetConnectionInterface)myValue;
                    sLabel = target.getDisplayName();
                }
            }
            this.m_lblRenderer.setText(sLabel);
            return this.m_pnlRenderer;
        }
    }
}

