/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.promotion.visuals;

import com.sas.metadata.promotion.PromotionInterface;
import com.sas.metadata.promotion.PromotionUtil;
import com.sas.metadata.promotion.visuals.AbstractTreePanel;
import com.sas.metadata.promotion.visuals.ErrorTrackingManager;
import com.sas.metadata.promotion.visuals.Images;
import com.sas.metadata.promotion.visuals.LogViewerDialog;
import com.sas.metadata.promotion.visuals.RB;
import com.sas.metadata.promotion.visuals.TreeNodeInterface;
import com.sas.swing.visuals.CheckBoxTree;
import com.sas.swing.visuals.util.Util;
import com.sas.text.Message;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WATextArea;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsFlatButton;
import com.sas.workspace.WsUIUtilities;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class VisualsUtil {
    private static final Insets BUTTON_MARGIN = new Insets(2, 2, 2, 2);
    private static String _previousPackageFileName = "";

    protected static void setPreviousPackageFileName(String fileName) {
        _previousPackageFileName = fileName;
    }

    protected static String getPreviousPackageFileName() {
        return _previousPackageFileName;
    }

    public static JButton createSelectAllButton(WsAbstractAction action) {
        return VisualsUtil.createSelectAllButton(RB.getStringResource("AbstractTreePanel.SelectAll.Mnemonic.txt"), action);
    }

    public static JButton createSelectAllButton(String name, WsAbstractAction action) {
        ImageIcon selectIcon = Images.getImageIcon(AbstractTreePanel.class, RB.getStringResource("AbstractTreePanel.Select.Icon.image"));
        JButton selectAllButton = WsUIUtilities.createFlatTextIconButton((WsAbstractAction)action);
        VisualsUtil.configureButton(selectAllButton, selectIcon, RB.getStringResource("AbstractTreePanel.SelectAll.txt"), name);
        return selectAllButton;
    }

    public static JButton createClearAllButton(WsAbstractAction action) {
        return VisualsUtil.createClearAllButton(RB.getStringResource("AbstractTreePanel.ClearAll.Mnemonic.txt"), action);
    }

    public static JButton createClearAllButton(String name, WsAbstractAction action) {
        ImageIcon clearIcon = Images.getImageIcon(AbstractTreePanel.class, RB.getStringResource("AbstractTreePanel.Clear.Icon.image"));
        JButton clearAllButton = WsUIUtilities.createFlatTextIconButton((WsAbstractAction)action);
        VisualsUtil.configureButton(clearAllButton, clearIcon, RB.getStringResource("AbstractTreePanel.ClearAll.txt"), name);
        return clearAllButton;
    }

    public static JButton createRolloverButton(String name, Icon icon, String tooltip) {
        WsFlatButton rolloverButton = new WsFlatButton();
        VisualsUtil.configureButton((AbstractButton)rolloverButton, icon, tooltip, name);
        return rolloverButton;
    }

    public static void configureButton(AbstractButton button, Icon icon, String tooltip, String name) {
        button.setIcon(icon);
        button.setFocusable(false);
        button.setMargin(BUTTON_MARGIN);
        if (tooltip != null && tooltip.length() > 0) {
            button.setToolTipText(tooltip);
        }
        if (name != null) {
            Util.configureMnemonicForButton((AbstractButton)button, (String)name);
        }
    }

    public static void selectTreeNodes(CheckBoxTree tree) {
        DefaultTreeModel model = (DefaultTreeModel)tree.getModel();
        if (model != null && model.getRoot() != null) {
            TreePath path = new TreePath(model.getRoot());
            tree.checkChildren(path, true, true);
        }
    }

    public static void clearTreeNodes(CheckBoxTree tree) {
        DefaultTreeModel model = (DefaultTreeModel)tree.getModel();
        if (model != null && model.getRoot() != null) {
            TreePath path = new TreePath(model.getRoot());
            tree.checkChildren(path, false, true);
        }
    }

    public static void expandTreeNodes(CheckBoxTree tree) {
        VisualsUtil.expandTreeNodes(tree, -1);
    }

    public static void expandTreeNodes(CheckBoxTree tree, int expandLevel) {
        tree.removeTreeExpansionListener((TreeExpansionListener)tree);
        tree.removeTreeWillExpandListener((TreeWillExpandListener)tree);
        VisualsUtil.expandAllFolderNodes((JTree)tree);
        tree.getCheckedModel().resetRowSelection();
        tree.addTreeExpansionListener((TreeExpansionListener)tree);
        tree.addTreeWillExpandListener((TreeWillExpandListener)tree);
    }

    private static void expandAllFolderNodes(JTree tree) {
        for (int row = 0; row < tree.getRowCount(); ++row) {
            TreeNodeInterface node;
            TreePath tp;
            Object obj;
            if (!tree.isCollapsed(row) || !((obj = (tp = tree.getPathForRow(row)).getLastPathComponent()) instanceof TreeNodeInterface) || !(node = (TreeNodeInterface)obj).isFolder() && !node.isVirtualFolder()) continue;
            tree.expandRow(row);
        }
    }

    public static void collapseTreeNodes(CheckBoxTree tree) {
        int startIndex;
        tree.removeTreeExpansionListener((TreeExpansionListener)tree);
        tree.removeTreeWillExpandListener((TreeWillExpandListener)tree);
        boolean change = false;
        int n = startIndex = !tree.isRootVisible() && tree.getShowsRootHandles() ? 0 : 1;
        for (int row = tree.getRowCount() - 1; row >= startIndex; --row) {
            if (!tree.isExpanded(row)) continue;
            tree.collapseRow(row);
            change = true;
        }
        if (change) {
            tree.getCheckedModel().resetRowSelection();
        }
        tree.addTreeExpansionListener((TreeExpansionListener)tree);
        tree.addTreeWillExpandListener((TreeWillExpandListener)tree);
    }

    public static void displayWaitCursor(Component comp) {
        comp.setCursor(Cursor.getPredefinedCursor(3));
    }

    public static void displayDefaultCursor(Component comp) {
        comp.setCursor(Cursor.getPredefinedCursor(0));
    }

    public static boolean isNodeSelected(CheckBoxTree tree, DefaultMutableTreeNode node) {
        if (node != null) {
            TreePath path = new TreePath(node.getPath());
            return VisualsUtil.isNodeSelected(tree, path);
        }
        return false;
    }

    public static boolean isNodeSelected(CheckBoxTree tree, TreePath path) {
        int state = tree.getCheckedState(path);
        switch (state) {
            case 2: 
            case 4: 
            case 8: 
            case 16: {
                return true;
            }
        }
        return false;
    }

    public static void displayMessageDialog(final String title, final String message, final int type) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MessageUtil.displayMessage((String)message, (String)title, (int)type, (int)-1);
            }
        });
    }

    public static void displayErrorDialog(String message) {
        VisualsUtil.displayErrorDialog(RB.getStringResource("Common.Error.txt"), message);
    }

    public static void displayErrorDialog(String title, String message) {
        VisualsUtil.displayMessageDialog(title, message, 0);
    }

    public static int displayConfirmationDialog(String title, String message, int type) {
        return MessageUtil.displayMessage((String)message, (String)title, (int)type, (int)0);
    }

    public static void showDetailsMessageDialogLater(String detailsText, final String title, final int messageType, final String messageText, final int optionsType) {
        WATextArea textArea = new WATextArea();
        textArea.setEditable(false);
        textArea.setAutoSelect(false);
        textArea.setMargin(new Insets(5, 5, 5, 5));
        textArea.setBehavior(0);
        textArea.setText(detailsText);
        Font fnt = textArea.getFont();
        fnt = new Font("Courier", fnt.getStyle(), fnt.getSize());
        textArea.setFont(fnt);
        final JScrollPane scrollPane = new JScrollPane((Component)textArea);
        scrollPane.setPreferredSize(new Dimension(375, 300));
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MessageUtil.displayDetailsMessage((String)messageText, (String)title, (int)messageType, (int)optionsType, (JComponent)scrollPane);
            }
        });
    }

    public static int showDetailsMessageDialog(String fileName, String title, int messageType, String messageText, int optionsType) {
        WATextArea textArea = new WATextArea();
        textArea.setEditable(false);
        textArea.setAutoSelect(false);
        textArea.setMargin(new Insets(5, 5, 5, 5));
        textArea.setBehavior(0);
        Font fnt = textArea.getFont();
        fnt = new Font("Courier", fnt.getStyle(), fnt.getSize());
        textArea.setFont(fnt);
        JScrollPane scrollPane = new JScrollPane((Component)textArea);
        scrollPane.setPreferredSize(new Dimension(375, 300));
        try {
            if (fileName != null) {
                String details = PromotionUtil.readFile(fileName);
                textArea.setText(details);
                textArea.setCaretPosition(details.length());
            }
        }
        catch (IOException e) {
            textArea.setText(Message.format((ResourceBundle)RB.getResources(), (String)"VisualsUtil.ReadLogFileFail.txt", (Object)e.getMessage()));
        }
        return MessageUtil.displayDetailsMessage((String)messageText, (String)title, (int)messageType, (int)optionsType, (JComponent)scrollPane);
    }

    public static DefaultMutableTreeNode[] pruneChildrenFromNodeArray(DefaultMutableTreeNode[] aNodes) {
        ArrayList<DefaultMutableTreeNode> lPrunedNodes = new ArrayList<DefaultMutableTreeNode>();
        for (int iNode = 0; iNode < aNodes.length; ++iNode) {
            lPrunedNodes.add(aNodes[iNode]);
        }
        Iterator iter1 = lPrunedNodes.iterator();
        block1: while (iter1.hasNext()) {
            DefaultMutableTreeNode node1 = (DefaultMutableTreeNode)iter1.next();
            for (DefaultMutableTreeNode node2 : lPrunedNodes) {
                if (node1 == node2 || !node1.isNodeAncestor(node2)) continue;
                iter1.remove();
                continue block1;
            }
        }
        return lPrunedNodes.toArray(new DefaultMutableTreeNode[lPrunedNodes.size()]);
    }

    public static String getDisplayPathForNode(TreePath treePath, int startingPos) {
        StringBuffer sb = new StringBuffer();
        Object[] path = treePath.getPath();
        int length = path.length;
        for (int i = startingPos; i < length; ++i) {
            if (!(path[i] instanceof DefaultMutableTreeNode)) continue;
            sb.append(((DefaultMutableTreeNode)path[i]).getUserObject());
            if (i >= length - 1) continue;
            sb.append('/');
        }
        return sb.toString();
    }

    public static void displayPromotionLog(Frame parentFrame, PromotionInterface operation, String title) {
        LogViewerDialog viewer = new LogViewerDialog(title, operation.getLogger().getLogFileName(), parentFrame);
        VisualsUtil.displayPromotionLog(operation, viewer);
    }

    public static void displayPromotionLog(Dialog parentDialog, PromotionInterface operation, String title) {
        LogViewerDialog viewer = new LogViewerDialog(title, operation.getLogger().getLogFileName(), parentDialog);
        VisualsUtil.displayPromotionLog(operation, viewer);
    }

    private static void displayPromotionLog(PromotionInterface operation, LogViewerDialog viewer) {
        viewer.setErrorTrackingSupported(true);
        ErrorTrackingManager errorTracking = viewer.getErrorTrackingManager();
        if (operation.getLogger().isDebugEnabled()) {
            errorTracking.setErrorMessageRegex(ErrorTrackingManager.ERROR_PATTERN_WITH_TIMESTAMPS);
            errorTracking.setWarningMessageRegex(ErrorTrackingManager.WARNING_PATTERN_WITH_TIMESTAMPS);
        }
        viewer.setVisible(true);
    }
}

