/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.promotion.visuals;

import com.sas.metadata.promotion.PromotionInterface;
import com.sas.metadata.promotion.visuals.RB;
import com.sas.swing.visuals.util.Util;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WorkspaceUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.lang.reflect.InvocationTargetException;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class SuppressibleMessageDialog {
    public static int displayErrorDialog(String message, String ignoreSettingText, String ignoreSettingKey, PromotionInterface operation) {
        return SuppressibleMessageDialog.displayDialog(message, ignoreSettingText, ignoreSettingKey, RB.getStringResource("Common.Error.txt"), 0, operation);
    }

    public static int displayWarningDialog(String message, String ignoreSettingText, String ignoreSettingKey, PromotionInterface operation) {
        return SuppressibleMessageDialog.displayDialog(message, ignoreSettingText, ignoreSettingKey, RB.getStringResource("Common.Warning.txt"), 2, operation);
    }

    private static int displayDialog(String message, String ignoreSettingText, String ignoreSettingKey, String title, int type, PromotionInterface operation) {
        Object value;
        if (ignoreSettingKey != null && (value = operation.getObjectFromCache(ignoreSettingKey)) instanceof Boolean && value.equals(Boolean.TRUE)) {
            return 0;
        }
        SuppressibleMessageRunnable run = new SuppressibleMessageRunnable(message, title, type, ignoreSettingKey, ignoreSettingText, operation);
        if (SwingUtilities.isEventDispatchThread()) {
            run.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(run);
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return run.getReturnCode();
    }

    private static int showDialog(String sMessage, String sTitle, int eType, String ignoreSettingText, String ignoreSettingKey, PromotionInterface operation) {
        SuppressibleDialog dialog = MessageUtil.getMainWindow() instanceof JFrame ? new SuppressibleDialog((JFrame)MessageUtil.getMainWindow(), sMessage, sTitle, eType) : new SuppressibleDialog((JDialog)MessageUtil.getMainWindow(), sMessage, sTitle, eType);
        JCheckBox checkBox = dialog.getCheckBox();
        if (checkBox != null) {
            Util.configureMnemonicForButton((AbstractButton)checkBox, (String)ignoreSettingText);
        }
        dialog.pack();
        WorkspaceUtil.centerOver((Window)((Object)dialog), (Component)MessageUtil.getMainWindow());
        dialog.setVisible(true);
        int rc = dialog.getReturn();
        if (ignoreSettingKey != null && rc == 0) {
            if (dialog.isCheckBoxSelected()) {
                operation.addObjectToCache(ignoreSettingKey, Boolean.TRUE);
            } else {
                operation.addObjectToCache(ignoreSettingKey, Boolean.FALSE);
            }
        }
        return rc;
    }

    static class SuppressibleDialog
    extends MessageUtil.cMessageDialog {
        JCheckBox _checkBox;

        public SuppressibleDialog(JFrame frmParent, String sMessage, String sTitle, int eType) {
            super(frmParent, sMessage, sTitle, eType, 0);
        }

        public SuppressibleDialog(JDialog dlgParent, String sMessage, String sTitle, int eType) {
            super(dlgParent, sMessage, sTitle, eType, 0);
        }

        protected void layoutComponents() {
            this._checkBox = new JCheckBox();
            Util.configureMnemonicForButton((AbstractButton)this._checkBox, (String)RB.getStringResource("SuppressibleMessageDialog.DoNotShowAgain.txt"));
            Container pnlContents = this.getContentPane();
            pnlContents.setLayout(new GridBagLayout());
            pnlContents.add((Component)this.m_lblIcon, new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 17, 3, new Insets(7, 7, 7, 7), 0, 0));
            pnlContents.add((Component)this.m_txtMessage, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(7, 7, 7, 7), 0, 0));
            pnlContents.add((Component)this._checkBox, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 18, 1, new Insets(7, 7, 7, 7), 0, 0));
            pnlContents.add((Component)this.m_pnlButtons, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 15, 0, new Insets(7, 0, 7, 0), 0, 0));
            JButton btnDefault = (JButton)this.m_pnlButtons.getComponents()[0];
            btnDefault.requestFocus();
            this.getRootPane().setDefaultButton(btnDefault);
            this.pack();
        }

        public boolean isCheckBoxSelected() {
            return this._checkBox.isSelected();
        }

        public void setCheckBoxSelected(boolean selected) {
            this._checkBox.setSelected(selected);
        }

        public void setCheckBoxText(String text) {
            this._checkBox.setText(text);
        }

        public JCheckBox getCheckBox() {
            return this._checkBox;
        }
    }

    static class SuppressibleMessageRunnable
    implements Runnable {
        protected String m_sTitle;
        protected String m_sMessage;
        protected int m_eType;
        protected int m_eReturnCode;
        protected String _ignoreSettingKey;
        protected String _ignoreSettingText;
        protected PromotionInterface _operation;

        public SuppressibleMessageRunnable(String sMessage, String sTitle, int eType, String ignoreSettingText, String ignoreSettingKey, PromotionInterface operation) {
            this.m_sMessage = sMessage;
            this.m_sTitle = sTitle;
            this.m_eType = eType;
            this._ignoreSettingKey = ignoreSettingKey;
            this._ignoreSettingText = ignoreSettingText;
            this._operation = operation;
        }

        @Override
        public void run() {
            this.m_eReturnCode = SuppressibleMessageDialog.showDialog(this.m_sMessage, this.m_sTitle, this.m_eType, this._ignoreSettingKey, this._ignoreSettingText, this._operation);
        }

        public int getReturnCode() {
            return this.m_eReturnCode;
        }
    }
}

