/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.promotion.visuals;

import com.sas.metadata.promotion.visuals.PromotionWizardInterface;
import com.sas.metadata.promotion.visuals.RB;
import com.sas.swing.visuals.util.LayoutConstants;
import com.sas.swing.visuals.util.Util;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WATextArea;
import com.sas.workspace.WAWizardDialog;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JScrollPane;

public class PromotionLogPanel
extends WAStandardDialog {
    private static final String NEW_LINE = "\n";
    private String _title;
    private File _logFile;
    private WATextArea _textArea;
    private JScrollPane _scrollPane;
    private JButton _okButton;

    public PromotionLogPanel(String title, File logFile, JDialog parent) {
        super((Dialog)parent, true);
        this._title = title;
        this._logFile = logFile;
        this.initialize();
        this.layoutWidgets();
    }

    public PromotionLogPanel(String title, File logFile, PromotionWizardInterface wizard) {
        this(title, logFile, (JDialog)((WAWizardDialog)wizard));
    }

    protected void initialize() {
        this.setTitle(this._title);
        this.setResizable(true);
        this._okButton = new JButton();
        Util.configureMnemonicForButton((AbstractButton)this._okButton, (String)RB.getStringResource("Common.OK.txt"));
        this._okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PromotionLogPanel.this.dispose();
            }
        });
        this._textArea = new WATextArea();
        this._textArea.setEditable(false);
        this._textArea.setAutoSelect(false);
        this._textArea.setMargin(new Insets(5, 5, 5, 5));
        this._textArea.setBehavior(0);
        Font fnt = this._textArea.getFont();
        fnt = new Font("Courier", fnt.getStyle(), fnt.getSize());
        this._textArea.setFont(fnt);
        this._scrollPane = new JScrollPane((Component)this._textArea);
        this._scrollPane.setPreferredSize(new Dimension(500, 350));
    }

    protected void layoutWidgets() {
        WAPanel panel = new WAPanel();
        panel.setLayout((LayoutManager)new GridBagLayout());
        panel.add((Component)this._scrollPane, (Object)new GridBagConstraints(0, 0, 2, 1, 1.0, 1.0, 18, 1, LayoutConstants.EMPTY_INSETS, 0, 0));
        panel.add((Component)this._okButton, (Object)new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 0, new Insets(10, 0, 5, 0), 0, 0));
        this.setMainPanel(panel);
    }

    public boolean doDataExchange(boolean bSaveToModel) {
        if (!bSaveToModel) {
            this.readLogFile();
            this._okButton.requestFocus();
        }
        return true;
    }

    private void readLogFile() {
        try {
            String in;
            BufferedReader br = new BufferedReader(new FileReader(this._logFile));
            StringBuffer sb = new StringBuffer();
            while ((in = br.readLine()) != null) {
                sb.append(in);
                sb.append(NEW_LINE);
            }
            br.close();
            if (sb.length() > 0) {
                this._textArea.setText(sb.toString());
                this._textArea.setCaretPosition(0);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

