/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.promotion.visuals;

import com.sas.metadata.promotion.ExportHandler;
import com.sas.metadata.promotion.ExportItemInterface;
import com.sas.metadata.promotion.ImportHandler;
import com.sas.metadata.promotion.Log;
import com.sas.metadata.promotion.MetadataPromotionException;
import com.sas.metadata.promotion.NotificationEvent;
import com.sas.metadata.promotion.NotificationListener;
import com.sas.metadata.promotion.visuals.AbstractExportProcessor;
import com.sas.metadata.promotion.visuals.DetailsMessageDialog;
import com.sas.metadata.promotion.visuals.ExportTree;
import com.sas.metadata.promotion.visuals.ExportTreeModelInterface;
import com.sas.metadata.promotion.visuals.PasteSpecialWizard;
import com.sas.metadata.promotion.visuals.ProgressBarLauncher;
import com.sas.metadata.promotion.visuals.ProgressReturnCode;
import com.sas.metadata.promotion.visuals.RB;
import com.sas.services.information.publicobject.PublicObjectContainerInterface;
import com.sas.text.Message;
import java.awt.Dimension;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.tree.TreeModel;

public class PasteSpecialProcessor
extends ProgressBarLauncher {
    private static final String BEGIN_HTML_TAG = "<html>";
    private static final String END_HTML_TAG = "</html>";
    private static final String BREAK_TAG = "<br>";
    private static final String EMPTY_STRING = "";
    private String _statusMessage = null;
    private File _packageFile;

    public PasteSpecialProcessor(PasteSpecialWizard wizard) {
        super(wizard, wizard.getExportHandler());
        this.setPreferredSize(new Dimension(340, 35));
        this.setWaitTime(100);
    }

    @Override
    public String getMessage() {
        return RB.getStringResource("CopyPasteUtil.ProgressCopyTitle.txt");
    }

    @Override
    public String getTitle() {
        return RB.getStringResource("PasteSpecialWizard.Title.txt");
    }

    @Override
    public void displayMessage(String message) {
        this.displayMessage(message, true);
    }

    public void displayMessage(String message, boolean append) {
        if (append) {
            String msg = this._statusMessage == null ? EMPTY_STRING : this._statusMessage;
            this._request.setMessage(this.convertMessageToHTML(msg, message));
        } else {
            this._statusMessage = message;
            this._request.setMessage(this.convertMessageToHTML(message, null));
        }
    }

    private String convertMessageToHTML(String message1, String message2) {
        StringBuffer sb = new StringBuffer();
        sb.append(BEGIN_HTML_TAG);
        sb.append(message1);
        sb.append(BREAK_TAG);
        if (message2 != null) {
            sb.append(message2);
        }
        sb.append(END_HTML_TAG);
        return sb.toString();
    }

    public boolean startPaste(ExportTree tree) {
        this.launch(new CopyRunnable(tree));
        int code = this.getReturnCode().getReturnCode();
        String errorMessage = this.getReturnCode().getErrorMessage();
        if (errorMessage != null) {
            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"CopyPasteUtil.GenericError.fmt.txt", (Object)errorMessage);
            String title = RB.getStringResource("Common.Error.txt");
            int type = code == 4 ? 2 : 0;
            DetailsMessageDialog.displayDialog(this._promotionHandler, msg, title, type, -1);
            return false;
        }
        if ((code & 4) > 0 || (code & 8) > 0) {
            String message;
            String string = message = code == 4 ? RB.getStringResource("CopyPasteUtil.WarningsBeforeImport.txt") : RB.getStringResource("CopyPasteUtil.ErrorsBeforeImport.txt");
            if (!this.displayDetailsMessage(message)) {
                return false;
            }
        }
        return true;
    }

    class CopyRunnable
    extends AbstractExportProcessor
    implements NotificationListener {
        public CopyRunnable(ExportTree tree) {
            super(tree);
        }

        @Override
        public void run() {
            ProgressReturnCode rc = PasteSpecialProcessor.this.getReturnCode();
            try {
                this.runExport();
                this.initializeImport();
                PasteSpecialProcessor.this._wizard.replaceWizardData("STATUS", new Integer(rc.getReturnCode()));
            }
            catch (Exception e) {
                String msg;
                String string = msg = e.getMessage() == null ? RB.getStringResource("CopyPasteUtil.GenericError.txt") : e.getMessage();
                if (PasteSpecialProcessor.this._log.isErrorEnabled()) {
                    PasteSpecialProcessor.this._log.error(Message.format((ResourceBundle)RB.getResources(), (String)"CopyPasteUtil.ErrorPlus.txt", (Object)msg));
                }
                rc.setReturnCode(8);
                rc.setErrorMessage(msg);
                PasteSpecialProcessor.this._log.debug((Object)"Paste Special", e);
            }
        }

        private void runExport() throws Exception {
            ProgressReturnCode rc = PasteSpecialProcessor.this.getReturnCode();
            if (PasteSpecialProcessor.this._promotionHandler instanceof ExportHandler) {
                PasteSpecialProcessor.this._log.info(RB.getStringResource("CopyPasteUtil.Start.txt"));
                ExportHandler exportOperation = (ExportHandler)PasteSpecialProcessor.this._promotionHandler;
                PasteSpecialProcessor.this.addMessageListeners();
                exportOperation.addNotificationListener(this);
                ExportTreeModelInterface model = null;
                TreeModel tm = this._tree.getModel();
                if (tm instanceof ExportTreeModelInterface) {
                    model = (ExportTreeModelInterface)tm;
                }
                if (model == null) {
                    return;
                }
                try {
                    Map<String, List<ExportItemInterface>> exportItems = this.processSelectedExportItems(model, this._tree.getCheckedObjects());
                    if (exportItems == null || exportItems.size() == 0) {
                        String msg = RB.getStringResource("PasteSpecialTreePanel.SelectItems.txt");
                        throw new MetadataPromotionException(msg);
                    }
                    exportOperation.setDependentObjects(this.getExternalDependencies(model));
                    int returnCode = exportOperation.setItemsToExport(exportItems, true);
                    rc.setReturnCode(returnCode |= exportOperation.runExport());
                    PasteSpecialProcessor.this._packageFile = exportOperation.getPackageFile();
                }
                catch (Exception e) {
                    throw e;
                }
                finally {
                    PasteSpecialProcessor.this.removeMessageListeners();
                    PasteSpecialProcessor.this._promotionHandler.removeNotificationListener(this);
                    PasteSpecialProcessor.this.displayMessage(PasteSpecialProcessor.EMPTY_STRING, false);
                }
            }
        }

        private void initializeImport() throws Exception {
            ProgressReturnCode rc = PasteSpecialProcessor.this.getReturnCode();
            PasteSpecialProcessor.this.displayMessage(RB.getStringResource("CopyPasteUtil.AnalyzeDepend.txt"), false);
            ImportHandler importOperation = ((PasteSpecialWizard)PasteSpecialProcessor.this._wizard).getImportHandler();
            if (importOperation == null) {
                throw new IllegalStateException("Import operation is not initialized");
            }
            try {
                PasteSpecialProcessor.this.setPromotionHandler(importOperation);
                importOperation.loadExportPackage(PasteSpecialProcessor.this._packageFile);
                if (importOperation.isProjectRepository()) {
                    importOperation.importSecurityMetadata(false);
                } else {
                    importOperation.importSecurityMetadata(true);
                }
                PasteSpecialProcessor.this.addMessageListeners();
                importOperation.loadObjectsToImport(false);
                int returnCode = importOperation.fireAnalyzeObjects();
                rc.setReturnCode(returnCode);
            }
            catch (Exception e) {
                String message = e.getMessage() == null ? e.toString() : e.getMessage();
                Log log = importOperation.getLogger();
                PublicObjectContainerInterface targetContainer = importOperation.getTargetContainer();
                if (targetContainer != null) {
                    log.error(Message.format((ResourceBundle)RB.getResources(), (String)"CopyPasteUtil.PasteError.txt", (Object)targetContainer.getName(), (Object)message));
                }
                throw e;
            }
            finally {
                PasteSpecialProcessor.this.removeMessageListeners();
                PasteSpecialProcessor.this.displayMessage(PasteSpecialProcessor.EMPTY_STRING, false);
            }
        }

        @Override
        public void notify(NotificationEvent event) {
            int type = event.getEventType();
            switch (type) {
                case 105: {
                    PasteSpecialProcessor.this.displayMessage(RB.getStringResource("CopyPasteUtil.CopyMetadata.txt"), false);
                    break;
                }
                case 110: {
                    PasteSpecialProcessor.this.displayMessage(RB.getStringResource("CopyPasteUtil.CopyContent.txt"), false);
                }
            }
        }
    }
}

