/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.promotion.visuals;

import com.sas.metadata.logical.TypeInterface;
import com.sas.metadata.promotion.ImportHandler;
import com.sas.metadata.promotion.Log;
import com.sas.metadata.promotion.LoggingUtil;
import com.sas.metadata.promotion.visuals.AbstractPromotionWizard;
import com.sas.metadata.promotion.visuals.ConnectionTransitionHandler;
import com.sas.metadata.promotion.visuals.DependencyAnalyzer;
import com.sas.metadata.promotion.visuals.Images;
import com.sas.metadata.promotion.visuals.ImportConnectionIntroPanel;
import com.sas.metadata.promotion.visuals.ImportExecutePanel;
import com.sas.metadata.promotion.visuals.ImportFilePanel;
import com.sas.metadata.promotion.visuals.ImportFinishPanel;
import com.sas.metadata.promotion.visuals.ImportSummaryPanel;
import com.sas.metadata.promotion.visuals.ImportTreePanel;
import com.sas.metadata.promotion.visuals.ImportWizardInterface;
import com.sas.metadata.promotion.visuals.RB;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.SoftwareComponent;
import com.sas.metadata.remote.Tree;
import com.sas.services.ServiceException;
import com.sas.services.information.OMIServer;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.publicobject.PublicObjectContainerInterface;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.Workspace;
import java.awt.Cursor;
import java.io.File;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;

public class ImportWizard
extends AbstractPromotionWizard
implements ImportWizardInterface {
    private static final long serialVersionUID = -5439461948755770548L;
    protected Tree _parentFolder;
    protected SoftwareComponent _bipService;
    private PublicObjectContainerInterface _targetContainer;
    protected ImportHandler _importHandler;
    protected ConnectionTransitionHandler _connectionHandler;
    protected ImportFinishPanel _finishPanel;
    protected DependencyAnalyzer _analyzer;
    protected Map<String, String> _targetIDMap;
    private boolean _initialized = false;

    private ImportWizard(List<String> supportedTypes, String title) {
        super(supportedTypes, title);
        if (title == null) {
            this._title = RB.getStringResource("ImportWizard.Title.txt");
        }
        this.setTitle(this._title);
    }

    public ImportWizard(PublicObjectContainerInterface container, List<String> supportedTypes, String title) {
        this(supportedTypes, title);
        this._targetContainer = container;
        this.initializePanels();
    }

    public static ImageIcon getImportIcon() {
        return Images.getImportIcon();
    }

    @Override
    protected void initializePanels() {
        Workspace workspace = Workspace.getWorkspace();
        try {
            if (this._isOldStylePromotion) {
                this.convertToPublicObjectModel();
            }
            if (this._targetContainer == null) {
                return;
            }
            this._importHandler = new ImportHandler(this._targetContainer, this._supportedTypes, 1);
            String value = System.getProperty("promotion.apply.locprop");
            if (value != null && value.equalsIgnoreCase(Boolean.TRUE.toString())) {
                this._importHandler.getPropertiesManager().setProcessLocalizableProperties(true, true);
            }
            if (workspace.getWorkspaceFile() != null) {
                this._importHandler.setProfileName(workspace.getWorkspaceFile().getFileName());
            }
            this._importHandler.setSessionContext(workspace.getSessionContext(), true);
            this._importHandler.getPropertiesManager().setPromptForSubstitutions(true);
            this._log = Log.getInstance(ImportWizard.class.getName());
            this._logFileName = this._log.getLogFileName();
            this.addWizardData("LOGFILE", this._logFileName);
            LoggingUtil.logServerInformation(workspace.getUserContext(), this._log, false);
            this._initialized = true;
        }
        catch (ServiceException e) {
            String msg = e.getLocalizedMessage();
            if (msg == null) {
                msg = RB.getStringResource("ImportWizard.InitializationError.txt");
            }
            if (this._log != null) {
                this._log.error(msg);
                this._log.debug((Object)"Initialization error", e);
            }
            MessageUtil.displayServiceExceptionMessage((ServiceException)e);
            return;
        }
        catch (Exception e) {
            String msg = e.getLocalizedMessage();
            if (msg == null) {
                msg = RB.getStringResource("ImportWizard.InitializationError.txt");
            }
            if (this._log != null) {
                this._log.error(msg);
                this._log.debug((Object)"Initialization error", e);
            }
            MessageUtil.displayMessage((String)msg, (String)RB.getStringResource("Common.Error.txt"), (int)0, (int)-1);
            return;
        }
        ImportFilePanel filePanel = new ImportFilePanel(this);
        this.addTab(filePanel.getPanelTitle(), "FilePanel", (WAPropertyTab)filePanel, false);
        ImportTreePanel treePanel = new ImportTreePanel(this);
        this.addTab(treePanel.getPanelTitle(), "TreePanel", (WAPropertyTab)treePanel, false);
        ImportConnectionIntroPanel connectionPanel = new ImportConnectionIntroPanel(this);
        this.addTab(connectionPanel.getPanelTitle(), "ConnectionIntroPanel", (WAPropertyTab)connectionPanel, false);
        ImportSummaryPanel summaryPanel = new ImportSummaryPanel(this);
        this.addTab(summaryPanel.getPanelTitle(), "ImportSummary", (WAPropertyTab)summaryPanel, false);
        ImportExecutePanel executePanel = new ImportExecutePanel(this);
        this.addTab(executePanel.getPanelTitle(), "ExecutePanel", (WAPropertyTab)executePanel, false);
        this._finishPanel = new ImportFinishPanel(this);
        this.addTab(this._finishPanel.getPanelTitle(), "FinishPanel", (WAPropertyTab)this._finishPanel, true);
        this.setupTransitions();
    }

    private void convertToPublicObjectModel() throws ServiceException, RemoteException {
        Workspace workspace = Workspace.getWorkspace();
        OMIServer server = workspace.getConnectionManager().getMetadataServer();
        if (this._parentFolder != null) {
            String key = this._parentFolder.getId() + "/" + this._parentFolder.getCMetadataType();
            FolderInterface folder = (FolderInterface)server.fetch(key, true);
            if (folder == null) {
                throw new ServiceException("Unable to retrieve folder from the server.");
            }
            this._targetContainer = folder;
        } else if (this._bipService != null) {
            this._targetContainer = server.getRootFolder();
        }
    }

    @Override
    protected void setupTransitions() {
        String[][] transitions = new String[][]{{"FilePanel", "FINISH", "ImportSummary"}, {"FilePanel", "IMPORT_TREE", "TreePanel"}, {"FilePanel", "CONNECTIONS", "ConnectionIntroPanel"}, {"FilePanel", "NEXT", "TreePanel"}, {"ConnectionIntroPanel", "FINISH", "ImportSummary"}, {"ConnectionIntroPanel", "NEXT", "ImportSummary"}, {"TreePanel", "NEXT", ""}, {"TreePanel", "CONNECTIONS", "ConnectionIntroPanel"}, {"TreePanel", "FINISH", "ImportSummary"}, {"ImportSummary", "NEXT", "ExecutePanel"}, {"ExecutePanel", "NEXT", "FinishPanel"}};
        this._model.addTransitions(transitions);
    }

    @Override
    protected WAPanel getFinishPanel() {
        return this._finishPanel;
    }

    @Override
    protected void cleanUp(boolean cancelling) {
        if (cancelling) {
            this._log.info(RB.getStringResource("ImportWizard.Cancel.Log.txt"));
        } else if (this._importHandler != null) {
            this._targetIDMap = this._importHandler.getTargetObjectIDs();
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        this._importHandler.dispose();
        this._connectionHandler = null;
        if (Workspace.isDebug()) {
            try {
                MdFactory factory = Workspace.getMdFactory();
                factory.dumpDetailHashMap();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.m_wizardData.clear();
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    public void changeRepositoryID(String repositoryID) {
        if (this._importHandler != null) {
            this._importHandler.changeRepositoryID(repositoryID);
        }
    }

    @Override
    public ImportHandler getImportHandler() {
        return this._importHandler;
    }

    public void setPackageFileName(String fileName) {
        this.addWizardData("PACKAGE_FILE_NAME", fileName);
    }

    public String getPackageFileName() {
        if (this._importHandler == null) {
            return null;
        }
        File packageFile = this._importHandler.getPackageFile();
        return packageFile == null ? null : packageFile.getAbsolutePath();
    }

    public Map<String, String> getTargetObjectIDs() {
        return this._targetIDMap;
    }

    public boolean objectsWereImported() {
        return this._targetIDMap != null && this._targetIDMap.size() > 0;
    }

    @Override
    public ConnectionTransitionHandler getConnectionHandler() {
        if (this._connectionHandler == null) {
            this._connectionHandler = new ConnectionTransitionHandler(this);
        }
        return this._connectionHandler;
    }

    @Override
    public DependencyAnalyzer getDependencyAnalyzer() {
        if (this._analyzer == null) {
            this._analyzer = new DependencyAnalyzer(this);
        }
        return this._analyzer;
    }

    public void show() {
        if (this._importHandler == null || !this._initialized) {
            return;
        }
        if (this.getDescription() == null) {
            this.setDescription(RB.getStringResource("ImportWizard.Desc.txt"));
        }
        super.show();
    }

    private ImportWizard(TypeInterface[] availableTypes, String title) {
        super(availableTypes, title);
        if (title == null) {
            this._title = RB.getStringResource("ImportWizard.Title.txt");
        }
        this.setTitle(this._title);
    }

    public ImportWizard(Tree parentFolder, TypeInterface[] availableTypes, String title) {
        this(availableTypes, title);
        this._parentFolder = parentFolder;
        this.initializePanels();
    }

    public ImportWizard(SoftwareComponent bipService, TypeInterface[] availableTypes, String title) {
        this(availableTypes, title);
        this._bipService = bipService;
        this.initializePanels();
    }
}

