/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.promotion.visuals;

import com.sas.metadata.promotion.ImportHandler;
import com.sas.metadata.promotion.ImportOperationInterface;
import com.sas.metadata.promotion.Log;
import com.sas.metadata.promotion.PromotionUtil;
import com.sas.metadata.promotion.connections.SecurityConnectionType;
import com.sas.metadata.promotion.model.ImportElementInterface;
import com.sas.metadata.promotion.model.ImportFolderModelInterface;
import com.sas.metadata.promotion.visuals.AbstractTreePanel;
import com.sas.metadata.promotion.visuals.ConnectionTransitionHandler;
import com.sas.metadata.promotion.visuals.DependencyAnalyzer;
import com.sas.metadata.promotion.visuals.ImportObjectOptionsPanel;
import com.sas.metadata.promotion.visuals.ImportObjectPropertiesPanel;
import com.sas.metadata.promotion.visuals.ImportTree;
import com.sas.metadata.promotion.visuals.ImportTreeManager;
import com.sas.metadata.promotion.visuals.ImportTreeModelInterface;
import com.sas.metadata.promotion.visuals.ImportTreeNodeInterface;
import com.sas.metadata.promotion.visuals.ImportWizardInterface;
import com.sas.metadata.promotion.visuals.RB;
import com.sas.metadata.promotion.visuals.TreeNodeInterface;
import com.sas.metadata.promotion.visuals.VisualsUtil;
import com.sas.metadata.promotion.visuals.WizardPanelInterface;
import com.sas.services.ServiceException;
import com.sas.services.information.publicobject.PublicObjectContainerInterface;
import com.sas.services.information.publicobject.PublicObjectInterface;
import com.sas.services.information.sasfolders.ContainerNodeInterface;
import com.sas.services.information.sasfolders.PublicObjectNodeInterface;
import com.sas.swing.visuals.CheckBoxTree;
import com.sas.text.Message;
import com.sas.workspace.MessageUtil;
import java.awt.Component;
import java.awt.Cursor;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;

public class ImportTreePanel
extends AbstractTreePanel
implements WizardPanelInterface {
    public static final String PANEL_NAME = "TreePanel";
    private static final String PANEL_TITLE = RB.getStringResource("ImportTreePanel.Title.txt");
    protected ImportObjectOptionsPanel _optionsPanel;
    private Log _log;
    private ImportWizardInterface _wizard;
    private ImportOperationInterface _handler;

    public ImportTreePanel(ImportWizardInterface wizard) {
        super(new ImportTree());
        this._wizard = wizard;
        this._handler = wizard.getImportHandler();
        this.initialize();
        this.layoutWidgets();
    }

    @Override
    public String getPanelTitle() {
        return PANEL_TITLE;
    }

    @Override
    public String getPanelName() {
        return PANEL_NAME;
    }

    @Override
    public void initialize() {
        this._log = Log.getInstance(ImportTreePanel.class.getName());
        this.setHelpProduct("promotion");
        this.setHelpTopic("imp_impobjectswin");
        this.setDescription(RB.getStringResource("ImportTreePanel.Description.txt"));
        super.initialize();
    }

    protected ImportWizardInterface getImportWizard() {
        return this._wizard;
    }

    protected ImportTree getImportTree() {
        return (ImportTree)this._tree;
    }

    public boolean validateData() {
        DependencyAnalyzer da;
        boolean success;
        Component comp;
        int value;
        if (!this._canClickNext) {
            return false;
        }
        Object[] selectedItems = this._tree.getCheckedObjects();
        TreeModel treeModel = this._tree.getModel();
        if (treeModel instanceof ImportTreeModelInterface) {
            ImportFolderModelInterface model = ((ImportTreeModelInterface)treeModel).getImportModel();
            ArrayList<ImportElementInterface> importItems = new ArrayList<ImportElementInterface>();
            try {
                if (this.validateDuplicateObjects((ImportTreeModelInterface)treeModel)) {
                    return false;
                }
                int length = selectedItems.length;
                for (int i = 0; i < length; ++i) {
                    ImportElementInterface importElement;
                    ImportTreeNodeInterface visualNode;
                    PublicObjectNodeInterface poNode;
                    if (!(selectedItems[i] instanceof ImportTreeNodeInterface) || (poNode = (visualNode = (ImportTreeNodeInterface)selectedItems[i]).getPublicObjectNode()) == null || (importElement = model.getImportElement((PublicObjectInterface)poNode)) == null || importElement.getImportItem() == null || !importElement.isValid()) continue;
                    model.includeNode(importElement);
                    importItems.add(importElement);
                }
                if (!model.isAuthorizedToImportPackage()) {
                    MessageUtil.displayMessage((String)RB.getStringResource("ImportTreePanel.NotAuthorized.txt"), (String)RB.getStringResource("ImportWizard.Error.txt"), (int)0);
                    return false;
                }
                if (importItems.size() == 0) {
                    MessageUtil.displayMessage((String)RB.getStringResource("ImportTreePanel.SelectItems.txt"), (String)RB.getStringResource("ImportWizard.Error.txt"), (int)0);
                    return false;
                }
                ((ImportHandler)this._handler).loadObjectsToImport(model, importItems);
            }
            catch (Exception e) {
                String msg = e.getLocalizedMessage();
                VisualsUtil.displayErrorDialog(RB.getStringResource("ImportWizard.Error.txt"), msg);
                return false;
            }
        } else {
            return false;
        }
        if (this.displayAccessControlsWarning() && (value = VisualsUtil.displayConfirmationDialog(RB.getStringResource("ImportWizard.Warning.txt"), RB.getStringResource("ImportTreePanel.AccessControlWarning.txt"), 2)) == 1) {
            return false;
        }
        Component component = comp = this.isDetailsVisible() ? this._detailsPane.getSelectedComponent() : null;
        if (this._optionsPanel != null && comp == this._optionsPanel) {
            List<TreeNodeInterface> nodes = this.getSelectedNodes();
            this._optionsPanel.saveSettings(nodes.toArray(new TreeNodeInterface[0]));
        }
        if (!(success = (da = new DependencyAnalyzer(this._wizard)).analyze())) {
            return false;
        }
        ConnectionTransitionHandler connHandler = this._wizard.getConnectionHandler();
        connHandler.setStartingPanel(this);
        connHandler.setTransitions();
        return true;
    }

    @Override
    public void moveDataToView() {
        this._wizard.replaceWizardData("LOAD_PACKAGE_ERROR", null);
        Object value = this._wizard.getWizardData("LOAD_PACKAGE");
        if (value instanceof Boolean && !((Boolean)value).booleanValue()) {
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        this._tree.setModel(EMPTY_TREE_MODEL);
        this.removeAllDetailComponents();
        this._optionsPanel = new ImportObjectOptionsPanel(this._handler);
        this.addDetailsPanel(this._optionsPanel);
        this.addDetailsPanel(new ImportObjectPropertiesPanel(this._handler));
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    ImportTreePanel.this.setCursor(Cursor.getPredefinedCursor(3));
                    ImportTreePanel.this.constructTree();
                }
                finally {
                    ImportTreePanel.this.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        });
    }

    public void onBack() {
        this._wizard.getNextButton().setEnabled(true);
    }

    private void constructTree() {
        this._folderType = this._handler.getTransportableType("Folder");
        if (this._folderType == null) {
            throw new IllegalStateException("Unable to load folder type");
        }
        try {
            PublicObjectContainerInterface targetContainer = this._handler.getTargetContainer();
            if (targetContainer != null && !PromotionUtil.isRootFolder((PublicObjectInterface)targetContainer)) {
                this._tree.setRootVisible(false);
                this._tree.setShowsRootHandles(true);
                this._tree.setCheckBoxOnRootNode(true);
            }
            ImportTreeManager treeManager = ImportTreeManager.newInstance(this);
            treeManager.populateTree();
        }
        catch (Exception e) {
            try {
                this._wizard.replaceWizardData("LOAD_PACKAGE_ERROR", Boolean.TRUE);
                this.handleTreeFailure();
                String msg = e.getLocalizedMessage();
                if (msg == null) {
                    msg = RB.getStringResource("ImportTreePanel.Tree.Error.txt");
                }
                if (this._log != null && this._log.isErrorEnabled()) {
                    this._log.error(msg, e);
                }
                VisualsUtil.displayErrorDialog(RB.getStringResource("ImportWizard.Error.txt"), msg);
            }
            catch (Throwable throwable) {
                this._tree.requestFocus();
                if (!this._canClickNext) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ImportTreePanel.this._wizard.getNextButton().setEnabled(false);
                        }
                    });
                }
                throw throwable;
            }
            this._tree.requestFocus();
            if (!this._canClickNext) {
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
        }
        this._tree.requestFocus();
        if (!this._canClickNext) {
            SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
        }
    }

    private boolean validateDuplicateObjects(ImportTreeModelInterface model) throws ServiceException, RemoteException {
        List<PublicObjectNodeInterface> duplicateNodes = this.getSelectedDuplicateObjects(model);
        if (duplicateNodes == null || duplicateNodes.isEmpty()) {
            return false;
        }
        String msg = RB.getStringResource("ImportTreePanel.DuplicateNames.txt");
        StringBuffer sb = new StringBuffer();
        int count = 0;
        for (PublicObjectNodeInterface node : duplicateNodes) {
            if (count > 0) {
                sb.append("\n");
            }
            sb.append(Message.format((ResourceBundle)RB.getResources(), (String)"ImportTreePanel.DuplicateEntry.fmt.txt", (Object)(count + 1), (Object)node.getTypeDescriptor().getType(), (Object)node.getDisplayPath()));
            ++count;
        }
        VisualsUtil.showDetailsMessageDialogLater(sb.toString(), this._wizard.getTitle(), 0, msg, -1);
        return true;
    }

    private List<PublicObjectNodeInterface> getSelectedDuplicateObjects(ImportTreeModelInterface model) throws ServiceException, RemoteException {
        ImportFolderModelInterface folderModel = model.getImportModel();
        if (folderModel == null) {
            return null;
        }
        Map<ContainerNodeInterface, List<PublicObjectNodeInterface>> containerCache = ImportTreeManager.getDuplicateObjectsByContainer(folderModel);
        if (containerCache == null) {
            return null;
        }
        ArrayList<PublicObjectNodeInterface> duplicateNodes = new ArrayList<PublicObjectNodeInterface>(5);
        for (ContainerNodeInterface container : containerCache.keySet()) {
            LinkedHashMap<String, Set<String>> typeNameCache = new LinkedHashMap<String, Set<String>>(5);
            List<PublicObjectNodeInterface> nodes = containerCache.get(container);
            for (PublicObjectNodeInterface node : nodes) {
                Set<String> names;
                ImportTreeNodeInterface treeNode = model.getImportNode(node.getIdentifier());
                if (treeNode == null || !VisualsUtil.isNodeSelected((CheckBoxTree)this._tree, (DefaultMutableTreeNode)((Object)treeNode))) continue;
                String publicType = node.getTypeDescriptor().getTypeName();
                if (!typeNameCache.containsKey(publicType)) {
                    names = new HashSet(2);
                    typeNameCache.put(publicType, names);
                }
                if ((names = (Set)typeNameCache.get(publicType)).contains(node.getName())) {
                    duplicateNodes.add(node);
                    continue;
                }
                names.add(node.getName());
            }
        }
        return duplicateNodes;
    }

    private boolean displayAccessControlsWarning() {
        SecurityConnectionType type;
        if (!this._handler.isSecurityMetadataIncluded() && (type = ((ImportHandler)this._handler).getSecurityConnectionType()) != null) {
            return type.containsAccessControlConnections();
        }
        return false;
    }
}

