/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.promotion.visuals;

import com.sas.metadata.promotion.ImportHandler;
import com.sas.metadata.promotion.ImportOperationInterface;
import com.sas.metadata.promotion.NoObjectsToImportException;
import com.sas.metadata.promotion.PromotionItemInterface;
import com.sas.metadata.promotion.model.ImportFolderModelInterface;
import com.sas.metadata.promotion.model.ModelFactory;
import com.sas.metadata.promotion.visuals.Images;
import com.sas.metadata.promotion.visuals.ImportTree;
import com.sas.metadata.promotion.visuals.ImportTreeModel;
import com.sas.metadata.promotion.visuals.ImportTreeModelInterface;
import com.sas.metadata.promotion.visuals.ImportTreeNode;
import com.sas.metadata.promotion.visuals.ImportTreeNodeInterface;
import com.sas.metadata.promotion.visuals.ImportTreePanel;
import com.sas.metadata.promotion.visuals.ImportWizardInterface;
import com.sas.metadata.promotion.visuals.ProgressBarLauncher;
import com.sas.metadata.promotion.visuals.ProgressReturnCode;
import com.sas.metadata.promotion.visuals.RB;
import com.sas.metadata.promotion.visuals.TreeNodeInterface;
import com.sas.metadata.promotion.visuals.VisualsUtil;
import com.sas.services.ServiceException;
import com.sas.services.information.publicobject.PublicObjectContainerInterface;
import com.sas.services.information.sasfolders.ContainerNodeInterface;
import com.sas.services.information.sasfolders.PublicObjectNodeInterface;
import com.sas.swing.visuals.CheckBoxTree;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

public class ImportTreeManager {
    public static DefaultTreeModel EMPTY_TREE_MODEL = new DefaultTreeModel(null);
    private static final int NO_OBJECTS_TO_IMPORT_CODE = 100;
    private static Map<ImportOperationInterface, ImportTreeManager> _instanceCache = new HashMap<ImportOperationInterface, ImportTreeManager>(5);
    private ImportTreePanel _owningPanel;
    private ImportWizardInterface _wizard;
    private ImportOperationInterface _operation;
    private ImportTree _tree;
    private PublicObjectContainerInterface _targetContainer;
    private boolean _checkNodes = true;
    private boolean _repopulatingTree = false;

    private ImportTreeManager(ImportTreePanel treePanel) {
        this._owningPanel = treePanel;
        this._wizard = treePanel.getImportWizard();
        this._operation = this._wizard.getImportHandler();
        this._tree = treePanel.getImportTree();
    }

    public static synchronized ImportTreeManager newInstance(ImportTreePanel treePanel) throws ServiceException, RemoteException {
        ImportWizardInterface wizard = treePanel.getImportWizard();
        ImportHandler operation = wizard.getImportHandler();
        if (operation == null) {
            throw new IllegalArgumentException("Invalid operation");
        }
        if (_instanceCache.containsKey(operation)) {
            return _instanceCache.get(operation);
        }
        ImportTreeManager instance = new ImportTreeManager(treePanel);
        _instanceCache.put(operation, instance);
        return instance;
    }

    public static synchronized ImportTreeManager getInstance(ImportOperationInterface operation) {
        if (operation == null) {
            throw new IllegalArgumentException("Invalid operation");
        }
        if (_instanceCache.containsKey(operation)) {
            return _instanceCache.get(operation);
        }
        throw new IllegalStateException("The tree manager has not been configured");
    }

    public void dispose() {
        _instanceCache.remove(this._operation);
    }

    public void checkNodesAutomatically(boolean check) {
        this._checkNodes = check;
    }

    public void selectNode(String id) {
        ImportTreeNodeInterface node;
        TreeModel model = this._tree.getModel();
        if (model instanceof ImportTreeModelInterface && (node = ((ImportTreeModelInterface)model).getImportNode(id)) instanceof ImportTreeNode) {
            TreePath path = new TreePath(((ImportTreeNode)node).getPath());
            this._tree.setSelectionPath(path);
        }
    }

    public boolean populateTree() {
        return this.populateTree(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean populateTree(boolean repopulating) {
        this._repopulatingTree = repopulating;
        boolean returnCode = true;
        try {
            Object[] nodes;
            TreePath nodePath;
            ImportTreeNodeInterface node;
            List<ImportTreeNodeInterface> disabledNodes;
            ImportTreeModelInterface model = this.createTreeModel();
            this._tree.setModel(model);
            if (this._checkNodes) {
                TreePath path = new TreePath(model.getRoot());
                this._tree.checkChildren(path, true, true);
            }
            if ((disabledNodes = model.getDisabledNodes()) != null) {
                for (ImportTreeNodeInterface node2 : disabledNodes) {
                    Object[] nodes2 = ((DefaultMutableTreeNode)((Object)node2)).getPath();
                    TreePath treePath = new TreePath(nodes2);
                    this._tree.checkPath(treePath, false, false);
                    this._tree.disableCheckBoxForPath(treePath);
                }
            }
            VisualsUtil.expandTreeNodes(this._tree);
            if (this._targetContainer != null && (node = model.getImportNode(this._targetContainer.getIdentifier())) instanceof DefaultMutableTreeNode && !this._tree.isExpanded(nodePath = new TreePath(nodes = ((DefaultMutableTreeNode)((Object)node)).getPath()))) {
                this._tree.expandPath(nodePath);
            }
            TreeSelectionModel chkModel = this._tree.getCheckedModel();
            chkModel.addTreeSelectionListener(new CheckStateListener());
            this.checkForDuplicateObjects(model);
            returnCode = model.getRoot() != null;
        }
        catch (NoObjectsToImportException e) {
            returnCode = false;
            this._wizard.replaceWizardData("LOAD_PACKAGE_ERROR", Boolean.TRUE);
            this.resetTreeModel();
            VisualsUtil.displayMessageDialog(RB.getStringResource("ImportWizard.Error.txt"), RB.getStringResource("ImportTreePanel.NoNewObjects.txt"), 2);
            this._tree.requestFocus();
            if (!returnCode) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ImportTreeManager.this._wizard.getNextButton().setEnabled(false);
                    }
                });
            }
        }
        catch (Exception e2) {
            returnCode = false;
            this._wizard.replaceWizardData("LOAD_PACKAGE_ERROR", Boolean.TRUE);
            this.resetTreeModel();
            String msg = e2.getLocalizedMessage();
            if (msg == null) {
                msg = RB.getStringResource("ImportTreePanel.Tree.Error.txt");
            }
            if (this._operation.getLogger() != null) {
                if (this._operation.getLogger().isDebugEnabled()) {
                    this._operation.getLogger().error(msg, e2);
                } else {
                    this._operation.getLogger().error(msg);
                }
            }
            VisualsUtil.displayErrorDialog(RB.getStringResource("ImportWizard.Error.txt"), msg);
            {
                catch (Throwable throwable) {
                    this._tree.requestFocus();
                    if (!returnCode) {
                        SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                    }
                    throw throwable;
                }
            }
            this._tree.requestFocus();
            if (!returnCode) {
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
        }
        this._tree.requestFocus();
        if (!returnCode) {
            SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
        }
        return returnCode;
    }

    public void repopulateTree(boolean preserveCheckState) {
        if (preserveCheckState) {
            this.checkNodesAutomatically(false);
            this._tree.setCheckBoxShouldCheckChildren(false);
        }
        try {
            Map<String, Boolean> checkState = null;
            if (preserveCheckState) {
                checkState = this.getCheckState();
            }
            this.populateTree(true);
            if (preserveCheckState && checkState != null) {
                this.setCheckedState(checkState);
            }
        }
        catch (Exception e) {
            VisualsUtil.displayErrorDialog(RB.getStringResource("ImportWizard.Error.txt"), e.getLocalizedMessage());
        }
        finally {
            this.checkNodesAutomatically(true);
            this._tree.setCheckBoxShouldCheckChildren(true);
        }
    }

    public Map<String, Boolean> getCheckState() throws ServiceException, RemoteException {
        LinkedHashMap<String, Boolean> cache = new LinkedHashMap<String, Boolean>();
        TreeModel model = this._tree.getModel();
        if (model instanceof ImportTreeModelInterface) {
            Object[] selectedItems = this._tree.getCheckedObjects();
            int length = selectedItems.length;
            for (int i = 0; i < length; ++i) {
                ImportTreeNodeInterface visualNode;
                PublicObjectNodeInterface poNode;
                if (!(selectedItems[i] instanceof ImportTreeNodeInterface) || (poNode = (visualNode = (ImportTreeNodeInterface)selectedItems[i]).getPublicObjectNode()) == null) continue;
                cache.put(poNode.getIdentifier(), Boolean.TRUE);
            }
            TreeNodeInterface rootNode = (TreeNodeInterface)model.getRoot();
            Enumeration<? extends TreeNode> children = rootNode.children();
            while (children.hasMoreElements()) {
                ImportTreeNodeInterface childVisualNode = (ImportTreeNodeInterface)children.nextElement();
                this.loadUncheckedNodes(childVisualNode, cache);
            }
        }
        return cache;
    }

    private void loadUncheckedNodes(ImportTreeNodeInterface visualNode, Map<String, Boolean> cache) throws ServiceException, RemoteException {
        PublicObjectNodeInterface poNode = visualNode.getPublicObjectNode();
        if (poNode != null) {
            if (!cache.containsKey(poNode.getIdentifier())) {
                cache.put(poNode.getIdentifier(), Boolean.FALSE);
            }
            if (visualNode.isFolder()) {
                Enumeration<? extends TreeNode> children = visualNode.children();
                while (children.hasMoreElements()) {
                    ImportTreeNodeInterface childVisualNode = (ImportTreeNodeInterface)children.nextElement();
                    this.loadUncheckedNodes(childVisualNode, cache);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCheckedState(Map<String, Boolean> checkState) throws ServiceException, RemoteException {
        if (checkState == null) {
            return;
        }
        TreeModel model = this._tree.getModel();
        if (model instanceof ImportTreeModelInterface) {
            boolean checkingChildren = this._tree.isCheckBoxShouldCheckChildren();
            this._tree.setCheckBoxShouldCheckChildren(false);
            try {
                TreeNodeInterface rootNode = (TreeNodeInterface)model.getRoot();
                Enumeration<? extends TreeNode> children = rootNode.children();
                while (children.hasMoreElements()) {
                    ImportTreeNodeInterface childVisualNode = (ImportTreeNodeInterface)children.nextElement();
                    this.checkNodeSelectState(childVisualNode, checkState);
                }
            }
            finally {
                this._tree.setCheckBoxShouldCheckChildren(checkingChildren);
            }
        }
    }

    private void checkNodeSelectState(ImportTreeNodeInterface visualNode, Map<String, Boolean> checkState) throws ServiceException, RemoteException {
        PublicObjectNodeInterface poNode = visualNode.getPublicObjectNode();
        if (poNode != null) {
            Boolean value = checkState.get(poNode.getIdentifier());
            if (!Boolean.FALSE.equals(value)) {
                TreePath path = new TreePath(((ImportTreeNode)visualNode).getPath());
                this._tree.checkPath(path, true, false);
            }
            if (visualNode.isFolder()) {
                Enumeration<? extends TreeNode> children = visualNode.children();
                while (children.hasMoreElements()) {
                    ImportTreeNodeInterface childVisualNode = (ImportTreeNodeInterface)children.nextElement();
                    this.checkNodeSelectState(childVisualNode, checkState);
                }
            }
        }
    }

    private void resetTreeModel() {
        this._tree.setModel(EMPTY_TREE_MODEL);
    }

    private ImportTreeModelInterface createTreeModel() throws ServiceException, RemoteException {
        ImportFolderModelInterface importModel = ModelFactory.createImportFolderModel(this._operation);
        ImportTreeModel model = new ImportTreeModel(importModel);
        TreeLoader loader = new TreeLoader(this._wizard);
        loader.createTree(model);
        return model;
    }

    private void checkForDuplicateObjects(ImportTreeModelInterface model) throws ServiceException, RemoteException {
        if (this.areDuplicateObjectsSelected(model)) {
            this._owningPanel.displayInfoMessage(RB.getStringResource("ImportTreePanel.DuplicateObjectWarning.txt"), Images.getImage(Images.WARNING_ICON));
        } else {
            this._owningPanel.hideInfoMessage();
        }
    }

    private boolean doesPackageContainDuplicateObjects(ImportTreeModelInterface model) {
        ImportFolderModelInterface folderModel = model.getImportModel();
        if (folderModel == null) {
            return false;
        }
        return folderModel.getDuplicateNamedObjects() != null && !folderModel.getDuplicateNamedObjects().isEmpty();
    }

    protected static Map<ContainerNodeInterface, List<PublicObjectNodeInterface>> getDuplicateObjectsByContainer(ImportFolderModelInterface folderModel) throws ServiceException, RemoteException {
        if (folderModel.getDuplicateNamedObjects() == null) {
            return null;
        }
        LinkedHashMap<ContainerNodeInterface, List<PublicObjectNodeInterface>> containerCache = new LinkedHashMap<ContainerNodeInterface, List<PublicObjectNodeInterface>>();
        List<PublicObjectNodeInterface> items = folderModel.getDuplicateNamedObjects();
        for (PublicObjectNodeInterface node : items) {
            ArrayList<PublicObjectNodeInterface> nodes = (ArrayList<PublicObjectNodeInterface>)containerCache.get((ContainerNodeInterface)node.getContainer());
            if (nodes == null) {
                nodes = new ArrayList<PublicObjectNodeInterface>();
                containerCache.put((ContainerNodeInterface)node.getContainer(), nodes);
            }
            nodes.add(node);
        }
        return containerCache;
    }

    private boolean areDuplicateObjectsSelected(ImportTreeModelInterface model) throws ServiceException, RemoteException {
        ImportFolderModelInterface folderModel = model.getImportModel();
        if (folderModel == null) {
            return false;
        }
        Map<ContainerNodeInterface, List<PublicObjectNodeInterface>> containerCache = ImportTreeManager.getDuplicateObjectsByContainer(folderModel);
        if (containerCache != null) {
            for (ContainerNodeInterface container : containerCache.keySet()) {
                LinkedHashMap<String, Set<String>> typeNameCache = new LinkedHashMap<String, Set<String>>(5);
                List<PublicObjectNodeInterface> nodes = containerCache.get(container);
                for (PublicObjectNodeInterface node : nodes) {
                    Set<String> names;
                    ImportTreeNodeInterface treeNode = model.getImportNode(node.getIdentifier());
                    if (treeNode == null || !VisualsUtil.isNodeSelected((CheckBoxTree)this._tree, (DefaultMutableTreeNode)((Object)treeNode))) continue;
                    String publicType = node.getTypeDescriptor().getTypeName();
                    if (!typeNameCache.containsKey(publicType)) {
                        names = new HashSet(2);
                        typeNameCache.put(publicType, names);
                    }
                    if ((names = (Set)typeNameCache.get(publicType)).contains(node.getName())) {
                        return true;
                    }
                    names.add(node.getName());
                }
            }
        }
        return false;
    }

    public TreeNodeInterface[] getCheckedNodes() {
        Object[] objs = this._tree.getCheckedObjects();
        if (objs != null) {
            int length = objs.length;
            ArrayList<TreeNodeInterface> nodes = new ArrayList<TreeNodeInterface>(length);
            for (int i = 0; i < length; ++i) {
                Object obj = objs[i];
                if (!(obj instanceof TreeNodeInterface)) continue;
                nodes.add((TreeNodeInterface)obj);
            }
            return nodes.toArray(new TreeNodeInterface[nodes.size()]);
        }
        return null;
    }

    private class CheckStateListener
    implements TreeSelectionListener {
        private CheckStateListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            TreeModel model;
            Object obj;
            TreePath path = e.getPath();
            if (path != null && (obj = path.getLastPathComponent()) instanceof ImportTreeNodeInterface && (model = ImportTreeManager.this._tree.getModel()) instanceof ImportTreeModelInterface && ImportTreeManager.this.doesPackageContainDuplicateObjects((ImportTreeModelInterface)model)) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ImportTreeManager.this.checkForDuplicateObjects((ImportTreeModelInterface)model);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                });
            }
        }
    }

    private class TreeLoader
    extends ProgressBarLauncher {
        public TreeLoader(ImportWizardInterface wizard) {
            super(wizard, wizard.getImportHandler());
        }

        @Override
        public String getMessage() {
            return ImportTreeManager.this._repopulatingTree ? RB.getStringResource("ImportTreePanel.Repopulating.txt") : RB.getStringResource("ImportTreePanel.ProgressMessage.txt");
        }

        @Override
        public String getTitle() {
            return RB.getStringResource("ImportTreePanel.ProgressTitle.txt");
        }

        public void createTree(ImportTreeModelInterface model) throws ServiceException {
            this.setWaitTime(1000);
            this.launch(new TreeRunnable(model));
            ProgressReturnCode code = this.getReturnCode();
            int rc = code.getReturnCode();
            switch (rc) {
                case 0: {
                    break;
                }
                case 4: 
                case 8: {
                    throw new ServiceException(code.getErrorMessage());
                }
                case 100: {
                    throw new NoObjectsToImportException(code.getErrorMessage());
                }
            }
        }

        class TreeRunnable
        implements Runnable {
            private ImportTreeModelInterface _model;

            public TreeRunnable(ImportTreeModelInterface model) {
                this._model = model;
            }

            @Override
            public void run() {
                ProgressReturnCode rc = TreeLoader.this.getReturnCode();
                try {
                    ImportFolderModelInterface importModel = this._model.getImportModel();
                    ImportTreeManager.this._targetContainer = ImportTreeManager.this._operation.getTargetContainer();
                    List<? extends PromotionItemInterface> itemsToImport = ImportTreeManager.this._operation.getMetadataManager().getPromotionItems();
                    importModel.populateModel(itemsToImport, ImportTreeManager.this._targetContainer);
                    this._model.addChildren();
                }
                catch (NoObjectsToImportException e) {
                    rc.setReturnCode(100);
                    rc.setErrorMessage(e.getMessage());
                }
                catch (Exception e) {
                    if (ImportTreeManager.this._operation.getLogger().isDebugEnabled()) {
                        ImportTreeManager.this._operation.getLogger().debug((Object)"Error creating import tree", e);
                    }
                    rc.setReturnCode(8);
                    rc.setErrorMessage(e.getMessage());
                }
            }
        }
    }
}

