/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.promotion.visuals;

import com.sas.metadata.promotion.ImportItemInterface;
import com.sas.metadata.promotion.ImportOperationInterface;
import com.sas.metadata.promotion.LoggingUtil;
import com.sas.metadata.promotion.visuals.ImportWizardInterface;
import com.sas.metadata.promotion.visuals.PasteSpecialWizard;
import com.sas.metadata.promotion.visuals.RB;
import com.sas.metadata.promotion.visuals.WizardPanelInterface;
import com.sas.swing.visuals.util.LayoutConstants;
import com.sas.text.Message;
import com.sas.workspace.WATextArea;
import com.sas.workspace.WsDescriptionWizardTab;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public class ImportSummaryPanel
extends WsDescriptionWizardTab
implements WizardPanelInterface {
    public static final String PANEL_NAME = "ImportSummary";
    private static final String PANEL_TITLE = RB.getStringResource("ImportSummaryPanel.Title.txt");
    private static final String NEW_LINE = "\r\n";
    private ImportWizardInterface _wizard;
    private ImportOperationInterface _importHandler;
    private WATextArea _summaryTextArea;
    private JScrollPane _scrollPane;

    public ImportSummaryPanel(ImportWizardInterface wizard) {
        this._wizard = wizard;
        this.initialize();
        this.layoutWidgets();
    }

    @Override
    public String getPanelTitle() {
        return PANEL_TITLE;
    }

    @Override
    public String getPanelName() {
        return PANEL_NAME;
    }

    public void initialize() {
        this.setHelpProduct("promotion");
        if (this._wizard instanceof PasteSpecialWizard) {
            this.setHelpTopic("pastespec_summarywin");
        } else {
            this.setHelpTopic("imp_summarywin");
        }
        if (this._wizard instanceof PasteSpecialWizard) {
            this.setDescription(RB.getStringResource("ImportSummaryPanel.DescriptionPaste.txt"));
        } else {
            this.setDescription(RB.getStringResource("ImportSummaryPanel.Description.txt"));
        }
        this._summaryTextArea = new WATextArea();
        this._summaryTextArea.setEditable(false);
        this._summaryTextArea.setMargin(new Insets(5, 5, 5, 5));
        this._summaryTextArea.setBackground(null);
        this._summaryTextArea.setBehavior(1);
        Font fnt = this._summaryTextArea.getFont();
        fnt = new Font("Monospaced", fnt.getStyle(), fnt.getSize() - 1);
        this._summaryTextArea.setFont(fnt);
        this._scrollPane = new JScrollPane((Component)this._summaryTextArea);
    }

    public void layoutWidgets() {
        this.setLayout(new GridBagLayout());
        this.add(this._scrollPane, new GridBagConstraints(1, 0, 0, 1, 1.0, 0.5, 18, 1, LayoutConstants.EMPTY_INSETS, 0, 0));
    }

    public boolean doDataExchange(boolean bSaveToModel) {
        if (!bSaveToModel) {
            this._importHandler = this._wizard.getImportHandler();
            if (this._importHandler == null) {
                return false;
            }
            StringBuffer sb = new StringBuffer();
            if (this._importHandler.getPromotionType() == 1) {
                sb.append(RB.getStringResource("ImportSummaryPanel.FileToImport.txt"));
                sb.append(NEW_LINE);
                sb.append((String)this._wizard.getWizardData("IMPORT_PACKAGE"));
                sb.append(NEW_LINE);
                sb.append(NEW_LINE);
            }
            Map importItems = this._importHandler.getImportItems();
            try {
                String objectsToImport = LoggingUtil.displayImportedObjects(importItems, this._importHandler.getServer(), false);
                if (objectsToImport.length() == 0) {
                    if (this._importHandler.getPromotionType() == 1) {
                        sb.append(Message.format((ResourceBundle)RB.getResources(), (String)"ImportSummaryPanel.NoObjectsSelected.txt", (Object)RB.getStringResource("Common.ImportType.txt")));
                    } else if (this._importHandler.getPromotionType() == 3) {
                        sb.append(Message.format((ResourceBundle)RB.getResources(), (String)"ImportSummaryPanel.NoObjectsSelected.txt", (Object)RB.getStringResource("Common.PasteType.txt")));
                    } else if (this._importHandler.getPromotionType() == 4) {
                        sb.append(Message.format((ResourceBundle)RB.getResources(), (String)"ImportSummaryPanel.NoObjectsSelected.txt", (Object)RB.getStringResource("Common.PromoteType.txt")));
                    }
                    if (importItems.size() == 1 && importItems.containsKey("Folder")) {
                        boolean displayMessage = true;
                        List folders = (List)importItems.get("Folder");
                        for (ImportItemInterface item : folders) {
                            if (item.getImportState() == 0) continue;
                            displayMessage = false;
                            break;
                        }
                        if (displayMessage) {
                            sb.append(NEW_LINE);
                            sb.append(RB.getStringResource("ImportSummaryPanel.OnlyFolders.txt"));
                        }
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ImportSummaryPanel.this._wizard.getNextButton().setEnabled(false);
                        }
                    });
                } else {
                    sb.append(RB.getStringResource("ImportSummaryPanel.ObjectsIncluded.txt"));
                    sb.append(NEW_LINE);
                    sb.append(objectsToImport);
                    String mapping = LoggingUtil.displayConnectionMapping(this._importHandler);
                    sb.append(mapping);
                }
            }
            catch (Exception e) {
                this._importHandler.getLogger().error(e.getMessage());
            }
            this._summaryTextArea.setText(sb.toString());
            this._summaryTextArea.setCaretPosition(0);
        }
        return true;
    }
}

