/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.promotion.visuals;

import com.sas.metadata.promotion.ImportHandler;
import com.sas.metadata.promotion.Log;
import com.sas.metadata.promotion.MetadataPromotionException;
import com.sas.metadata.promotion.visuals.AbstractFilePanel;
import com.sas.metadata.promotion.visuals.ImportWizardInterface;
import com.sas.metadata.promotion.visuals.RB;
import com.sas.metadata.promotion.visuals.WizardPanelInterface;
import com.sas.services.TransportException;
import com.sas.swing.visuals.util.LayoutConstants;
import com.sas.swing.visuals.util.Util;
import com.sas.text.Message;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WATextArea;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.rmi.RemoteException;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;

public class ImportFilePanel
extends AbstractFilePanel
implements WizardPanelInterface {
    public static final String PANEL_NAME = "FilePanel";
    private static final String PANEL_TITLE = RB.getStringResource("ImportFilePanel.Title.txt");
    protected JCheckBox _securityCheckBox;
    private JLabel _securityNoteLabel;
    protected JCheckBox _preservePathCheckBox;
    private JPanel _optionsPanel;
    private JRadioButton _newObjectsButton;
    private JRadioButton _allObjectsButton;
    private WATextArea _newObjectsLabel;
    private WATextArea _allObjectsLabel;
    private boolean _errorOccurred = false;
    private ImportHandler _handler;
    private Log _log;
    private String _previousFileNameValue = null;
    private int _previousTypeValue;
    private boolean _previousSecurityValue;
    private boolean _previousPreservePathValue;

    public ImportFilePanel(ImportWizardInterface wizard) {
        super(wizard);
        this._wizard = wizard;
        this._handler = wizard.getImportHandler();
        this.initialize();
        this.layoutWidgets();
    }

    @Override
    public String getPanelTitle() {
        return PANEL_TITLE;
    }

    @Override
    public String getPanelName() {
        return PANEL_NAME;
    }

    @Override
    public void initialize() {
        this._log = Log.getInstance(ImportFilePanel.class.getName());
        this.setHelpProduct("promotion");
        this.setHelpTopic("imp_pkgnamewin");
        this.setDescription(this._wizard.getDescription());
        this.setText(RB.getStringResource("ImportFilePanel.Label.txt"));
        super.initialize();
        this._optionsPanel = new JPanel();
        TitledBorder title = BorderFactory.createTitledBorder(RB.getStringResource("ImportFilePanel.BorderTitle.txt"));
        this._optionsPanel.setBorder(title);
        this._securityCheckBox = new JCheckBox();
        Util.configureMnemonicForButton((AbstractButton)this._securityCheckBox, (String)RB.getStringResource("FilePanel.IncludeSecurity.txt"));
        this._preservePathCheckBox = new JCheckBox();
        Util.configureMnemonicForButton((AbstractButton)this._preservePathCheckBox, (String)RB.getStringResource("ImportFilePanel.PreservePath.All.txt"));
        this._preservePathCheckBox.setVisible(this._handler.importIntoRoot());
        this._preservePathCheckBox.setSelected(true);
        this._allObjectsButton = new JRadioButton();
        this._newObjectsButton = new JRadioButton();
        this._allObjectsButton.setSelected(true);
        Util.configureMnemonicForButton((AbstractButton)this._allObjectsButton, (String)RB.getStringResource("ImportFilePanel.AllButton.txt"));
        Util.configureMnemonicForButton((AbstractButton)this._newObjectsButton, (String)RB.getStringResource("ImportFilePanel.PartialButton.txt"));
        ButtonGroup group = new ButtonGroup();
        group.add(this._allObjectsButton);
        group.add(this._newObjectsButton);
        Font labelFont = UIManager.getFont("Label.font");
        this._securityNoteLabel = new JLabel();
        this._securityNoteLabel.setFont(labelFont);
        this._securityNoteLabel.setText(RB.getStringResource("ImportFilePanel.SecurityNote.txt"));
        this._allObjectsLabel = new WATextArea();
        this._allObjectsLabel.setFont(labelFont);
        this._allObjectsLabel.setColumns(30);
        this._allObjectsLabel.setBehavior(1);
        this._allObjectsLabel.setText(RB.getStringResource("ImportFilePanel.AllLabel.txt"));
        this._allObjectsLabel.setAutosize(true);
        this._newObjectsLabel = new WATextArea();
        this._newObjectsLabel.setFont(labelFont);
        this._newObjectsLabel.setColumns(30);
        this._newObjectsLabel.setBehavior(1);
        this._newObjectsLabel.setText(RB.getStringResource("ImportFilePanel.PartialLabel.txt"));
        this._newObjectsLabel.setAutosize(true);
        this._allObjectsLabel.setLineWrap(true);
        this._allObjectsLabel.setWrapStyleWord(true);
        this._newObjectsLabel.setLineWrap(true);
        this._newObjectsLabel.setWrapStyleWord(true);
    }

    @Override
    public void layoutWidgets() {
        super.layoutWidgets();
        JPanel securityPanel = new JPanel();
        securityPanel.setLayout(new GridBagLayout());
        securityPanel.add((Component)this._securityCheckBox, new GridBagConstraints(0, 0, 0, 1, 1.0, 0.0, 18, 1, LayoutConstants.EMPTY_INSETS, 0, 0));
        securityPanel.add((Component)this._securityNoteLabel, new GridBagConstraints(0, 1, 0, 1, 1.0, 0.0, 18, 1, new Insets(0, 20, 0, 0), 0, 0));
        JSeparator sep = new JSeparator(0);
        JLabel label = new JLabel(RB.getStringResource("ImportFilePanel.Select.txt"));
        JPanel sepPanel = new JPanel();
        sepPanel.setLayout(new GridBagLayout());
        sepPanel.add((Component)label, new GridBagConstraints(0, 0, -1, 0, 0.0, 0.0, 17, 0, LayoutConstants.EMPTY_INSETS, 0, 0));
        sepPanel.add((Component)sep, new GridBagConstraints(1, 0, 0, 0, 1.0, 0.0, 10, 2, new Insets(0, 6, 0, 0), 0, 0));
        this._optionsPanel.setLayout(new GridBagLayout());
        this._optionsPanel.add((Component)securityPanel, new GridBagConstraints(0, 0, 0, 1, 1.0, 0.0, 18, 1, LayoutConstants.EMPTY_INSETS, 0, 0));
        this._optionsPanel.add((Component)this._preservePathCheckBox, new GridBagConstraints(0, 1, 0, 1, 1.0, 0.0, 18, 1, new Insets(10, 0, 0, 0), 0, 0));
        this._optionsPanel.add((Component)sepPanel, new GridBagConstraints(0, 2, 0, 1, 1.0, 0.0, 18, 1, new Insets(20, 4, 0, 0), 0, 0));
        this._optionsPanel.add((Component)this._allObjectsButton, new GridBagConstraints(0, 3, 0, 1, 1.0, 0.0, 18, 1, new Insets(10, 0, 0, 0), 0, 0));
        this._optionsPanel.add((Component)this._allObjectsLabel, new GridBagConstraints(0, 4, 0, 1, 1.0, 0.0, 18, 1, new Insets(0, 20, 0, 0), 0, 0));
        this._optionsPanel.add((Component)this._newObjectsButton, new GridBagConstraints(0, 5, 0, 1, 1.0, 0.0, 18, 1, new Insets(10, 0, 0, 0), 0, 0));
        this._optionsPanel.add((Component)this._newObjectsLabel, new GridBagConstraints(0, 6, 0, 1, 1.0, 0.0, 18, 1, new Insets(0, 20, 10, 0), 0, 0));
        this.add(this._optionsPanel);
        this.add(new JPanel());
    }

    @Override
    public void setText(String text) {
        this._labelText = text;
    }

    public boolean doDataExchange(boolean bSaveToModel) {
        if (!bSaveToModel) {
            if (((ImportWizardInterface)this._wizard).getImportHandler().isProjectRepository()) {
                this._securityCheckBox.setEnabled(false);
            }
            this.setDescription(this._wizard.getDescription());
            this.setInitialFileName();
        }
        return true;
    }

    public boolean validateData() {
        try {
            String fileName = this.getSelectedFileName();
            this.setCurrentDirectory(fileName);
            this.loadPackageFile(fileName);
            return true;
        }
        catch (TransportException e) {
            return this.handleErrorCondition(e.getLocalizedMessage());
        }
        catch (MetadataPromotionException e) {
            return this.handleErrorCondition(e.getLocalizedMessage());
        }
        catch (Throwable t) {
            this._log.debug((Object)"LoadInputFile", t);
            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"ImportFilePanel.GenericError.fmt.txt", (Object)t.getLocalizedMessage());
            return this.handleErrorCondition(msg);
        }
    }

    private boolean handleErrorCondition(String errorMessage) {
        this._errorOccurred = true;
        if (this._log.isErrorEnabled()) {
            this._log.error(errorMessage);
        }
        MessageUtil.displayMessage((String)errorMessage, (String)RB.getStringResource("ImportWizard.Error.txt"), (int)0, (int)-1);
        return false;
    }

    private void loadPackageFile(String packageFileName) throws MetadataPromotionException, TransportException, RemoteException {
        int importType = 0;
        if (this._newObjectsButton.isSelected()) {
            importType = 1;
        }
        boolean securityIncluded = this._securityCheckBox.isSelected();
        boolean preservePaths = this._preservePathCheckBox.isVisible() ? this._preservePathCheckBox.isSelected() : false;
        boolean loadPackage = this.compareValues(packageFileName, importType, securityIncluded, preservePaths);
        this._wizard.replaceWizardData("LOAD_PACKAGE", loadPackage);
        if (loadPackage) {
            this._handler.setImportType(importType);
            this._handler.importSecurityMetadata(securityIncluded);
            this._handler.setPreservePaths(preservePaths);
            this._handler.loadExportPackage(packageFileName);
        }
        this.setConditionState("IMPORT_TREE");
        this._wizard.replaceWizardData("IMPORT_PACKAGE", packageFileName);
        this._errorOccurred = false;
    }

    private boolean compareValues(String packageFileName, int importType, boolean securityIncluded, boolean preservePaths) {
        if (this._previousFileNameValue == null || this._errorOccurred) {
            this.setPreviousValues(packageFileName, importType, securityIncluded, preservePaths);
            return true;
        }
        Object value = this._wizard.getWizardData("LOAD_PACKAGE_ERROR");
        if (value instanceof Boolean && ((Boolean)value).booleanValue()) {
            this.setPreviousValues(packageFileName, importType, securityIncluded, preservePaths);
            return true;
        }
        if (this._previousFileNameValue.equals(packageFileName) && this._previousTypeValue == importType && this._previousSecurityValue == securityIncluded && this._previousPreservePathValue == preservePaths) {
            return false;
        }
        this.setPreviousValues(packageFileName, importType, securityIncluded, preservePaths);
        return true;
    }

    private void setPreviousValues(String packageFileName, int importType, boolean securityIncluded, boolean preservePaths) {
        this._previousFileNameValue = packageFileName;
        this._previousTypeValue = importType;
        this._previousSecurityValue = securityIncluded;
        this._previousPreservePathValue = preservePaths;
    }
}

