/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.promotion.visuals;

import com.sas.metadata.promotion.ImportHandler;
import com.sas.metadata.promotion.ImportOperationInterface;
import com.sas.metadata.promotion.MetadataPromotionException;
import com.sas.metadata.promotion.visuals.AbstractExecutePanel;
import com.sas.metadata.promotion.visuals.ImportWizardInterface;
import com.sas.metadata.promotion.visuals.PasteSpecialWizard;
import com.sas.metadata.promotion.visuals.RB;
import com.sas.metadata.remote.MdException;
import com.sas.services.TransportException;
import com.sas.text.Message;
import java.io.IOException;
import java.util.ResourceBundle;

public class ImportExecutePanel
extends AbstractExecutePanel {
    private static final String STATUS_IMPORTING_METADATA = RB.getStringResource("ImportExecutePanel.CreatingMetadata.txt");
    private static final String STATUS_UPDATING_OBJECTS = RB.getStringResource("ImportExecutePanel.AdjustingMetadata.txt");
    private static final String STATUS_IMPORTING_CONTENT = RB.getStringResource("ImportExecutePanel.CreatingContent.txt");

    public ImportExecutePanel(ImportWizardInterface wizard) {
        super(wizard, wizard.getImportHandler());
        this.initialize();
        this.layoutWidgets();
    }

    @Override
    public String getPanelTitle() {
        int type = ((ImportOperationInterface)((Object)this._operation)).getPromotionType();
        if (type == 3) {
            return RB.getStringResource("ImportExecutePanel.PasteTitle.txt");
        }
        return RB.getStringResource("ImportExecutePanel.Title.txt");
    }

    @Override
    public void initialize() {
        this.setHelpTopic("importexecutepanel");
        this.addStatusEntry(205, STATUS_IMPORTING_METADATA);
        this.addStatusEntry(220, STATUS_UPDATING_OBJECTS);
        this.addStatusEntry(230, STATUS_IMPORTING_CONTENT);
        if (this._wizard instanceof PasteSpecialWizard) {
            this.setDescription(RB.getStringResource("ImportExecutePanel.DescPaste.txt"));
        } else {
            this.setDescription(RB.getStringResource("ImportExecutePanel.Desc.txt"));
        }
        super.initialize();
        if (this._wizard instanceof PasteSpecialWizard) {
            this._executionLabel.setText(RB.getStringResource("ImportExecutePanel.Pasting.txt"));
        } else {
            this._executionLabel.setText(RB.getStringResource("ImportExecutePanel.Importing.txt"));
        }
    }

    @Override
    public AbstractExecutePanel.ExecutionThread createExecutionThread() {
        return new ImportThread();
    }

    class ImportThread
    extends AbstractExecutePanel.ExecutionThread {
        ImportThread() {
        }

        @Override
        public void launchOperation() {
            try {
                this._rc |= ((ImportHandler)ImportExecutePanel.this._operation).runImport();
            }
            catch (MdException e) {
                this._rc |= 8;
                if (this._log.isErrorEnabled()) {
                    String msg = e.getMessage() == null ? e.toString() : e.getMessage();
                    this._log.error(Message.format((ResourceBundle)RB.getResources(), (String)"ImportExecutePanel.ImportMetadataError.fmt.txt", (Object)msg));
                }
                if (this._log.isDebugEnabled()) {
                    this._log.debug((Object)"MetadataException", e);
                }
            }
            catch (MetadataPromotionException e) {
                this._rc |= 8;
                if (this._log.isErrorEnabled()) {
                    String msg = e.getMessage() == null ? e.toString() : e.getMessage();
                    this._log.error(Message.format((ResourceBundle)RB.getResources(), (String)"ImportExecutePanel.ImportMetadataError.fmt.txt", (Object)msg));
                }
                if (this._log.isDebugEnabled()) {
                    this._log.debug((Object)"MetadataException", (Throwable)((Object)e));
                }
            }
            catch (IOException e) {
                this._rc |= 8;
                if (this._log.isErrorEnabled()) {
                    String msg = e.getMessage() == null ? e.toString() : e.getMessage();
                    this._log.error(Message.format((ResourceBundle)RB.getResources(), (String)"ImportExecutePanel.ImportContentError.fmt.txt", (Object)msg));
                }
            }
            catch (TransportException e) {
                this._rc |= 8;
                if (this._log.isErrorEnabled()) {
                    String msg = e.getMessage() == null ? e.toString() : e.getMessage();
                    this._log.error(Message.format((ResourceBundle)RB.getResources(), (String)"ImportExecutePanel.ImportContentError.fmt.txt", (Object)msg));
                }
            }
            catch (OutOfMemoryError e) {
                this._rc |= 8;
                if (this._log.isErrorEnabled()) {
                    this._log.error(RB.getStringResource("ImportExecutePanel.MemoryError.txt"));
                }
            }
            catch (Exception e) {
                this._rc |= 8;
                if (this._log.isErrorEnabled()) {
                    String msg = e.getMessage() == null ? e.toString() : e.getMessage();
                    this._log.error(Message.format((ResourceBundle)RB.getResources(), (String)"ImportExecutePanel.GenericError.fmt.txt", (Object)msg));
                }
                this._log.debug((Object)"GenericException", e);
            }
            finally {
                if (this._log.isInfoEnabled()) {
                    if ((this._rc & 8) > 0) {
                        this._log.info(RB.getStringResource("ImportExecutePanel.FinishedError.txt"));
                    } else if ((this._rc & 4) > 0) {
                        this._log.info(RB.getStringResource("ImportExecutePanel.FinishedWarning.txt"));
                    } else {
                        this._log.info(RB.getStringResource("ImportExecutePanel.FinishedSuccess.txt"));
                    }
                }
            }
        }
    }
}

