/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.promotion.visuals;

import com.sas.metadata.promotion.visuals.RB;
import com.sas.swing.visuals.CompoundIcon;
import com.sas.visuals.Resources;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class Images {
    private static Map _imageCache = new HashMap();
    private static final String FOLDER_ICON = RB.getStringResource("Images.Folder.image");
    private static final String VIRTUAL_FOLDER_ICON = RB.getStringResource("Images.VirtualFolder.image");
    private static final String ROOT_FOLDER_ICON = RB.getStringResource("Images.RootFolder.image");
    private static final String NEW_OVERLAY_ICON = RB.getStringResource("Images.NewOverlay.image");
    private static final String OVERWRITE_OVERLAY_ICON = RB.getStringResource("Images.AttentionOverlay.image");
    private static final String INVALID_OVERLAY_ICON = RB.getStringResource("Images.InvalidOverlay.image");
    private static final String EXPORT_ICON = RB.getStringResource("Images.Export.image");
    private static final String IMPORT_ICON = RB.getStringResource("Images.Import.image");
    public static final String WARNING_ICON = RB.getStringResource("Images.Warning.image");

    public static Map getImageCache() {
        return _imageCache;
    }

    public static ImageIcon getImage(String iconName) {
        if (_imageCache.containsKey(iconName)) {
            return (ImageIcon)_imageCache.get(iconName);
        }
        ImageIcon icon = null;
        try {
            icon = Resources.getImageIcon((String)iconName, (int)16);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        _imageCache.put(iconName, icon);
        return icon;
    }

    public static ImageIcon getImageIcon(Class resourceClass, String resource) {
        ImageIcon icon = Resources.getImageIcon((Class)resourceClass, (String)resource);
        return icon;
    }

    public static ImageIcon getExportIcon() {
        return Images.getImage(EXPORT_ICON);
    }

    public static ImageIcon getImportIcon() {
        return Images.getImage(IMPORT_ICON);
    }

    public static ImageIcon getPackageIcon() {
        return Images.getImageIcon(Images.class, RB.getStringResource("Images.Package.image"));
    }

    public static Icon getRootFolderIcon() {
        return Images.getImage(ROOT_FOLDER_ICON);
    }

    public static Icon getFolderIcon() {
        return Images.getImage(FOLDER_ICON);
    }

    public static Icon getVirtualFolderIcon() {
        return Images.getImage(VIRTUAL_FOLDER_ICON);
    }

    public static Icon getNewFolderIcon() {
        Icon folder = Images.getFolderIcon();
        return Images.getNewObjectIcon(folder);
    }

    public static Icon getOverwriteObjectIcon(Icon typeIcon) {
        if (typeIcon == null) {
            return null;
        }
        Icon[] icons = new Icon[]{Images.getOverwriteObjectOverlayIcon(), typeIcon};
        CompoundIcon iconCompound = new CompoundIcon(icons);
        iconCompound.setIconGap(-15);
        iconCompound.setReverseOrder(true);
        return iconCompound;
    }

    public static Icon getNewObjectIcon(Icon typeIcon) {
        if (typeIcon == null) {
            return null;
        }
        Icon[] icons = new Icon[]{Images.getNewObjectOverlayIcon(), typeIcon};
        CompoundIcon iconCompound = new CompoundIcon(icons);
        iconCompound.setIconGap(-15);
        iconCompound.setReverseOrder(true);
        return iconCompound;
    }

    public static Icon getInvalidObjectIcon(Icon typeIcon) {
        if (typeIcon == null) {
            return null;
        }
        Icon[] icons = new Icon[]{Images.getInvalidObjectOverlayIcon(), typeIcon};
        CompoundIcon iconCompound = new CompoundIcon(icons);
        iconCompound.setIconGap(-15);
        iconCompound.setReverseOrder(true);
        return iconCompound;
    }

    public static Icon getUnknownObjectIcon() {
        return Images.getImage(RB.getStringResource("Images.UnknownObject.image"));
    }

    private static Icon getOverwriteObjectOverlayIcon() {
        return Images.getImage(OVERWRITE_OVERLAY_ICON);
    }

    private static Icon getNewObjectOverlayIcon() {
        return Images.getImage(NEW_OVERLAY_ICON);
    }

    private static Icon getInvalidObjectOverlayIcon() {
        return Images.getImage(INVALID_OVERLAY_ICON);
    }
}

