/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.promotion.visuals;

import com.sas.metadata.promotion.visuals.RB;
import com.sas.swing.visuals.WideComboBox;
import com.sas.swing.visuals.util.Util;
import com.sas.text.Message;
import com.sas.visuals.AutoSizingGridLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;

public class FindDialog
extends JDialog {
    private static final long serialVersionUID = 8054818560940218934L;
    private static int FINISHED_SEARCHING = -10;
    private JLabel _findLabel = new JLabel();
    private JComboBox _findComboBox = new WideComboBox();
    private JButton _findButton = new JButton();
    private JButton _closeButton = new JButton();
    private JCheckBox _matchCaseCheckbox = new JCheckBox();
    private JCheckBox _matchWholeWordCheckbox = new JCheckBox();
    private JRadioButton _searchForwardOption = new JRadioButton();
    private JRadioButton _searchBackwardOption = new JRadioButton();
    private ButtonGroup _searchDirectionGroup = new ButtonGroup();
    private static boolean _matchCase = false;
    private static boolean _matchWholeWord = false;
    private static String _currentSearchString = null;
    private static String[] _historySearchStrings = null;
    private boolean _searchForwards = true;
    private int _firstOccurrenceIndex = -1;
    private JTextComponent _searchableComponent;
    private boolean _previousMatchCase = false;
    private boolean _previousMatchWholeWord = false;
    private boolean _previousSearchForward = false;
    private String _previousSearchString = null;
    private int _previousOccurrenceIndex = -1;

    public static FindDialog createDialog(Component parentComponent, JTextComponent searchArea) {
        if (parentComponent instanceof Frame) {
            return new FindDialog((Frame)parentComponent, searchArea);
        }
        if (parentComponent instanceof Dialog) {
            return new FindDialog((Dialog)parentComponent, searchArea);
        }
        return null;
    }

    private FindDialog(Frame parent, JTextComponent searchArea) {
        super(parent);
        this._searchableComponent = searchArea;
        this.initialize();
        this.layoutWidgets();
    }

    private FindDialog(Dialog parent, JTextComponent searchArea) {
        super(parent);
        this._searchableComponent = searchArea;
        this.initialize();
        this.layoutWidgets();
    }

    private void initialize() {
        this.setSize(400, 175);
        this.setTitle(RB.getStringResource("FindDialog.Title.txt"));
        this.setLocationRelativeTo(this.getParent());
        this.setResizable(false);
        this.configureComponent(this._findLabel, RB.getStringResource("FindDialog.FindTextLabel.txt"));
        this.configureComponent(this._findButton, RB.getStringResource("FindDialog.FindNextLabel.txt"));
        this.configureComponent(this._closeButton, RB.getStringResource("FindDialog.Close.txt"));
        this.configureComponent(this._searchForwardOption, RB.getStringResource("FindDialog.SearchForwardLabel.txt"));
        this.configureComponent(this._searchBackwardOption, RB.getStringResource("FindDialog.SearchBackwardLabel.txt"));
        this.configureComponent(this._matchCaseCheckbox, RB.getStringResource("FindDialog.MatchCaseLabel.txt"));
        this.configureComponent(this._matchWholeWordCheckbox, RB.getStringResource("FindDialog.MatchWholeWordLabel.txt"));
        this._findComboBox.requestFocus();
        this._findComboBox.setEditable(true);
        this.initializeListeners();
        Component[] comps = this._findComboBox.getComponents();
        if (comps.length > 0) {
            this._findLabel.setLabelFor(comps[comps.length - 1]);
        }
        if (_historySearchStrings != null) {
            for (int i = 0; i < _historySearchStrings.length; ++i) {
                this._findComboBox.addItem(_historySearchStrings[i]);
            }
        }
        if (_currentSearchString == null || _currentSearchString.length() == 0) {
            this.enableFields(false);
        } else {
            this.setSearchText(_currentSearchString);
            this.enableFields(true);
        }
        this._matchCaseCheckbox.setSelected(_matchCase);
        this._matchWholeWordCheckbox.setSelected(_matchWholeWord);
        if (this._searchForwards) {
            this._searchForwardOption.setSelected(true);
        } else {
            this._searchBackwardOption.setSelected(true);
        }
    }

    private void layoutWidgets() {
        JPanel searchFieldPanel = new JPanel();
        AutoSizingGridLayout searchFieldLayout = new AutoSizingGridLayout(1, 2, 5, 5, true, false, true);
        searchFieldLayout.setRemainderColumn(2);
        searchFieldPanel.setLayout((LayoutManager)searchFieldLayout);
        searchFieldPanel.add(this._findLabel);
        searchFieldPanel.add(this._findComboBox);
        JPanel optionsPanel = new JPanel();
        String searchOptionsLabel = RB.getStringResource("FindDialog.OptionsLabel.txt");
        TitledBorder optionsBorder = new TitledBorder(searchOptionsLabel);
        optionsPanel.setBorder(optionsBorder);
        AutoSizingGridLayout optionsLayout = new AutoSizingGridLayout(2, 1, 0, 0, true, false, false);
        optionsPanel.setLayout((LayoutManager)optionsLayout);
        optionsPanel.add(this._matchCaseCheckbox);
        optionsPanel.add(this._matchWholeWordCheckbox);
        this._searchDirectionGroup.add(this._searchForwardOption);
        this._searchDirectionGroup.add(this._searchBackwardOption);
        JPanel directionPanel = new JPanel();
        String searchDirectionLabel = RB.getStringResource("FindDialog.DirectionLabel.txt");
        TitledBorder directionBorder = new TitledBorder(searchDirectionLabel);
        directionPanel.setBorder(directionBorder);
        AutoSizingGridLayout directionLayout = new AutoSizingGridLayout(2, 1, 0, 0, true, false, false);
        directionPanel.setLayout((LayoutManager)directionLayout);
        directionPanel.add(this._searchForwardOption);
        directionPanel.add(this._searchBackwardOption);
        JPanel settingsPanel = new JPanel();
        AutoSizingGridLayout settingsLayout = new AutoSizingGridLayout(1, 2, 5, 0, true, false, true);
        settingsPanel.setLayout((LayoutManager)settingsLayout);
        settingsPanel.add(optionsPanel);
        settingsPanel.add(directionPanel);
        JPanel controlPanel = new JPanel();
        AutoSizingGridLayout controlLayout = new AutoSizingGridLayout(2, 1, 0, 15, true, false, true);
        controlPanel.setLayout((LayoutManager)controlLayout);
        controlPanel.add(searchFieldPanel);
        controlPanel.add(settingsPanel);
        JPanel buttonPanel = new JPanel();
        AutoSizingGridLayout buttonLayout = new AutoSizingGridLayout(2, 1, 0, 5, true, false, false);
        buttonPanel.setLayout((LayoutManager)buttonLayout);
        buttonPanel.add(this._findButton);
        buttonPanel.add(this._closeButton);
        JPanel mainPanel = new JPanel();
        EmptyBorder border = new EmptyBorder(15, 10, 10, 10);
        mainPanel.setBorder(border);
        AutoSizingGridLayout mainLayout = new AutoSizingGridLayout(1, 2, 10, 0, true, true, true);
        mainLayout.setRemainderColumn(1);
        mainPanel.setLayout((LayoutManager)mainLayout);
        mainPanel.add(controlPanel);
        mainPanel.add(buttonPanel);
        this.getContentPane().add(mainPanel);
    }

    private void initializeListeners() {
        SearchDirectionAction directionAction = new SearchDirectionAction();
        SearchOptionsAction optionsAction = new SearchOptionsAction();
        this._searchForwardOption.addActionListener(directionAction);
        this._searchBackwardOption.addActionListener(directionAction);
        this._matchCaseCheckbox.addActionListener(optionsAction);
        this._matchWholeWordCheckbox.addActionListener(optionsAction);
        this._closeButton.addActionListener(new CloseAction());
        this._findButton.addActionListener(new FindNextAction());
        Component editorComp = this._findComboBox.getEditor().getEditorComponent();
        if (editorComp instanceof JTextField) {
            ((JTextField)editorComp).getDocument().addDocumentListener(new SearchFieldListener());
        }
        editorComp.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int key = e.getKeyCode();
                if (key == 10) {
                    FindDialog.this.onFind();
                } else {
                    super.keyPressed(e);
                }
            }
        });
        this.addWindowListener(new DialogWindowListener());
    }

    private void enableFields(boolean enabled) {
        this._findButton.setEnabled(enabled);
        this._matchWholeWordCheckbox.setEnabled(enabled);
    }

    protected void setSearchText(String text) {
        if (text == null) {
            return;
        }
        this._findComboBox.configureEditor(this._findComboBox.getEditor(), text);
        this._findComboBox.getEditor().selectAll();
    }

    protected void onFind() {
        int index;
        this._findButton.requestFocus();
        String text = (String)this._findComboBox.getEditor().getItem();
        if (text == null || text.length() == 0) {
            return;
        }
        this.setWaitCursor();
        boolean matchCase = this._matchCaseCheckbox.isSelected();
        boolean matchWholeWord = this._matchWholeWordCheckbox.isSelected();
        boolean searchForward = this._searchForwardOption.isSelected();
        this.addToSearchHistory(text);
        this.saveSearchHistory();
        int offset = 0;
        offset = this._previousOccurrenceIndex == FINISHED_SEARCHING && !this.didSearchValuesChange(text, matchCase, matchWholeWord, searchForward) ? (searchForward ? 0 : this._searchableComponent.getText().length()) : (searchForward ? this._searchableComponent.getCaretPosition() : this._searchableComponent.getSelectionStart() - 1);
        this._previousOccurrenceIndex = index = this.performSearch(text, offset, matchCase, matchWholeWord, searchForward);
        this.setDefaultCursor();
        if (index == FINISHED_SEARCHING) {
            Toolkit.getDefaultToolkit().beep();
            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"FindDialog.FinishedSearching.fmt.txt", (Object)text);
            this.displayMessage(msg);
        } else if (index > -1) {
            String s = this._searchableComponent.getText().substring(index, index + text.length());
            System.err.println("Found text: " + s + " Index: " + index);
            this._searchableComponent.setSelectionStart(index);
            this._searchableComponent.setSelectionEnd(index + text.length());
        } else {
            Toolkit.getDefaultToolkit().beep();
            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"FindDialog.StringNotFound.fmt.txt", (Object)text);
            this.displayMessage(msg);
        }
    }

    private int performSearch(String searchString, int offset, boolean matchCase, boolean matchWholeWord, boolean searchForward) {
        if (this.didSearchValuesChange(searchString, matchCase, matchWholeWord, searchForward)) {
            this.resetSearch();
        }
        this._previousSearchString = searchString;
        this._previousMatchCase = matchCase;
        this._previousMatchWholeWord = matchWholeWord;
        this._previousSearchForward = searchForward;
        int index = this.runSearch(searchString, offset, matchCase, matchWholeWord, searchForward);
        if (this._firstOccurrenceIndex < 0) {
            this._firstOccurrenceIndex = index;
        } else if (this._firstOccurrenceIndex == index || index == -1) {
            this.resetSearch();
            return FINISHED_SEARCHING;
        }
        return index;
    }

    private int runSearch(String searchString, int offset, boolean matchCase, boolean matchWholeWord, boolean searchForwards) {
        int foundPosition = -1;
        String documentText = this._searchableComponent.getText();
        if (documentText == null || documentText.length() == 0) {
            return 0;
        }
        if (!matchCase) {
            searchString = searchString.toUpperCase();
            documentText = documentText.toUpperCase();
        }
        while ((foundPosition = searchForwards ? documentText.indexOf(searchString, offset) : documentText.lastIndexOf(searchString, offset)) >= 0) {
            if (!matchWholeWord) {
                return foundPosition;
            }
            if (this.isMatchingWord(searchString, documentText, foundPosition)) {
                return foundPosition;
            }
            offset = searchForwards ? foundPosition + 1 : foundPosition - 1;
        }
        return -1;
    }

    private boolean isMatchingWord(String searchString, String text, int index) {
        return !(index != 0 && !Character.isWhitespace(text.charAt(index - 1)) || index + searchString.length() != text.length() && !Character.isWhitespace(text.charAt(index + searchString.length())));
    }

    private boolean didSearchValuesChange(String searchString, boolean matchCase, boolean matchWholeWord, boolean searchForward) {
        return searchString != null && !searchString.equals(this._previousSearchString) || matchCase != this._previousMatchCase || matchWholeWord != this._previousMatchWholeWord || searchForward != this._previousSearchForward;
    }

    private void resetSearch() {
        this._firstOccurrenceIndex = -1;
    }

    private void saveSearchHistory() {
        ArrayList historyList = new ArrayList();
        for (int i = 0; i < this._findComboBox.getItemCount(); ++i) {
            historyList.add(this._findComboBox.getItemAt(i));
        }
        _historySearchStrings = historyList.toArray(new String[0]);
    }

    private void addToSearchHistory(String searchString) {
        for (int i = 0; i < this._findComboBox.getItemCount(); ++i) {
            String existingItem = (String)this._findComboBox.getItemAt(i);
            if (!existingItem.equals(searchString)) continue;
            this._findComboBox.removeItemAt(i);
            break;
        }
        this._findComboBox.insertItemAt(searchString, 0);
        int historyMaxSize = 10;
        while (this._findComboBox.getItemCount() > historyMaxSize) {
            this._findComboBox.remove(historyMaxSize);
        }
        this.setSearchText(searchString);
    }

    protected void onClose() {
        _currentSearchString = (String)this._findComboBox.getEditor().getItem();
        this.dispose();
    }

    protected void configureComponent(JLabel lbl, String text) {
        String lblText = Util.getLabelWithoutMnemonic((String)text);
        lbl.setText(lblText);
        int index = Util.getDisplayedMnemonicIndex((String)text);
        if (index > -1) {
            lbl.setDisplayedMnemonic(Util.getDisplayedMnemonic((String)text));
            lbl.setDisplayedMnemonicIndex(index);
        }
    }

    protected void configureComponent(AbstractButton btn, String text) {
        String buttonText = Util.getLabelWithoutMnemonic((String)text);
        btn.setText(buttonText);
        int index = Util.getDisplayedMnemonicIndex((String)text);
        if (index > -1) {
            btn.setMnemonic(Util.getDisplayedMnemonic((String)text));
            btn.setDisplayedMnemonicIndex(index);
        }
    }

    private void setWaitCursor() {
        this.setCursor(Cursor.getPredefinedCursor(3));
    }

    private void setDefaultCursor() {
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    private void displayMessage(String message) {
        JOptionPane.showMessageDialog(this, message, RB.getStringResource("FindDialog.Title.txt"), 1);
    }

    protected class DialogWindowListener
    extends WindowAdapter {
        protected DialogWindowListener() {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            FindDialog.this.onClose();
        }
    }

    protected class SearchFieldListener
    implements DocumentListener {
        protected SearchFieldListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            String text = (String)FindDialog.this._findComboBox.getEditor().getItem();
            if (text != null && text.length() > 0) {
                FindDialog.this.enableFields(true);
            }
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            String text = (String)FindDialog.this._findComboBox.getEditor().getItem();
            if (text == null || text.length() == 0) {
                FindDialog.this.enableFields(false);
            }
        }
    }

    protected class SearchDirectionAction
    implements ActionListener {
        protected SearchDirectionAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (source == FindDialog.this._searchForwardOption) {
                FindDialog.this._searchForwards = true;
            } else if (source == FindDialog.this._searchBackwardOption) {
                FindDialog.this._searchForwards = false;
            }
        }
    }

    protected class SearchOptionsAction
    implements ActionListener {
        protected SearchOptionsAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (source == FindDialog.this._matchCaseCheckbox) {
                _matchCase = FindDialog.this._matchCaseCheckbox.isSelected();
            } else if (source == FindDialog.this._matchWholeWordCheckbox) {
                _matchWholeWord = FindDialog.this._matchWholeWordCheckbox.isSelected();
            }
        }
    }

    protected class FindNextAction
    implements ActionListener {
        protected FindNextAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FindDialog.this.onFind();
        }
    }

    protected class CloseAction
    implements ActionListener {
        protected CloseAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FindDialog.this.onClose();
        }
    }
}

