/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.promotion.visuals;

import com.sas.metadata.logical.SimpleLogicalObjectInterface;
import com.sas.metadata.promotion.Log;
import com.sas.metadata.promotion.ObjectConverter;
import com.sas.metadata.promotion.model.ExportFolderModelInterface;
import com.sas.metadata.promotion.model.ExportModelConfiguration;
import com.sas.metadata.promotion.model.ModelFactory;
import com.sas.metadata.promotion.visuals.AbstractExportTreePanel;
import com.sas.metadata.promotion.visuals.ExportAnalyzer;
import com.sas.metadata.promotion.visuals.ExportTree;
import com.sas.metadata.promotion.visuals.ExportTreeModel;
import com.sas.metadata.promotion.visuals.ExportTreeModelInterface;
import com.sas.metadata.promotion.visuals.ExportTreeNodeInterface;
import com.sas.metadata.promotion.visuals.ExportWizardInterface;
import com.sas.metadata.promotion.visuals.FolderNode;
import com.sas.metadata.promotion.visuals.RB;
import com.sas.metadata.promotion.visuals.VisualsUtil;
import com.sas.metadata.remote.SoftwareComponent;
import com.sas.metadata.remote.Tree;
import com.sas.services.ServiceException;
import com.sas.services.information.publicobject.PublicObjectContainerInterface;
import com.sas.services.information.publicobject.PublicObjectInterface;
import com.sas.services.information.sasfolders.ContainerNodeInterface;
import com.sas.services.information.sasfolders.FolderNodeInterface;
import com.sas.services.information.sasfolders.PublicObjectNodeInterface;
import java.rmi.RemoteException;
import java.util.List;

public class ExportTreePanel
extends AbstractExportTreePanel {
    public static final String PANEL_NAME = "TreePanel";
    public static final String PANEL_TITLE = RB.getStringResource("ExportTreePanel.Title.txt");
    private SimpleLogicalObjectInterface[] _logicalObjects;
    private Tree _parentFolder;
    private SoftwareComponent _bipService;
    private boolean _isOldStylePromotion = false;
    private String _treeName;
    private boolean _emptyFolderExists = false;

    public ExportTreePanel(ExportWizardInterface wizard) {
        super(wizard);
        this.initialize();
        this.layoutWidgets();
    }

    public ExportTreePanel(ExportWizardInterface wizard, SimpleLogicalObjectInterface[] logicalObjects) {
        this(wizard);
        this._isOldStylePromotion = true;
        this._logicalObjects = logicalObjects;
    }

    public ExportTreePanel(ExportWizardInterface wizard, Tree parentFolder) {
        this(wizard);
        this._isOldStylePromotion = true;
        this._parentFolder = parentFolder;
    }

    public ExportTreePanel(ExportWizardInterface wizard, SoftwareComponent bipService) {
        this(wizard);
        this._isOldStylePromotion = true;
        this._bipService = bipService;
    }

    public ExportTreePanel(ExportWizardInterface wizard, SimpleLogicalObjectInterface[] logicalObjects, String projectReposID, String treeName) {
        this(wizard, logicalObjects);
        this._isOldStylePromotion = true;
        this._treeName = treeName;
        if (projectReposID != null && projectReposID.length() > 0) {
            this._usedForChangeManagement = true;
            this._projectReposID = projectReposID;
        }
    }

    @Override
    public void initialize() {
        this._log = Log.getInstance(ExportTreePanel.class.getName());
        this.setHelpProduct("promotion");
        this.setHelpTopic("exp_expobjectswin");
        this.setDescription(RB.getStringResource("ExportTreePanel.Description.txt"));
        super.initialize();
    }

    public boolean validateData() {
        int value;
        if (!this._canClickNext) {
            return false;
        }
        if (this._depPanels != null) {
            for (int i = 0; i < this._depPanels.length; ++i) {
                this._depPanels[i].stopProcessing();
            }
        }
        ExportAnalyzer analyzer = new ExportAnalyzer(this._wizard);
        analyzer.setUsedForChangeManagement(this._usedForChangeManagement);
        boolean success = analyzer.analyze((ExportTree)this._tree);
        if (!success) {
            return false;
        }
        return this._usedForChangeManagement || !this._emptyFolderExists || (value = VisualsUtil.displayConfirmationDialog(RB.getStringResource("ExportWizard.Warning.txt"), RB.getStringResource("ExportTreePanel.EmptyFolder.txt"), 2)) != 1;
    }

    @Override
    protected String getRootNodeName() {
        return this._usedForChangeManagement ? this._treeName : this._handler.getExportFile().getName();
    }

    @Override
    protected ExportTreeModelInterface createTreeModel() throws ServiceException, RemoteException {
        ExportFolderModelInterface exportModel = ModelFactory.createExportFolderModel(this._handler);
        ExportModelConfiguration config = (ExportModelConfiguration)exportModel.getConfiguration();
        if (this._usedForChangeManagement) {
            config.setDisplayEmptyFolders(true);
            config.setSearchProjectReposOnly(true);
        } else {
            Boolean include = (Boolean)this._wizard.getWizardData("INCLUDE_EMPTY_FOLDERS");
            if (include != null) {
                config.setDisplayEmptyFolders(include);
            } else {
                config.setDisplayEmptyFolders(false);
            }
        }
        config.setIncludeDependencies(this._handler.isIncludingDependencies());
        List filterList = (List)this._wizard.getWizardData("FILTERS");
        if (filterList != null) {
            exportModel.setSearchFilters(filterList);
        }
        ExportTreeModelInterface visualTreeModel = this.populateTree(exportModel);
        return visualTreeModel;
    }

    private ExportTreeModelInterface populateTree(ExportFolderModelInterface exportModel) throws ServiceException, RemoteException {
        ExportTreeModel visualTreeModel = new ExportTreeModel(exportModel);
        FolderNode rootNode = null;
        PublicObjectContainerInterface exportedContainer = null;
        PublicObjectInterface[] exportedObjects = null;
        if (!this._isOldStylePromotion) {
            List<PublicObjectInterface> publicObjects;
            exportedContainer = this._handler.getExportedContainer();
            if (exportedContainer == null && (publicObjects = this._handler.getExportedObjects()) != null) {
                exportedObjects = publicObjects.toArray(new PublicObjectInterface[publicObjects.size()]);
            }
        } else if (this._logicalObjects != null) {
            ObjectConverter converter = ObjectConverter.getInstance();
            exportedObjects = converter.convertToPublicObjects(this._logicalObjects, this._handler.getServer());
        } else if (this._parentFolder != null) {
            exportedContainer = (PublicObjectContainerInterface)exportModel.getObject(this._parentFolder.getId(), this._parentFolder.getPublicType());
        } else if (this._bipService != null) {
            exportedContainer = exportModel.getRootFolder();
        }
        if (exportedContainer != null) {
            PublicObjectNodeInterface node = exportModel.getObject((PublicObjectInterface)exportedContainer);
            if (node instanceof ContainerNodeInterface) {
                exportModel.populateModel((ContainerNodeInterface)node);
                if ("RootFolder".equalsIgnoreCase(node.getTypeDescriptor().getTypeName())) {
                    rootNode = this.createRootNode();
                    List children = ((ContainerNodeInterface)node).getChildren();
                    for (PublicObjectNodeInterface childNode : children) {
                        ExportTreeNodeInterface visualNode = visualTreeModel.createNode(childNode);
                        visualTreeModel.addChildren(visualNode, true);
                        rootNode.add(visualNode);
                    }
                } else {
                    rootNode = this.createRootNode();
                    ExportTreeNodeInterface visualNode = visualTreeModel.createNode(node);
                    visualTreeModel.addChildren(visualNode, true);
                    rootNode.add(visualNode);
                }
            } else {
                exportModel.populateModel(new PublicObjectInterface[]{node});
                List<PublicObjectNodeInterface> exportedNodes = exportModel.getExportedNodes();
                if (exportedNodes != null && exportedNodes.size() > 0) {
                    PublicObjectNodeInterface thisNode = exportedNodes.get(0);
                    rootNode = this.createRootNode();
                    ExportTreeNodeInterface visualNode = visualTreeModel.createNode(thisNode);
                    visualTreeModel.addChildren(visualNode, true);
                    rootNode.add(visualNode);
                }
            }
        } else if (exportedObjects != null) {
            exportModel.populateModel(exportedObjects);
            rootNode = this.createRootNode();
            List<PublicObjectNodeInterface> exportedNodes = exportModel.getExportedNodes();
            if (exportedNodes != null && exportedNodes.size() > 0) {
                for (PublicObjectNodeInterface node : exportedNodes) {
                    ExportTreeNodeInterface visualNode = visualTreeModel.createNode(node);
                    visualTreeModel.addChildren(visualNode, true);
                    rootNode.add(visualNode);
                }
            }
        } else {
            throw new IllegalStateException("There are no objects to export");
        }
        visualTreeModel.setRoot(rootNode);
        visualTreeModel.createDependencyNodes(exportModel.getExternalDependentObjects());
        if (exportedContainer != null && "Folder".equalsIgnoreCase(exportedContainer.getTypeDescriptor().getTypeName())) {
            this._emptyFolderExists = this.containsEmptyFolders(exportModel);
        }
        return visualTreeModel;
    }

    private boolean containsEmptyFolders(ExportFolderModelInterface exportModel) throws ServiceException, RemoteException {
        ExportModelConfiguration config = (ExportModelConfiguration)exportModel.getConfiguration();
        if (config.isDisplayingEmptyFolders()) {
            return false;
        }
        List<PublicObjectNodeInterface> exportedNodes = exportModel.getExportedNodes();
        for (PublicObjectNodeInterface node : exportedNodes) {
            if (node instanceof FolderNodeInterface) {
                if (exportModel.getChildCount((PublicObjectContainerInterface)((FolderNodeInterface)node)) <= 0) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    private FolderNode createRootNode() {
        String name = this.getRootNodeName();
        return this._usedForChangeManagement ? new FolderNode(name) : new FolderNode(name, true);
    }
}

