/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.promotion.visuals;

import com.sas.metadata.promotion.model.ExportElementInterface;
import com.sas.metadata.promotion.model.ExportFolderModelInterface;
import com.sas.metadata.promotion.visuals.ExportTreeModelInterface;
import com.sas.metadata.promotion.visuals.ExportTreeNode;
import com.sas.metadata.promotion.visuals.ExportTreeNodeInterface;
import com.sas.metadata.promotion.visuals.FolderNode;
import com.sas.metadata.promotion.visuals.TreeNodeInterface;
import com.sas.services.ServiceException;
import com.sas.services.information.publicobject.PublicObjectContainerInterface;
import com.sas.services.information.publicobject.PublicObjectInterface;
import com.sas.services.information.sasfolders.ContainerNodeInterface;
import com.sas.services.information.sasfolders.FolderNodeInterface;
import com.sas.services.information.sasfolders.PublicObjectNodeInterface;
import com.sas.services.information.sasfolders.SASFoldersUtil;
import com.sas.services.information.search.SortOrder;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;

public class ExportTreeModel
extends DefaultTreeModel
implements ExportTreeModelInterface {
    protected ExportFolderModelInterface _model;
    protected Map<String, ExportTreeNodeInterface> _nodeCache;
    protected List<ExportTreeNodeInterface> _externalDependenciesList;

    public ExportTreeModel(ExportFolderModelInterface model) throws ServiceException, RemoteException {
        super(null, true);
        this._model = model;
        this._nodeCache = new HashMap<String, ExportTreeNodeInterface>();
    }

    @Override
    public ExportFolderModelInterface getExportModel() {
        return this._model;
    }

    @Override
    public List<ExportTreeNodeInterface> getExternalDependencies() {
        return this._externalDependenciesList;
    }

    @Override
    public void addChild(ExportTreeNodeInterface parent, ExportTreeNodeInterface child) throws ServiceException, RemoteException {
        int pos = this.getChildPosition(parent, child);
        this.insertNodeInto(child, parent, pos);
    }

    @Override
    public void addChildren(ExportTreeNodeInterface parent) throws ServiceException, RemoteException {
        this.addChildren(parent, false);
    }

    @Override
    public void addChildren(ExportTreeNodeInterface parent, boolean recursive) throws ServiceException, RemoteException {
        PublicObjectNodeInterface parentNode = parent.getPublicObjectNode();
        boolean loadChildren = false;
        loadChildren = recursive ? parentNode instanceof FolderNodeInterface : parentNode instanceof ContainerNodeInterface;
        if (loadChildren) {
            List children = ((ContainerNodeInterface)parentNode).getChildren();
            for (PublicObjectNodeInterface childNode : children) {
                ExportTreeNodeInterface visualChildNode = this.createNode(childNode);
                this.addChild(parent, visualChildNode);
                if (!recursive || !(childNode instanceof FolderNodeInterface)) continue;
                this.addChildren(visualChildNode, recursive);
            }
        }
    }

    @Override
    public ExportTreeNodeInterface createNode(PublicObjectNodeInterface node) throws ServiceException, RemoteException {
        ExportTreeNode visualNode = new ExportTreeNode(node);
        visualNode.setTreeModel(this);
        this._nodeCache.put(node.getIdentifier(), visualNode);
        return visualNode;
    }

    @Override
    public ExportTreeNodeInterface createNode(String id, String publicType) throws ServiceException, RemoteException {
        PublicObjectNodeInterface poNode = this._model.getObject(id, publicType);
        if (poNode != null) {
            return this.createNode(poNode);
        }
        return null;
    }

    @Override
    public void createDependencyNodes(Collection<PublicObjectNodeInterface> nodes) throws ServiceException, RemoteException {
        if (nodes != null && nodes.size() > 0) {
            for (PublicObjectNodeInterface node : nodes) {
                this.createDependencyNode(node);
            }
        }
    }

    @Override
    public ExportTreeNodeInterface createDependencyNode(PublicObjectNodeInterface node) throws ServiceException, RemoteException {
        ExportTreeNodeInterface visualNode = this.createNode(node);
        if (visualNode != null) {
            ExportElementInterface exportElement = this._model.getExportElement((PublicObjectInterface)node);
            if (exportElement.isExternalDependency()) {
                this.createExternalDependencyFolderStructure(visualNode);
                if (this._externalDependenciesList == null) {
                    this._externalDependenciesList = new ArrayList<ExportTreeNodeInterface>();
                }
                this._externalDependenciesList.add(visualNode);
            } else {
                this.createInternalDependencyFolderStructure(visualNode);
            }
        }
        return visualNode;
    }

    @Override
    public ExportTreeNodeInterface createDependencyNode(String id, String publicType) throws ServiceException, RemoteException {
        PublicObjectNodeInterface poNode = this._model.createDependentObject(id, publicType);
        if (poNode != null) {
            return this.createDependencyNode(poNode);
        }
        return null;
    }

    private void createInternalDependencyFolderStructure(ExportTreeNodeInterface node) throws ServiceException, RemoteException {
        ExportTreeNodeInterface parent;
        PublicObjectNodeInterface poNode = node.getPublicObjectNode();
        if (poNode != null && (parent = this.createInternalDependencyParentNode(node)) != null) {
            this.addChild(parent, node);
        }
    }

    private ExportTreeNodeInterface createInternalDependencyParentNode(ExportTreeNodeInterface node) throws ServiceException, RemoteException {
        int index;
        ExportTreeNodeInterface parent = null;
        PublicObjectContainerInterface[] containers = SASFoldersUtil.getContainerPath((PublicObjectInterface)node.getPublicObjectNode());
        if (containers == null || containers.length == 0) {
            return null;
        }
        boolean exportingFromRoot = false;
        Object rootFolder = this.getRoot();
        if (rootFolder instanceof FolderNode) {
            exportingFromRoot = ((FolderNode)rootFolder).isRoot();
        }
        PublicObjectContainerInterface[] relativePath = null;
        int length = containers.length;
        for (index = 0; index < length; ++index) {
            ExportTreeNodeInterface containerNode;
            PublicObjectContainerInterface container = containers[index];
            if (index == 0 && this.isRootFolder(container) || (containerNode = this.getExportNode(container.getIdentifier())) == null) continue;
            parent = containerNode;
            int startPos = index + 1;
            int adjustedLength = length - startPos;
            relativePath = new PublicObjectContainerInterface[adjustedLength];
            System.arraycopy(containers, startPos, relativePath, 0, adjustedLength);
            break;
        }
        if (parent != null && relativePath != null) {
            for (index = 0; index < relativePath.length; ++index) {
                void container = relativePath[index];
                ExportTreeNodeInterface child = this.getChildNode(parent, (PublicObjectContainerInterface)container);
                if (child == null && container instanceof PublicObjectNodeInterface) {
                    child = this.createNode((PublicObjectNodeInterface)container);
                    this.addChild(parent, child);
                }
                parent = child;
            }
        } else if (exportingFromRoot) {
            TreeNodeInterface tempParent = (FolderNode)rootFolder;
            int length2 = containers.length;
            for (int index2 = 0; index2 < length2; ++index2) {
                PublicObjectContainerInterface container = containers[index2];
                if (index2 == 0 && this.isRootFolder(container)) continue;
                ExportTreeNodeInterface childContainerNode = this.getChildNode(tempParent, container);
                if (childContainerNode == null && (childContainerNode = this.createNode(container.getIdentifier(), container.getTypeDescriptor().getTypeName())) == null) {
                    return null;
                }
                if (childContainerNode.getParent() == null) {
                    if (tempParent instanceof ExportTreeNodeInterface) {
                        this.addChild((ExportTreeNodeInterface)tempParent, childContainerNode);
                    } else {
                        int position = tempParent.getChildCount();
                        this.insertNodeInto(childContainerNode, tempParent, position);
                    }
                }
                tempParent = childContainerNode;
            }
            if (tempParent instanceof ExportTreeNodeInterface) {
                parent = (ExportTreeNodeInterface)tempParent;
            }
        }
        return parent;
    }

    private boolean isRootFolder(PublicObjectContainerInterface container) throws ServiceException, RemoteException {
        return "RootFolder".equalsIgnoreCase(container.getTypeDescriptor().getTypeName());
    }

    private void createExternalDependencyFolderStructure(ExportTreeNodeInterface node) throws ServiceException, RemoteException {
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)this.getRoot();
        PublicObjectNodeInterface poNode = node.getPublicObjectNode();
        if (poNode != null) {
            int index = parent.getChildCount();
            this.insertNodeInto(node, parent, index);
        }
    }

    private ExportTreeNodeInterface getChildNode(TreeNodeInterface parentNode, PublicObjectContainerInterface childContainer) throws RemoteException {
        if (childContainer == null) {
            return null;
        }
        Enumeration<? extends TreeNode> enumer = parentNode.children();
        while (enumer.hasMoreElements()) {
            TreeNode obj = enumer.nextElement();
            if (!(obj instanceof ExportTreeNodeInterface)) continue;
            ExportTreeNodeInterface child = (ExportTreeNodeInterface)obj;
            if (!childContainer.getName().equals(child.getName())) continue;
            return child;
        }
        return null;
    }

    private int getChildPosition(ExportTreeNodeInterface parent, ExportTreeNodeInterface child) throws ServiceException, RemoteException {
        PublicObjectNodeInterface childNode = child.getPublicObjectNode();
        if (childNode == null) {
            return 0;
        }
        int position = 0;
        int index = 0;
        int childCount = parent.getChildCount();
        Comparator sortingComparator = SortOrder.getComparator((SortOrder[])this._model.getSortOrder());
        while (index < childCount) {
            int result;
            position = (index + childCount) / 2;
            ExportTreeNodeInterface visualNode = (ExportTreeNodeInterface)parent.getChildAt(position);
            PublicObjectNodeInterface node = visualNode.getPublicObjectNode();
            if (node == null) {
                index = position + 1;
            }
            if ((result = sortingComparator.compare(node, childNode)) > 0) {
                childCount = position;
                continue;
            }
            if (result > 0) continue;
            index = position + 1;
        }
        position = index;
        return position;
    }

    @Override
    public boolean containsExportNode(String id) {
        return this._nodeCache.containsKey(id);
    }

    @Override
    public ExportTreeNodeInterface getExportNode(String id) {
        return this._nodeCache.get(id);
    }
}

