/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.promotion.visuals;

import com.sas.metadata.promotion.Log;
import com.sas.metadata.promotion.visuals.AbstractPromotionTree;
import com.sas.metadata.promotion.visuals.ExportTreeNodeInterface;
import com.sas.metadata.promotion.visuals.FolderNode;
import com.sas.metadata.promotion.visuals.Images;
import com.sas.metadata.promotion.visuals.RB;
import com.sas.metadata.promotion.visuals.VisualsUtil;
import com.sas.services.information.publicobject.TypeDescriptorInterface;
import com.sas.services.information.sasfolders.PublicObjectNodeInterface;
import com.sas.swing.visuals.CheckBoxTree;
import com.sas.swing.visuals.CheckBoxTreeCellRendererWrapper;
import com.sas.text.Message;
import java.awt.Component;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;

public class ExportTree
extends AbstractPromotionTree {
    public ExportTree() {
        this.setCellRenderer((TreeCellRenderer)new CheckBoxTreeCellRendererWrapper((TreeCellRenderer)new TreeNodeRenderer()));
        this.addTreeExpansionListener(new ContainerExpansionListener(this));
    }

    public void expandRoot() {
        if (this.treeModel != null && this.treeModel.getRoot() != null) {
            this.fireTreeExpanded(new TreePath(this.treeModel.getRoot()));
        }
    }

    class ContainerExpansionListener
    implements TreeExpansionListener {
        private CheckBoxTree _tree;

        public ContainerExpansionListener(CheckBoxTree tree) {
            this._tree = tree;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void treeExpanded(TreeExpansionEvent event) {
            ExportTreeNodeInterface node;
            Object obj = event.getPath().getLastPathComponent();
            if (obj instanceof ExportTreeNodeInterface && !(node = (ExportTreeNodeInterface)obj).isFolder()) {
                try {
                    TreePath path;
                    VisualsUtil.displayWaitCursor((Component)this._tree);
                    boolean populated = node.isPopulated();
                    node.expand();
                    if (!populated && VisualsUtil.isNodeSelected(this._tree, path = event.getPath())) {
                        ExportTree.this.checkChildren(path, true, false);
                    }
                }
                catch (Exception e) {
                    try {
                        PublicObjectNodeInterface poNode = node.getPublicObjectNode();
                        String msg = Message.format((ResourceBundle)RB.getResources(), (String)"ExportTree.ExpandContainer.fmt.txt", (Object)poNode.getTypeDescriptor().getType(), (Object)poNode.getAbsolutePath(), (Object)e.getMessage());
                        Log log = Log.getInstance(ExportTree.class.getName());
                        log.warn(msg);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                finally {
                    VisualsUtil.displayDefaultCursor((Component)this._tree);
                }
            }
        }

        @Override
        public void treeCollapsed(TreeExpansionEvent event) {
        }
    }

    class TreeNodeRenderer
    extends DefaultTreeCellRenderer {
        TreeNodeRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            Icon icon = null;
            if (value instanceof ExportTreeNodeInterface) {
                ExportTreeNodeInterface node = (ExportTreeNodeInterface)value;
                if (node.isFolder()) {
                    icon = node.isRoot() ? Images.getPackageIcon() : (node.isVirtualFolder() ? Images.getVirtualFolderIcon() : this.getTypeIcon(node));
                } else {
                    try {
                        this.setText(node.getObjectName());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    icon = this.getTypeIcon(node);
                }
            } else if (value instanceof FolderNode) {
                FolderNode node = (FolderNode)value;
                icon = node.isRoot() ? Images.getPackageIcon() : Images.getFolderIcon();
            }
            if (icon == null) {
                icon = Images.getUnknownObjectIcon();
            }
            if (icon != null) {
                this.setIcon(icon);
            }
            return this;
        }

        private Icon getTypeIcon(ExportTreeNodeInterface node) {
            Icon icon = null;
            PublicObjectNodeInterface metaNode = node.getPublicObjectNode();
            if (metaNode != null) {
                try {
                    TypeDescriptorInterface type = metaNode.getTypeDescriptor();
                    if (type != null) {
                        icon = type.getIcon();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (icon == null) {
                icon = Images.getUnknownObjectIcon();
            }
            return icon;
        }
    }
}

