/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.promotion.visuals;

import com.sas.metadata.promotion.ExportHandler;
import com.sas.metadata.promotion.LoggingUtil;
import com.sas.metadata.promotion.visuals.ExportWizardInterface;
import com.sas.metadata.promotion.visuals.RB;
import com.sas.swing.visuals.util.LayoutConstants;
import com.sas.workspace.WATextArea;
import com.sas.workspace.WsDescriptionWizardTab;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JScrollPane;

public class ExportSummaryPanel
extends WsDescriptionWizardTab {
    public static final String PANEL_NAME = "SummaryPanel";
    public static final String PANEL_TITLE = RB.getStringResource("ExportSummaryPanel.Title.txt");
    private static final String NEW_LINE = "\r\n";
    private ExportWizardInterface _wizard;
    private WATextArea _summaryTextArea;
    private JScrollPane _scrollPane;

    public ExportSummaryPanel(ExportWizardInterface wizard) {
        this._wizard = wizard;
        this.initialize();
        this.layoutWidgets();
    }

    public void initialize() {
        this.setHelpProduct("promotion");
        this.setHelpTopic("exp_summarywin");
        this.setDescription(RB.getStringResource("ExportSummaryPanel.Description.txt"));
        this._summaryTextArea = new WATextArea();
        this._summaryTextArea.setMargin(new Insets(5, 5, 5, 5));
        this._summaryTextArea.setEditable(false);
        this._summaryTextArea.setBackground(null);
        this._summaryTextArea.setBehavior(1);
        Font fnt = this._summaryTextArea.getFont();
        fnt = new Font("Monospaced", fnt.getStyle(), fnt.getSize() - 1);
        this._summaryTextArea.setFont(fnt);
        this._scrollPane = new JScrollPane((Component)this._summaryTextArea);
    }

    public void layoutWidgets() {
        this.setLayout(new GridBagLayout());
        this.add(this._scrollPane, new GridBagConstraints(1, 0, 0, 1, 1.0, 0.5, 18, 1, LayoutConstants.EMPTY_INSETS, 0, 0));
    }

    public boolean doDataExchange(boolean bSaveToModel) {
        if (!bSaveToModel) {
            this.moveDataToView();
        }
        return true;
    }

    public void moveDataToView() {
        ExportHandler exportOperation = this._wizard.getExportHandler();
        StringBuffer sb = new StringBuffer();
        try {
            String displayText = LoggingUtil.displayExportedObjects(exportOperation.getExportItems(), exportOperation.getServer(), false);
            if (displayText.length() == 0) {
                sb.append(NEW_LINE);
                sb.append(RB.getStringResource("ExportSummaryPanel.NoObjectsSelected.txt"));
            } else {
                String fileName = this._wizard.getExportHandler().getExportFile().getAbsolutePath();
                sb.append(RB.getStringResource("ExportSummaryPanel.ExportObjects.txt"));
                sb.append(NEW_LINE);
                sb.append(fileName);
                sb.append(NEW_LINE);
                sb.append(NEW_LINE);
                sb.append(RB.getStringResource("ExportSummaryPanel.ObjectsIncluded.txt"));
                sb.append(NEW_LINE);
                sb.append(displayText);
            }
        }
        catch (Exception e) {
            exportOperation.getLogger().error(e.getMessage());
        }
        this._summaryTextArea.setText(sb.toString());
        this._summaryTextArea.setCaretPosition(0);
    }
}

