/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.promotion.visuals;

import com.sas.metadata.promotion.ExportHandler;
import com.sas.metadata.promotion.ExportItemInterface;
import com.sas.metadata.promotion.visuals.AbstractExportProcessor;
import com.sas.metadata.promotion.visuals.ExportTree;
import com.sas.metadata.promotion.visuals.ExportTreeModelInterface;
import com.sas.metadata.promotion.visuals.ExportWizardInterface;
import com.sas.metadata.promotion.visuals.ProgressBarLauncher;
import com.sas.metadata.promotion.visuals.ProgressReturnCode;
import com.sas.metadata.promotion.visuals.RB;
import com.sas.metadata.remote.MdException;
import com.sas.workspace.MessageUtil;
import java.util.List;
import java.util.Map;
import javax.swing.tree.TreeModel;

public class ExportAnalyzer
extends ProgressBarLauncher {
    protected boolean _usedForChangeManagement = false;

    public ExportAnalyzer(ExportWizardInterface wizard) {
        super(wizard, wizard.getExportHandler());
    }

    public void setUsedForChangeManagement(boolean cm) {
        this._usedForChangeManagement = cm;
    }

    @Override
    public String getMessage() {
        return RB.getStringResource("ExportAnalyzer.Message.txt");
    }

    @Override
    public String getTitle() {
        return RB.getStringResource("ExportAnalyzer.TitleBar.txt");
    }

    @Override
    protected String getMessagePrefix() {
        return "";
    }

    public boolean analyze(ExportTree tree) {
        this.launch(new AnalyzeRunnable(tree));
        String errorMessage = this.getReturnCode().getErrorMessage();
        if (errorMessage != null) {
            String title = this._usedForChangeManagement ? RB.getStringResource("ExportWizard.CheckIn.Error.txt") : RB.getStringResource("ExportWizard.Error.txt");
            MessageUtil.displayMessage((String)errorMessage, (String)title, (int)0, (int)-1);
            return false;
        }
        int code = this.getReturnCode().getReturnCode();
        if ((code & 4) > 0 || (code & 8) > 0) {
            String message;
            String string = message = code == 4 ? RB.getStringResource("ExportAnalyzer.ValidationWarnings.txt") : RB.getStringResource("ExportAnalyzer.ValidationErrors.txt");
            if (!this.displayDetailsMessage(message)) {
                return false;
            }
        }
        return true;
    }

    class AnalyzeRunnable
    extends AbstractExportProcessor {
        public AnalyzeRunnable(ExportTree tree) {
            super(tree);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ProgressReturnCode rc = ExportAnalyzer.this.getReturnCode();
            try {
                ExportTreeModelInterface model = null;
                TreeModel tm = this._tree.getModel();
                if (tm instanceof ExportTreeModelInterface) {
                    model = (ExportTreeModelInterface)tm;
                }
                if (model == null) {
                    return;
                }
                Map<String, List<ExportItemInterface>> exportItems = this.processSelectedExportItems(model, this._tree.getCheckedObjects());
                if (exportItems == null || exportItems.size() == 0) {
                    String msg = ExportAnalyzer.this._usedForChangeManagement ? RB.getStringResource("ExportTreePanel.CheckIn.SelectItems.txt") : RB.getStringResource("ExportTreePanel.SelectItems.txt");
                    rc.setReturnCode(8);
                    rc.setErrorMessage(msg);
                    return;
                }
                ((ExportHandler)ExportAnalyzer.this._promotionHandler).setDependentObjects(this.getExternalDependencies(model));
                int returnCode = ((ExportHandler)ExportAnalyzer.this._promotionHandler).setItemsToExport(exportItems, true);
                rc.setReturnCode(returnCode);
                ExportAnalyzer.this._wizard.replaceWizardData("STATUS", new Integer(returnCode));
            }
            catch (MdException e) {
                rc.setErrorMessage(e.getMessage());
                ExportAnalyzer.this._log.debug((Object)"AnalyzeObjects", e);
            }
            catch (Exception e) {
                String msg = RB.getStringResource("ExportAnalyzer.ValidateError.txt") + e.getLocalizedMessage();
                if (ExportAnalyzer.this._log.isErrorEnabled()) {
                    ExportAnalyzer.this._log.error(msg);
                }
                rc.setErrorMessage(msg);
                ExportAnalyzer.this._log.debug((Object)"AnalyzeObjects", e);
            }
            finally {
                ExportAnalyzer.this.displayMessage(null);
            }
        }
    }
}

