/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.promotion.visuals;

import com.sas.metadata.logical.RelatedObjectsInterface;
import com.sas.metadata.logical.SimpleLogicalObjectInterface;
import com.sas.metadata.logical.TypeInterface;
import com.sas.metadata.promotion.ExportItemInterface;
import com.sas.metadata.promotion.ExportOperationInterface;
import com.sas.metadata.promotion.Log;
import com.sas.metadata.promotion.PromotionInterface;
import com.sas.metadata.promotion.PromotionUtil;
import com.sas.metadata.promotion.model.ExportElementInterface;
import com.sas.metadata.promotion.visuals.AbstractPromotionPanel;
import com.sas.metadata.promotion.visuals.DependenciesEvent;
import com.sas.metadata.promotion.visuals.DependenciesListener;
import com.sas.metadata.promotion.visuals.ExportTreeNodeInterface;
import com.sas.metadata.promotion.visuals.RB;
import com.sas.metadata.promotion.visuals.TreeNodeInterface;
import com.sas.metadata.promotion.visuals.VisualsUtil;
import com.sas.services.ServiceException;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.PathUrl;
import com.sas.services.information.publicobject.DetailsProcessorInterface;
import com.sas.services.information.publicobject.TypeDescriptorInterface;
import com.sas.services.information.sasfolders.PublicObjectNodeInterface;
import com.sas.services.information.sasfolders.SASFoldersUtil;
import com.sas.swing.visuals.CheckBoxTree;
import com.sas.swing.visuals.CheckBoxTreeCellRendererWrapper;
import com.sas.swing.visuals.util.LayoutConstants;
import com.sas.text.Message;
import com.sas.workspace.WsAbstractAction;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class DependenciesPanel
extends AbstractPromotionPanel
implements TreeSelectionListener {
    private static final String BRACKET_BEGIN = RB.getStringResource("Common.Bracket.Begin.txt");
    private static final String BRACKET_END = RB.getStringResource("Common.Bracket.End.txt");
    private static final String SELECT_ITEM_LABEL = RB.getStringResource("DependenciesPanel.SelectItem.txt");
    private static final String NOT_AVAILABLE_LABEL = RB.getStringResource("DependenciesPanel.NotAvailable.txt");
    private static final String LOADING_LABEL = RB.getStringResource("DependenciesPanel.Loading.txt");
    private static final String DOUBLE_SPACE = "  ";
    private static DefaultTreeModel EMPTY_MODEL = new DefaultTreeModel(null);
    private Log _log;
    private ExportOperationInterface _exportOperation;
    private DependenciesListener _dependenciesListener;
    private CheckBoxTree _tree;
    private JPanel _mainPanel;
    private JScrollPane _scrollPane;
    private JLabel _statusLabel;
    private JButton _selectAllButton;
    private JButton _clearAllButton;
    private List<DependencyNode> _checkList;
    private String _projectReposID;
    private List<PublicObjectNodeInterface> _duplicateObjects;
    private DependencyThread _depThread;
    private boolean _stop = false;

    public DependenciesPanel(DependenciesListener listener, ExportOperationInterface exportOperation) {
        this._exportOperation = exportOperation;
        this._dependenciesListener = listener;
        this.initialize();
        this.layoutWidgets();
    }

    private void initialize() {
        this._log = this._exportOperation.getLogger();
        this._tree = new CheckBoxTree();
        this._tree.setModel((TreeModel)new DefaultTreeModel(null));
        this._tree.setRootVisible(false);
        this._tree.setCheckBoxShouldCheckParents(true);
        this._tree.setCheckBoxShouldCheckChildren(true);
        this._tree.setCellRenderer((TreeCellRenderer)new CheckBoxTreeCellRendererWrapper((TreeCellRenderer)new TreeNodeRenderer()));
        this._tree.getCheckedModel().addTreeSelectionListener(this);
        this._tree.setShowSelectionIcon(false);
        this._statusLabel = new JLabel();
        Border border = BorderFactory.createEmptyBorder(8, 8, 0, 0);
        this._statusLabel.setBorder(border);
        this._mainPanel = new JPanel();
        this._mainPanel.setVisible(false);
        this._scrollPane = new JScrollPane((Component)this._tree);
        this._scrollPane.setVisible(true);
        this._selectAllButton = VisualsUtil.createSelectAllButton(RB.getStringResource("DependenciesPanel.SelectAll.Mnemonic.txt"), new SelectAllAction());
        this._clearAllButton = VisualsUtil.createClearAllButton(RB.getStringResource("DependenciesPanel.ClearAll.Mnemonic.txt"), new ClearAllAction());
    }

    private void layoutWidgets() {
        JToolBar toolBar = new JToolBar(1);
        toolBar.setFloatable(false);
        toolBar.setRollover(true);
        toolBar.add(this._selectAllButton);
        toolBar.addSeparator(new Dimension(0, 3));
        toolBar.add(this._clearAllButton);
        this._mainPanel.setLayout(new GridBagLayout());
        this._mainPanel.add((Component)this._scrollPane, new GridBagConstraints(0, 0, -1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 3), 0, 0));
        this._mainPanel.add((Component)toolBar, new GridBagConstraints(1, 0, 0, 1, 0.0, 1.0, 18, 0, LayoutConstants.EMPTY_INSETS, 0, 0));
        this.setLayout(new BorderLayout());
        this.add(this._mainPanel);
        this.add((Component)this._statusLabel, "North");
    }

    protected void setProjectRepositoryID(String reposID) {
        this._projectReposID = reposID;
    }

    protected void setDuplicateObjectMap(List<PublicObjectNodeInterface> duplicateObjects) {
        this._duplicateObjects = duplicateObjects;
    }

    @Override
    public String getLabel() {
        return RB.getStringResource("DependenciesPanel.Label.txt");
    }

    @Override
    public void loadComponent(Object sourceData, Object targetData) {
        this._stop = false;
        boolean itemsSelected = false;
        if (sourceData instanceof TreeNodeInterface[]) {
            TreeNodeInterface[] items = (TreeNodeInterface[])sourceData;
            if (items.length > 0) {
                itemsSelected = true;
                ArrayList<ExportItemInterface> exportItems = new ArrayList<ExportItemInterface>();
                try {
                    for (TreeNodeInterface node : items) {
                        ExportItemInterface exportItem;
                        ExportElementInterface exportElement;
                        PublicObjectNodeInterface poNode;
                        if (!(node instanceof ExportTreeNodeInterface) || (poNode = ((ExportTreeNodeInterface)node).getPublicObjectNode()) == null || (exportElement = (ExportElementInterface)poNode.getProcessorInterface("com.sas.metadata.promotion.model.ExportElementInterface")) == null || (exportItem = exportElement.getExportItem()) == null) continue;
                        exportItems.add(exportItem);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this._depThread = new DependencyThread(exportItems);
                this._depThread.start();
                new ProgressThread().start();
            } else {
                this.displayLabel(itemsSelected);
            }
        } else {
            this.displayLabel(itemsSelected);
        }
    }

    protected void displayLabel(boolean itemsSelected) {
        this.displayLabel(itemsSelected ? NOT_AVAILABLE_LABEL : SELECT_ITEM_LABEL);
    }

    protected void displayLabel(String text) {
        this._mainPanel.setVisible(false);
        this._statusLabel.setVisible(true);
        this._statusLabel.setText(text);
        this.validate();
        this.repaint();
    }

    protected int getDependencyType() {
        return 0;
    }

    public void stopProcessing() {
        this._stop = true;
    }

    private void displayTree() {
        this._mainPanel.setVisible(true);
        this._statusLabel.setVisible(false);
        this.validate();
        this.repaint();
    }

    private void createDependencyTree(List<SimpleLogicalObjectInterface> dependentObjects, boolean retrievedDependencies) {
        if (dependentObjects.size() > 0) {
            DefaultMutableTreeNode root = new DefaultMutableTreeNode();
            try {
                this.addDependentObjectsToTree(dependentObjects, root);
            }
            catch (Exception e) {
                this.displayLabel(RB.getStringResource("DependenciesPanel.LoadingError2.txt"));
                this.setTreeModel(EMPTY_MODEL);
                return;
            }
            if (root.getChildCount() > 0) {
                this.setTreeModel(new DefaultTreeModel(root));
                if (this._checkList != null && this._checkList.size() > 0) {
                    for (int i = 0; i < this._checkList.size(); ++i) {
                        this.checkNode(this._checkList.get(i), true);
                    }
                    this._checkList.clear();
                }
            } else {
                this.setTreeModel(EMPTY_MODEL);
            }
        } else {
            this.setTreeModel(EMPTY_MODEL);
        }
        if (retrievedDependencies) {
            this.displayTree();
        } else {
            this.displayLabel(true);
        }
    }

    private void addDependentObjectsToTree(List<SimpleLogicalObjectInterface> dependentObjects, DefaultMutableTreeNode rootNode) throws ServiceException, RemoteException {
        Collections.sort(dependentObjects, new DependentObjectsSorter());
        HashSet<String> objectCache = new HashSet<String>();
        for (SimpleLogicalObjectInterface logicalObject : dependentObjects) {
            String displayPath;
            String displayName;
            String id;
            TypeInterface type;
            block10: {
                type = logicalObject.getTypeInterface();
                if (type == null || this._projectReposID != null && !logicalObject.getID().substring(0, 8).equals(this._projectReposID)) continue;
                String pt = type.getPublicType();
                ServerInterface server = this._exportOperation.getServer();
                String containerType = SASFoldersUtil.getContainerType((String)pt, (ServerInterface)server);
                if (!this._exportOperation.isTypeSupported(pt) || !"Folder".equalsIgnoreCase(containerType) && !SASFoldersUtil.isContainedByVirtualFolder((String)pt, (ServerInterface)server)) continue;
                if (this._log.isDebugEnabled()) {
                    this._log.debug("Adding dependency to tree: " + logicalObject.getName());
                }
                if (objectCache.contains(id = logicalObject.getID())) continue;
                displayName = logicalObject.getName();
                displayPath = "";
                if ("Folder".equalsIgnoreCase(containerType) || SASFoldersUtil.isContainedByVirtualFolder((String)type.getPublicType(), (ServerInterface)server)) {
                    try {
                        MetadataInterface meta = PromotionUtil.getSmartObject((PromotionInterface)this._exportOperation, logicalObject);
                        if (meta != null) {
                            DetailsProcessorInterface details;
                            PathUrl path = meta.getPathUrl();
                            if (path != null) {
                                displayPath = path.getDisplayPath();
                            }
                            if ((details = (DetailsProcessorInterface)meta.getProcessorInterface("com.sas.services.information.publicobject.DetailsProcessorInterface")) != null) {
                                displayName = details.getDisplayName();
                            }
                        }
                    }
                    catch (ServiceException e) {
                        if (!this._log.isDebugEnabled()) break block10;
                        this._log.debug((Object)"Error fetching path and display name information for dependent object", e);
                    }
                }
            }
            if (this.isDuplicate(id)) {
                String msg = Message.format((ResourceBundle)RB.getResources(), (String)"DependenciesPanel.DuplicateObject.txt", (Object)type.getDisplayType(), (Object)displayPath, (Object)logicalObject.getID());
                this._log.warn(msg);
                continue;
            }
            DependencyNode node = new DependencyNode(id, displayName, type.getPublicType());
            node.setDisplayPath(displayPath);
            rootNode.add(node);
            objectCache.add(id);
            if (!this.isExportObjectFound(id) || !this.isExportObjectSelected(id)) continue;
            if (this._checkList == null) {
                this._checkList = new ArrayList<DependencyNode>();
            }
            this._checkList.add(node);
        }
    }

    private boolean isDuplicate(String id) throws ServiceException, RemoteException {
        if (this._duplicateObjects == null) {
            return false;
        }
        for (PublicObjectNodeInterface node : this._duplicateObjects) {
            if (!id.equalsIgnoreCase(node.getIdentifier())) continue;
            return true;
        }
        return false;
    }

    private void setTreeModel(DefaultTreeModel model) {
        this._tree.getCheckedModel().removeTreeSelectionListener(this);
        this._tree.setModel((TreeModel)model);
        this._tree.getCheckedModel().addTreeSelectionListener(this);
    }

    public DependencyNode getNode(String id) {
        DefaultMutableTreeNode rootNode;
        if (id == null) {
            return null;
        }
        DefaultTreeModel model = (DefaultTreeModel)this._tree.getModel();
        Object root = model.getRoot();
        if (root != null && root instanceof DefaultMutableTreeNode && (rootNode = (DefaultMutableTreeNode)root).getChildCount() > 0) {
            Enumeration<TreeNode> children = rootNode.children();
            while (children.hasMoreElements()) {
                DependencyNode node = (DependencyNode)children.nextElement();
                if (!id.equalsIgnoreCase(node.getId())) continue;
                return node;
            }
        }
        return null;
    }

    protected void checkNode(DependencyNode node, boolean check) {
        TreePath path = new TreePath(node.getPath());
        if (check && !VisualsUtil.isNodeSelected(this._tree, path) || !check && VisualsUtil.isNodeSelected(this._tree, path)) {
            this.checkNode(path, check);
        } else if (!check && this._tree.getCheckedState(path) == 1) {
            this.checkNode(path, check);
        }
    }

    private void checkNode(TreePath path, boolean check) {
        this._tree.getCheckedModel().removeTreeSelectionListener(this);
        this._tree.checkPath(path, check, true);
        this._tree.getCheckedModel().addTreeSelectionListener(this);
    }

    public void fireDependencyChange(DependenciesEvent event) throws ServiceException, RemoteException {
        this._dependenciesListener.objectSelected(event);
    }

    public boolean isExportObjectFound(String id) throws ServiceException, RemoteException {
        return this._dependenciesListener.isObjectBeingExported(id);
    }

    public boolean isExportObjectSelected(String id) throws ServiceException, RemoteException {
        return this._dependenciesListener.isExportObjectSelected(id);
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        Object obj;
        TreePath path = e.getPath();
        if (path != null && (obj = path.getLastPathComponent()) instanceof DependencyNode) {
            try {
                DependencyNode node = (DependencyNode)obj;
                DependenciesEvent event = new DependenciesEvent(this, node.getId(), node.getPublicType(), e.isAddedPath());
                this.fireDependencyChange(event);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private void selectAllNodes(boolean select) {
        DefaultTreeModel model = (DefaultTreeModel)this._tree.getModel();
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)model.getRoot();
        if (root != null) {
            Enumeration<TreeNode> enumer = root.children();
            try {
                while (enumer.hasMoreElements()) {
                    TreeNode treeNode = enumer.nextElement();
                    if (!(treeNode instanceof DependencyNode)) continue;
                    DependencyNode node = (DependencyNode)treeNode;
                    this.checkNode(node, select);
                    DependenciesEvent event = new DependenciesEvent(this, node.getId(), node.getPublicType(), select);
                    this.fireDependencyChange(event);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected class DependencyNode
    extends DefaultMutableTreeNode {
        private String _id;
        private String _name;
        private String _type;
        private String _path;

        public DependencyNode(String id, String name, String type) {
            super(name);
            this._id = id;
            this._name = name;
            this._type = type;
        }

        public void setDisplayPath(String path) {
            this._path = path;
        }

        public String getDisplayPath() {
            return this._path == null ? "" : this._path;
        }

        public String getId() {
            return this._id;
        }

        public String getName() {
            return this._name;
        }

        public String getPublicType() {
            return this._type;
        }
    }

    protected class ClearAllAction
    extends WsAbstractAction {
        protected ClearAllAction() {
        }

        public void actionPerformed(ActionEvent e) {
            DependenciesPanel.this.setCursor(Cursor.getPredefinedCursor(3));
            DependenciesPanel.this.selectAllNodes(false);
            DependenciesPanel.this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    protected class SelectAllAction
    extends WsAbstractAction {
        protected SelectAllAction() {
        }

        public void actionPerformed(ActionEvent e) {
            DependenciesPanel.this.setCursor(Cursor.getPredefinedCursor(3));
            DependenciesPanel.this.selectAllNodes(true);
            DependenciesPanel.this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    class ProgressThread
    extends Thread {
        ProgressThread() {
        }

        @Override
        public void run() {
            try {
                ProgressThread.sleep(1000L);
                if (DependenciesPanel.this._depThread.isOperationCurrentlyRunning()) {
                    DependenciesPanel.this.displayLabel(LOADING_LABEL);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    class DependencyThread
    extends Thread {
        boolean _finished = false;
        List<ExportItemInterface> _exportItemList;

        public DependencyThread(List<ExportItemInterface> items) {
            this._exportItemList = items;
        }

        @Override
        public void run() {
            ArrayList<SimpleLogicalObjectInterface> dependencies = new ArrayList<SimpleLogicalObjectInterface>();
            boolean retrievedDependencies = false;
            int length = this._exportItemList.size();
            for (int index = 0; index < length && !DependenciesPanel.this._stop; ++index) {
                ExportItemInterface item = this._exportItemList.get(index);
                if (!(item instanceof RelatedObjectsInterface)) continue;
                retrievedDependencies = true;
                if (DependenciesPanel.this._log.isDebugEnabled()) {
                    DependenciesPanel.this._log.debug("Retrieving dependencies for " + item.getTypeInterface().getDisplayType() + " named " + item.getName());
                }
                try {
                    List dependentObjects = ((RelatedObjectsInterface)item).getRelatedObjects(DependenciesPanel.this.getDependencyType());
                    if (dependentObjects == null || dependentObjects.size() <= 0) continue;
                    for (Object obj : dependentObjects) {
                        if (!(obj instanceof SimpleLogicalObjectInterface)) continue;
                        dependencies.add((SimpleLogicalObjectInterface)obj);
                    }
                    continue;
                }
                catch (Exception e) {
                    String message = Message.format((ResourceBundle)RB.getResources(), (String)"DependenciesPanel.LoadingError.txt", (Object)item.getTypeInterface().getDisplayType(), (Object)item.getName());
                    DependenciesPanel.this.displayLabel(message);
                    DependenciesPanel.this._log.warn(message, e);
                    this._finished = true;
                    return;
                }
            }
            this._finished = true;
            final ArrayList<SimpleLogicalObjectInterface> objects = dependencies;
            final boolean retrieve = retrievedDependencies;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DependenciesPanel.this.createDependencyTree(objects, retrieve);
                }
            });
        }

        protected boolean isOperationCurrentlyRunning() {
            return !this._finished || this.isAlive();
        }
    }

    class DependentObjectsSorter
    implements Comparator<SimpleLogicalObjectInterface> {
        DependentObjectsSorter() {
        }

        @Override
        public int compare(SimpleLogicalObjectInterface obj1, SimpleLogicalObjectInterface obj2) {
            if (obj1 == obj2) {
                return 0;
            }
            if (obj1 == null) {
                return -1;
            }
            if (obj2 == null) {
                return 1;
            }
            return obj1.getName().compareToIgnoreCase(obj2.getName());
        }
    }

    class TreeNodeRenderer
    extends DefaultTreeCellRenderer {
        TreeNodeRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            DependencyNode node;
            String publicType;
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            if (value instanceof DependencyNode && (publicType = (node = (DependencyNode)value).getPublicType()) != null) {
                try {
                    ServerInterface server = DependenciesPanel.this._exportOperation.getServer();
                    TypeDescriptorInterface type = server.getTypeDescriptor(publicType);
                    if (type != null) {
                        this.setIcon(type.getIcon());
                    }
                    StringBuilder name = new StringBuilder();
                    name.append(node.getName());
                    String path = node.getDisplayPath();
                    if (path != null && path.length() > 0) {
                        name.append(DependenciesPanel.DOUBLE_SPACE);
                        name.append(BRACKET_BEGIN);
                        name.append(node.getDisplayPath());
                        name.append(BRACKET_END);
                    }
                    this.setText(name.toString());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return this;
        }
    }
}

