/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.promotion.visuals;

import com.sas.metadata.logical.visuals.properties.AbstractPropertiesModel;
import com.sas.metadata.promotion.ImportItemInterface;
import com.sas.metadata.promotion.ImportOperationInterface;
import com.sas.metadata.promotion.MetadataPromotionException;
import com.sas.metadata.promotion.ObjectMoveManager;
import com.sas.metadata.promotion.model.ImportElementInterface;
import com.sas.metadata.promotion.model.ImportFolderModelInterface;
import com.sas.metadata.promotion.visuals.ImportTreeManager;
import com.sas.metadata.promotion.visuals.RB;
import com.sas.metadata.promotion.visuals.VisualsUtil;
import com.sas.metadata.remote.MdException;
import com.sas.services.ServiceException;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.PathUrl;
import com.sas.services.information.publicobject.PublicObjectContainerInterface;
import com.sas.services.information.publicobject.PublicObjectInterface;
import com.sas.services.information.sasfolders.ContainerNodeInterface;
import com.sas.services.information.sasfolders.FolderNodeInterface;
import com.sas.services.information.sasfolders.PublicObjectNodeInterface;
import com.sas.services.information.sasfolders.SASFoldersUtil;
import com.sas.swing.visuals.remotefileselector2.BaseRemoteFileSelectorPanel;
import com.sas.swing.visuals.remotefileselector2.InformationServicesSelectorPanel;
import com.sas.swing.visuals.remotefileselector2.RemoteFileSelectorDialog;
import com.sas.swing.visuals.tableview.DefaultTableCellEditor;
import com.sas.text.Message;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WATextField;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsUIUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class DefaultImportPropertiesModel
extends AbstractPropertiesModel {
    protected static final int PROPERTY_COUNT = 5;
    protected ImportOperationInterface _operation;
    protected int _indexType;
    protected int _indexName;
    protected int _indexDesc;
    protected int _indexPath;
    protected int _indexOriginalPath;
    protected Object[] _tempValues;
    protected PublicObjectNodeInterface _node;

    public DefaultImportPropertiesModel(ImportOperationInterface operation, PublicObjectNodeInterface node) {
        this._operation = operation;
        this._node = node;
        this._tempValues = new Object[this.getNumberOfProperties()];
    }

    protected void initializePropertyIndexes() {
        this._indexType = 0;
        this._indexName = 1;
        this._indexDesc = 2;
        this._indexPath = 3;
        this._indexOriginalPath = 4;
    }

    protected void initializeProperties() {
        this.setProperty(this._indexType, RB.getStringResource("DefaultExportPropertiesModel.Type.txt"), null, DefaultImportPropertiesModel.getDefaultRenderer());
        this.setProperty(this._indexName, RB.getStringResource("DefaultExportPropertiesModel.Name.txt"), null, DefaultImportPropertiesModel.getDefaultRenderer());
        this.setProperty(this._indexDesc, RB.getStringResource("DefaultExportPropertiesModel.Description.txt"), null, DefaultImportPropertiesModel.getDefaultRenderer());
        this.setProperty(this._indexPath, RB.getStringResource("DefaultExportPropertiesModel.Folder.txt"), null, DefaultImportPropertiesModel.getDefaultRenderer());
        this.setProperty(this._indexOriginalPath, RB.getStringResource("DefaultImportPropertiesModel.OriginalPath.txt"), null, DefaultImportPropertiesModel.getDefaultRenderer());
    }

    public int getNumberOfProperties() {
        return 5;
    }

    public void populate() throws MdException, RemoteException {
        try {
            if (SASFoldersUtil.isContainedByFolder((PublicObjectInterface)this._node)) {
                ImportElementInterface element = (ImportElementInterface)this._node.getProcessorInterface("com.sas.metadata.promotion.model.ImportElementInterface");
                if (element == null) {
                    return;
                }
                ImportItemInterface item = element.getImportItem();
                if (item == null || item.isOrphaned()) {
                    return;
                }
                if (this._operation.isProjectRepository()) {
                    return;
                }
                this.setPropertyRenderer(this._indexPath, new PathCellRenderer());
                this.setPropertyEditor(this._indexPath, (TableCellEditor)((Object)new PathCellEditor()));
                this.setPropertyValueEditable(this._indexPath, true);
            }
        }
        catch (Exception e) {
            try {
                this._operation.getLogger().error(Message.format((ResourceBundle)RB.getResources(), (String)"DefaultImportPropertiesModel.PopulateError.fmt.txt", (Object)this._node.getDisplayPath()));
                if (this._operation.getLogger().isDebugEnabled()) {
                    this._operation.getLogger().debug((Object)"Exception", e);
                }
            }
            catch (ServiceException se) {
                throw new MdException((Throwable)se);
            }
        }
    }

    public void loadPropertyValues() throws MdException, RemoteException {
        if (this._node != null) {
            try {
                this._tempValues[this._indexType] = this._node.getTypeDescriptor().getType();
                this._tempValues[this._indexPath] = this._node.getDisplayPath();
                this._tempValues[this._indexOriginalPath] = this._node.getDisplayPath();
                ImportFolderModelInterface model = (ImportFolderModelInterface)this._node.getFolderModel();
                ImportElementInterface importElement = model.getImportElement((PublicObjectInterface)this._node);
                if (importElement != null) {
                    this._tempValues[this._indexName] = importElement.getDisplayName();
                    ObjectMoveManager manager = ObjectMoveManager.getInstance(this._operation);
                    PathUrl originalPath = manager.getOriginalTargetPath(this._node);
                    if (originalPath != null) {
                        this._tempValues[this._indexOriginalPath] = originalPath.getDisplayPath();
                    }
                    this._tempValues[this._indexDesc] = importElement.getImportItem() == null ? "" : importElement.getImportItem().getDescription();
                } else {
                    this._tempValues[this._indexName] = this._node.getName();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void updatePropertyValues() throws MdException, RemoteException {
        for (int i = 0; i < this.getNumberOfProperties(); ++i) {
            this.setPropertyValue(i, this._tempValues[i]);
        }
    }

    class PathCellEditor
    extends DefaultTableCellEditor {
        Object m_Value;
        int m_iRow;
        int m_iCol;
        WATextField m_lblEditor = new WATextField();
        JButton m_btnBrowse = WsUIUtilities.createBrowseButton();
        JPanel m_pnlEditor = new JPanel(){

            @Override
            public void requestFocus() {
                PathCellEditor.this.m_lblEditor.requestFocus();
            }
        };

        PathCellEditor() {
            this.m_btnBrowse.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (PathCellEditor.this.m_Value != null && PathCellEditor.this.m_Value instanceof String) {
                        PathCellEditor.this.openFileSelector((String)PathCellEditor.this.m_Value);
                    }
                }
            });
            this.m_lblEditor.setEditable(false);
            this.m_pnlEditor.setLayout(new BorderLayout());
            this.m_pnlEditor.add((Component)this.m_lblEditor, "Center");
            this.m_pnlEditor.add((Component)this.m_btnBrowse, "East");
            this.setClickCountToStart(1);
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean flag, int row, int column) {
            this.m_Value = value;
            this.m_iRow = row;
            this.m_iCol = column;
            String sText = "";
            if (value != null && value instanceof String) {
                sText = (String)value;
            }
            this.m_lblEditor.setText(sText);
            this.m_lblEditor.setToolTipText(sText);
            return this.m_pnlEditor;
        }

        public Object getCellEditorValue() {
            return this.m_Value;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void openFileSelector(String objectPath) {
            try {
                boolean isFolder = SASFoldersUtil.isFolder((PublicObjectInterface)DefaultImportPropertiesModel.this._node);
                LinkedHashMap mapFileTypes = new LinkedHashMap(0);
                ServerInterface server = DefaultImportPropertiesModel.this._node.getFolderModel().getServer();
                RepositoryInterface reposInterface = null;
                String initialPath = null;
                PublicObjectContainerInterface container = DefaultImportPropertiesModel.this._node.getContainer();
                if (container != null && container instanceof ContainerNodeInterface) {
                    ImportElementInterface ie = (ImportElementInterface)DefaultImportPropertiesModel.this._node.getProcessorInterface("com.sas.metadata.promotion.model.ImportElementInterface");
                    initialPath = ie != null && ie.isNewObject() ? null : ((ContainerNodeInterface)container).getDisplayPath();
                }
                InformationServicesSelectorPanel panel = new InformationServicesSelectorPanel(initialPath, server, reposInterface, mapFileTypes);
                panel.setShowDirectoriesOnly(isFolder);
                panel.setSelectionMode(InformationServicesSelectorPanel.DIRECTORIES_ONLY);
                panel.setMultiSelectionEnabled(false);
                panel.setRootFolderSelectable(isFolder);
                RemoteFileSelectorDialog dialog = null;
                dialog = new RemoteFileSelectorDialog((Frame)Workspace.getWorkspace(), RB.getStringResource("DefaultImportPropertiesModel.SelectLocation.txt"), true, 2, (BaseRemoteFileSelectorPanel)panel);
                dialog.setAllowNonExistentSelections(false);
                dialog.setVisible(true);
                try {
                    String extendedPath;
                    PathUrl objectPathUrl;
                    String displayPath;
                    String path;
                    PathUrl pathUrl;
                    List lReturnedItems;
                    if (!panel.isCancelled() && (lReturnedItems = panel.getReturnedInformation(true)) != null && !lReturnedItems.isEmpty() && "Folder".equalsIgnoreCase((pathUrl = new PathUrl(path = lReturnedItems.get(0).toString())).getType()) && !(displayPath = (objectPathUrl = new PathUrl(pathUrl, extendedPath = DefaultImportPropertiesModel.this._node.getName() + "(" + DefaultImportPropertiesModel.this._node.getTypeDescriptor().getTypeName() + ")")).getDisplayPath()).equalsIgnoreCase(objectPath)) {
                        String newTargetReposID;
                        String originalTargetReposID;
                        RepositoryInterface repos;
                        MetadataInterface mi;
                        if (DefaultImportPropertiesModel.this._operation.getPackageFileVersion() < 9300 && DefaultImportPropertiesModel.this._node instanceof FolderNodeInterface && (mi = DefaultImportPropertiesModel.this._operation.getServer().getObjectByPath(pathUrl)) != null && (repos = mi.getRepository()) instanceof OMIRepositoryInterface && !(originalTargetReposID = DefaultImportPropertiesModel.this._operation.getRepositoryID()).equalsIgnoreCase(newTargetReposID = ((OMIRepositoryInterface)repos).getDefaultRepositoryId())) {
                            String msg = "The folder \"" + DefaultImportPropertiesModel.this._node.getName() + "\" cannot be moved to \"" + pathUrl.getDisplayPath() + "\".";
                            throw new MetadataPromotionException(msg);
                        }
                        this.m_Value = displayPath;
                        this.m_lblEditor.setText(displayPath);
                        DefaultImportPropertiesModel.this.firePropertyChangeEvent(DefaultImportPropertiesModel.this._indexPath, this.m_Value);
                        ObjectMoveManager moveManager = ObjectMoveManager.getInstance(DefaultImportPropertiesModel.this._operation);
                        moveManager.setCustomTargetPath(DefaultImportPropertiesModel.this._node, pathUrl);
                        if (moveManager.isTargetPathModified(DefaultImportPropertiesModel.this._node.getIdentifier())) {
                            ImportTreeManager treeManager = ImportTreeManager.getInstance(DefaultImportPropertiesModel.this._operation);
                            treeManager.repopulateTree(true);
                            treeManager.selectNode(DefaultImportPropertiesModel.this._node.getIdentifier());
                            moveManager.fireObjectPathNotificationEvent();
                        }
                    }
                }
                catch (MetadataPromotionException e) {
                    VisualsUtil.displayErrorDialog(e.getLocalizedMessage());
                    if (DefaultImportPropertiesModel.this._operation.getLogger().isDebugEnabled()) {
                        DefaultImportPropertiesModel.this._operation.getLogger().debug((Object)("Error moving object: " + e.getLocalizedMessage()), (Throwable)((Object)e));
                    }
                }
                catch (ServiceException e) {
                    String msg = Message.format((ResourceBundle)RB.getResources(), (String)"DefaultImportPropertiesModel.MoveError.fmt.txt", (Object)DefaultImportPropertiesModel.this._node.getTypeDescriptor().getType(), (Object)DefaultImportPropertiesModel.this._node.getDisplayPath());
                    VisualsUtil.displayErrorDialog(msg);
                    if (DefaultImportPropertiesModel.this._operation.getLogger().isDebugEnabled()) {
                        DefaultImportPropertiesModel.this._operation.getLogger().debug((Object)("Error moving object: " + e.getLocalizedMessage()), e);
                    }
                }
                finally {
                    dialog.dispose();
                }
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
            catch (ServiceException ex) {
                MessageUtil.displayServiceExceptionMessage((ServiceException)ex);
            }
            this.stopCellEditing();
        }
    }

    class PathCellRenderer
    implements TableCellRenderer {
        JPanel _panel = new JPanel();
        JLabel _editableLabel = new JLabel();
        JLabel _nonEditableLabel = new JLabel();
        JButton _browseButton = WsUIUtilities.createBrowseButton();

        PathCellRenderer() {
            this._editableLabel.setOpaque(true);
            this._editableLabel.setBackground(SystemColor.window);
            this._editableLabel.setForeground(SystemColor.windowText);
            this._panel.setLayout(new BorderLayout());
            this._panel.add((Component)this._editableLabel, "Center");
            this._panel.add((Component)this._browseButton, "East");
            this._nonEditableLabel.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            int iColumnModelIndex = table.convertColumnIndexToModel(column);
            if (table.getModel().isCellEditable(row, iColumnModelIndex)) {
                String sLabel = "";
                Object myValue = table.getValueAt(row, column);
                if (myValue != null && myValue instanceof String) {
                    sLabel = (String)myValue;
                }
                this._editableLabel.setText(sLabel);
                this._panel.setToolTipText(sLabel);
                return this._panel;
            }
            this._nonEditableLabel.setText(value.toString());
            this._nonEditableLabel.setBackground(isSelected ? table.getSelectionBackground() : SystemColor.control);
            this._nonEditableLabel.setForeground(isSelected ? table.getSelectionForeground() : SystemColor.controlText);
            return this._nonEditableLabel;
        }
    }
}

