/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.promotion.visuals;

import com.sas.metadata.logical.Factory;
import com.sas.metadata.logical.LogicalTypeException;
import com.sas.metadata.logical.TransportableContainerTypeInterface;
import com.sas.metadata.logical.TransportableType2Interface;
import com.sas.metadata.logical.TransportableTypeInterface;
import com.sas.metadata.logical.TypeInterface;
import com.sas.metadata.promotion.ExportHandler;
import com.sas.metadata.promotion.ImportHandler;
import com.sas.metadata.promotion.ImportSummaryInterface;
import com.sas.metadata.promotion.ImportUtil;
import com.sas.metadata.promotion.Log;
import com.sas.metadata.promotion.PropertiesManager;
import com.sas.metadata.promotion.model.ExportFolderModelInterface;
import com.sas.metadata.promotion.model.ExportModelConfiguration;
import com.sas.metadata.promotion.model.ModelFactory;
import com.sas.metadata.promotion.visuals.CopyListListener;
import com.sas.metadata.promotion.visuals.ErrorTrackingManager;
import com.sas.metadata.promotion.visuals.LogViewerDialog;
import com.sas.metadata.promotion.visuals.PasteSpecialWizard;
import com.sas.metadata.promotion.visuals.RB;
import com.sas.metadata.promotion.visuals.ReturnCode;
import com.sas.services.ServiceException;
import com.sas.services.information.OMIServer;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.VirtualFolderInterface;
import com.sas.services.information.publicobject.PublicObjectContainerInterface;
import com.sas.services.information.publicobject.PublicObjectInterface;
import com.sas.services.information.publicobject.TypeDescriptorInterface;
import com.sas.services.information.sasfolders.SASFoldersUtil;
import com.sas.services.information.sasfolders.VirtualFolderNodeInterface;
import com.sas.services.session.SessionContextInterface;
import com.sas.text.Message;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.OpRequestUI;
import com.sas.workspace.Workspace;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.io.File;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.SwingUtilities;

public class CopyPasteManager {
    private static List<PublicObjectInterface> _copyList = new ArrayList<PublicObjectInterface>();
    private static List<CopyListListener> _copyListListeners = new ArrayList<CopyListListener>();
    private static ImportSummaryInterface _importSummary;
    private static String _logFileName;
    private static boolean _isDebugEnabled;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(List<PublicObjectInterface> publicObjects) {
        Workspace workspace = Workspace.getWorkspace();
        workspace.setCursor(Cursor.getPredefinedCursor(3));
        try {
            if (CopyPasteManager.isCopyAllowed(publicObjects)) {
                _copyList.clear();
                _copyList.addAll(publicObjects);
                CopyPasteManager.fireCopyListChanged();
            }
        }
        catch (Exception e) {
            String msg = e.getLocalizedMessage();
            CopyPasteManager.displayErrorDialogNoDetails(msg, 8);
        }
        finally {
            workspace.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    public static boolean isCopyAllowed(PublicObjectInterface publicObject) throws ServiceException, RemoteException {
        ArrayList<PublicObjectInterface> items = new ArrayList<PublicObjectInterface>(1);
        items.add(publicObject);
        return CopyPasteManager.isCopyAllowed(items);
    }

    public static boolean isCopyAllowed(List<PublicObjectInterface> publicObjects) throws ServiceException, RemoteException {
        if (publicObjects == null || publicObjects.isEmpty()) {
            return false;
        }
        try {
            HashMap<String, List<String>> objectMap = new HashMap<String, List<String>>(5);
            Factory factory = Factory.getInstance();
            for (PublicObjectInterface publicObject : publicObjects) {
                TypeDescriptorInterface typeDesc = publicObject.getTypeDescriptor();
                if (typeDesc == null) {
                    return false;
                }
                TypeInterface ti = factory.getTypeInterface(typeDesc.getTypeName());
                if (ti instanceof TransportableType2Interface && !((TransportableType2Interface)ti).isCopyAllowed()) {
                    return false;
                }
                if (!(ti instanceof TransportableTypeInterface)) {
                    return false;
                }
                String typeName = typeDesc.getTypeName();
                if (!CopyPasteManager.isDuplicate(publicObject.getName(), typeName, objectMap)) continue;
                return false;
            }
        }
        catch (LogicalTypeException e) {
            throw new ServiceException((Throwable)e);
        }
        return true;
    }

    private static boolean isDuplicate(String name, String type, Map<String, List<String>> objectMap) {
        List<String> names = objectMap.get(type);
        if (names == null) {
            names = new ArrayList<String>();
            names.add(name);
            objectMap.put(type, names);
        } else {
            for (String objectName : names) {
                if (!name.equalsIgnoreCase(objectName)) continue;
                return true;
            }
            names.add(name);
        }
        return false;
    }

    public static void clearCopyList() {
        _copyList.clear();
        CopyPasteManager.fireCopyListChanged();
    }

    public static List<PublicObjectInterface> getCopyList() {
        return Collections.unmodifiableList(_copyList);
    }

    public static void removeItemFromCopyList(PublicObjectInterface publicObject) {
        if (_copyList.contains(publicObject)) {
            _copyList.remove(publicObject);
            CopyPasteManager.fireCopyListChanged();
        }
    }

    public static void addCopyListListener(CopyListListener lsnr) {
        if (!_copyListListeners.contains(lsnr)) {
            _copyListListeners.add(lsnr);
        }
    }

    public static void removeCopyListListener(CopyListListener lsnr) {
        if (_copyListListeners.contains(lsnr)) {
            _copyListListeners.remove(lsnr);
        }
    }

    public static ImportSummaryInterface getCopySummary() throws ServiceException, RemoteException {
        return _importSummary;
    }

    public static boolean objectsWerePasted() throws ServiceException, RemoteException {
        return _importSummary != null && _importSummary.getTotalImportedItemsCount() > 0;
    }

    public static boolean isPasteAllowed() throws ServiceException, RemoteException {
        return _copyList != null && _copyList.size() != 0;
    }

    public static boolean isPasteAllowed(PublicObjectContainerInterface targetContainer) throws ServiceException, RemoteException {
        if (!CopyPasteManager.isPasteAllowed()) {
            return false;
        }
        TypeDescriptorInterface typeDesc = targetContainer.getTypeDescriptor();
        if (typeDesc == null) {
            return false;
        }
        try {
            Factory factory = Factory.getInstance();
            TypeInterface ti = factory.getTypeInterface(typeDesc.getTypeName());
            if (ti instanceof TransportableContainerTypeInterface && ((TransportableContainerTypeInterface)ti).isPasteAllowed() || CopyPasteManager.isRootFolder(targetContainer)) {
                boolean valid = true;
                for (PublicObjectInterface obj : _copyList) {
                    if (CopyPasteManager.isVirtualFolder(targetContainer)) {
                        return SASFoldersUtil.isContainedByVirtualFolder((PublicObjectInterface)obj);
                    }
                    if (SASFoldersUtil.isValidContainerForChild((PublicObjectInterface)obj, (PublicObjectContainerInterface)targetContainer)) continue;
                    valid = false;
                    break;
                }
                return valid;
            }
        }
        catch (LogicalTypeException e) {
            throw new ServiceException((Throwable)e);
        }
        return false;
    }

    private static boolean isVirtualFolder(PublicObjectContainerInterface container) {
        return container instanceof VirtualFolderNodeInterface || container instanceof VirtualFolderInterface;
    }

    public static void pasteSpecial(PublicObjectContainerInterface targetContainer) {
        CopyPasteManager.pasteSpecialInternal(targetContainer, null, null);
    }

    public static void pasteSpecial(PublicObjectContainerInterface targetContainer, List<String> supportedTypes) {
        CopyPasteManager.pasteSpecialInternal(targetContainer, supportedTypes, null);
    }

    public static void pasteSpecial(PublicObjectContainerInterface targetContainer, List<String> supportedTypes, String reposID) {
        CopyPasteManager.pasteSpecialInternal(targetContainer, supportedTypes, reposID);
    }

    private static void pasteSpecialInternal(PublicObjectContainerInterface targetContainer, List<String> supportedTypes, String reposID) {
        try {
            if (CopyPasteManager.isPasteAllowed()) {
                _importSummary = null;
                ArrayList<PublicObjectInterface> selectedObjects = new ArrayList<PublicObjectInterface>(_copyList);
                if (reposID == null && targetContainer != null) {
                    OMIServer server = Workspace.getWorkspace().getMetadataServer();
                    ImportUtil.validateTargetContainerPermissions(targetContainer, (ServerInterface)server, true);
                }
                CopyPasteManager.importObjectsIntoRootCheck(targetContainer, selectedObjects);
                PasteSpecialWizard wizard = new PasteSpecialWizard(targetContainer, selectedObjects, supportedTypes, RB.getStringResource("PasteSpecialWizard.Title.txt"));
                if (reposID != null) {
                    wizard.changeRepositoryID(reposID);
                }
                wizard.show();
                _importSummary = wizard.getCopySummary();
            }
        }
        catch (Exception e) {
            String msg = e.getLocalizedMessage();
            CopyPasteManager.displayErrorDialogNoDetails(msg, 8);
        }
    }

    public static void paste(PublicObjectContainerInterface targetContainer) {
        CopyPasteManager.pasteInternal(targetContainer, null, null);
    }

    public static void paste(PublicObjectContainerInterface targetContainer, List<String> supportedTypes) {
        CopyPasteManager.pasteInternal(targetContainer, supportedTypes, null);
    }

    public static void paste(PublicObjectContainerInterface targetContainer, List<String> supportedTypes, String reposID) {
        CopyPasteManager.pasteInternal(targetContainer, supportedTypes, reposID);
    }

    private static void pasteInternal(final PublicObjectContainerInterface targetContainer, final List<String> supportedTypes, final String reposID) {
        try {
            if (CopyPasteManager.isPasteAllowed()) {
                _importSummary = null;
                String message = CopyPasteManager.isRootFolder(targetContainer) ? RB.getStringResource("CopyPasteUtil.CopyingObjects.txt") : Message.format((ResourceBundle)RB.getResources(), (String)"CopyPasteUtil.ProgressCopyToFolder.txt", (Object)targetContainer.getName());
                final Workspace workspace = Workspace.getWorkspace();
                OpRequestUI request = new OpRequestUI((Frame)workspace, message, RB.getStringResource("CopyPasteUtil.ProgressCopyTitle.txt"));
                request.setMessagePreferredSize(new Dimension(250, 20));
                request.setDelayBeforeProgressCancelDialog(1000);
                final ReturnCode rc = new ReturnCode();
                Runnable pasteRunnable = new Runnable(){

                    @Override
                    public void run() {
                        CopyPasteManager.runPaste(workspace, targetContainer, supportedTypes, reposID, rc);
                    }
                };
                request.execute(pasteRunnable);
                String error = rc.getErrorMessage();
                if (error != null) {
                    if (rc.getDisplayDetails()) {
                        CopyPasteManager.displayErrorDialog(error, rc.getReturnCode(), _logFileName);
                    } else {
                        CopyPasteManager.displayErrorDialogNoDetails(error, rc.getReturnCode());
                    }
                }
            }
        }
        catch (Exception e) {
            CopyPasteManager.displayErrorDialogNoDetails(e.getLocalizedMessage(), 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void runPaste(Workspace workspace, PublicObjectContainerInterface targetContainer, List<String> supportedTypes, String reposID, ReturnCode rc) {
        File packageFile = null;
        _logFileName = null;
        try {
            if (reposID == null && targetContainer != null) {
                OMIServer server = Workspace.getWorkspace().getMetadataServer();
                ImportUtil.validateTargetContainerPermissions(targetContainer, (ServerInterface)server, true);
            }
            ArrayList<PublicObjectInterface> selectedObjects = new ArrayList<PublicObjectInterface>(_copyList);
            CopyPasteManager.importObjectsIntoRootCheck(targetContainer, selectedObjects);
            packageFile = File.createTempFile("CopyPaste", ".spk");
            boolean exported = CopyPasteManager.runExport(workspace.getSessionContext(), selectedObjects, supportedTypes, packageFile, rc);
            if (exported) {
                CopyPasteManager.runImport(workspace.getSessionContext(), targetContainer, supportedTypes, packageFile, reposID, rc);
            }
            String message = null;
            int returnCode = rc.getReturnCode();
            if ((returnCode & 8) > 0) {
                message = RB.getStringResource("CopyPasteUtil.ErrorsOccurred.txt");
            } else if ((returnCode & 4) > 0) {
                message = RB.getStringResource("CopyPasteUtil.WarningsOccurred.txt");
            }
            if (message != null) {
                rc.setErrorMessage(message);
                rc.setDisplayDetails(true);
            }
        }
        catch (Exception e) {
            String message = null;
            if (packageFile != null) {
                rc.setDisplayDetails(true);
                message = Message.format((ResourceBundle)RB.getResources(), (String)"CopyPasteUtil.GenericErrorWithDetails.fmt.txt", (Object)(e.getMessage() == null ? e.toString() : e.getMessage()));
            } else {
                message = Message.format((ResourceBundle)RB.getResources(), (String)"CopyPasteUtil.GenericError.fmt.txt", (Object)(e.getMessage() == null ? e.toString() : e.getMessage()));
            }
            rc.setErrorMessage(message);
            rc.setReturnCode(8);
        }
        finally {
            if (packageFile != null) {
                packageFile.delete();
            }
        }
    }

    private static boolean runExport(SessionContextInterface session, List<PublicObjectInterface> selectedObjects, List<String> supportedTypes, File packageFile, ReturnCode rc) throws Exception {
        ExportHandler exportHandler = new ExportHandler(selectedObjects, supportedTypes, 2);
        PropertiesManager propManager = exportHandler.getPropertiesManager();
        propManager.setProcessLocalizableProperties(false, false);
        propManager.setProcessSubstitutionProperties(false, false);
        exportHandler.setExportFile(packageFile);
        int returnCode = rc.getReturnCode();
        _logFileName = exportHandler.getLogger().getLogFileName();
        _isDebugEnabled = exportHandler.getLogger().isDebugEnabled();
        boolean exceptionOccurred = false;
        try {
            exportHandler.setSessionContext(session, true);
            Log log = exportHandler.getLogger();
            log.info(RB.getStringResource("CopyPasteUtil.Begin.txt"));
            ExportFolderModelInterface model = ModelFactory.createExportFolderModel(exportHandler);
            ExportModelConfiguration config = (ExportModelConfiguration)model.getConfiguration();
            config.setDisplayEmptyFolders(true);
            config.setAllowFolderExport(false);
            config.setDisplayUnknownObjects(false);
            PublicObjectInterface[] publicObjects = selectedObjects.toArray(new PublicObjectInterface[selectedObjects.size()]);
            exportHandler.loadObjectsToExport(publicObjects, null, model);
            exportHandler.runExport();
            List items = exportHandler.getAllPromotionItems();
            boolean bl = items != null && items.size() > 0;
            return bl;
        }
        catch (Exception e) {
            exceptionOccurred = true;
            returnCode |= 8;
            String message = e.getMessage() == null ? e.toString() : e.getMessage();
            Log log = exportHandler.getLogger();
            log.error(Message.format((ResourceBundle)RB.getResources(), (String)"CopyPasteUtil.CopyError.txt", (Object)message));
            throw e;
        }
        finally {
            Log log = exportHandler.getLogger();
            if (log.isInfoEnabled()) {
                if ((returnCode & 8) > 0) {
                    log.info(RB.getStringResource("CopyPasteUtil.ExportError.txt"));
                } else if ((returnCode & 4) > 0) {
                    log.info(RB.getStringResource("CopyPasteUtil.ExportWarning.txt"));
                } else {
                    log.info(RB.getStringResource("CopyPasteUtil.ExportSuccess.txt"));
                }
            }
            exportHandler.dispose();
            if (exceptionOccurred && (log = exportHandler.getLogger()) != null) {
                log.destroy();
            }
            rc.setReturnCode(returnCode);
        }
    }

    private static void runImport(SessionContextInterface session, PublicObjectContainerInterface targetContainer, List<String> supportedTypes, File packageFile, String reposID, ReturnCode rc) throws Exception {
        ImportHandler importHandler = new ImportHandler(targetContainer, supportedTypes, 2);
        PropertiesManager propManager = importHandler.getPropertiesManager();
        propManager.setProcessLocalizableProperties(false, false);
        propManager.setProcessSubstitutionProperties(false, false);
        if (reposID != null) {
            importHandler.changeRepositoryID(reposID);
        }
        int returnCode = rc.getReturnCode();
        try {
            importHandler.setSessionContext(session, true);
            importHandler.loadExportPackage(packageFile);
            if (importHandler.isProjectRepository()) {
                importHandler.importSecurityMetadata(false);
            } else {
                importHandler.importSecurityMetadata(true);
            }
            importHandler.loadObjectsToImport(false);
            returnCode |= importHandler.fireAnalyzeObjects();
            returnCode |= importHandler.runImport(1);
        }
        catch (Exception e) {
            returnCode |= 8;
            String message = e.getMessage() == null ? e.toString() : e.getMessage();
            Log log = importHandler.getLogger();
            if (CopyPasteManager.isRootFolder(targetContainer)) {
                log.error(Message.format((ResourceBundle)RB.getResources(), (String)"CopyPasteUtil.PasteErrorRepos.txt", (Object)message));
            } else {
                log.error(Message.format((ResourceBundle)RB.getResources(), (String)"CopyPasteUtil.PasteError.txt", (Object)targetContainer.getName(), (Object)message));
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"Copy error", e);
            }
            throw e;
        }
        finally {
            Log log = importHandler.getLogger();
            if (log.isInfoEnabled()) {
                if ((returnCode & 8) > 0) {
                    log.info(RB.getStringResource("CopyPasteUtil.ImportError.txt"));
                } else if ((returnCode & 4) > 0) {
                    log.info(RB.getStringResource("CopyPasteUtil.ImportWarning.txt"));
                } else {
                    log.info(RB.getStringResource("CopyPasteUtil.ImportSuccess.txt"));
                }
            }
            _importSummary = importHandler.getImportSummary();
            importHandler.dispose();
            rc.setReturnCode(returnCode);
        }
    }

    private static void fireCopyListChanged() {
        for (int i = 0; i < _copyListListeners.size(); ++i) {
            _copyListListeners.get(i).copyListChanged();
        }
    }

    protected static void displayErrorDialog(final String message, final int status, String fileName) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int type;
                String title = status == 4 ? RB.getStringResource("Common.Warning.txt") : RB.getStringResource("Common.Error.txt");
                int option = MessageUtil.displayMessage((String)message, (String)title, (int)(type = status == 4 ? 2 : 0), (int)0);
                if (option == 0) {
                    CopyPasteManager.displayLog();
                }
            }
        });
    }

    private static void displayLog() {
        if (_logFileName != null) {
            LogViewerDialog viewer = new LogViewerDialog(RB.getStringResource("CopyPasteUtil.LogTitle.txt"), _logFileName, (Frame)Workspace.getWorkspace());
            viewer.setErrorTrackingSupported(true);
            ErrorTrackingManager errorTracking = viewer.getErrorTrackingManager();
            if (_isDebugEnabled) {
                errorTracking.setErrorMessageRegex(ErrorTrackingManager.ERROR_PATTERN_WITH_TIMESTAMPS);
                errorTracking.setWarningMessageRegex(ErrorTrackingManager.WARNING_PATTERN_WITH_TIMESTAMPS);
            }
            viewer.setVisible(true);
        }
    }

    protected static void displayErrorDialogNoDetails(final String message, final int status) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                String title = status == 4 ? RB.getStringResource("Common.Warning.txt") : RB.getStringResource("Common.Error.txt");
                int type = status == 4 ? 2 : 0;
                MessageUtil.displayMessage((String)message, (String)title, (int)type, (int)-1);
            }
        });
    }

    protected static void importObjectsIntoRootCheck(PublicObjectContainerInterface targetContainer, List<PublicObjectInterface> selectedObjects) throws ServiceException, RemoteException {
        if (CopyPasteManager.isRootFolder(targetContainer)) {
            for (PublicObjectInterface publicObject : selectedObjects) {
                String publicType;
                TypeDescriptorInterface typeDesc = publicObject.getTypeDescriptor();
                if (typeDesc == null || "Folder".equalsIgnoreCase(publicType = typeDesc.getTypeName())) continue;
                throw new ServiceException(RB.getStringResource("CopyPasteUtil.ObjectsUnderRoot.txt"));
            }
        }
    }

    private static boolean isRootFolder(PublicObjectContainerInterface targetContainer) throws ServiceException, RemoteException {
        String publicType;
        TypeDescriptorInterface typeDesc = targetContainer.getTypeDescriptor();
        return typeDesc != null && "RootFolder".equalsIgnoreCase(publicType = typeDesc.getTypeName());
    }

    static {
        _isDebugEnabled = false;
    }
}

