/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.promotion.visuals;

import com.sas.metadata.logical.TransportableTypeInterface;
import com.sas.metadata.promotion.visuals.AbstractPromotionPanel;
import com.sas.metadata.promotion.visuals.AbstractPromotionTree;
import com.sas.metadata.promotion.visuals.Images;
import com.sas.metadata.promotion.visuals.RB;
import com.sas.metadata.promotion.visuals.TreeNodeInterface;
import com.sas.metadata.promotion.visuals.VisualsUtil;
import com.sas.swing.visuals.util.LayoutConstants;
import com.sas.swing.visuals.util.Util;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsAbstractToggleAction;
import com.sas.workspace.WsDescriptionWizardTab;
import com.sas.workspace.WsUIUtilities;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public abstract class AbstractTreePanel
extends WsDescriptionWizardTab
implements ChangeListener,
TreeSelectionListener {
    protected static DefaultTreeModel EMPTY_TREE_MODEL = new DefaultTreeModel(null);
    protected AbstractPromotionTree _tree;
    protected TransportableTypeInterface _folderType;
    protected JScrollPane _scrollPane;
    protected JSplitPane _splitPane;
    protected JTabbedPane _detailsPane;
    protected JLabel _infoLabel;
    protected JToolBar _toolBar;
    protected JButton _selectAllButton;
    protected JButton _clearAllButton;
    protected JButton _expandAllButton;
    protected JButton _collapseAllButton;
    protected JButton _detailsButton;
    protected boolean _canClickNext = true;
    protected int _splitPaneLocation;
    private List<AbstractPromotionPanel> _detailsPanelList;
    private List<AbstractPromotionPanel> _detailsPanelCache;
    private List<TreeNodeInterface> _previousSelectedNodes;

    public AbstractTreePanel(AbstractPromotionTree tree) {
        this._tree = tree;
    }

    public void initialize() {
        this._toolBar = new JToolBar();
        this._toolBar.setFloatable(false);
        this._toolBar.setRollover(true);
        ImageIcon expandIcon = Images.getImageIcon(AbstractTreePanel.class, RB.getStringResource("AbstractTreePanel.Expand.Icon.image"));
        this._expandAllButton = WsUIUtilities.createFlatTextIconButton((WsAbstractAction)new ExpandAllAction());
        VisualsUtil.configureButton(this._expandAllButton, expandIcon, RB.getStringResource("AbstractTreePanel.ExpandAll.txt"), RB.getStringResource("AbstractTreePanel.ExpandAll.Mnemonic.txt"));
        this._toolBar.add(this._expandAllButton);
        ImageIcon collapseIcon = Images.getImageIcon(AbstractTreePanel.class, RB.getStringResource("AbstractTreePanel.Collapse.Icon.image"));
        this._collapseAllButton = WsUIUtilities.createFlatTextIconButton((WsAbstractAction)new CollapseAllAction());
        VisualsUtil.configureButton(this._collapseAllButton, collapseIcon, RB.getStringResource("AbstractTreePanel.CollapseAll.txt"), RB.getStringResource("AbstractTreePanel.CollapseAll.Mnemonic.txt"));
        this._toolBar.add(this._collapseAllButton);
        this._toolBar.addSeparator(new Dimension(10, 0));
        this._selectAllButton = WsUIUtilities.createFlatTextIconButton((WsAbstractAction)new SelectAllAction());
        ImageIcon selectIcon = Images.getImageIcon(AbstractTreePanel.class, RB.getStringResource("AbstractTreePanel.Select.Icon.image"));
        VisualsUtil.configureButton(this._selectAllButton, selectIcon, RB.getStringResource("AbstractTreePanel.SelectAll.txt"), RB.getStringResource("AbstractTreePanel.SelectAll.Mnemonic.txt"));
        this._toolBar.add(this._selectAllButton);
        this._clearAllButton = WsUIUtilities.createFlatTextIconButton((WsAbstractAction)new ClearAllAction());
        ImageIcon clearIcon = Images.getImageIcon(AbstractTreePanel.class, RB.getStringResource("AbstractTreePanel.Clear.Icon.image"));
        VisualsUtil.configureButton(this._clearAllButton, clearIcon, RB.getStringResource("AbstractTreePanel.ClearAll.txt"), RB.getStringResource("AbstractTreePanel.ClearAll.Mnemonic.txt"));
        this._toolBar.add(this._clearAllButton);
        this._toolBar.addSeparator(new Dimension(10, 0));
        ImageIcon detailsIcon = Images.getImageIcon(AbstractTreePanel.class, RB.getStringResource("AbstractTreePanel.Details.Icon.image"));
        this._detailsButton = WsUIUtilities.createFlatToggleTextIconButton((WsAbstractToggleAction)new DetailsAction());
        VisualsUtil.configureButton(this._detailsButton, detailsIcon, RB.getStringResource("AbstractTreePanel.Details.txt"), RB.getStringResource("AbstractTreePanel.Details.Mnemonic.txt"));
        this._toolBar.add(this._detailsButton);
        this._tree.setModel(new DefaultTreeModel(null));
        this._scrollPane = new JScrollPane((Component)((Object)this._tree));
        this._detailsPane = new JTabbedPane();
        this._detailsPane.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        this._detailsPane.setOpaque(false);
        this._splitPane = new JSplitPane(0);
        this._splitPane.setLeftComponent(this._scrollPane);
        this._splitPane.setRightComponent(this._detailsPane);
        this._splitPane.setOpaque(false);
        this._splitPane.setBorder(null);
        this._infoLabel = new JLabel();
        this._infoLabel.setVisible(false);
        this._tree.addTreeSelectionListener(this);
    }

    public void layoutWidgets() {
        GridBagLayout gbl = new GridBagLayout();
        this.setLayout(gbl);
        this.add(this._toolBar, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 13, 0, LayoutConstants.EMPTY_INSETS, 0, 0));
        this.add(this._infoLabel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 18, 1, LayoutConstants.EMPTY_INSETS, 0, 0));
        this.add(this._splitPane, new GridBagConstraints(0, 2, 2, 1, 1.0, 1.0, 18, 1, new Insets(5, 0, 0, 0), 0, 5));
    }

    public boolean doDataExchange(boolean bSaveToModel) {
        if (!bSaveToModel) {
            this.moveDataToView();
            this.loadDetails();
            this.showDetails();
        }
        return true;
    }

    public abstract void moveDataToView();

    protected void displayInfoMessage(String msg, Icon icon) {
        this._infoLabel.setVisible(true);
        this._infoLabel.setText(msg);
        this._infoLabel.setIcon(icon);
    }

    protected void hideInfoMessage() {
        this._infoLabel.setVisible(false);
    }

    protected void handleTreeFailure() {
        DefaultTreeModel model = new DefaultTreeModel(null);
        this._tree.setModel(model);
        this._canClickNext = false;
    }

    protected void addDetailsPanel(AbstractPromotionPanel comp) {
        if (this._detailsPanelList == null) {
            this._detailsPanelList = new ArrayList<AbstractPromotionPanel>();
        }
        this._detailsPanelList.add(comp);
    }

    protected void removeAllDetailComponents() {
        if (this._detailsPanelList != null) {
            this._detailsPanelList.clear();
        }
        this._detailsPane.removeAll();
    }

    private void loadDetails() {
        if (this._detailsPanelList != null && this._detailsPanelList.size() > 0) {
            this._detailsPane.removeAll();
            int treeHeight = this.getHeight();
            if (treeHeight == 0) {
                this.setDividerLocation(0);
            } else {
                this.setDividerLocation(treeHeight * 3 / 5);
            }
            this._splitPane.setResizeWeight(0.75);
            for (int i = 0; i < this._detailsPanelList.size(); ++i) {
                AbstractPromotionPanel panel = this._detailsPanelList.get(i);
                panel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
                String label = Util.getLabelWithoutMnemonic((String)panel.getLabel());
                int index = Util.getDisplayedMnemonicIndex((String)panel.getLabel());
                this._detailsPane.addTab(label, panel);
                if (index == -1) continue;
                int mnemonic = Util.getDisplayedMnemonic((String)panel.getLabel());
                this._detailsPane.setMnemonicAt(i, mnemonic);
                this._detailsPane.setDisplayedMnemonicIndexAt(i, index);
            }
            if (!this.hasBeenShown()) {
                this._detailsPane.getModel().addChangeListener(this);
            }
        }
    }

    protected boolean isDetailsVisible() {
        return this._detailsPane.isVisible();
    }

    protected List<TreeNodeInterface> getSelectedNodes() {
        TreePath[] paths = this._tree.getSelectionPaths();
        if (paths != null) {
            int length = paths.length;
            ArrayList<TreeNodeInterface> nodes = new ArrayList<TreeNodeInterface>(length);
            for (int i = 0; i < length; ++i) {
                Object obj = paths[i].getLastPathComponent();
                if (!(obj instanceof TreeNodeInterface)) continue;
                nodes.add((TreeNodeInterface)obj);
            }
            return nodes;
        }
        return Collections.emptyList();
    }

    protected void updateDetails() {
        JPanel panel;
        List<TreeNodeInterface> nodes = this.getSelectedNodes();
        Component comp = this._detailsPane.getSelectedComponent();
        if (comp instanceof JPanel && (panel = (JPanel)comp) instanceof AbstractPromotionPanel) {
            AbstractPromotionPanel app = (AbstractPromotionPanel)panel;
            boolean loadPanel = this.reloadPanel(nodes, app);
            if (loadPanel) {
                this._tree.removeTreeSelectionListener((TreeSelectionListener)((Object)this._tree));
                app.loadComponent(nodes.toArray(new TreeNodeInterface[0]), null);
                this._tree.addTreeSelectionListener((TreeSelectionListener)((Object)this._tree));
            }
            this._previousSelectedNodes = nodes;
        }
    }

    private boolean reloadPanel(List<TreeNodeInterface> selectedNodes, AbstractPromotionPanel panel) {
        if (this._previousSelectedNodes == null) {
            this._detailsPanelCache = new ArrayList<AbstractPromotionPanel>();
            this._detailsPanelCache.add(panel);
            return true;
        }
        if (this._previousSelectedNodes.size() == selectedNodes.size()) {
            int len = selectedNodes.size();
            for (int i = 0; i < len; ++i) {
                TreeNodeInterface obj2;
                TreeNodeInterface obj1 = selectedNodes.get(i);
                if (obj1 == (obj2 = this._previousSelectedNodes.get(i)) || this._detailsPanelCache == null) continue;
                this._detailsPanelCache.clear();
                this._detailsPanelCache.add(panel);
                return true;
            }
            if (this._detailsPanelCache == null) {
                this._detailsPanelCache = new ArrayList<AbstractPromotionPanel>();
                this._detailsPanelCache.add(panel);
                return true;
            }
            boolean contains = this._detailsPanelCache.contains(panel);
            if (!contains) {
                this._detailsPanelCache.add(panel);
            }
            return !contains;
        }
        if (this._detailsPanelCache != null) {
            this._detailsPanelCache.clear();
            this._detailsPanelCache.add(panel);
        }
        return true;
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        if (this.isDetailsVisible()) {
            this.updateDetails();
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        Object source;
        if (e != null && (source = e.getSource()) == this._detailsPane.getModel()) {
            this.updateDetails();
        }
    }

    protected void setDividerLocation(int location) {
        this._splitPaneLocation = location;
    }

    protected void showDetails() {
        this._detailsPane.setVisible(true);
        this._splitPane.setDividerSize(3);
        if (this._splitPaneLocation > 0) {
            this._splitPane.setDividerLocation(this._splitPaneLocation);
        } else {
            this._splitPane.setDividerLocation(250);
        }
        this.updateDetails();
    }

    protected void hideDetails() {
        this._detailsPane.setVisible(false);
        this._splitPane.setDividerSize(0);
        this._splitPaneLocation = this._splitPane.getDividerLocation();
    }

    protected class DetailsAction
    extends WsAbstractToggleAction {
        public DetailsAction() {
            this.setSelected(true);
        }

        public void actionPerformed(ActionEvent e) {
            if (AbstractTreePanel.this._detailsPane.isVisible()) {
                AbstractTreePanel.this.hideDetails();
            } else {
                AbstractTreePanel.this.showDetails();
            }
        }
    }

    protected class CollapseAllAction
    extends WsAbstractAction {
        protected CollapseAllAction() {
        }

        public void actionPerformed(ActionEvent e) {
            AbstractTreePanel.this.setCursor(Cursor.getPredefinedCursor(3));
            VisualsUtil.collapseTreeNodes(AbstractTreePanel.this._tree);
            AbstractTreePanel.this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    protected class ExpandAllAction
    extends WsAbstractAction {
        protected ExpandAllAction() {
        }

        public void actionPerformed(ActionEvent e) {
            AbstractTreePanel.this.setCursor(Cursor.getPredefinedCursor(3));
            VisualsUtil.expandTreeNodes(AbstractTreePanel.this._tree);
            AbstractTreePanel.this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    protected class ClearAllAction
    extends WsAbstractAction {
        protected ClearAllAction() {
        }

        public void actionPerformed(ActionEvent e) {
            AbstractTreePanel.this.setCursor(Cursor.getPredefinedCursor(3));
            VisualsUtil.clearTreeNodes(AbstractTreePanel.this._tree);
            AbstractTreePanel.this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    protected class SelectAllAction
    extends WsAbstractAction {
        protected SelectAllAction() {
        }

        public void actionPerformed(ActionEvent e) {
            AbstractTreePanel.this.setCursor(Cursor.getPredefinedCursor(3));
            VisualsUtil.selectTreeNodes(AbstractTreePanel.this._tree);
            AbstractTreePanel.this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }
}

