/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.promotion.visuals;

import com.sas.metadata.promotion.PromotionUtil;
import com.sas.metadata.promotion.visuals.PromotionWizardInterface;
import com.sas.metadata.promotion.visuals.RB;
import com.sas.metadata.promotion.visuals.VisualsUtil;
import com.sas.swing.visuals.LabelView;
import com.sas.swing.visuals.util.Util;
import com.sas.visuals.AutoSizingGridLayout;
import com.sas.workspace.WATextField;
import com.sas.workspace.WsDescriptionWizardTab;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;

public abstract class AbstractFilePanel
extends WsDescriptionWizardTab {
    protected static final String FILE_SEPARATOR = System.getProperty("file.separator");
    protected PromotionWizardInterface _wizard;
    protected String _currentDirectory;
    protected String _labelText;
    protected String _fileName;
    protected LabelView _fileLabel;
    protected WATextField _fileText;
    protected JButton _browseButton;

    public AbstractFilePanel(PromotionWizardInterface wizard) {
        this._wizard = wizard;
    }

    public void initialize() {
        super.initialize();
        this._currentDirectory = PromotionUtil.getCurrentDirectory();
        this._fileText = new WATextField();
        this._fileLabel = new LabelView();
        this._browseButton = new JButton();
        Util.configureMnemonicForButton((AbstractButton)this._browseButton, (String)RB.getStringResource("Common.Browse.txt"));
        this._browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractFilePanel.this.onBrowse();
            }
        });
        this._fileLabel.setVerticalAlignment(3);
        this._fileLabel.setWrapStyleWord(true);
        this._fileLabel.setLineWrap(true);
        this._fileLabel.setText(this._labelText);
    }

    protected void setInitialFileName() {
        String fileName = (String)this._wizard.getWizardData("PACKAGE_FILE_NAME");
        if (fileName != null) {
            this._fileText.setText(fileName);
        } else {
            fileName = AbstractFilePanel.getPreviousFileName();
            if (fileName != null && fileName.length() > 0) {
                this._fileText.setText(fileName);
            }
        }
    }

    public void layoutWidgets() {
        AutoSizingGridLayout layout = new AutoSizingGridLayout(0, 1, 5, 10, true, true, true);
        this.setLayout((LayoutManager)layout);
        this.add((Component)this._fileLabel);
        JPanel filePanel = new JPanel();
        AutoSizingGridLayout fileLayout = new AutoSizingGridLayout(1, 2, 5, 5, true, true, true);
        fileLayout.setRemainderColumn(1);
        filePanel.setLayout((LayoutManager)fileLayout);
        filePanel.add((Component)this._fileText);
        filePanel.add(this._browseButton);
        this.add(filePanel);
    }

    public static void setPreviousFileName(String fileName) {
        VisualsUtil.setPreviousPackageFileName(fileName);
    }

    public static String getPreviousFileName() {
        return VisualsUtil.getPreviousPackageFileName();
    }

    public abstract void setText(String var1);

    protected void setCurrentDirectory(String fileName) {
        if (fileName == null) {
            return;
        }
        int index = fileName.lastIndexOf(FILE_SEPARATOR);
        if (index > -1) {
            String parentPath = fileName.substring(0, index);
            PromotionUtil.setCurrentDirectory(parentPath);
        }
    }

    public String getSelectedFileName() {
        String fileName = this._fileText.getText().trim();
        if (fileName.length() == 0) {
            return null;
        }
        if (fileName.indexOf(FILE_SEPARATOR) < 0) {
            fileName = PromotionUtil.getCurrentDirectory() + FILE_SEPARATOR + fileName;
        } else if (fileName.endsWith(FILE_SEPARATOR)) {
            return null;
        }
        return this.getProperFileName(fileName);
    }

    public String getSelectedDirectory() {
        int index;
        String fileName = this._fileText.getText().trim();
        if (fileName.length() == 0) {
            return null;
        }
        if (fileName.endsWith(FILE_SEPARATOR)) {
            return fileName;
        }
        if ((fileName.endsWith(".spk") || fileName.endsWith(".spk".toUpperCase())) && (index = fileName.lastIndexOf(FILE_SEPARATOR)) > -1) {
            return fileName.substring(0, index);
        }
        String dir = fileName + FILE_SEPARATOR;
        File directory = new File(dir);
        if (directory.exists() && directory.isDirectory()) {
            return dir;
        }
        int index2 = fileName.lastIndexOf(FILE_SEPARATOR);
        return index2 == -1 ? null : fileName.substring(0, index2);
    }

    private void onBrowse() {
        File selectedFile;
        String defaultPath = this.getSelectedDirectory();
        if (defaultPath == null) {
            defaultPath = PromotionUtil.getCurrentDirectory();
        }
        JFileChooser chooser = new JFileChooser(defaultPath);
        chooser.setApproveButtonText(RB.getStringResource("FilePanel.OK.txt"));
        chooser.setDialogTitle(RB.getStringResource("FilePanel.Browse.txt"));
        chooser.setFileSelectionMode(0);
        chooser.addChoosableFileFilter(new BrowseFilter());
        int rc = chooser.showOpenDialog((Component)((Object)this));
        if (rc == 0 && (selectedFile = chooser.getSelectedFile()) != null) {
            String path = selectedFile.getPath();
            path = this.getProperFileName(path);
            this._fileText.setText(path);
        }
    }

    protected String getProperFileName(String path) {
        return path;
    }

    private class BrowseFilter
    extends FileFilter {
        private BrowseFilter() {
        }

        @Override
        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            String name = f.getName().toLowerCase();
            return name.endsWith(".spk");
        }

        @Override
        public String getDescription() {
            return RB.getStringResource("FilePanel.Filter.Description.txt");
        }
    }
}

