/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.promotion.visuals;

import com.sas.metadata.promotion.ExportHandler;
import com.sas.metadata.promotion.ExportItemInterface;
import com.sas.metadata.promotion.ExportOperationInterface;
import com.sas.metadata.promotion.Log;
import com.sas.metadata.promotion.visuals.AbstractObjectOptionsPanel;
import com.sas.metadata.promotion.visuals.AbstractTreePanel;
import com.sas.metadata.promotion.visuals.DependenciesEvent;
import com.sas.metadata.promotion.visuals.DependenciesListener;
import com.sas.metadata.promotion.visuals.DependenciesPanel;
import com.sas.metadata.promotion.visuals.ExportObjectOptionsPanel;
import com.sas.metadata.promotion.visuals.ExportObjectPropertiesPanel;
import com.sas.metadata.promotion.visuals.ExportTree;
import com.sas.metadata.promotion.visuals.ExportTreeModel;
import com.sas.metadata.promotion.visuals.ExportTreeModelInterface;
import com.sas.metadata.promotion.visuals.ExportTreeNode;
import com.sas.metadata.promotion.visuals.ExportTreeNodeInterface;
import com.sas.metadata.promotion.visuals.ExportWizardInterface;
import com.sas.metadata.promotion.visuals.FolderNode;
import com.sas.metadata.promotion.visuals.ProgressBarLauncher;
import com.sas.metadata.promotion.visuals.ProgressReturnCode;
import com.sas.metadata.promotion.visuals.RB;
import com.sas.metadata.promotion.visuals.UsedByPanel;
import com.sas.metadata.promotion.visuals.VisualsUtil;
import com.sas.services.ServiceException;
import com.sas.services.information.sasfolders.PublicObjectNodeInterface;
import com.sas.swing.visuals.CheckBoxTree;
import java.awt.Cursor;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public abstract class AbstractExportTreePanel
extends AbstractTreePanel
implements DependenciesListener {
    protected ExportWizardInterface _wizard;
    protected ExportOperationInterface _handler;
    protected Log _log;
    protected ExportTreeModelInterface _model;
    protected DependenciesPanel[] _depPanels;
    protected AbstractObjectOptionsPanel _optionsPanel;
    protected List<PublicObjectNodeInterface> _duplicateObjects;
    protected boolean _treeCreated = false;
    protected String _projectReposID;
    protected boolean _usedForChangeManagement = false;

    public AbstractExportTreePanel(ExportWizardInterface wizard) {
        super(new ExportTree());
        this._wizard = wizard;
        this._handler = wizard.getExportHandler();
    }

    protected abstract ExportTreeModelInterface createTreeModel() throws ServiceException, RemoteException;

    @Override
    public void initialize() {
        this._tree.getCheckedModel().addTreeSelectionListener(this);
        super.initialize();
    }

    protected boolean isExportItemUnique(Map<String, List<ExportItemInterface>> exportMap, ExportItemInterface exportItem) {
        String publicType = exportItem.getTypeInterface().getPublicType();
        List<ExportItemInterface> items = exportMap.get(publicType);
        if (items == null) {
            return false;
        }
        for (ExportItemInterface item : items) {
            if (item == exportItem || item.getID().equalsIgnoreCase(exportItem.getID())) {
                return false;
            }
            if (!item.getName().equalsIgnoreCase(exportItem.getName())) continue;
            return true;
        }
        return false;
    }

    protected boolean isPopulatingTree() {
        if (this._usedForChangeManagement) {
            return true;
        }
        if (!this._canClickNext) {
            return true;
        }
        Boolean populate = (Boolean)this._wizard.getWizardData("POPULATE_TREE_MODEL");
        return populate == null || populate != false;
    }

    protected abstract String getRootNodeName();

    @Override
    public void moveDataToView() {
        if (this.isPopulatingTree()) {
            this.removeAllDetailComponents();
            this._tree.setModel(EMPTY_TREE_MODEL);
            this._tree.scrollRowToVisible(0);
            this._folderType = this._handler.getTransportableType("Folder");
            if (this._folderType == null) {
                throw new IllegalStateException(RB.getStringResource("AbstractTreePanel.FolderType.txt"));
            }
            DependenciesPanel depPanel = new DependenciesPanel(this, this._handler);
            UsedByPanel usedByPanel = new UsedByPanel(this, this._handler);
            this._depPanels = new DependenciesPanel[]{depPanel, usedByPanel};
            if (this._usedForChangeManagement) {
                depPanel.setProjectRepositoryID(this._projectReposID);
                usedByPanel.setProjectRepositoryID(this._projectReposID);
            }
            this.addDetailsPanel(depPanel);
            this.addDetailsPanel(usedByPanel);
            this._optionsPanel = new ExportObjectOptionsPanel(this._handler);
            if (!this._usedForChangeManagement) {
                this.addDetailsPanel(this._optionsPanel);
            }
            this.addDetailsPanel(new ExportObjectPropertiesPanel(this._handler));
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        AbstractExportTreePanel.this.setCursor(Cursor.getPredefinedCursor(3));
                        AbstractExportTreePanel.this.populateTree();
                    }
                    finally {
                        AbstractExportTreePanel.this.setCursor(Cursor.getPredefinedCursor(0));
                    }
                }
            });
        } else {
            Object root;
            TreeModel model = this._tree.getModel();
            if (model != null && (root = model.getRoot()) instanceof FolderNode && ((FolderNode)root).isRoot()) {
                String currentName = ((FolderNode)root).getName();
                String name = this.getRootNodeName();
                if (currentName != null && !currentName.equals(name)) {
                    ((FolderNode)root).setName(name);
                    if (model instanceof ExportTreeModel) {
                        ((ExportTreeModel)model).nodeChanged((FolderNode)root);
                    }
                }
            }
        }
    }

    private void populateTree() {
        try {
            TreeLoader loader = new TreeLoader(this._wizard);
            loader.createTree();
            VisualsUtil.expandTreeNodes(this._tree);
            if (this._duplicateObjects != null && this._depPanels != null) {
                for (int i = 0; i < this._depPanels.length; ++i) {
                    this._depPanels[i].setDuplicateObjectMap(new ArrayList<PublicObjectNodeInterface>(this._duplicateObjects));
                }
            }
            this._canClickNext = true;
        }
        catch (Exception e) {
            try {
                String msg;
                this.handleTreeFailure();
                String string = msg = e.getMessage() != null ? e.getMessage() : RB.getStringResource("AbstractTreePanel.Tree.Error.txt");
                if (this._log != null && this._log.isErrorEnabled()) {
                    this._log.error(msg, e);
                }
                VisualsUtil.displayErrorDialog(msg);
            }
            catch (Throwable throwable) {
                this._tree.requestFocus();
                if (!this._canClickNext) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            AbstractExportTreePanel.this._wizard.getNextButton().setEnabled(false);
                        }
                    });
                }
                throw throwable;
            }
            this._tree.requestFocus();
            if (!this._canClickNext) {
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
        }
        this._tree.requestFocus();
        if (!this._canClickNext) {
            SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
        }
    }

    @Override
    public boolean isObjectBeingExported(String id) throws ServiceException, RemoteException {
        return this._model.containsExportNode(id);
    }

    @Override
    public boolean isExportObjectSelected(String id) throws ServiceException, RemoteException {
        if (id == null) {
            return false;
        }
        for (Object obj : this._tree.getCheckedObjects()) {
            ExportTreeNodeInterface exportNode;
            PublicObjectNodeInterface poNode;
            if (!(obj instanceof ExportTreeNodeInterface) || (poNode = (exportNode = (ExportTreeNodeInterface)obj).getPublicObjectNode()) == null || !id.equalsIgnoreCase(poNode.getIdentifier())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void objectSelected(DependenciesEvent event) throws ServiceException, RemoteException {
        if (event.isSelected()) {
            this.addDependentObjectToTree(event.getObjectID(), event.getPublicType());
        } else {
            this.removeDependentObjectFromTree(event.getObjectID(), event.getPublicType());
        }
    }

    protected void addDependentObjectToTree(String objectID, String publicType) throws ServiceException, RemoteException {
        if (this.isObjectBeingExported(objectID)) {
            TreePath path;
            ExportTreeNodeInterface node = this._model.getExportNode(objectID);
            if (node instanceof ExportTreeNode && !VisualsUtil.isNodeSelected((CheckBoxTree)this._tree, path = new TreePath(((ExportTreeNode)node).getPath()))) {
                this.checkObjectNode(node, true);
            }
        } else {
            ExportTreeNodeInterface node = this._model.createDependencyNode(objectID, publicType);
            if (node != null) {
                TreeNode parent = node.getParent();
                if (parent instanceof DefaultMutableTreeNode) {
                    this._tree.expandPath(new TreePath(((DefaultMutableTreeNode)parent).getPath()));
                }
                this.checkObjectNode(node, true);
            }
        }
    }

    protected void removeDependentObjectFromTree(String objectID, String publicType) throws ServiceException, RemoteException {
        ExportTreeNodeInterface node;
        if (this.isObjectBeingExported(objectID) && (node = this._model.getExportNode(objectID)) != null) {
            this.checkObjectNode(node, false);
        }
    }

    protected void checkObjectNode(ExportTreeNodeInterface node, boolean check) {
        if (node instanceof ExportTreeNode) {
            this._tree.getCheckedModel().removeTreeSelectionListener(this);
            this._tree.checkPath(new TreePath(((ExportTreeNode)node).getPath()), check, true);
            this._tree.getCheckedModel().addTreeSelectionListener(this);
        }
    }

    protected class TreeLoader
    extends ProgressBarLauncher {
        public TreeLoader(ExportWizardInterface wizard) {
            super(wizard, wizard.getExportHandler());
        }

        @Override
        public String getMessage() {
            if (AbstractExportTreePanel.this._usedForChangeManagement) {
                return RB.getStringResource("ExportTreePanel.ProgressMessage.CM.txt");
            }
            return RB.getStringResource("ExportTreePanel.ProgressMessage.txt");
        }

        @Override
        public String getTitle() {
            return RB.getStringResource("ExportTreePanel.ProgressTitle.txt");
        }

        public void createTree() throws ServiceException {
            this.setWaitTime(1000);
            this.launch(new TreeRunnable());
            ProgressReturnCode code = this.getReturnCode();
            int rc = code.getReturnCode();
            if (rc != 0) {
                throw new ServiceException(code.getErrorMessage());
            }
        }

        class TreeRunnable
        implements Runnable {
            @Override
            public void run() {
                ProgressReturnCode rc = TreeLoader.this.getReturnCode();
                try {
                    ExportTreeModelInterface model = AbstractExportTreePanel.this.createTreeModel();
                    if (model != null) {
                        AbstractExportTreePanel.this._model = model;
                        AbstractExportTreePanel.this._tree.setRootVisible(true);
                        AbstractExportTreePanel.this._tree.setModel(model);
                        ((ExportHandler)AbstractExportTreePanel.this._handler).setExportModel(model.getExportModel());
                        TreePath path = new TreePath(model.getRoot());
                        AbstractExportTreePanel.this._tree.checkPath(path, true, true);
                        AbstractExportTreePanel.this._tree.checkChildren(path, true, true);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    rc.setReturnCode(8);
                    rc.setErrorMessage(e.getMessage());
                }
            }
        }
    }
}

