/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.promotion.visuals;

import com.sas.metadata.logical.TransportableTypeInterface;
import com.sas.metadata.logical.TypeInterface;
import com.sas.metadata.promotion.AbstractPromotionListener;
import com.sas.metadata.promotion.Log;
import com.sas.metadata.promotion.MessageListener;
import com.sas.metadata.promotion.NotificationEvent;
import com.sas.metadata.promotion.NotificationListener;
import com.sas.metadata.promotion.PromotionHandler;
import com.sas.metadata.promotion.visuals.AbstractPromotionWizard;
import com.sas.metadata.promotion.visuals.Images;
import com.sas.metadata.promotion.visuals.PromotionWizardInterface;
import com.sas.metadata.promotion.visuals.RB;
import com.sas.metadata.promotion.visuals.WizardPanelInterface;
import com.sas.swing.visuals.util.LayoutConstants;
import com.sas.text.Message;
import com.sas.workspace.WsDescriptionWizardTab;
import com.sas.workspace.WsUIUtilities;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public abstract class AbstractExecutePanel
extends WsDescriptionWizardTab
implements WizardPanelInterface,
NotificationListener,
MessageListener {
    private static final long serialVersionUID = -5314369941462802875L;
    public static final String PANEL_NAME = "ExecutePanel";
    protected PromotionWizardInterface _wizard;
    protected PromotionHandler _operation;
    protected JList _executionList;
    protected JScrollPane _executionScrollPane;
    protected JLabel _executionLabel;
    protected JLabel _statusLabel;
    protected JLabel _detailsLabel;
    protected JLabel _processingLabel;
    protected String _status;
    protected Map<Integer, String> _statusMessageMap;
    private int _selectedListIndex = 0;
    protected boolean _finished = false;
    protected Timer _timer;
    protected int _imageCount = 0;
    private static ImageIcon _time1Image = Images.getImageIcon(AbstractExecutePanel.class, RB.getStringResource("AbstractExecutePanel.Time1.image"));
    private static ImageIcon _time2Image = Images.getImageIcon(AbstractExecutePanel.class, RB.getStringResource("AbstractExecutePanel.Time2.image"));
    private static ImageIcon _time3Image = Images.getImageIcon(AbstractExecutePanel.class, RB.getStringResource("AbstractExecutePanel.Time3.image"));
    private static ImageIcon _time4Image = Images.getImageIcon(AbstractExecutePanel.class, RB.getStringResource("AbstractExecutePanel.Time4.image"));
    private static ImageIcon _time5Image = Images.getImageIcon(AbstractExecutePanel.class, RB.getStringResource("AbstractExecutePanel.Time5.image"));
    private static ImageIcon _runningImage = Images.getImageIcon(AbstractExecutePanel.class, RB.getStringResource("AbstractExecutePanel.RunningIcon.image"));
    private static ImageIcon _emptyImage = Images.getImageIcon(AbstractExecutePanel.class, RB.getStringResource("AbstractExecutePanel.Empty.image"));

    public AbstractExecutePanel(PromotionWizardInterface wizard, PromotionHandler operation) {
        this._wizard = wizard;
        this._operation = operation;
        this._statusMessageMap = new LinkedHashMap<Integer, String>(5);
    }

    public abstract ExecutionThread createExecutionThread();

    public void initialize() {
        this._executionLabel = new JLabel();
        this._statusLabel = new JLabel();
        this._statusLabel.setIcon(_runningImage);
        this._statusLabel.setPreferredSize(new Dimension(300, 15));
        Font fnt = WsUIUtilities.getSystemDefaultFont();
        this._statusLabel.setFont(fnt.deriveFont(1));
        this._detailsLabel = new JLabel();
        this._detailsLabel.setPreferredSize(new Dimension(300, 12));
        this._processingLabel = new JLabel();
        this._executionScrollPane = new JScrollPane();
        this._executionList = new JList();
        this._executionList.setBackground(null);
        this._executionList.setCellRenderer(new StatusRenderer());
        this._executionScrollPane.getViewport().setView(this._executionList);
        DefaultListModel<String> listModel = new DefaultListModel<String>();
        this._executionList.setModel(listModel);
        this._executionScrollPane.getViewport().setView(this._executionList);
        int currentIndex = 1;
        for (Map.Entry<Integer, String> entry : this._statusMessageMap.entrySet()) {
            String statusMessage = entry.getValue();
            String resourceKey = "AbstractExecutePanel.Status_" + currentIndex++ + ".fmt.txt";
            try {
                String msg = Message.format((ResourceBundle)RB.getResources(), (String)resourceKey, (Object)statusMessage);
                listModel.addElement(msg);
            }
            catch (MissingResourceException missingResourceException) {}
        }
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AbstractExecutePanel.this.timerAction();
            }
        };
        this._timer = new Timer(250, listener);
    }

    public void layoutWidgets() {
        GridBagLayout gbl = new GridBagLayout();
        this.setLayout(gbl);
        this.add(this._executionLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 1, LayoutConstants.EMPTY_INSETS, 0, 0));
        this.add(this._executionScrollPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.5, 18, 1, LayoutConstants.EMPTY_INSETS, 0, 0));
        this.add(this._statusLabel, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 18, 2, new Insets(5, 0, 0, 0), 0, 0));
        this.add(this._detailsLabel, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 18, 2, new Insets(5, 2, 0, 0), 0, 0));
        this.add(this._processingLabel, new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.add(new JPanel(), new GridBagConstraints(0, 8, 0, 0, 1.0, 1.0, 18, 1, new Insets(12, 12, 12, 12), 0, 0));
    }

    public boolean validateData() {
        return this._finished;
    }

    @Override
    public String getPanelName() {
        return PANEL_NAME;
    }

    protected void addStatusEntry(int statusCode, String message) {
        this._statusMessageMap.put(statusCode, message);
    }

    @Override
    public void notify(NotificationEvent event) {
        Integer type = event.getEventType();
        String statusMessage = this._statusMessageMap.get(type);
        if (statusMessage != null) {
            this._status = statusMessage;
            this._statusLabel.setText(statusMessage);
            this._executionList.setSelectedIndex(this._selectedListIndex++);
        }
        this.setDetailsText(event.getDetailMessage());
    }

    private void setDetailsText(String message) {
        if (message != null && message.length() > 0) {
            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"AbstractExecutePanel.Details.fmt.txt", (Object)message);
            this._detailsLabel.setText(msg);
        } else {
            this._detailsLabel.setText("");
        }
    }

    public boolean doDataExchange(boolean bSaveToModel) {
        if (!bSaveToModel) {
            this.runProcess();
        }
        return true;
    }

    private void runProcess() {
        if (this._operation == null) {
            return;
        }
        this._operation.addNotificationListener(this);
        this.addMessageListeners();
        ExecutionThread thread = this.createExecutionThread();
        thread.start();
    }

    public void addMessageListeners() {
        this.setMessageListeners(true);
    }

    public void removeMessageListeners() {
        this.setMessageListeners(false);
    }

    private void setMessageListeners(boolean add) {
        Map<String, TypeInterface> types = this._operation.getTypes();
        int promotionType = this._operation.getPromotionType();
        for (Map.Entry<String, TypeInterface> entry : types.entrySet()) {
            TypeInterface pt = entry.getValue();
            if (!(pt instanceof TransportableTypeInterface)) continue;
            Object obj = null;
            if (promotionType == 0) {
                obj = ((TransportableTypeInterface)pt).getExportListener();
            } else if (promotionType == 1 || promotionType == 3) {
                obj = ((TransportableTypeInterface)pt).getImportListener();
            }
            if (obj == null || !(obj instanceof AbstractPromotionListener)) continue;
            AbstractPromotionListener listener = (AbstractPromotionListener)obj;
            if (add) {
                listener.addMessageListener(this);
                continue;
            }
            listener.removeMessageListener(this);
        }
    }

    @Override
    public void displayMessage(String message) {
        this.setDetailsText(message);
    }

    public void timerAction() {
        ++this._imageCount;
        if (this._imageCount > 8) {
            this._imageCount = 1;
        }
        switch (this._imageCount) {
            case 1: {
                this._processingLabel.setIcon(_time1Image);
                break;
            }
            case 2: {
                this._processingLabel.setIcon(_time2Image);
                break;
            }
            case 3: {
                this._processingLabel.setIcon(_time3Image);
                break;
            }
            case 4: {
                this._processingLabel.setIcon(_time4Image);
                break;
            }
            case 5: {
                this._processingLabel.setIcon(_time5Image);
                break;
            }
            case 6: {
                this._processingLabel.setIcon(_time4Image);
                break;
            }
            case 7: {
                this._processingLabel.setIcon(_time3Image);
                break;
            }
            case 8: {
                this._processingLabel.setIcon(_time2Image);
                break;
            }
            default: {
                this._processingLabel.setIcon(_time3Image);
            }
        }
    }

    public void startTimer() {
        this._processingLabel.setVisible(true);
        this._processingLabel.setIcon(_time1Image);
        this._timer.start();
    }

    public void stopTimer() {
        this._timer.stop();
        this._imageCount = 1;
    }

    protected void disableButtons() {
        this._wizard.getNextButton().setEnabled(false);
        this._wizard.getBackButton().setEnabled(false);
        this._wizard.getCancelButton().setEnabled(false);
        this._wizard.getHelpButton().setEnabled(false);
        this._wizard.setCloseable(false);
    }

    protected void proceedToFinish(int status) {
        if (this._wizard != null) {
            this._operation.removeNotificationListener(this);
            this.removeMessageListeners();
            Integer iStatus = (Integer)this._wizard.getWizardData("STATUS");
            if (iStatus == null) {
                this._wizard.replaceWizardData("STATUS", new Integer(status));
            } else if (status > iStatus) {
                this._wizard.replaceWizardData("STATUS", new Integer(status));
            }
            this._finished = true;
            this.validate();
            if (this._wizard instanceof AbstractPromotionWizard) {
                ActionEvent event = new ActionEvent(this._wizard.getNextButton(), 1, "FINISH");
                ((AbstractPromotionWizard)this._wizard).actionPerformed(event);
            }
        }
    }

    protected abstract class ExecutionThread
    extends Thread {
        protected Log _log;
        protected int _rc = 0;

        public ExecutionThread() {
            this._log = AbstractExecutePanel.this._operation.getLogger();
        }

        public abstract void launchOperation();

        @Override
        public void run() {
            this.startProcess();
            this.launchOperation();
            this.endProcess();
        }

        private void startProcess() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AbstractExecutePanel.this.disableButtons();
                    AbstractExecutePanel.this.startTimer();
                }
            });
        }

        private void endProcess() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AbstractExecutePanel.this.stopTimer();
                    AbstractExecutePanel.this.proceedToFinish(ExecutionThread.this._rc);
                }
            });
        }
    }

    class StatusRenderer
    extends JLabel
    implements ListCellRenderer {
        StatusRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Font listFont = list.getFont();
            String text = value.toString();
            if (text != null && text.length() > 0) {
                this.setText(text);
                if (isSelected) {
                    Font boldFont;
                    this.setIcon(_runningImage);
                    listFont = boldFont = listFont.deriveFont(1);
                } else {
                    this.setIcon(_emptyImage);
                }
            }
            this.setBackground(list.getBackground());
            this.setForeground(list.getForeground());
            this.setEnabled(list.isEnabled());
            this.setFont(listFont);
            return this;
        }
    }
}

