/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.promotion.persistence;

import com.sas.metadata.promotion.PromotionItemInterface;
import com.sas.metadata.promotion.persistence.AbstractTransportMetadataParser;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class MapTransportMetadataParser
extends AbstractTransportMetadataParser {
    protected Map<String, Map> _mappedObjects;

    public MapTransportMetadataParser(List<PromotionItemInterface> importItems) {
        super(importItems);
        this._mappedObjects = new LinkedHashMap<String, Map>(importItems.size());
        for (PromotionItemInterface item : importItems) {
            this._mappedObjects.put(item.getID(), null);
        }
    }

    public Map getObjectMap() {
        return this._mappedObjects;
    }

    @Override
    protected AbstractTransportMetadataParser.ObjectElement createNewObjectElement(String name, AbstractTransportMetadataParser.BaseElement parent) {
        return new MapObjectElement(name, parent);
    }

    @Override
    protected AbstractTransportMetadataParser.AssocElement createNewAssocElement(String name, AbstractTransportMetadataParser.BaseElement parent) {
        return new MapAssocElement(name, parent);
    }

    @Override
    protected void createTopLevelObject(AbstractTransportMetadataParser.ObjectElement element, String id, String name, String metadataType) {
        Map objectMap = this.createObjectMap(id, name, metadataType);
        ((MapObjectElement)element).setObjectMap(objectMap);
        this._mappedObjects.put(id, objectMap);
    }

    @Override
    protected void createSecondaryObject(AbstractTransportMetadataParser.ObjectElement element, String id, String name, String metadataType, boolean isObjRef) {
        Map objectMap = this.createObjectMap(id, name, metadataType);
        ((MapObjectElement)element).setObjectMap(objectMap);
        AbstractTransportMetadataParser.AssocElement parent = (AbstractTransportMetadataParser.AssocElement)element.getParent();
        ((MapAssocElement)parent).addObjectMap(objectMap);
    }

    @Override
    protected void addObjectAttribute(AbstractTransportMetadataParser.ObjectElement element, String attrName, String attrValue) {
        Map objectMap = ((MapObjectElement)element).getObjectMap();
        objectMap.put(attrName, attrValue);
    }

    private Map createObjectMap(String id, String name, String type) {
        LinkedHashMap<String, String> objectMap = new LinkedHashMap<String, String>();
        objectMap.put("MetadataObjectType", type);
        objectMap.put("Id", id);
        objectMap.put("Name", name);
        return objectMap;
    }

    private class MapAssocElement
    extends AbstractTransportMetadataParser.AssocElement {
        private List _objectList;

        public MapAssocElement(String name, AbstractTransportMetadataParser.BaseElement parentElement) {
            super(name, parentElement);
        }

        @Override
        public List<?> getAssocList() {
            return this._objectList;
        }

        public void addObjectMap(Map objectMap) {
            if (this._objectList == null) {
                this._objectList = new ArrayList();
            }
            this._objectList.add(objectMap);
        }
    }

    private class MapObjectElement
    extends AbstractTransportMetadataParser.ObjectElement {
        protected Map _objectMap;

        public MapObjectElement(String name, AbstractTransportMetadataParser.BaseElement parentElement) {
            super(name, parentElement);
        }

        public void setObjectMap(Map objectMap) {
            this._objectMap = objectMap;
        }

        public Map getObjectMap() {
            return this._objectMap;
        }

        @Override
        public void addAssociation(String associationName, List<?> objectList) {
            if (this._objectMap != null) {
                this._objectMap.put(associationName, objectList);
            }
        }

        @Override
        public boolean containsAssociation(String associationName) {
            return this._objectMap == null ? false : this._objectMap.containsKey(associationName);
        }
    }
}

