/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.promotion.persistence;

import com.sas.meta.SASOMI.IMetadataTransport;
import com.sas.metadata.promotion.ConnectionPoint;
import com.sas.metadata.promotion.ConnectionPointInterface;
import com.sas.metadata.promotion.DefaultImportItem;
import com.sas.metadata.promotion.ImportItemInterface;
import com.sas.metadata.promotion.ImportOperationInterface;
import com.sas.metadata.promotion.MetadataPromotionException;
import com.sas.metadata.promotion.NestedImportItemInterface;
import com.sas.metadata.promotion.PromotionItemInterface;
import com.sas.metadata.promotion.PromotionUtil;
import com.sas.metadata.promotion.XMLUtil;
import com.sas.metadata.promotion.model.ImportElementInterface;
import com.sas.metadata.promotion.model.ImportFolderModelInterface;
import com.sas.metadata.promotion.persistence.AbstractImportMetadataManager;
import com.sas.metadata.promotion.persistence.AbstractTransportMetadataParser;
import com.sas.metadata.promotion.persistence.DocumentTransportMetadataParser;
import com.sas.metadata.promotion.persistence.FinishedParsingException;
import com.sas.metadata.promotion.persistence.ImportMetadataManagementInterface;
import com.sas.metadata.promotion.persistence.MapTransportMetadataParser;
import com.sas.metadata.promotion.persistence.ParsingConstants;
import com.sas.metadata.promotion.persistence.PersistenceUtil;
import com.sas.metadata.promotion.persistence.RB;
import com.sas.metadata.remote.MdOMRConnection;
import com.sas.services.ServiceException;
import com.sas.services.TransportException;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.PathUrl;
import com.sas.services.information.publicobject.PublicObjectInterface;
import com.sas.services.information.sasfolders.FolderNodeInterface;
import com.sas.services.information.sasfolders.PublicObjectNodeInterface;
import com.sas.services.information.sasfolders.SASFoldersUtil;
import com.sas.util.UsageVersion;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.omg.CORBA.StringHolder;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ImportMetadataManager_930
extends AbstractImportMetadataManager
implements ImportMetadataManagementInterface {
    protected XMLEventFactory _eventFactory = XMLEventFactory.newInstance();
    protected XMLInputFactory _inputFactory = XMLInputFactory.newInstance();
    protected XMLOutputFactory _outputFactory = null;
    protected Map<String, Document> _templateCache = null;
    protected DocumentBuilderFactory _documentFactory = null;
    private SAXParser _saxParser = null;
    protected String _currentObjectId = null;
    protected Map<String, String> _objectReposMap;
    protected String _defaultTargetRepos = null;
    protected File _transportFile = null;
    protected File _deployMapFile = null;

    public ImportMetadataManager_930(ImportOperationInterface operation) {
        super(operation);
        this._inputFactory.setProperty("com.ctc.wstx.maxAttributeSize", String.valueOf(10000000));
        this._outputFactory = XMLOutputFactory.newInstance();
    }

    @Override
    public void loadPackageMetadata() throws MetadataPromotionException {
        this.readDeployMap();
        this.readConnections();
    }

    private File getDeployMapFile() throws TransportException, IOException {
        if (this._deployMapFile == null) {
            this._deployMapFile = this._contentHandler.getFileFromPackage("DeployMap.xml");
        }
        return this._deployMapFile;
    }

    private File getTransportMetadataFile() throws TransportException, IOException {
        if (this._transportFile == null) {
            this._transportFile = this._contentHandler.getFileFromPackage("TransportMetadata.xml");
        }
        return this._transportFile;
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this._deployMapFile != null) {
            if (this._deployMapFile.exists()) {
                this._deployMapFile.delete();
            }
            this._deployMapFile = null;
        }
        if (this._transportFile != null) {
            if (this._transportFile.exists()) {
                this._transportFile.delete();
            }
            this._transportFile = null;
        }
    }

    private void readDeployMap() throws MetadataPromotionException {
        FileInputStream fileStream = null;
        XMLEventReader eventReader = null;
        try {
            fileStream = new FileInputStream(this.getDeployMapFile());
            eventReader = this._inputFactory.createXMLEventReader(fileStream, "UTF-8");
            int currentLevel = 0;
            boolean continueParsing = true;
            boolean processingRepos = false;
            boolean processingObjects = false;
            Stack<ImportItemInterface> itemStack = new Stack<ImportItemInterface>();
            block13: while (eventReader.hasNext() && continueParsing) {
                XMLEvent e = eventReader.nextEvent();
                switch (e.getEventType()) {
                    case 1: {
                        StartElement se = e.asStartElement();
                        if (currentLevel == 1) {
                            if ("Objects".equals(se.getName().getLocalPart())) {
                                processingObjects = true;
                            } else if ("ReposMap".equals(se.getName().getLocalPart())) {
                                processingRepos = true;
                            }
                        } else if (currentLevel > 1) {
                            if (processingObjects) {
                                boolean isTopLevel = currentLevel == 2;
                                ImportItemInterface importItem = this.parsePublicObject(se, isTopLevel);
                                if (importItem != null) {
                                    if (!isTopLevel && !itemStack.isEmpty()) {
                                        ImportItemInterface parentItem = (ImportItemInterface)itemStack.get(itemStack.size() - 1);
                                        this.setParentItem(parentItem, importItem);
                                    }
                                    itemStack.push(importItem);
                                }
                            } else if (processingRepos) {
                                this.parseRepository(se);
                            }
                        }
                        ++currentLevel;
                        break;
                    }
                    case 2: {
                        EndElement ee;
                        if (--currentLevel == 1) {
                            ee = e.asEndElement();
                            if (!"Objects".equals(ee.getName().getLocalPart())) continue block13;
                            processingObjects = false;
                            continueParsing = false;
                            break;
                        }
                        if (!processingObjects || currentLevel < 2 || "Nested".equalsIgnoreCase((ee = e.asEndElement()).getName().getLocalPart()) || itemStack.isEmpty()) break;
                        itemStack.pop();
                    }
                }
            }
        }
        catch (Exception e) {
            throw new MetadataPromotionException(e);
        }
        finally {
            try {
                if (fileStream != null) {
                    ((InputStream)fileStream).close();
                }
                if (eventReader != null) {
                    eventReader.close();
                }
            }
            catch (Exception e) {
                this._operation.getLogger().debug("Unable to close input/output streams.");
            }
        }
    }

    private void parseRepository(StartElement se) {
        Attribute idAttr = se.getAttributeByName(ParsingConstants.ATTRIBUTE_QNAME_ID);
        if (idAttr != null) {
            this._repositoryMap.put(idAttr.getValue(), null);
        }
    }

    private ImportItemInterface parsePublicObject(StartElement se, boolean isTopLevel) throws ServiceException, RemoteException {
        ImportItemInterface item;
        Attribute idAttr = se.getAttributeByName(ParsingConstants.ATTRIBUTE_QNAME_ID);
        if (idAttr == null) {
            return null;
        }
        Attribute nameAttr = se.getAttributeByName(ParsingConstants.ATTRIBUTE_QNAME_NAME);
        Attribute typeAttr = se.getAttributeByName(ParsingConstants.ATTRIBUTE_QNAME_PUBLICTYPE);
        if (nameAttr == null || typeAttr == null) {
            return null;
        }
        String publicType = typeAttr.getValue();
        String id = idAttr.getValue();
        String name = nameAttr.getValue();
        ImportItemInterface importItemInterface = item = isTopLevel ? this.createImportItem(name, publicType, id) : this.createNestedItem(name, publicType, id);
        if (item instanceof DefaultImportItem) {
            Attribute displayNameAttr;
            Attribute descAttr;
            Attribute versionAttr;
            DefaultImportItem importItem = (DefaultImportItem)item;
            this.addPromotionItem(importItem);
            if (isTopLevel) {
                Attribute userFolderAttr;
                String[] sourcePath = null;
                Attribute pathAttr = se.getAttributeByName(ParsingConstants.ATTRIBUTE_QNAME_PATH);
                if (pathAttr != null) {
                    String absPath = pathAttr.getValue();
                    List pathList = SASFoldersUtil.parseFolderPath((String)absPath);
                    if (!pathList.isEmpty()) {
                        pathList.remove(pathList.size() - 1);
                    }
                    if (((sourcePath = pathList.toArray(new String[pathList.size()])) == null || sourcePath.length == 0 && !"Folder".equalsIgnoreCase(publicType)) && SASFoldersUtil.isContainedByFolder((String)publicType, (ServerInterface)this._operation.getServer())) {
                        importItem.setOrphaned(true);
                        sourcePath = new String[]{"##ORPHANED_SOURCE_FOLDER##"};
                    }
                }
                importItem.setSourcePath(sourcePath);
                if ("Folder".equalsIgnoreCase(publicType) && (userFolderAttr = se.getAttributeByName(ParsingConstants.ATTRIBUTE_QNAME_USERFOLDER)) != null) {
                    String userFolderType = userFolderAttr.getValue();
                    Attribute userFolderIdentityAttr = se.getAttributeByName(ParsingConstants.ATTRIBUTE_QNAME_USERFOLDER_IDENTITY);
                    if (userFolderIdentityAttr != null) {
                        String identity = userFolderIdentityAttr.getValue();
                        if (userFolderType != null && identity != null) {
                            this._userFolderManager.cacheUserFolderInfo(id, userFolderType, identity);
                        }
                    }
                }
            }
            if ((versionAttr = se.getAttributeByName(ParsingConstants.ATTRIBUTE_QNAME_USAGEVERSION)) != null) {
                double ver = Double.parseDouble(versionAttr.getValue());
                importItem.setUsageVersion(UsageVersion.decode((double)ver));
            }
            if ((descAttr = se.getAttributeByName(ParsingConstants.ATTRIBUTE_QNAME_DESC)) != null) {
                importItem.setDescription(descAttr.getValue());
            }
            if ((displayNameAttr = se.getAttributeByName(ParsingConstants.ATTRIBUTE_QNAME_DISPLAYNAME)) != null) {
                importItem.setDisplayName(displayNameAttr.getValue());
            }
        } else if (isTopLevel) {
            this.addUnsupportedObject(id);
        }
        return item;
    }

    private void readConnections() throws MetadataPromotionException {
        File inputFile = null;
        InputStream fileStream = null;
        XMLStreamReader streamReader = null;
        try {
            inputFile = this._contentHandler.getFileFromPackage("ConnectionMapping.xml");
            fileStream = new FileInputStream(inputFile);
            streamReader = this._inputFactory.createXMLStreamReader(fileStream, "UTF-8");
            ConnectionPoint pt = null;
            boolean processingConnections = false;
            while (streamReader.hasNext()) {
                int type = streamReader.next();
                switch (type) {
                    case 1: {
                        if (!processingConnections) {
                            if (!"Connections".equalsIgnoreCase(streamReader.getLocalName())) break;
                            processingConnections = true;
                            break;
                        }
                        String id = streamReader.getAttributeValue(null, "Id");
                        if (id != null) {
                            pt = this.parseConnectionPoint(streamReader, id);
                            break;
                        }
                        if (pt == null) break;
                        this.addConnectionPointAttributes(streamReader, pt);
                    }
                }
            }
        }
        catch (Exception e) {
            throw new MetadataPromotionException(e);
        }
        finally {
            try {
                if (fileStream != null) {
                    fileStream.close();
                }
                if (streamReader != null) {
                    streamReader.close();
                }
                if (inputFile != null) {
                    inputFile.delete();
                }
            }
            catch (Exception e) {
                this._operation.getLogger().debug("Unable to close input/output streams.");
            }
        }
    }

    private ConnectionPoint parseConnectionPoint(XMLStreamReader streamReader, String id) {
        String autoMap;
        String action;
        String direct;
        String active;
        String path;
        String desc;
        String metadataType = streamReader.getLocalName();
        String name = streamReader.getAttributeValue(null, "Name");
        if (metadataType == null || name == null) {
            return null;
        }
        ConnectionPoint pt = (ConnectionPoint)this._connectionManager.createConnection(metadataType, id, name);
        String publicType = streamReader.getAttributeValue(null, "PublicType");
        if (publicType != null) {
            pt.setPublicType(publicType);
        }
        if ((desc = streamReader.getAttributeValue(null, "Desc")) != null) {
            pt.setDescription(desc);
        }
        if ((path = streamReader.getAttributeValue(null, "Path")) != null) {
            pt.setSourcePath(path);
        }
        if ((active = streamReader.getAttributeValue(null, "Active")) != null) {
            if (ParsingConstants.VALUE_FALSE.equalsIgnoreCase(active)) {
                pt.setActive(false);
            } else {
                pt.setActive(true);
            }
        }
        if ((direct = streamReader.getAttributeValue(null, "Direct")) != null) {
            if (ParsingConstants.VALUE_FALSE.equalsIgnoreCase(direct)) {
                pt.setDirectConnection(false);
            } else {
                pt.setDirectConnection(true);
            }
        }
        if ((action = streamReader.getAttributeValue(null, "ConnectionAction")) != null && action.length() > 0) {
            switch (action.toLowerCase().charAt(0)) {
                case 'f': {
                    pt.setConnectionAction(2);
                    break;
                }
                case 'w': {
                    pt.setConnectionAction(1);
                    break;
                }
                default: {
                    pt.setConnectionAction(0);
                }
            }
        }
        if ((autoMap = streamReader.getAttributeValue(null, "AutoMap")) != null) {
            if (ParsingConstants.VALUE_TRUE.equalsIgnoreCase(autoMap)) {
                pt.setAutoMapped(true);
            } else {
                String conflict = streamReader.getAttributeValue(null, "conflict");
                if (conflict != null && ParsingConstants.VALUE_TRUE.equalsIgnoreCase(conflict)) {
                    pt.setConflict(true);
                }
            }
        }
        return pt;
    }

    private void addConnectionPointAttributes(XMLStreamReader streamReader, ConnectionPoint pt) {
        String key;
        String elementName = streamReader.getLocalName();
        if ("Search".equalsIgnoreCase(elementName)) {
            pt.addSourceSearch(streamReader.getAttributeValue(null, "Value"));
        } else if ("Objects".equalsIgnoreCase(elementName)) {
            pt.addAssociatedObjects(this.getAssociatedObjectsFromIDList(streamReader.getAttributeValue(null, "Value")));
        } else if ("UserProperty".equalsIgnoreCase(elementName) && (key = streamReader.getAttributeValue(null, "Key")) != null) {
            pt.addUserDefinedProperty(key, streamReader.getAttributeValue(null, "Value"));
        }
    }

    @Override
    public Document getObjectDocument(PromotionItemInterface importItem) throws MetadataPromotionException {
        ArrayList<PromotionItemInterface> list = new ArrayList<PromotionItemInterface>(1);
        list.add(importItem);
        Map<String, Document> map = this.getObjectDocuments(list);
        return map.get(importItem.getID());
    }

    @Override
    public Map<String, Document> getObjectDocuments(List<PromotionItemInterface> items) throws MetadataPromotionException {
        DocumentTransportMetadataParser transportParser = new DocumentTransportMetadataParser(this, this._documentFactory, items);
        this.parseTransportMetadata(null, transportParser);
        Map<String, Document> map = transportParser.getDocumentMap();
        return map;
    }

    @Override
    public Map<String, ?> getAssociationsForObject(PromotionItemInterface promotionItem, String template) throws MetadataPromotionException {
        ArrayList<PromotionItemInterface> list = new ArrayList<PromotionItemInterface>(1);
        list.add(promotionItem);
        return this.getAssociationsForObjects(list, template);
    }

    @Override
    public Map<String, ?> getAssociationsForObjects(List<PromotionItemInterface> promotionItems, String template) throws MetadataPromotionException {
        MapTransportMetadataParser transportParser = new MapTransportMetadataParser(promotionItems);
        this.parseTransportMetadata(template, transportParser);
        return transportParser.getObjectMap();
    }

    private void parseTransportMetadata(String template, AbstractTransportMetadataParser transportParser) throws MetadataPromotionException {
        BufferedInputStream inputStream = null;
        try {
            Document doc;
            inputStream = new BufferedInputStream(new FileInputStream(this.getTransportMetadataFile()));
            if (template != null && template.length() > 0 && (doc = this.parseTemplate(template)) != null) {
                transportParser.applyTemplate(doc);
            }
            if (this._saxParser == null) {
                this._saxParser = XMLUtil.createSAXParser();
            }
            this._saxParser.parse((InputStream)inputStream, (DefaultHandler)transportParser);
        }
        catch (FinishedParsingException e) {
        }
        catch (Exception e) {
            throw new MetadataPromotionException(e);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException e) {
                this._operation.getLogger().debug("Unable to close input/output streams.");
            }
        }
    }

    private Document parseTemplate(String template) throws ParserConfigurationException, SAXException, IOException {
        Document doc;
        if (this._templateCache == null) {
            this._templateCache = new HashMap<String, Document>(5);
        }
        if ((doc = this._templateCache.get(template)) == null) {
            doc = XMLUtil.parseXML(template);
            this._templateCache.put(template, doc);
        }
        return doc;
    }

    @Override
    public boolean isPackageValid() throws MetadataPromotionException {
        try {
            if (!this._contentHandler.containsFile("TransportMetadata.xml")) {
                return false;
            }
            if (!this._contentHandler.containsFile("DeployMap.xml")) {
                return false;
            }
            if (!this._contentHandler.containsFile("ConnectionMapping.xml")) {
                return false;
            }
        }
        catch (Exception e) {
            throw new MetadataPromotionException(e);
        }
        return true;
    }

    @Override
    public void importMetadata() throws MetadataPromotionException {
        if (this._operation.getLogger().isDebugEnabled()) {
            this._operation.getLogger().debug("Submitting the import metadata request");
        }
        int flags = 0;
        if (!((ImportOperationInterface)this._operation).isSecurityMetadataIncluded()) {
            flags |= 0x80000;
        }
        MdOMRConnection connection = null;
        IMetadataTransport transport = null;
        try {
            connection = this._operation.getMetadataFactory().getConnection();
            transport = connection.makeIMetadataTransportConnection(connection.getCMRHandle());
            String inTransport = null;
            inTransport = this.containsDisabledObjects() ? this.updateTransportMetadata() : this.loadTransportXML();
            String inDeployMap = this.updateDeployMap();
            if (this._operation.getLogger().isDebugEnabled() && this._operation.getMetadataFactory().getLoggingEnabled()) {
                int index = inTransport.indexOf("<TransportXml");
                if (index > 0) {
                    inTransport = inTransport.substring(index);
                }
                if ((index = inDeployMap.indexOf("<DeployMap")) > 0) {
                    inDeployMap = inDeployMap.substring(index);
                }
                StringBuilder sb = new StringBuilder(100 + inTransport.length() + inDeployMap.length());
                sb.append("<ImportMetadata>");
                sb.append("<Metadata>");
                sb.append(inTransport);
                sb.append(inDeployMap);
                sb.append("</Metadata>");
                sb.append("<NS>SAS</NS>");
                sb.append("<Flags>").append(flags).append("</Flags>");
                sb.append("<Options/>");
                sb.append("</ImportMetadata>");
                PersistenceUtil.logRequestInput(this._operation, sb.toString());
            }
            StringHolder outMetadata = new StringHolder();
            transport.ImportMetadata(inTransport, inDeployMap, outMetadata, "SAS", flags, "");
            inTransport = null;
            inDeployMap = null;
            if (this._operation.getLogger().isDebugEnabled() && this._operation.getMetadataFactory().getLoggingEnabled()) {
                PersistenceUtil.logRequestOutput(this._operation, outMetadata.value);
            }
            this.processOutputRequest(outMetadata.value);
        }
        catch (Exception e) {
            throw new MetadataPromotionException(e);
        }
        finally {
            if (transport != null && connection != null) {
                try {
                    connection.closeIMetadataTransportConnection(transport);
                }
                catch (Exception exception) {}
            }
        }
    }

    private void setDefaultTargetRepos(String reposID) {
        this._defaultTargetRepos = reposID;
    }

    @Override
    public void initializeRepositoryMappings() throws MetadataPromotionException {
        if (this._operation.getLogger().isDebugEnabled()) {
            this._operation.getLogger().debug("Initializing repository mappings");
        }
        this._objectReposMap = null;
        if (this._operation.getPromotionType() == 1) {
            try {
                if (((ImportOperationInterface)this._operation).importIntoRoot()) {
                    if (this._operation.isProjectRepository()) {
                        this._operation.getLogger().debug("Mapping all objects to the target project repository");
                        this.setDefaultTargetRepos(this._operation.getRepositoryID());
                        return;
                    }
                    List<ImportElementInterface> importedTopLevelFolders = this.getImportedTopLevelFolders();
                    if (importedTopLevelFolders.size() == 1) {
                        ImportElementInterface item = importedTopLevelFolders.get(0);
                        if (item.isNewObject()) {
                            this._operation.getLogger().debug("Mapping all objects to the foundation repository");
                            this.setDefaultTargetRepos(this._operation.getRepositoryID());
                        } else {
                            ImportItemInterface importItem;
                            String id = item.getTargetID();
                            if (id == null && (importItem = item.getImportItem()) != null && "Folder".equalsIgnoreCase(importItem.getTypeInterface().getPublicType())) {
                                id = (String)this._operation.getObjectFromCache("ResetTargetID:" + importItem.getID());
                            }
                            if (id == null) {
                                throw new IllegalStateException("Missing target id for folder");
                            }
                            this.setDefaultTargetRepos("A0000001." + id.substring(0, 8));
                            this._operation.getLogger().debug("Mapping all objects to " + this._defaultTargetRepos);
                        }
                    } else if (importedTopLevelFolders.size() > 1) {
                        for (ImportElementInterface element : importedTopLevelFolders) {
                            PathUrl path;
                            ImportItemInterface importItem;
                            if (element.isNewObject()) {
                                PathUrl path2;
                                this.setDefaultTargetRepos(this._operation.getRepositoryID());
                                if (!this._operation.getLogger().isDebugEnabled() || (path2 = element.getPublicObject().getPathUrl()) == null) continue;
                                this._operation.getLogger().debug("Mapping \"" + path2.getDisplayPath() + "\" to the foundation repository");
                                continue;
                            }
                            String targetID = element.getTargetID();
                            if (targetID == null && (importItem = element.getImportItem()) != null && "Folder".equalsIgnoreCase(importItem.getTypeInterface().getPublicType())) {
                                targetID = (String)this._operation.getObjectFromCache("ResetTargetID:" + importItem.getID());
                            }
                            if (targetID == null) {
                                throw new IllegalStateException("Missing target id for folder");
                            }
                            String targetReposID = "A0000001." + targetID.substring(0, 8);
                            String reposName = this._operation.getServer().getRepositoryName(targetReposID);
                            RepositoryInterface repos = this._operation.getServer().getRepository(reposName);
                            if (repos instanceof OMIRepositoryInterface && "CUSTOM".equals(((OMIRepositoryInterface)repos).getRepositoryType())) {
                                this.setRepositoryMappingForObject(element.getPublicObject(), targetReposID);
                                if (!this._operation.getLogger().isDebugEnabled() || (path = element.getPublicObject().getPathUrl()) == null) continue;
                                this._operation.getLogger().debug("Mapping \"" + path.getDisplayPath() + "\" to the " + reposName + " repository");
                                continue;
                            }
                            this.setDefaultTargetRepos(this._operation.getRepositoryID());
                            if (!this._operation.getLogger().isDebugEnabled() || (path = element.getPublicObject().getPathUrl()) == null) continue;
                            this._operation.getLogger().debug("Mapping \"" + path.getDisplayPath() + "\" to the foundation repository");
                        }
                    } else {
                        this._operation.getLogger().debug("Mapping all objects to the foundation repository");
                        this.setDefaultTargetRepos(this._operation.getRepositoryID());
                    }
                } else {
                    this._operation.getLogger().debug("Mapping all objects to the target repository");
                    this.setDefaultTargetRepos(this._operation.getRepositoryID());
                }
                this.setupRepositoryMappingsForFolderMoves();
            }
            catch (ServiceException e) {
                String error = RB.getStringResource("ImportHandler.LoadingRepositoriesError.txt");
                this._operation.getLogger().debug((Object)error, e);
                throw new MetadataPromotionException(error);
            }
            catch (RemoteException e) {
                String error = RB.getStringResource("ImportHandler.LoadingRepositoriesError.txt");
                this._operation.getLogger().debug((Object)error, e);
                throw new MetadataPromotionException(error);
            }
        } else {
            this._operation.getLogger().debug("Mapping all objects to the target repository");
            this.setDefaultTargetRepos(this._operation.getRepositoryID());
        }
    }

    private void setupRepositoryMappingsForFolderMoves() throws ServiceException, RemoteException {
        List<String> ids = this._moveManager.getDirectlyMovedObjects();
        if (ids != null && !ids.isEmpty()) {
            this._operation.getLogger().debug("Analyzing repository mappings for moved objects");
            ImportFolderModelInterface model = ((ImportOperationInterface)this._operation).getImportModel();
            for (String id : ids) {
                PathUrl path;
                String reposID;
                MetadataInterface mi;
                PathUrl parentPath;
                PublicObjectInterface poi;
                ImportElementInterface importElement = model.getImportElement(id);
                if (importElement == null || (poi = importElement.getPublicObject()) == null || !PromotionUtil.isFolder(poi) || (parentPath = this._moveManager.getNewParentFolder(id)) == null || (mi = this._operation.getServer().getObjectByPath(parentPath)) == null || (reposID = ((OMIRepositoryInterface)mi.getRepository()).getDefaultRepositoryId()).equalsIgnoreCase(this._defaultTargetRepos)) continue;
                this.setRepositoryMappingForObject(poi, reposID);
                if (!this._operation.getLogger().isDebugEnabled() || (path = poi.getPathUrl()) == null) continue;
                this._operation.getLogger().debug("Mapping \"" + path.getDisplayPath() + "\" to the " + ((OMIRepositoryInterface)mi.getRepository()).getDefaultRepositoryName() + " repository");
            }
        }
    }

    private void setRepositoryMappingForObject(PublicObjectInterface publicObject, String reposID) throws ServiceException, RemoteException {
        if (this._objectReposMap == null) {
            this._objectReposMap = new HashMap<String, String>();
        }
        this._objectReposMap.put(publicObject.getIdentifier(), reposID);
        if (publicObject instanceof FolderNodeInterface) {
            List children = ((FolderNodeInterface)publicObject).getChildren();
            for (PublicObjectNodeInterface node : children) {
                this.setRepositoryMappingForObject((PublicObjectInterface)node, reposID);
            }
        }
    }

    private String loadTransportXML() throws FileNotFoundException, TransportException, IOException {
        String inTransport;
        try (BufferedInputStream stream = null;){
            stream = new BufferedInputStream(new FileInputStream(this.getTransportMetadataFile()));
            inTransport = this._contentHandler.readStream(stream, "UTF-8");
        }
        return inTransport;
    }

    private String updateTransportMetadata() throws MetadataPromotionException {
        if (this._operation.getLogger().isDebugEnabled()) {
            this._operation.getLogger().debug("Updating transport metadata contents");
        }
        InputStream fileStream = null;
        XMLEventReader eventReader = null;
        try {
            StringWriter sw = new StringWriter();
            XMLEventWriter writer = this._outputFactory.createXMLEventWriter(sw);
            fileStream = new FileInputStream(this.getTransportMetadataFile());
            eventReader = this._inputFactory.createXMLEventReader(fileStream, "UTF-8");
            int currentLevel = 0;
            boolean skipCurrentObject = false;
            while (eventReader.hasNext()) {
                XMLEvent e = eventReader.nextEvent();
                switch (e.getEventType()) {
                    case 7: {
                        writer.add(this._eventFactory.createStartDocument());
                        break;
                    }
                    case 1: {
                        StartElement se = e.asStartElement();
                        if (currentLevel == 1) {
                            skipCurrentObject = false;
                            Attribute idAttr = se.getAttributeByName(ParsingConstants.ATTRIBUTE_QNAME_ID);
                            if (idAttr != null && this.isObjectDisabled(idAttr.getValue())) {
                                skipCurrentObject = true;
                            }
                        }
                        if (!skipCurrentObject) {
                            writer.add(this._eventFactory.createStartElement(se.getName(), se.getAttributes(), se.getNamespaces()));
                        }
                        ++currentLevel;
                        break;
                    }
                    case 2: {
                        --currentLevel;
                        if (skipCurrentObject) break;
                        EndElement ee = e.asEndElement();
                        writer.add(this._eventFactory.createEndElement(ee.getName(), ee.getNamespaces()));
                        break;
                    }
                    case 8: {
                        writer.add(this._eventFactory.createEndDocument());
                    }
                }
            }
            writer.flush();
            writer.close();
            String string = sw.toString();
            return string;
        }
        catch (Exception e) {
            throw new MetadataPromotionException(e);
        }
        finally {
            try {
                if (fileStream != null) {
                    fileStream.close();
                }
                if (eventReader != null) {
                    eventReader.close();
                }
            }
            catch (Exception e) {
                this._operation.getLogger().debug("Unable to close input/output streams.");
            }
        }
    }

    private String updateDeployMap() throws MetadataPromotionException {
        if (this._operation.getLogger().isDebugEnabled()) {
            this._operation.getLogger().debug("Updating deploy map contents");
        }
        InputStream fileStream = null;
        XMLEventReader eventReader = null;
        try {
            StringWriter sw = new StringWriter();
            XMLEventWriter writer = this._outputFactory.createXMLEventWriter(sw);
            fileStream = new FileInputStream(this.getDeployMapFile());
            eventReader = this._inputFactory.createXMLEventReader(fileStream, "UTF-8");
            int currentLevel = 0;
            boolean processingObject = false;
            boolean processingConnection = false;
            boolean processingRepository = false;
            boolean processingSubstitution = false;
            while (eventReader.hasNext()) {
                XMLEvent e = eventReader.nextEvent();
                switch (e.getEventType()) {
                    case 7: {
                        writer.add(this._eventFactory.createStartDocument());
                        break;
                    }
                    case 1: {
                        StartElement se = e.asStartElement();
                        if (currentLevel == 0) {
                            writer.add(this._eventFactory.createStartElement(se.getName(), se.getAttributes(), se.getNamespaces()));
                            this.updateRepositoryMapping(writer);
                        } else if (currentLevel == 1) {
                            String tagName = se.getName().getLocalPart();
                            if ("Objects".equals(tagName)) {
                                processingObject = true;
                            } else if ("Connections".equals(tagName)) {
                                processingConnection = true;
                            } else {
                                if ("ReposMap".equals(tagName)) {
                                    ++currentLevel;
                                    processingRepository = true;
                                    break;
                                }
                                if ("Substitutions".equals(tagName)) {
                                    processingSubstitution = true;
                                }
                            }
                            writer.add(this._eventFactory.createStartElement(se.getName(), se.getAttributes(), se.getNamespaces()));
                        } else if (currentLevel > 1) {
                            StartElement updatedElement = null;
                            if (processingObject) {
                                boolean isTopLevel = currentLevel == 2;
                                updatedElement = this.updatePublicObject(se, isTopLevel);
                            } else if (processingConnection) {
                                updatedElement = this.updateConnectionPoint(se);
                            } else {
                                if (processingRepository) {
                                    ++currentLevel;
                                    break;
                                }
                                if (processingSubstitution) {
                                    ++currentLevel;
                                    break;
                                }
                            }
                            if (updatedElement != null) {
                                writer.add(updatedElement);
                            } else {
                                writer.add(se);
                            }
                        } else {
                            writer.add(this._eventFactory.createStartElement(se.getName(), se.getAttributes(), se.getNamespaces()));
                        }
                        ++currentLevel;
                        break;
                    }
                    case 2: {
                        EndElement ee = e.asEndElement();
                        if (--currentLevel == 1) {
                            String tagName = ee.getName().getLocalPart();
                            if ("Objects".equals(tagName)) {
                                processingObject = false;
                            } else if ("Connections".equals(tagName)) {
                                processingConnection = false;
                            } else if ("Substitutions".equals(tagName)) {
                                this.updateServerSubstitutions(writer);
                            } else if ("ReposMap".equals(tagName)) {
                                processingRepository = false;
                                break;
                            }
                        } else if (currentLevel > 1) {
                            if (processingObject) {
                                boolean isTopLevel = currentLevel == 2;
                                this.endPublicObjectUpdate(isTopLevel, writer);
                            } else if (processingRepository || processingSubstitution) break;
                        }
                        writer.add(this._eventFactory.createEndElement(ee.getName(), ee.getNamespaces()));
                        break;
                    }
                    case 8: {
                        writer.add(this._eventFactory.createEndDocument());
                    }
                }
            }
            writer.flush();
            writer.close();
            String string = sw.toString();
            return string;
        }
        catch (Exception e) {
            if (this._operation.getLogger().isDebugEnabled()) {
                this._operation.getLogger().debug((Object)"Parsing error", e);
            }
            throw new MetadataPromotionException(e);
        }
        finally {
            try {
                if (fileStream != null) {
                    fileStream.close();
                }
                if (eventReader != null) {
                    eventReader.close();
                }
            }
            catch (Exception e) {
                this._operation.getLogger().debug("Unable to close input/output streams.");
            }
        }
    }

    private void updateRepositoryMapping(XMLEventWriter writer) throws XMLStreamException {
        QName repositoriesTagName = QName.valueOf("Repositories");
        writer.add(this._eventFactory.createStartElement(repositoriesTagName, null, null));
        this.addTargetRepositoryMapping(writer, this._defaultTargetRepos == null ? this._operation.getRepositoryID() : this._defaultTargetRepos);
        if (this._objectReposMap != null && !this._objectReposMap.isEmpty()) {
            LinkedHashSet<String> targetReposSet = new LinkedHashSet<String>(this._objectReposMap.values());
            for (String reposID : targetReposSet) {
                this.addTargetRepositoryMapping(writer, reposID);
            }
        }
        writer.add(this._eventFactory.createEndElement(repositoriesTagName, null));
    }

    private void addTargetRepositoryMapping(XMLEventWriter writer, String reposID) throws XMLStreamException {
        ArrayList<Attribute> attrs = new ArrayList<Attribute>(1);
        attrs.add(this._eventFactory.createAttribute("Id", reposID));
        QName targetReposTag = QName.valueOf("Target");
        writer.add(this._eventFactory.createStartElement(targetReposTag, attrs.iterator(), null));
        writer.add(this._eventFactory.createEndElement(targetReposTag, null));
    }

    private StartElement updatePublicObject(StartElement se, boolean isTopLevel) throws ServiceException, RemoteException {
        Attribute idAttr = se.getAttributeByName(ParsingConstants.ATTRIBUTE_QNAME_ID);
        if (idAttr == null) {
            return se;
        }
        HashMap<QName, Attribute> attrs = new HashMap<QName, Attribute>(8);
        Iterator<Attribute> iter = se.getAttributes();
        while (iter.hasNext()) {
            Attribute attr = iter.next();
            if (ParsingConstants.ATTRIBUTE_QNAME_PATH.equals(attr.getName()) || ParsingConstants.ATTRIBUTE_QNAME_DESC.equals(attr.getName())) continue;
            attrs.put(attr.getName(), attr);
        }
        ImportItemInterface item = (ImportItemInterface)this.getPromotionItem(idAttr.getValue());
        if (item != null) {
            if (isTopLevel) {
                this._currentObjectId = idAttr.getValue();
            }
            if (item.getImportState() == 0) {
                this.setObjectAction(attrs, "No", null);
            } else {
                if (isTopLevel) {
                    MetadataInterface mi;
                    PathUrl newPath;
                    if (this._moveManager.isParentFolderModified(item.getID()) && (newPath = this._moveManager.getNewParentFolder(item.getID())) != null && (mi = this._operation.getServer().getObjectByPath(newPath)) instanceof FolderInterface) {
                        if (this._operation.getLogger().isDebugEnabled()) {
                            this._operation.getLogger().debug("Setting new parent folder for \"" + item.toString() + "\" to \"" + mi.getName() + "\".");
                        }
                        attrs.put(ParsingConstants.ATTRIBUTE_QNAME_NEW_PARENTFOLDER, this._eventFactory.createAttribute(ParsingConstants.ATTRIBUTE_QNAME_NEW_PARENTFOLDER, mi.getIdentifier()));
                    }
                    if (this._objectReposMap != null && this._objectReposMap.containsKey(item.getID())) {
                        attrs.put(ParsingConstants.ATTRIBUTE_QNAME_NEW_REPOSITORY, this._eventFactory.createAttribute(ParsingConstants.ATTRIBUTE_QNAME_NEW_REPOSITORY, this._objectReposMap.get(item.getID())));
                    }
                }
                if (item.getImportState() == 2 && item.getTargetID() != null) {
                    if (isTopLevel) {
                        if (this.isMergingImportItem(item)) {
                            this.setObjectAction(attrs, "Merge", item.getTargetID());
                        } else {
                            this.setObjectAction(attrs, "Update", item.getTargetID());
                        }
                    } else {
                        switch (item.getImportState()) {
                            case 0: {
                                this.setObjectAction(attrs, "No", null);
                                break;
                            }
                            case 1: {
                                break;
                            }
                            case 2: {
                                this.setObjectAction(attrs, "Update", item.getTargetID());
                                break;
                            }
                            case 3: {
                                this.setObjectAction(attrs, "Delete", item.getTargetID());
                                break;
                            }
                        }
                    }
                } else if (!this.isObjectSupported(idAttr.getValue())) {
                    this.setObjectAction(attrs, "No", null);
                }
            }
        }
        return this._eventFactory.createStartElement(se.getName(), attrs.values().iterator(), null);
    }

    private void setObjectAction(Map<QName, Attribute> attrs, String action, String targetID) {
        attrs.put(ParsingConstants.ATTRIBUTE_QNAME_DEPLOYACTION, this._eventFactory.createAttribute(ParsingConstants.ATTRIBUTE_QNAME_DEPLOYACTION, action));
        if (targetID != null) {
            attrs.put(ParsingConstants.ATTRIBUTE_QNAME_DEPLOY_ID, this._eventFactory.createAttribute(ParsingConstants.ATTRIBUTE_QNAME_DEPLOY_ID, targetID));
        }
    }

    private void endPublicObjectUpdate(boolean isTopLevel, XMLEventWriter writer) throws XMLStreamException {
        if (isTopLevel && this._currentObjectId != null) {
            ImportItemInterface importItem = (ImportItemInterface)this.getPromotionItem(this._currentObjectId);
            if (importItem != null && importItem.containsNestedItems() && importItem.getImportState() == 2) {
                this.updateObjectMergeSettings(importItem, writer);
            }
            this._currentObjectId = null;
        }
    }

    private void updateObjectMergeSettings(ImportItemInterface importItem, XMLEventWriter writer) throws XMLStreamException {
        if (this.containsDeletedItems(importItem)) {
            ArrayList<Attribute> attrs = new ArrayList<Attribute>(1);
            attrs.add(this._eventFactory.createAttribute("Name", "DeleteInTarget"));
            QName tagName = QName.valueOf("Nested");
            writer.add(this._eventFactory.createStartElement(tagName, attrs.iterator(), null));
            this.processDeletedItems(importItem, writer);
            writer.add(this._eventFactory.createEndElement(tagName, null));
        }
    }

    private void processDeletedItems(ImportItemInterface importItem, XMLEventWriter writer) throws XMLStreamException {
        for (NestedImportItemInterface nestedItem : importItem.getNestedItems()) {
            if (nestedItem.getImportState() == 3) {
                this.addDeletedItem(nestedItem, writer);
            }
            if (!nestedItem.containsNestedItems()) continue;
            this.processDeletedItems(nestedItem, writer);
        }
    }

    private boolean containsDeletedItems(ImportItemInterface importItem) {
        if (importItem.containsNestedItems()) {
            for (NestedImportItemInterface nestedItem : importItem.getNestedItems()) {
                if (nestedItem.getImportState() == 3) {
                    return true;
                }
                if (!this.containsDeletedItems(nestedItem)) continue;
                return true;
            }
        }
        return false;
    }

    private void addDeletedItem(NestedImportItemInterface nestedItem, XMLEventWriter writer) throws XMLStreamException {
        String id = nestedItem.getID();
        String publicType = nestedItem.getTypeInterface().getPublicType();
        String targetID = nestedItem.getTargetID();
        if (id == null || publicType == null || targetID == null) {
            return;
        }
        ArrayList<Attribute> attrs = new ArrayList<Attribute>(2);
        attrs.add(this._eventFactory.createAttribute("Id", id));
        attrs.add(this._eventFactory.createAttribute("PublicType", publicType));
        attrs.add(this._eventFactory.createAttribute("Deploy_Id", targetID));
        String metadataType = nestedItem.getTypeInterface().getMetadataType();
        QName tagName = QName.valueOf(metadataType);
        writer.add(this._eventFactory.createStartElement(tagName, attrs.iterator(), null));
        writer.add(this._eventFactory.createEndElement(tagName, null));
    }

    private StartElement updateConnectionPoint(StartElement se) {
        String targetID;
        Attribute idAttr = se.getAttributeByName(ParsingConstants.ATTRIBUTE_QNAME_ID);
        if (idAttr == null) {
            return se;
        }
        HashMap<QName, Attribute> attrs = new HashMap<QName, Attribute>(8);
        Iterator<Attribute> iter = se.getAttributes();
        while (iter.hasNext()) {
            Attribute attr = iter.next();
            if (ParsingConstants.ATTRIBUTE_QNAME_SEARCH.equals(attr.getName()) || ParsingConstants.ATTRIBUTE_QNAME_CONNACTION.equals(attr.getName()) || ParsingConstants.ATTRIBUTE_QNAME_DESC.equals(attr.getName())) continue;
            attrs.put(attr.getName(), attr);
        }
        ConnectionPointInterface pt = this._connectionManager.getConnection(idAttr.getValue());
        if (pt != null && (targetID = pt.getTargetID()) != null) {
            Attribute actionAttr;
            attrs.put(ParsingConstants.ATTRIBUTE_QNAME_DEPLOY_ID, this._eventFactory.createAttribute("Deploy_Id", targetID));
            if (pt.isActive() && (actionAttr = (Attribute)attrs.get(ParsingConstants.ATTRIBUTE_QNAME_DEPLOYACTION)) != null && "Ignore".equalsIgnoreCase(actionAttr.getValue())) {
                attrs.remove(ParsingConstants.ATTRIBUTE_QNAME_DEPLOYACTION);
            }
        }
        return this._eventFactory.createStartElement(se.getName(), attrs.values().iterator(), null);
    }

    private void updateServerSubstitutions(XMLEventWriter writer) throws XMLStreamException {
        if (this._substitutionsList == null || this._substitutionsList.isEmpty()) {
            return;
        }
        for (AbstractImportMetadataManager.ServerSubstitution sub : this._substitutionsList) {
            ImportItemInterface importItem = sub.getImportItem();
            if (importItem == null) continue;
            String metadataType = importItem.getTypeInterface().getMetadataType();
            ArrayList<Attribute> attrs = new ArrayList<Attribute>(2);
            attrs.add(this._eventFactory.createAttribute("Id", importItem.getID()));
            attrs.add(this._eventFactory.createAttribute(sub.getAttributeName(), sub.getAttributeValue()));
            QName name = QName.valueOf(metadataType);
            writer.add(this._eventFactory.createStartElement(name, attrs.iterator(), null));
            writer.add(this._eventFactory.createEndElement(name, null));
        }
    }
}

