/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.promotion.persistence;

import com.sas.metadata.logical.TransportableTypeInterface;
import com.sas.metadata.promotion.BIPTreeUtil;
import com.sas.metadata.promotion.ConnectionPointInterface;
import com.sas.metadata.promotion.ImportItemInterface;
import com.sas.metadata.promotion.ImportOperationInterface;
import com.sas.metadata.promotion.ImportSummaryInterface;
import com.sas.metadata.promotion.MetadataPromotionException;
import com.sas.metadata.promotion.NestedImportItem;
import com.sas.metadata.promotion.NestedImportItemInterface;
import com.sas.metadata.promotion.ObjectMoveManager;
import com.sas.metadata.promotion.PromotionItemInterface;
import com.sas.metadata.promotion.UserFolderManager;
import com.sas.metadata.promotion.XMLUtil;
import com.sas.metadata.promotion.model.ImportElementInterface;
import com.sas.metadata.promotion.model.ImportFolderModelInterface;
import com.sas.metadata.promotion.persistence.AbstractMetadataManager;
import com.sas.metadata.promotion.persistence.FinishedParsingException;
import com.sas.metadata.promotion.persistence.ImportMetadataManagementInterface;
import com.sas.metadata.promotion.persistence.ImportOutputParser;
import com.sas.services.ServiceException;
import com.sas.services.TransportException;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.publicobject.PublicObjectFactory;
import com.sas.services.information.publicobject.PublicObjectInterface;
import com.sas.services.information.sasfolders.ContainerNodeInterface;
import com.sas.services.information.sasfolders.FolderNodeInterface;
import com.sas.services.information.sasfolders.PublicObjectNodeInterface;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class AbstractImportMetadataManager
extends AbstractMetadataManager
implements ImportMetadataManagementInterface {
    protected static final String ORPHANED_FOLDER_NAME = "##ORPHANED_SOURCE_FOLDER##";
    protected static final String PRESERVED_FOLDER_PREFIX = "PreservedFolder_";
    protected static final String DELETE_IN_TARGET = "DeleteInTarget";
    protected static final int OMI_EXCLUDE_SECURITY = 524288;
    protected Map<String, String> _repositoryMap = new HashMap<String, String>(4);
    protected Set<String> _unsupportedObjectSet;
    protected List<ServerSubstitution> _substitutionsList;
    protected ObjectMoveManager _moveManager;
    protected UserFolderManager _userFolderManager;

    public AbstractImportMetadataManager(ImportOperationInterface operation) {
        super(operation);
        this._moveManager = ObjectMoveManager.getNewInstance(operation);
        this._userFolderManager = UserFolderManager.getNewInstance(operation);
    }

    protected List<ImportElementInterface> getImportedTopLevelFolders() throws ServiceException, RemoteException {
        ImportFolderModelInterface model = ((ImportOperationInterface)this._operation).getImportModel();
        ArrayList<ImportElementInterface> importedTopLevelFolders = new ArrayList<ImportElementInterface>();
        ContainerNodeInterface targetContainer = model.getTargetContainer();
        List children = targetContainer.getChildren();
        for (PublicObjectNodeInterface node : children) {
            ImportElementInterface importNode;
            if (!(node instanceof FolderNodeInterface) || (importNode = model.getImportElement((PublicObjectInterface)node)) == null || importNode.isStateSet(1) || !this.doesFolderContainImportedObjects(model, (FolderNodeInterface)node)) continue;
            importedTopLevelFolders.add(importNode);
        }
        return importedTopLevelFolders;
    }

    private boolean doesFolderContainImportedObjects(ImportFolderModelInterface model, FolderNodeInterface folder) throws ServiceException, RemoteException {
        List children = folder.getChildren();
        for (PublicObjectNodeInterface child : children) {
            ImportElementInterface importElement = model.getImportElement((PublicObjectInterface)child);
            if (importElement != null && (child instanceof FolderNodeInterface ? importElement.isNewObject() : !importElement.isStateSet(1))) {
                return true;
            }
            if (!(child instanceof FolderNodeInterface) || !this.doesFolderContainImportedObjects(model, (FolderNodeInterface)child)) continue;
            return true;
        }
        return false;
    }

    public List<PromotionItemInterface> getPromotionItems() {
        ArrayList<PromotionItemInterface> items = new ArrayList<PromotionItemInterface>();
        for (PromotionItemInterface item : this._promotionItems.values()) {
            if (item instanceof NestedImportItemInterface) continue;
            items.add(item);
        }
        return items;
    }

    @Override
    public int getPackageFileVersion() throws MetadataPromotionException {
        try {
            return this._contentHandler.getPackageVersion();
        }
        catch (TransportException e) {
            throw new MetadataPromotionException(e);
        }
    }

    @Override
    public void renameItem(ImportItemInterface importItem) throws MetadataPromotionException {
        if (this._substitutionsList == null) {
            this._substitutionsList = new ArrayList<ServerSubstitution>();
        }
        this._substitutionsList.add(new ServerSubstitution(importItem, "Name", importItem.getName()));
    }

    protected List<PromotionItemInterface> getAssociatedObjectsFromIDList(String objectIDList) {
        ArrayList<PromotionItemInterface> associatedObjects = new ArrayList<PromotionItemInterface>();
        if (objectIDList != null && objectIDList.length() > 0) {
            StringTokenizer st = new StringTokenizer(objectIDList, String.valueOf(';'));
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                PromotionItemInterface item = (PromotionItemInterface)this._promotionItems.get(token);
                if (item == null) continue;
                associatedObjects.add(item);
            }
        }
        return associatedObjects;
    }

    protected ImportItemInterface createImportItem(String name, String publicType, String id) {
        return ((ImportOperationInterface)this._operation).createImportItem(name, publicType, id);
    }

    protected ImportItemInterface createNestedItem(String name, String publicType, String id) {
        TransportableTypeInterface type = this._operation.getTransportableType(publicType);
        if (type != null) {
            NestedImportItem nestedItem = new NestedImportItem(name, id, type);
            nestedItem.setImportOperation((ImportOperationInterface)this._operation);
            return nestedItem;
        }
        return null;
    }

    protected void setParentItem(ImportItemInterface parent, ImportItemInterface child) {
        if (child instanceof NestedImportItemInterface) {
            ((NestedImportItemInterface)child).setParent(parent);
        }
    }

    protected void addUnsupportedObject(String id) {
        if (this._unsupportedObjectSet == null) {
            this._unsupportedObjectSet = new HashSet<String>();
        }
        this._unsupportedObjectSet.add(id);
    }

    protected void processOutputRequest(String output) throws MetadataPromotionException, ServiceException, RemoteException {
        Map<String, String> idMap = this.parseObjectIDs(output);
        ImportSummaryInterface summary = ((ImportOperationInterface)this._operation).getImportSummary();
        List importItems = this._operation.getAllPromotionItems();
        for (ImportItemInterface importItem : importItems) {
            String targetID = idMap.get(importItem.getID());
            if (targetID == null) continue;
            importItem.setTargetID(targetID);
            String publicType = importItem.getTypeInterface().getPublicType();
            String objectPath = null;
            if (importItem.getTargetPath() != null) {
                objectPath = BIPTreeUtil.pathToString(importItem.getTargetPath(), importItem.getName(), publicType);
            }
            this.createSummaryItem(summary, importItem, objectPath);
            ConnectionPointInterface pt = this._connectionManager.getMatchingConnectionPoint(importItem);
            if (pt == null) continue;
            if (pt.getTargetID() == null) {
                pt.setTargetID(targetID);
            }
            if (pt.getTargetPath() != null || objectPath == null) continue;
            pt.setTargetPath(objectPath);
        }
    }

    private void createSummaryItem(ImportSummaryInterface summary, ImportItemInterface importItem, String objectPath) throws ServiceException, RemoteException {
        PublicObjectInterface importedObject = PublicObjectFactory.createPublicObject((ServerInterface)this._operation.getServer(), (String)importItem.getTargetID(), (String)importItem.getName(), (String)importItem.getTypeInterface().getPublicType());
        if (objectPath != null) {
            PublicObjectFactory.setPublicObjectPath((PublicObjectInterface)importedObject, (String)objectPath);
        }
        summary.addImportedObject(importedObject, importItem.getImportState() == 1);
    }

    private Map<String, String> parseObjectIDs(String outputXML) throws MetadataPromotionException {
        ImportOutputParser parser = new ImportOutputParser();
        try {
            XMLUtil.parseXML(outputXML, (DefaultHandler)parser);
        }
        catch (FinishedParsingException finishedParsingException) {
        }
        catch (SAXException e) {
            throw new MetadataPromotionException(e);
        }
        return parser.getDeployedObjectsMap();
    }

    protected boolean containsDisabledObjects() {
        if (this._unsupportedObjectSet != null && !this._unsupportedObjectSet.isEmpty()) {
            return true;
        }
        List<PromotionItemInterface> items = this.getPromotionItems();
        for (PromotionItemInterface item : items) {
            if (((ImportItemInterface)item).getImportState() != 0) continue;
            return true;
        }
        return false;
    }

    protected boolean isObjectDisabled(String id) throws ServiceException, RemoteException {
        if (!this.isObjectSupported(id)) {
            return true;
        }
        ImportItemInterface item = (ImportItemInterface)this.getPromotionItem(id);
        return item != null && item.getImportState() == 0;
    }

    protected boolean isObjectSupported(String id) {
        return this._unsupportedObjectSet == null ? true : !this._unsupportedObjectSet.contains(id);
    }

    protected boolean isMergingImportItem(ImportItemInterface item) {
        if (item.containsNestedItems()) {
            List nestedItems = item.getNestedItems();
            for (NestedImportItemInterface nestedItem : nestedItems) {
                if (nestedItem.getImportState() != -1) {
                    return true;
                }
                if (!this.isMergingImportItem(nestedItem)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    protected class ServerSubstitution {
        ImportItemInterface _importItem = null;
        String _attributeName = null;
        String _attributeValue = null;

        public ServerSubstitution(ImportItemInterface importItem, String attributeName, String attributeValue) {
            this._importItem = importItem;
            this._attributeName = attributeName;
            this._attributeValue = attributeValue;
        }

        public ImportItemInterface getImportItem() {
            return this._importItem;
        }

        public String getAttributeName() {
            return this._attributeName;
        }

        public String getAttributeValue() {
            return this._attributeValue;
        }
    }
}

