/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.promotion.model;

import com.sas.metadata.promotion.ImportOperationInterface;
import com.sas.metadata.promotion.XMLUtil;
import com.sas.metadata.promotion.model.ImportElementInterface;
import com.sas.metadata.remote.MdException;
import com.sas.services.ServiceException;
import com.sas.services.information.Filter;
import com.sas.services.information.FilterInterface;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.PathUrl;
import com.sas.services.information.metadata.RootFolderInterface;
import com.sas.services.information.publicobject.PublicObjectContainerInterface;
import com.sas.services.information.publicobject.PublicObjectInterface;
import com.sas.services.information.sasfolders.ContainerNodeInterface;
import com.sas.services.information.sasfolders.FolderModelInterface;
import com.sas.services.information.sasfolders.PublicObjectNodeInterface;
import com.sas.services.information.sasfolders.VirtualFolderNodeInterface;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;

public class ImportFolderUtil {
    private static final String SYSTEMS_FOLDER_NAME = "System";

    public static boolean isVirtualFolder(ContainerNodeInterface container) {
        return container instanceof VirtualFolderNodeInterface;
    }

    public static boolean isDirectChildOf(String[] childPath, String[] parentPath) {
        if (childPath == null || parentPath == null) {
            return false;
        }
        int length = parentPath.length;
        if (length == 0) {
            return true;
        }
        if (length > childPath.length) {
            return false;
        }
        if (childPath.length != length + 1) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (parentPath[i].equals(childPath[i])) continue;
            return false;
        }
        return true;
    }

    public static PathUrl constructFolderPathUrl(ServerInterface server, List<String> sourcePath) throws ServiceException, RemoteException {
        StringBuilder sb = new StringBuilder();
        for (String folderName : sourcePath) {
            sb.append("/").append(folderName);
        }
        sb.append("(").append("Folder").append(")");
        return PathUrl.newPathUrlFromAbsolutePath((ServerInterface)server, (String)sb.toString());
    }

    public static List<String> parseFolderPath(PathUrl pathUrl) {
        if (pathUrl == null) {
            return Collections.emptyList();
        }
        ArrayList<String> pathList = new ArrayList<String>();
        if (pathUrl.getRootTree() != null) {
            String objectName = pathUrl.getName();
            if (objectName == null && "Folder".equals(pathUrl.getType())) {
                return Collections.emptyList();
            }
            if (objectName == null && pathUrl.getPath() == null && !"Folder".equalsIgnoreCase(pathUrl.getType())) {
                return Collections.emptyList();
            }
            pathList.add(pathUrl.getRootTree());
            String path = pathUrl.getPath();
            if (path != null) {
                StringTokenizer st = new StringTokenizer(path, String.valueOf("/"));
                while (st.hasMoreTokens()) {
                    String token = st.nextToken();
                    pathList.add(token);
                }
            }
        }
        return pathList;
    }

    public static PublicObjectInterface findNodeByOriginalPath(String[] path, PublicObjectContainerInterface rootNode) throws ServiceException, RemoteException {
        PublicObjectContainerInterface node = rootNode;
        for (String nodeName : path) {
            PublicObjectInterface childNode = ImportFolderUtil.findOriginalChildNode((PublicObjectInterface)node, nodeName);
            if (childNode == null) {
                return null;
            }
            node = childNode;
        }
        return node;
    }

    private static PublicObjectInterface findOriginalChildNode(PublicObjectInterface parentNode, String nodeName) throws ServiceException, RemoteException {
        if (nodeName != null && parentNode instanceof ContainerNodeInterface) {
            List children = ((ContainerNodeInterface)parentNode).getChildren();
            for (PublicObjectNodeInterface child : children) {
                ImportElementInterface importNode = (ImportElementInterface)child.getProcessorInterface("com.sas.metadata.promotion.model.ImportElementInterface");
                String originalName = importNode == null ? child.getName() : importNode.getOriginalName();
                if (!nodeName.equalsIgnoreCase(originalName)) continue;
                return child;
            }
        }
        return null;
    }

    public static FolderInterface searchForFolder(ImportOperationInterface operation, String[] folderPath) throws ServiceException, RemoteException {
        ServerInterface server;
        List results;
        FilterInterface filter = ImportFolderUtil.createFolderSearchFilter(operation, folderPath);
        if (filter != null && (results = (server = operation.getServer()).search(filter)) != null && !results.isEmpty()) {
            return (FolderInterface)results.get(0);
        }
        return null;
    }

    private static FilterInterface createFolderSearchFilter(ImportOperationInterface operation, String[] folderPath) throws ServiceException, RemoteException {
        if (folderPath == null || folderPath.length == 0) {
            return null;
        }
        ServerInterface server = operation.getServer();
        String topLevelFolderID = ImportFolderUtil.getTopLevelFolderID(server, folderPath[0]);
        String reposID = null;
        StringBuilder sb = new StringBuilder(150);
        if (folderPath.length == 1) {
            sb.append("<XMLSelect search=\"*[@Name='");
            sb.append(folderPath[0]);
            sb.append("' and @PublicType='Folder'][");
            RootFolderInterface rootFolder = server.getRootFolder();
            sb.append("SoftwareComponents/SoftwareComponent[@Id='" + rootFolder.getIdentifier() + "']]");
            sb.append("\"/>");
            reposID = ImportFolderUtil.getRepositoryToSearchWithin(operation, topLevelFolderID);
        } else if (topLevelFolderID != null) {
            reposID = ImportFolderUtil.getRepositoryToSearchWithin(operation, topLevelFolderID);
            int length = folderPath.length;
            String folderName = folderPath[length - 1];
            if (length > 1) {
                sb.append("<XMLSelect search=\"*[@Name='");
                sb.append(XMLUtil.cleanStringForXML(folderName));
                sb.append("' and (@PublicType='Folder' or @PublicType=:'Folder.')][");
                for (int i = length - 2; i > 0; --i) {
                    if (i != length - 2) {
                        sb.append("/");
                    }
                    String name = folderPath[i];
                    sb.append("ParentTree/Tree[@Name='");
                    sb.append(XMLUtil.cleanStringForXML(name));
                    sb.append("' and (@PublicType='Folder' or @PublicType=:'Folder.')]");
                    if (i != 0) continue;
                    sb.append("/");
                }
                sb.append("ParentTree/Tree[@Id='" + topLevelFolderID + "']]");
                sb.append("\"/>");
            }
        }
        return ImportFolderUtil.createFilter(operation, "Tree", reposID, sb.toString());
    }

    private static FilterInterface createFilter(ImportOperationInterface operation, String metadataType, String reposID, String xmlSelect) throws ServiceException, RemoteException {
        if (xmlSelect == null || xmlSelect.length() == 0) {
            return null;
        }
        Filter filter = new Filter();
        int flags = -2147483260;
        if (reposID != null) {
            filter.setOMRRepository(reposID);
        }
        if (operation.isProjectRepository()) {
            flags |= 0x2000;
        }
        filter.setOMRFlags(flags);
        filter.setType(metadataType);
        filter.setExplicitSearchString("omi", xmlSelect);
        filter.setOMRTemplate("<Templates><Tree Name=\"\" TreeType=\"\" PublicType=\"\" ></Tree></Templates>");
        return filter;
    }

    private static String getTopLevelFolderID(ServerInterface server, String topLevelFolderName) throws ServiceException, RemoteException {
        RootFolderInterface rootFolder = server.getRootFolder();
        FolderInterface topLevelFolder = rootFolder.getSubfolder(topLevelFolderName);
        return topLevelFolder == null ? null : topLevelFolder.getIdentifier();
    }

    protected static String getRepositoryToSearchWithin(ImportOperationInterface operation, String topLevelFolderID) throws ServiceException, RemoteException {
        try {
            return operation.isProjectRepository() ? operation.getRepositoryID() : (topLevelFolderID == null ? operation.getFoundationRepositoryID() : "A0000001." + topLevelFolderID.substring(0, 8));
        }
        catch (MdException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public static boolean isSystemFolder(ContainerNodeInterface folder) throws ServiceException, RemoteException {
        if (folder == null || folder.getFolderModel() == null) {
            throw new IllegalArgumentException("Invalid folder node");
        }
        if (SYSTEMS_FOLDER_NAME.equalsIgnoreCase(folder.getName())) {
            FolderModelInterface model = folder.getFolderModel();
            ServerInterface server = model.getServer();
            String reposId = ImportFolderUtil.getTargetReposId(folder);
            OMIRepositoryInterface repos = ImportFolderUtil.getRepositoryById(reposId, server);
            if (repos == null) {
                return false;
            }
            String type = repos.getRepositoryType();
            if ("FOUNDATION".equalsIgnoreCase(type)) {
                return folder.getContainer().equals(model.getRootFolder());
            }
            if ("CUSTOM".equalsIgnoreCase(type)) {
                List reposTopLevelFolders = server.getRootFolder().getSASFolders((RepositoryInterface)repos);
                if (reposTopLevelFolders != null && !reposTopLevelFolders.isEmpty()) {
                    for (FolderInterface topLevelFolder : reposTopLevelFolders) {
                        String id = topLevelFolder.getIdentifier();
                        if (!id.equalsIgnoreCase(folder.getContainer().getIdentifier())) continue;
                        return true;
                    }
                }
                return false;
            }
        }
        return false;
    }

    private static String getTargetReposId(ContainerNodeInterface folder) throws ServiceException, RemoteException {
        ImportElementInterface importElement = (ImportElementInterface)folder.getProcessorInterface("com.sas.metadata.promotion.model.ImportElementInterface");
        if (importElement != null) {
            if (!importElement.isNewObject() && importElement.getTargetID() != null) {
                String targetId = importElement.getTargetID();
                return "A0000001." + targetId.substring(0, 8);
            }
            PublicObjectContainerInterface parent = folder.getContainer();
            if (parent instanceof ContainerNodeInterface) {
                return ImportFolderUtil.getTargetReposId((ContainerNodeInterface)parent);
            }
        }
        return "A0000001." + folder.getIdentifier().substring(0, 8);
    }

    private static OMIRepositoryInterface getRepositoryById(String reposId, ServerInterface server) throws ServiceException, RemoteException {
        List reposList = server.getRepositories(true);
        for (RepositoryInterface repos : reposList) {
            if (!(repos instanceof OMIRepositoryInterface) || !reposId.equalsIgnoreCase(((OMIRepositoryInterface)repos).getDefaultRepositoryId())) continue;
            return (OMIRepositoryInterface)repos;
        }
        return null;
    }
}

