/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.promotion.model;

import com.sas.metadata.promotion.DefaultImportItem;
import com.sas.metadata.promotion.ImportItemInterface;
import com.sas.metadata.promotion.model.ImportElementInterface;
import com.sas.services.ServiceException;
import com.sas.services.information.publicobject.AbstractProcessor;
import com.sas.services.information.publicobject.BasePublicObject;
import com.sas.services.information.publicobject.PublicObjectInterface;
import com.sas.services.information.sasfolders.PublicObjectNodeInterface;
import com.sas.services.information.sasfolders.SASFoldersUtil;
import java.rmi.RemoteException;

public class ImportElement
extends AbstractProcessor
implements ImportElementInterface {
    protected int _objectState = -1;
    protected String _originalName = null;
    protected ImportItemInterface _importItem;

    public ImportElement(PublicObjectInterface publicObject) {
        super(publicObject);
    }

    @Override
    public ImportItemInterface getImportItem() throws ServiceException, RemoteException {
        return this._importItem;
    }

    public void setImportItem(ImportItemInterface importItem) throws ServiceException, RemoteException {
        this._importItem = importItem;
        if (this._importItem instanceof DefaultImportItem) {
            String[] targetPath = SASFoldersUtil.getObjectPath((PublicObjectInterface)((PublicObjectNodeInterface)this._publicObject));
            ((DefaultImportItem)this._importItem).setTargetPath(targetPath);
        }
    }

    @Override
    public String getTargetID() throws ServiceException, RemoteException {
        if (this._importItem != null) {
            return this._importItem.getTargetID();
        }
        if (!this.isNewObject()) {
            return this._publicObject.getIdentifier();
        }
        return null;
    }

    @Override
    public String getOriginalName() throws ServiceException, RemoteException {
        return this._originalName == null ? this._publicObject.getName() : this._originalName;
    }

    @Override
    public void setOriginalName(String orig) {
        this._originalName = orig;
    }

    @Override
    public String getDisplayName() throws ServiceException, RemoteException {
        return this._importItem == null ? this._publicObject.getName() : this._importItem.getDisplayName();
    }

    @Override
    public boolean isNewObject() throws ServiceException, RemoteException {
        return this.isStateSet(2);
    }

    @Override
    public boolean isRenamed() throws ServiceException, RemoteException {
        return this._originalName == null ? false : !this._originalName.equalsIgnoreCase(this._publicObject.getName());
    }

    @Override
    public void rename(String newName) throws ServiceException, RemoteException {
        String name = this._publicObject.getName();
        if (!name.equalsIgnoreCase(newName)) {
            this.setOriginalName(name);
            if (this._publicObject instanceof BasePublicObject) {
                ((BasePublicObject)this._publicObject).setName(newName);
            }
            this.setObjectState(2, true);
        }
    }

    @Override
    public int getObjectState() throws ServiceException, RemoteException {
        return this._objectState;
    }

    @Override
    public void setObjectState(int state) {
        this.setObjectState(state, false);
    }

    @Override
    public void setObjectState(int state, boolean override) {
        this._objectState = override || this._objectState == -1 ? state : (this._objectState |= state);
    }

    @Override
    public boolean isPermissionGranted() {
        return !this.isReadPermissionDenied() && !this.isWritePermissionDenied();
    }

    @Override
    public boolean isReadPermissionDenied() {
        return this.isStateSet(24);
    }

    @Override
    public boolean isWritePermissionDenied() {
        return this.isStateSet(96);
    }

    @Override
    public boolean isStateSet(int state) {
        return this._objectState != -1 && (this._objectState & state) > 0;
    }

    @Override
    public boolean isValid() throws ServiceException, RemoteException {
        boolean isValid = true;
        PublicObjectInterface po = this.getPublicObject();
        if (po == null) {
            return false;
        }
        if (this.isStateSet(128)) {
            return false;
        }
        if (SASFoldersUtil.isFolder((PublicObjectInterface)po)) {
            if (this.isReadPermissionDenied() || this.isNewObject() && this.isWritePermissionDenied()) {
                isValid = false;
            }
        } else {
            isValid = this.isPermissionGranted();
        }
        return isValid;
    }
}

