/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.promotion.model;

import com.sas.metadata.logical.RelatedObjectsInterface;
import com.sas.metadata.logical.SimpleLogicalObjectInterface;
import com.sas.metadata.logical.TypeInterface;
import com.sas.metadata.promotion.ExportItemInterface;
import com.sas.metadata.promotion.ExportOperationInterface;
import com.sas.metadata.promotion.Log;
import com.sas.metadata.promotion.model.ExportElement;
import com.sas.metadata.promotion.model.ExportElementInterface;
import com.sas.metadata.promotion.model.ExportFolderModelInterface;
import com.sas.metadata.promotion.model.ExportModelConfiguration;
import com.sas.metadata.promotion.model.RB;
import com.sas.services.ServiceException;
import com.sas.services.information.Filter;
import com.sas.services.information.MetadataServerInterface;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.browse.BrowseMetadataInterface;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.FolderUtil;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.PathUrl;
import com.sas.services.information.metadata.VirtualFolderInterface;
import com.sas.services.information.metadata.VirtualFolderManager;
import com.sas.services.information.publicobject.ProcessorInterface;
import com.sas.services.information.publicobject.PublicObjectContainerInterface;
import com.sas.services.information.publicobject.PublicObjectInterface;
import com.sas.services.information.publicobject.TypeDescriptorInterface;
import com.sas.services.information.sasfolders.ContainerNodeInterface;
import com.sas.services.information.sasfolders.FolderModelInterface;
import com.sas.services.information.sasfolders.FolderNodeInterface;
import com.sas.services.information.sasfolders.ModelConfiguration;
import com.sas.services.information.sasfolders.NodeFilterInterface;
import com.sas.services.information.sasfolders.PublicObjectNodeInterface;
import com.sas.services.information.sasfolders.RootFolderNode;
import com.sas.services.information.sasfolders.SASFoldersModel;
import com.sas.services.information.sasfolders.SASFoldersUtil;
import com.sas.services.information.sasfolders.VirtualFolderNode;
import com.sas.services.information.sasfolders.VirtualFolderNodeInterface;
import com.sas.services.information.search.PublicTypeFilter;
import com.sas.services.information.search.SearchFilter;
import com.sas.text.Message;
import com.sas.util.Strings;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;

public class ExportFolderModel
extends SASFoldersModel
implements ExportFolderModelInterface,
NodeFilterInterface {
    protected FolderNodeInterface _dependencyRootNode = null;
    protected ExportOperationInterface _operation;
    protected Map<String, PublicObjectNodeInterface> _nodeCache;
    protected Set<PublicObjectNodeInterface> _exportedNodes;
    protected Set<PublicObjectNodeInterface> _duplicateObjects = null;
    protected Set<PublicObjectNodeInterface> _externalDependencies = null;

    public ExportFolderModel(ExportOperationInterface operation) throws ServiceException, RemoteException {
        super(operation.getServer());
        this._operation = operation;
        this.setNodeFilters(new NodeFilterInterface[]{this});
        if (VirtualFolderManager.instanceCreated((ServerInterface)this._operation.getServer())) {
            VirtualFolderManager vm = VirtualFolderManager.getInstance((ServerInterface)this._operation.getServer());
            vm.reset();
        }
    }

    protected ModelConfiguration createModelConfiguration() {
        return ExportModelConfiguration.getDefault();
    }

    public PublicObjectNodeInterface getObject(String id, String publicType) throws ServiceException, RemoteException {
        FolderNodeInterface rootFolder;
        if (this._nodeCache != null && this._nodeCache.containsKey(id)) {
            return this._nodeCache.get(id);
        }
        if ("RootFolder".equalsIgnoreCase(publicType) && (rootFolder = this.getRootFolder()).getIdentifier().equalsIgnoreCase(id)) {
            return rootFolder;
        }
        TypeDescriptorInterface type = this._server.getTypeDescriptor(publicType);
        if (type == null) {
            throw new ServiceException("Invalid public type");
        }
        if (SASFoldersUtil.isContainedByFolder((String)publicType, (ServerInterface)this._server)) {
            return this.getObjectNode(id, type);
        }
        String key = SASFoldersUtil.getISEntityKey((String)id, (TypeDescriptorInterface)type);
        MetadataInterface meta = this._server.fetch(key, true);
        if (meta != null) {
            return this.getObjectNode(meta);
        }
        return null;
    }

    public PublicObjectNodeInterface getObject(PublicObjectInterface publicObject) throws ServiceException, RemoteException {
        if (publicObject == null || publicObject.getTypeDescriptor() == null) {
            return null;
        }
        if (publicObject instanceof VirtualFolderInterface) {
            PathUrl path = ((VirtualFolderInterface)publicObject).getPathUrl();
            VirtualFolderNodeInterface virtualFolder = (VirtualFolderNodeInterface)this.getObjectByPath(path);
            return virtualFolder;
        }
        if (publicObject instanceof VirtualFolderNodeInterface) {
            PathUrl path = ((VirtualFolderNodeInterface)publicObject).getPathUrl();
            VirtualFolderNodeInterface virtualFolder = (VirtualFolderNodeInterface)this.getObjectByPath(path);
            return virtualFolder;
        }
        return this.getObject(publicObject.getIdentifier(), publicObject.getTypeDescriptor().getTypeName());
    }

    @Override
    public List<PublicObjectNodeInterface> getExportedNodes() throws ServiceException, RemoteException {
        if (this._exportedNodes == null) {
            return Collections.emptyList();
        }
        return new ArrayList<PublicObjectNodeInterface>(this._exportedNodes);
    }

    @Override
    public List<PublicObjectNodeInterface> getExternalDependentObjects() throws ServiceException, RemoteException {
        if (this._externalDependencies == null) {
            return Collections.emptyList();
        }
        ArrayList<PublicObjectNodeInterface> dependencies = new ArrayList<PublicObjectNodeInterface>(this._externalDependencies);
        if (!dependencies.isEmpty()) {
            Collections.sort(dependencies, this._sortingComparator);
        }
        return dependencies;
    }

    @Override
    public List<PublicObjectNodeInterface> getDuplicateObjects() throws ServiceException, RemoteException {
        if (this._duplicateObjects == null) {
            return Collections.emptyList();
        }
        return new ArrayList<PublicObjectNodeInterface>(this._duplicateObjects);
    }

    @Override
    public ExportElementInterface getExportElement(PublicObjectInterface object) throws ServiceException, RemoteException {
        if (object == null) {
            return null;
        }
        if (this.isVirtualFolder(object) || object.getTypeDescriptor() == null || object.getIdentifier() == null) {
            return null;
        }
        ExportElementInterface exportElement = (ExportElementInterface)object.getProcessorInterface("com.sas.metadata.promotion.model.ExportElementInterface");
        if (exportElement == null) {
            exportElement = new ExportElement(object, this._operation);
            object.addProcessorInterface("com.sas.metadata.promotion.model.ExportElementInterface", (ProcessorInterface)exportElement);
        }
        return exportElement;
    }

    private boolean isVirtualFolder(PublicObjectInterface object) {
        return object instanceof VirtualFolderNodeInterface || object instanceof VirtualFolderInterface;
    }

    private void createExportElement(PublicObjectInterface object) throws ServiceException, RemoteException {
        this.getExportElement(object);
    }

    @Override
    public List<PublicObjectNodeInterface> getAllExportedObjects() throws ServiceException, RemoteException {
        LinkedHashSet<PublicObjectNodeInterface> exportItems = new LinkedHashSet<PublicObjectNodeInterface>();
        for (PublicObjectNodeInterface node : this._exportedNodes) {
            if (this.getExportElement((PublicObjectInterface)node) != null) {
                exportItems.add(node);
            }
            if (!(node instanceof ContainerNodeInterface)) continue;
            this.loadContainerItems((ContainerNodeInterface)node, exportItems);
        }
        List<PublicObjectNodeInterface> dependencies = this.getExternalDependentObjects();
        if (dependencies != null && !dependencies.isEmpty()) {
            for (PublicObjectNodeInterface node : dependencies) {
                if (this.getExportElement((PublicObjectInterface)node) != null) {
                    exportItems.add(node);
                }
                if (!(node instanceof ContainerNodeInterface)) continue;
                this.loadContainerItems((ContainerNodeInterface)node, exportItems);
            }
        }
        return new ArrayList<PublicObjectNodeInterface>(exportItems);
    }

    private void initialize() throws ServiceException, RemoteException {
        this._nodeCache = new HashMap<String, PublicObjectNodeInterface>();
        this._exportedNodes = new LinkedHashSet<PublicObjectNodeInterface>(5);
        this._externalDependencies = new LinkedHashSet<PublicObjectNodeInterface>();
        this._duplicateObjects = null;
        boolean filteringByType = false;
        if (this._filterList != null && this._filterList.size() > 0) {
            for (SearchFilter sc : this._filterList) {
                String desc;
                if (sc instanceof PublicTypeFilter) {
                    filteringByType = true;
                }
                if ((desc = sc.getFilterDescription()) == null || desc.length() <= 0) continue;
                this._operation.getLogger().info(desc);
            }
        }
        List<String> supportedTypes = this._operation.getSupportedPublicTypes();
        if (!filteringByType && supportedTypes != null && !supportedTypes.isEmpty()) {
            this.addSearchFilter((SearchFilter)new PublicTypeFilter(supportedTypes));
        }
    }

    @Override
    public void populateModel(ContainerNodeInterface container) throws ServiceException, RemoteException {
        this.initialize();
        boolean isRoot = false;
        String type = container.getTypeDescriptor().getTypeName();
        if ("RootFolder".equalsIgnoreCase(type)) {
            isRoot = true;
            this._operation.getLogger().info(RB.getStringResource("ExportFolderModel.ExportingRootFolder.txt"));
        } else if ("Folder".equalsIgnoreCase(type)) {
            if (!(container instanceof VirtualFolderNodeInterface)) {
                this.validateObjectExists((PublicObjectInterface)container);
            }
            this._operation.getLogger().info(Message.format((ResourceBundle)RB.getResources(), (String)"ExportFolderModel.ExportingFolder.fmt.txt", (Object)container.getDisplayPath()));
        } else {
            this.validateObjectExists((PublicObjectInterface)container);
            this._operation.getLogger().info(Message.format((ResourceBundle)RB.getResources(), (String)"ExportFolderModel.ExportingContainer.fmt.txt", (Object)container.getTypeDescriptor().getType(), (Object)container.getDisplayPath()));
        }
        this.populateContainerContents(container);
        this.exportDependencies(isRoot);
    }

    @Override
    public void populateModel(PublicObjectInterface[] objects) throws ServiceException, RemoteException {
        boolean isRoot;
        block6: {
            int length;
            block7: {
                PublicObjectInterface publicObject;
                block8: {
                    PublicObjectNodeInterface node;
                    block9: {
                        this.initialize();
                        isRoot = false;
                        if (objects == null) break block6;
                        length = objects.length;
                        boolean allowFolderExport = true;
                        if (this._config instanceof ExportModelConfiguration) {
                            allowFolderExport = ((ExportModelConfiguration)this._config).isAllowingFolderExport();
                        }
                        if (length != 1 || !allowFolderExport) break block7;
                        publicObject = objects[0];
                        TypeDescriptorInterface type = publicObject.getTypeDescriptor();
                        if (type == null) break block6;
                        this.validateObjectExists(publicObject);
                        if (!this.isContainerType(type, publicObject.getIdentifier())) break block8;
                        node = this.getObject(publicObject);
                        if (!(node instanceof ContainerNodeInterface)) break block9;
                        this.populateContainerContents((ContainerNodeInterface)node);
                        if ("RootFolder".equals(type.getTypeName())) {
                            isRoot = true;
                        }
                        break block6;
                    }
                    if (node == null) break block6;
                    this.populateContainerMember((PublicObjectInterface)node);
                    break block6;
                }
                this.populateContainerMember(publicObject);
                break block6;
            }
            if (objects.length > 1) {
                Arrays.sort(objects, new ObjectTypeSorter());
            }
            for (int index = 0; index < length; ++index) {
                String id;
                PublicObjectInterface publicObject = objects[index];
                TypeDescriptorInterface type = publicObject.getTypeDescriptor();
                if (type == null || this._nodeCache.containsKey(id = publicObject.getIdentifier())) continue;
                this.validateObjectExists(publicObject);
                if (this.isContainerType(type, id)) {
                    PublicObjectNodeInterface node = this.getObject(publicObject);
                    if (node instanceof ContainerNodeInterface) {
                        this.populateContainerContents((ContainerNodeInterface)node);
                        if (!"RootFolder".equals(type.getTypeName())) continue;
                        isRoot = true;
                        continue;
                    }
                    this.populateContainerMember((PublicObjectInterface)node);
                    continue;
                }
                this.populateContainerMember(publicObject);
            }
        }
        this.exportDependencies(isRoot);
    }

    public void exportDependencies(boolean isRoot) throws ServiceException, RemoteException {
        if (this._config instanceof ExportModelConfiguration && ((ExportModelConfiguration)this._config).isIncludingDependencies()) {
            if (isRoot && (this._filterList == null || this._filterList.isEmpty())) {
                return;
            }
            this.populateDependentObjects();
        }
    }

    private void populateContainerMember(PublicObjectInterface po) throws ServiceException, RemoteException {
        PublicObjectNodeInterface node = this.getObject(po.getIdentifier(), po.getTypeDescriptor().getTypeName());
        if (node != null) {
            this.createExportNode(node);
        }
    }

    private void populateContainerContents(ContainerNodeInterface container) throws ServiceException, RemoteException {
        if (container == null) {
            return;
        }
        String publicType = container.getTypeDescriptor().getTypeName();
        if ("RootFolder".equals(publicType)) {
            this.createExportNode((PublicObjectNodeInterface)this.getRootFolder());
            this.populateFolders();
            this.createChildExportNodes((ContainerNodeInterface)this.getRootFolder());
        } else if (FolderUtil.isFolder((String)publicType)) {
            if (container instanceof VirtualFolderNodeInterface) {
                this.createExportNode((PublicObjectNodeInterface)container);
                this.populateFolder((FolderNodeInterface)((VirtualFolderNodeInterface)container), true);
                this.createChildExportNodes(container);
            } else if (container instanceof FolderNodeInterface) {
                this.createExportNode((PublicObjectNodeInterface)container);
                this.populateFolder((FolderNodeInterface)container, true);
                this.createChildExportNodes(container);
            }
        } else {
            this.createExportNode((PublicObjectNodeInterface)container);
            this.populateContainer(container);
            this.createChildExportNodes(container);
        }
    }

    private void createExportNode(PublicObjectNodeInterface node) throws ServiceException, RemoteException {
        this.cacheNode(node);
        this._exportedNodes.add(node);
        String publicType = node.getTypeDescriptor().getTypeName();
        if (!"RootFolder".equals(publicType)) {
            this.createExportElement((PublicObjectInterface)node);
            for (ContainerNodeInterface parent = (ContainerNodeInterface)node.getContainer(); parent != null; parent = (ContainerNodeInterface)parent.getContainer()) {
                if (parent.isPopulated()) continue;
                parent.setPopulated(true);
            }
        }
    }

    private void createChildExportNodes(ContainerNodeInterface container) throws ServiceException, RemoteException {
        if (container != null) {
            List children = container.getChildren();
            for (PublicObjectNodeInterface child : children) {
                this.createExportElement((PublicObjectInterface)child);
                this.cacheNode(child);
                if (!(child instanceof ContainerNodeInterface)) continue;
                this.createChildExportNodes((ContainerNodeInterface)child);
            }
        }
    }

    protected boolean isContainerType(TypeDescriptorInterface type, String objectID) throws ServiceException, RemoteException {
        if (!super.isContainerType(type, objectID)) {
            return false;
        }
        String typeName = type.getTypeName();
        return FolderUtil.isFolder((String)typeName) || "RootFolder".equals(typeName);
    }

    private void cacheNode(PublicObjectNodeInterface node) throws ServiceException, RemoteException {
        String id = node.getIdentifier();
        if (!this._nodeCache.containsKey(id)) {
            this._nodeCache.put(id, node);
        }
    }

    private void addDuplicateObject(PublicObjectNodeInterface node) {
        if (this._duplicateObjects == null) {
            this._duplicateObjects = new LinkedHashSet<PublicObjectNodeInterface>(4);
        }
        this._duplicateObjects.add(node);
    }

    private void loadContainerItems(ContainerNodeInterface container, Set<PublicObjectNodeInterface> exportItems) throws ServiceException, RemoteException {
        if (container != null) {
            List children = container.getChildren();
            for (PublicObjectNodeInterface child : children) {
                if (this.getExportElement((PublicObjectInterface)child) != null) {
                    exportItems.add(child);
                }
                if (!(child instanceof ContainerNodeInterface)) continue;
                this.loadContainerItems((ContainerNodeInterface)child, exportItems);
            }
        }
    }

    private void populateDependentObjects() throws ServiceException, RemoteException {
        if (this._exportedNodes == null || this._exportedNodes.isEmpty()) {
            return;
        }
        Log log = this._operation.getLogger();
        log.info(RB.getStringResource("ExportFolderModel.RetrieveDependencies.txt"));
        HashMap<String, PublicObjectNodeInterface> objectCache = new HashMap<String, PublicObjectNodeInterface>(this._nodeCache);
        for (PublicObjectNodeInterface node : this._exportedNodes) {
            this.retrieveObjectDependencies(node, objectCache);
        }
    }

    private void retrieveObjectDependencies(PublicObjectNodeInterface node, Map<String, PublicObjectNodeInterface> objectCache) throws ServiceException, RemoteException {
        TypeDescriptorInterface type = node.getTypeDescriptor();
        if (type == null) {
            return;
        }
        if (!"Folder".equalsIgnoreCase(type.getTypeName())) {
            this.retrieveDependencies(node, objectCache);
        }
        if (node instanceof ContainerNodeInterface) {
            List children = ((ContainerNodeInterface)node).getChildren();
            for (PublicObjectNodeInterface child : children.toArray(new PublicObjectNodeInterface[children.size()])) {
                this.retrieveObjectDependencies(child, objectCache);
            }
        }
    }

    private void retrieveDependencies(PublicObjectNodeInterface node, Map<String, PublicObjectNodeInterface> objectCache) throws ServiceException, RemoteException {
        block7: {
            ExportElementInterface element = this.getExportElement((PublicObjectInterface)node);
            if (element == null) {
                return;
            }
            ExportItemInterface exportItem = element.getExportItem();
            if (exportItem instanceof RelatedObjectsInterface) {
                try {
                    List relatedItems;
                    Log log = this._operation.getLogger();
                    if (log.isDebugEnabled()) {
                        log.debug("Retrieving dependencies for \"" + exportItem.toString() + "\"");
                    }
                    if ((relatedItems = ((RelatedObjectsInterface)exportItem).getRelatedObjects(0)) != null && relatedItems.size() > 0) {
                        for (Object item : relatedItems) {
                            PublicObjectNodeInterface dependentNode;
                            String publicType;
                            TypeInterface type;
                            SimpleLogicalObjectInterface logicalObject;
                            String id;
                            if (!(item instanceof SimpleLogicalObjectInterface) || objectCache.containsKey(id = (logicalObject = (SimpleLogicalObjectInterface)item).getID()) || (type = logicalObject.getTypeInterface()) == null || !this._operation.isTypeSupported(publicType = type.getPublicType()) || (dependentNode = this.createDependentObject(id, publicType)) == null) continue;
                            objectCache.put(id, dependentNode);
                            this.retrieveDependencies(dependentNode, objectCache);
                        }
                    }
                }
                catch (Exception e) {
                    Log log = this._operation.getLogger();
                    String type = node.getTypeDescriptor().getType();
                    String msg = Message.format((ResourceBundle)RB.getResources(), (String)"ExportFolderModel.DependencyFailure.fmt.txt", (Object)type, (Object)node.getDisplayPath());
                    log.warn(msg);
                    if (!log.isDebugEnabled()) break block7;
                    log.debug((Object)"Error retrieving dependencies", e);
                }
            }
        }
    }

    @Override
    public PublicObjectNodeInterface createDependentObject(String id, String publicType) throws ServiceException, RemoteException {
        OMIRepositoryInterface repos;
        String defaultFolderLocation;
        TypeDescriptorInterface type = this._server.getTypeDescriptor(publicType);
        String key = SASFoldersUtil.getISEntityKey((String)id, (TypeDescriptorInterface)type);
        BrowseMetadataInterface browse = this._server.browseFetch(key, FETCH_OBJECT_FILTER);
        if (browse == null) {
            return null;
        }
        PublicObjectNodeInterface node = this.createNode(browse);
        this.createExportElement((PublicObjectInterface)node);
        if (SASFoldersUtil.isContainedByFolder((PublicObjectInterface)node)) {
            List<BrowseMetadataInterface> parentPath = this.getParentFolderPath(browse);
            ArrayList<String> folderPath = new ArrayList<String>(5);
            for (BrowseMetadataInterface browseObject : parentPath) {
                folderPath.add(browseObject.getName());
            }
            boolean external = this.isExternalDependency(folderPath);
            if (external) {
                ExportElementInterface exportElement = this.getExportElement((PublicObjectInterface)node);
                if (exportElement != null) {
                    exportElement.setExternalDependency(true);
                }
                this._externalDependencies.add(node);
            }
            this.createDependencyParentStructure(node, parentPath);
        } else if (SASFoldersUtil.isContainedByVirtualFolder((String)publicType, (ServerInterface)this._server) && (defaultFolderLocation = VirtualFolderManager.getDefaultPath((String)publicType, (OMIRepositoryInterface)(repos = SASFoldersUtil.getRepositoryForObject((String)id, (ServerInterface)this._server)))) != null && defaultFolderLocation.length() > 0) {
            List folderPath = SASFoldersUtil.parseFolderPath((String)defaultFolderLocation);
            boolean external = this.isExternalDependency(folderPath);
            if (external) {
                ExportElementInterface exportElement = this.getExportElement((PublicObjectInterface)node);
                if (exportElement != null) {
                    exportElement.setExternalDependency(true);
                }
                this._externalDependencies.add(node);
            }
            this.createVirtualParentStructure(node, folderPath);
        }
        return node;
    }

    private List<BrowseMetadataInterface> getParentFolderPath(BrowseMetadataInterface browse) {
        ArrayList<BrowseMetadataInterface> path = new ArrayList<BrowseMetadataInterface>(5);
        List parents = browse.getParents();
        while (parents != null && !parents.isEmpty()) {
            BrowseMetadataInterface parentBrowse = (BrowseMetadataInterface)parents.get(0);
            path.add(parentBrowse);
            parents = parentBrowse.getParents();
        }
        Collections.reverse(path);
        return path;
    }

    private boolean isExternalDependency(List<String> folderPath) throws ServiceException, RemoteException {
        String[] childPath = folderPath.toArray(new String[folderPath.size()]);
        for (PublicObjectNodeInterface exportedNode : this._exportedNodes) {
            String[] parentPath;
            if (exportedNode instanceof RootFolderNode) {
                return false;
            }
            if (!(exportedNode instanceof FolderNodeInterface) || !SASFoldersUtil.isChildOf((String[])childPath, (String[])(parentPath = SASFoldersUtil.getObjectPath((PublicObjectInterface)exportedNode, (boolean)true)))) continue;
            return false;
        }
        return true;
    }

    private void createDependencyParentStructure(PublicObjectNodeInterface node, List<BrowseMetadataInterface> parentPath) throws ServiceException, RemoteException {
        if (node.getContainer() == null) {
            FolderNodeInterface parent = this.getRootFolder();
            if (parentPath != null) {
                for (BrowseMetadataInterface browse : parentPath) {
                    PublicObjectNodeInterface childNode = SASFoldersUtil.findChildNode((ContainerNodeInterface)parent, (String)browse.getName(), (String)"Folder");
                    if (childNode == null && (childNode = this.createNode(browse)) instanceof ContainerNodeInterface) {
                        ContainerNodeInterface cn = (ContainerNodeInterface)childNode;
                        cn.setPopulated(true);
                        int position = this.getChildPosition((ContainerNodeInterface)parent, (PublicObjectNodeInterface)cn);
                        parent.insertChild((PublicObjectInterface)childNode, position);
                    }
                    if (!(childNode instanceof ContainerNodeInterface)) continue;
                    parent = (ContainerNodeInterface)childNode;
                }
            }
            int position = this.getChildPosition((ContainerNodeInterface)parent, node);
            parent.insertChild((PublicObjectInterface)node, position);
        }
    }

    private void createVirtualParentStructure(PublicObjectNodeInterface node, List<String> folderPath) throws ServiceException, RemoteException {
        if (node.getContainer() == null) {
            String parentPath = "/";
            FolderNodeInterface parentNode = this.getRootFolder();
            if (folderPath != null) {
                for (String folderName : folderPath) {
                    Object childNode = SASFoldersUtil.findChildNode((ContainerNodeInterface)parentNode, (String)folderName, (String)"Folder");
                    if (childNode == null) {
                        String path = parentPath + folderName;
                        PathUrl childPathUrl = PathUrl.newPathUrlFromAbsolutePath((ServerInterface)this._server, (String)path);
                        childPathUrl.setType("Folder");
                        FolderInterface folder = (FolderInterface)this._server.getObjectByPath(childPathUrl);
                        if (folder == null) {
                            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"ExportFolderModel.MissingFolder.fmt.txt", (Object)childPathUrl.getDisplayPath());
                            throw new ServiceException(msg);
                        }
                        childNode = folder instanceof VirtualFolderInterface ? this.createVirtualFolder((VirtualFolderInterface)folder) : this.createNode((PublicObjectInterface)folder);
                        if (childNode instanceof ContainerNodeInterface) {
                            ContainerNodeInterface cn = (ContainerNodeInterface)childNode;
                            cn.setPopulated(true);
                            int position = this.getChildPosition((ContainerNodeInterface)parentNode, (PublicObjectNodeInterface)cn);
                            parentNode.insertChild((PublicObjectInterface)childNode, position);
                        }
                    }
                    if (childNode instanceof ContainerNodeInterface) {
                        parentPath = parentPath + childNode.getName() + "/";
                        parentNode = (ContainerNodeInterface)childNode;
                        continue;
                    }
                    throw new ServiceException("Invalid container: " + childNode.getName());
                }
            }
            int position = this.getChildPosition((ContainerNodeInterface)parentNode, node);
            parentNode.insertChild((PublicObjectInterface)node, position);
        }
    }

    public boolean accept(PublicObjectNodeInterface node, ContainerNodeInterface parentNode) throws ServiceException, RemoteException {
        if (this.isNodeBeingExported(parentNode)) {
            if (node == null || node.getTypeDescriptor() == null) {
                return false;
            }
            if (node instanceof VirtualFolderNodeInterface) {
                return true;
            }
            String publicType = node.getTypeDescriptor().getTypeName();
            if (this._operation.isTypeSupported(publicType)) {
                if (!this._operation.isUsedForChangeManagement() && this._operation.getPromotionType() != 0 && !SASFoldersUtil.isUnique((PublicObjectContainerInterface)parentNode, (String)node.getName(), (String)publicType)) {
                    this.addDuplicateObject(node);
                    return false;
                }
            } else {
                if (!this.getConfiguration().isDisplayingUnknownObjects()) {
                    String msg = Message.format((ResourceBundle)RB.getResources(), (String)"ExportFolderModel.CannotCopyUnknown.fmt.txt", (Object)parentNode.getDisplayPath());
                    throw new ServiceException(msg);
                }
                return false;
            }
        }
        return true;
    }

    private boolean isNodeBeingExported(ContainerNodeInterface parentNode) throws ServiceException, RemoteException {
        if (this._exportedNodes == null) {
            return true;
        }
        for (PublicObjectNodeInterface node : this._exportedNodes) {
            if (node != parentNode) continue;
            return true;
        }
        for (PublicObjectNodeInterface node : this._exportedNodes) {
            if (!(node instanceof ContainerNodeInterface)) continue;
            PublicObjectContainerInterface[] containers = SASFoldersUtil.getContainerPath((PublicObjectInterface)parentNode);
            for (int index = 0; index < containers.length; ++index) {
                if (containers[index] != node) continue;
                return true;
            }
        }
        return false;
    }

    private VirtualFolderNodeInterface createVirtualFolder(VirtualFolderInterface folder) throws ServiceException, RemoteException {
        VirtualFolderNode vf = new VirtualFolderNode(folder);
        vf.setFolderModel((FolderModelInterface)this);
        vf.setPopulated(true);
        return vf;
    }

    private void validateObjectExists(PublicObjectInterface publicObject) throws ServiceException, RemoteException {
        String id = publicObject.getIdentifier();
        if (id != null && !this.isVirtualFolder(publicObject)) {
            MetadataServerInterface server = (MetadataServerInterface)this._operation.getServer();
            StringBuilder sb = new StringBuilder(50);
            sb.append("<XMLSelect search=\"*[@Id='");
            sb.append(id);
            sb.append("']\"/>");
            Filter filter = new Filter();
            filter.setOMRRepository("A0000001." + id.substring(0, 8));
            filter.setExplicitSearchString("omi", sb.toString());
            filter.setType(publicObject.getTypeDescriptor().getMetadataType());
            int count = server.getCountNoSecurity(filter, null);
            if (count == 0) {
                if (this._operation.getPromotionType() == 0) {
                    throw new ServiceException(RB.getStringResource("ExportFolderModel.MissingObjects.Export.txt"));
                }
                throw new ServiceException(RB.getStringResource("ExportFolderModel.MissingObjects.Copy.txt"));
            }
        }
    }

    class ObjectTypeSorter
    implements Comparator<PublicObjectInterface> {
        ObjectTypeSorter() {
        }

        @Override
        public int compare(PublicObjectInterface publicObject1, PublicObjectInterface publicObject2) {
            try {
                String type1 = publicObject1.getTypeDescriptor().getTypeName();
                String type2 = publicObject2.getTypeDescriptor().getTypeName();
                if ("Folder".equalsIgnoreCase(type1) && "Folder".equalsIgnoreCase(type2)) {
                    int count2;
                    PathUrl url1 = publicObject1.getPathUrl();
                    PathUrl url2 = publicObject2.getPathUrl();
                    if (url1 == null) {
                        return -1;
                    }
                    if (url2 == null) {
                        return 1;
                    }
                    String path1 = url1.getPath();
                    String path2 = url2.getPath();
                    if (path1 == null && path2 == null) {
                        if (url1.getName() == null && url2.getName() == null) {
                            return publicObject1.getName().compareToIgnoreCase(publicObject2.getName());
                        }
                        if (url1.getName() == null && url2.getName() != null) {
                            return -1;
                        }
                        return 1;
                    }
                    if (path1 == null && path2 != null) {
                        return -1;
                    }
                    if (path1 != null && path2 == null) {
                        return 1;
                    }
                    int count1 = Strings.count((String)path1, (int)0, (int)-1, (char)'/');
                    if (count1 < (count2 = Strings.count((String)path2, (int)0, (int)-1, (char)'/'))) {
                        return -1;
                    }
                    if (count1 > count2) {
                        return 1;
                    }
                    return publicObject1.getName().compareToIgnoreCase(publicObject2.getName());
                }
                if ("Folder".equalsIgnoreCase(type1)) {
                    return -1;
                }
                if ("Folder".equalsIgnoreCase(type2)) {
                    return 1;
                }
                if (type1 != null && type2 != null) {
                    return type1.compareToIgnoreCase(type2);
                }
                return 0;
            }
            catch (Exception e) {
                return 0;
            }
        }
    }
}

