/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.promotion.connections;

import com.sas.metadata.promotion.AbstractConnectionType;
import com.sas.metadata.promotion.ConnectionManagerInterface;
import com.sas.metadata.promotion.ConnectionObjectType;
import com.sas.metadata.promotion.ConnectionPointInterface;
import com.sas.metadata.promotion.ConnectionTypeInterface;
import com.sas.metadata.promotion.ExportOperationInterface;
import com.sas.metadata.promotion.ImportOperationInterface;
import com.sas.metadata.promotion.MetadataPromotionException;
import com.sas.metadata.promotion.ObjectsSelectedListener;
import com.sas.metadata.promotion.PromotionInterface;
import com.sas.metadata.promotion.SourceConnectionInterface;
import com.sas.metadata.promotion.TargetConnectionInterface;
import com.sas.metadata.promotion.connections.ACTConnectionType;
import com.sas.metadata.promotion.connections.RB;
import com.sas.metadata.promotion.connections.RoleConnectionType;
import com.sas.metadata.promotion.connections.UserConnectionType;
import com.sas.metadata.promotion.connections.UserGroupConnectionType;
import com.sas.metadata.remote.MdException;
import com.sas.text.Message;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;

public class SecurityConnectionType
extends AbstractConnectionType
implements ConnectionTypeInterface,
ObjectsSelectedListener {
    private static final String TYPE_NAME = "Access Controls";
    private List<SourceConnectionInterface> _securityConnections;
    private List<SourceConnectionInterface> _unmappedConnections;
    private List<ConnectionTypeInterface> _typesList = null;

    public SecurityConnectionType(PromotionInterface operation) {
        super(operation);
        this.registerTypes();
        operation.addObjectsSelectedListener(this);
    }

    private void registerTypes() {
        this._typesList = new ArrayList<ConnectionTypeInterface>(4);
        this._typesList.add(new UserConnectionType(this._operation));
        this._typesList.add(new UserGroupConnectionType(this._operation));
        this._typesList.add(new RoleConnectionType(this._operation));
        this._typesList.add(new ACTConnectionType(this._operation));
    }

    public static boolean isConnectionMappingNeeded(PromotionInterface operation) {
        if (operation instanceof ImportOperationInterface) {
            if (((ImportOperationInterface)operation).isSecurityMetadataIncluded()) {
                return true;
            }
            List items = operation.getPromotionItems("ACT");
            if (items != null && !items.isEmpty()) {
                return true;
            }
        } else if (operation instanceof ExportOperationInterface) {
            return true;
        }
        return false;
    }

    @Override
    public String getConnectionTypeName() {
        return TYPE_NAME;
    }

    @Override
    public String getLocalizedTypeName() {
        return RB.getStringResource("SecurityConnectionType.TypeName.txt");
    }

    @Override
    public String getPanelName() {
        return "com.sas.metadata.promotion.visuals.connections.SecurityConnectionPanel";
    }

    @Override
    public List<SourceConnectionInterface> getSourceConnections() {
        if (this._securityConnections == null) {
            this._securityConnections = this.mapConnections();
        }
        return this._securityConnections;
    }

    @Override
    public List<TargetConnectionInterface> getTargetConnections() throws MdException, RemoteException {
        return null;
    }

    @Override
    public boolean isConnectionRequired(SourceConnectionInterface connection) {
        return false;
    }

    @Override
    public void objectsSelected(Map selectedItems) {
        this._securityConnections = null;
    }

    public boolean containsAccessControlConnections() {
        return this.getAccessControlConnections().size() > 0;
    }

    public List<ConnectionTypeInterface> getSecurityConnectionTypes() {
        return this._typesList;
    }

    public List<SourceConnectionInterface> getAccessControlConnections() {
        ArrayList<SourceConnectionInterface> accessControls = new ArrayList<SourceConnectionInterface>();
        ArrayList<ConnectionTypeInterface> types = new ArrayList<ConnectionTypeInterface>(this._typesList);
        for (ConnectionTypeInterface type : types) {
            List<SourceConnectionInterface> connections = type.getSourceConnections();
            if (connections == null || connections.isEmpty()) continue;
            accessControls.addAll(connections);
        }
        List<SourceConnectionInterface> connections = this.getHiddenConnections();
        if (connections != null && !connections.isEmpty()) {
            accessControls.addAll(connections);
        }
        return accessControls;
    }

    public List<SourceConnectionInterface> getHiddenConnections() {
        ArrayList<SourceConnectionInterface> hiddenConnections = new ArrayList<SourceConnectionInterface>();
        ConnectionManagerInterface manager = this._operation.getConnectionManager();
        List<ConnectionPointInterface> connections = manager.getConnections(ConnectionObjectType.MetadataType, "Permission");
        for (ConnectionPointInterface pt : connections) {
            String name = pt.getName();
            String type = SecurityConnectionType.getPermissionType(pt);
            if (type.length() > 0) {
                name = name + " (" + type + ")";
            }
            hiddenConnections.add(this.createSourceConnection(pt, name));
        }
        return hiddenConnections;
    }

    public List<SourceConnectionInterface> mapConnections() {
        if (this._unmappedConnections != null) {
            return this._unmappedConnections;
        }
        if (this._operation instanceof ImportOperationInterface) {
            ConnectionManagerInterface manager = this._operation.getConnectionManager();
            this._unmappedConnections = this.getAccessControlConnections();
            Object[] array = this._unmappedConnections.toArray();
            int length = array.length;
            for (int i = 0; i < length; ++i) {
                SourceConnectionInterface source = (SourceConnectionInterface)array[i];
                ConnectionPointInterface pt = source.getConnectionPoint();
                if (this.mapSecurityConnection(manager, pt)) {
                    this._unmappedConnections.remove(source);
                    continue;
                }
                String typeName = SecurityConnectionType.getConnectionLabel(source);
                String name = source.getDisplayName();
                String msg = Message.format((ResourceBundle)RB.getResources(), (String)"SecurityConnectionType.MissingConnection.fmt.txt", (Object)typeName, (Object)name);
                this._operation.getLogger().warn(msg);
            }
        }
        return this._unmappedConnections;
    }

    private boolean mapSecurityConnection(ConnectionManagerInterface manager, ConnectionPointInterface pt) {
        boolean mapped = true;
        if (pt.getTargetID() == null) {
            try {
                manager.autoMapConnectionPoint((ImportOperationInterface)this._operation, pt, 2);
                if (pt.getTargetID() == null || pt.getTargetID().length() == 0) {
                    mapped = false;
                }
            }
            catch (MetadataPromotionException e) {
                mapped = false;
            }
        }
        return mapped;
    }

    private static String getPermissionType(ConnectionPointInterface pt) {
        String searchAttribute;
        int index;
        List<String> searchList = pt.getSourceSearchList();
        if (searchList.size() > 0 && (index = (searchAttribute = searchList.get(0)).indexOf("@Type='")) > -1) {
            return searchAttribute.substring(index + 7, searchAttribute.indexOf(39, index + 7));
        }
        return "";
    }

    public static String getConnectionLabel(SourceConnectionInterface connection) {
        String typeName;
        ConnectionTypeInterface type = connection.getConnectionType();
        if (type instanceof SecurityConnectionType) {
            ConnectionPointInterface pt = connection.getConnectionPoint();
            typeName = pt.getMetadataType();
        } else {
            typeName = type.getLocalizedTypeName();
        }
        return typeName;
    }
}

