/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.promotion.connections;

import com.sas.metadata.promotion.AbstractConnectionType;
import com.sas.metadata.promotion.ConnectionObjectType;
import com.sas.metadata.promotion.ConnectionSearchInterface;
import com.sas.metadata.promotion.ConnectionTypeInterface;
import com.sas.metadata.promotion.ImportOperationInterface;
import com.sas.metadata.promotion.MetadataPromotionException;
import com.sas.metadata.promotion.ObjectsSelectedListener;
import com.sas.metadata.promotion.PromotionInterface;
import com.sas.metadata.promotion.SearchCriteria;
import com.sas.metadata.promotion.SourceConnectionInterface;
import com.sas.metadata.promotion.connections.SecurityConnectionType;
import com.sas.metadata.remote.MdException;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Map;

abstract class AbstractAccessControlConnectionType
extends AbstractConnectionType
implements ConnectionTypeInterface,
ConnectionSearchInterface,
ObjectsSelectedListener {
    protected List _securityConnections = null;
    protected String _publicType;
    protected String _metadataType;

    public AbstractAccessControlConnectionType(String publicType, String metadataType, PromotionInterface promotionOperation) {
        super(promotionOperation);
        this._publicType = publicType;
        this._metadataType = metadataType;
        promotionOperation.addObjectsSelectedListener(this);
    }

    @Override
    public String getPanelName() {
        return null;
    }

    public List getSourceConnections() {
        if (this._securityConnections == null && SecurityConnectionType.isConnectionMappingNeeded(this._operation)) {
            this._securityConnections = this.getSourceConnectionsByType(ConnectionObjectType.PublicType, this._publicType);
        }
        return this._securityConnections;
    }

    public List getTargetConnections() throws MdException, RemoteException {
        return null;
    }

    @Override
    public boolean isConnectionRequired(SourceConnectionInterface connection) {
        return false;
    }

    @Override
    public void objectsSelected(Map selectedItems) {
        this._securityConnections = null;
    }

    @Override
    public boolean isContainedByFolder() {
        return false;
    }

    @Override
    public SearchCriteria generateSearchCriteria(SourceConnectionInterface connection, String objectName) throws MetadataPromotionException {
        SearchCriteria criteria = new SearchCriteria(connection, 2);
        criteria.setMetadataType(this._metadataType);
        StringBuilder sb = new StringBuilder();
        sb.append("*[@Name='");
        sb.append(objectName);
        sb.append("' and @PublicType='");
        sb.append(this._publicType);
        sb.append("']");
        criteria.setSearchString(sb.toString());
        return criteria;
    }

    protected boolean isSecurityIncluded() {
        if (this._operation instanceof ImportOperationInterface) {
            return ((ImportOperationInterface)this._operation).isSecurityMetadataIncluded();
        }
        return true;
    }
}

