/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.promotion;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLUtil {
    public static String formatXML(String original) {
        boolean newLine = false;
        char[] chars = new char[original.length()];
        original.getChars(0, original.length(), chars, 0);
        int indent = 0;
        StringBuffer output = new StringBuffer();
        int length = chars.length;
        for (int index = 0; index < length; ++index) {
            if (chars[index] == '<') {
                int indentIndex;
                if (chars[index + 1] != '/') {
                    if (index > 0) {
                        newLine = true;
                        output.append('\n');
                        for (indentIndex = 0; indentIndex < indent; ++indentIndex) {
                            output.append('\t');
                        }
                    }
                    if (chars[index + 1] != '!') {
                        ++indent;
                    }
                } else {
                    --indent;
                    if (newLine) {
                        output.append('\n');
                        newLine = false;
                        for (indentIndex = 0; indentIndex < indent; ++indentIndex) {
                            output.append('\t');
                        }
                    }
                }
            }
            if (chars[index] != '\t' && chars[index] != '\n') {
                output.append(chars[index]);
            }
            if (chars[index] != '>') continue;
            if (chars[index - 1] != '/') {
                if (newLine) {
                    newLine = false;
                    continue;
                }
                newLine = true;
                continue;
            }
            if (!newLine) {
                output.append('\n');
            }
            --indent;
        }
        original = null;
        chars = null;
        return output.toString();
    }

    public static String cleanStringForXML(String s) {
        StringBuffer parsed = new StringBuffer();
        if (s == null) {
            return "";
        }
        block3: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case '\"': 
                case '&': 
                case '<': 
                case '>': 
                case '\\': {
                    parsed.append("&#");
                    parsed.append(Integer.toString(c));
                    parsed.append(';');
                    continue block3;
                }
                default: {
                    parsed.append(c);
                }
            }
        }
        return parsed.toString();
    }

    public static String convertNodeToString(Node node) throws TransformerException, TransformerConfigurationException {
        if (node == null) {
            throw new IllegalArgumentException("Invalid node");
        }
        DOMSource source = new DOMSource(node);
        StringWriter stringWriter = new StringWriter();
        StreamResult result = new StreamResult(stringWriter);
        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer transformer = factory.newTransformer();
        transformer.transform(source, result);
        return stringWriter.toString();
    }

    public static String transformXML(InputStream xml, InputStream xsl) throws TransformerException {
        if (xml == null) {
            throw new IllegalArgumentException("Invalid xml input param");
        }
        StringWriter result = new StringWriter();
        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer transformer = factory.newTransformer(new StreamSource(xsl));
        transformer.transform(new StreamSource(xml), new StreamResult(result));
        return result.toString();
    }

    public static void parseXML(String xml, DefaultHandler handler) throws SAXException {
        StringReader reader = new StringReader(xml);
        InputSource source = new InputSource(reader);
        XMLUtil.parseXML(source, handler);
    }

    public static void parseXML(InputStream stream, DefaultHandler handler) throws SAXException {
        InputSource source = new InputSource(stream);
        XMLUtil.parseXML(source, handler);
    }

    public static void parseXML(InputSource source, DefaultHandler handler) throws SAXException {
        try {
            SAXParser parser = XMLUtil.createSAXParser();
            if (source != null) {
                parser.parse(source, handler);
                parser = null;
            }
        }
        catch (IOException io) {
            throw new SAXException(io);
        }
    }

    public static SAXParser createSAXParser() throws SAXException {
        try {
            SAXParserFactory parserFactory = SAXParserFactory.newInstance();
            parserFactory.setNamespaceAware(false);
            parserFactory.setValidating(false);
            return parserFactory.newSAXParser();
        }
        catch (ParserConfigurationException pce) {
            throw new SAXException(pce);
        }
    }

    public static Document parseXML(String inputXML) throws ParserConfigurationException, SAXException, IOException {
        StringReader strReader = new StringReader(inputXML);
        return XMLUtil.parseXML(new InputSource(strReader));
    }

    public static Document parseXML(InputStream is) throws ParserConfigurationException, SAXException, IOException {
        return XMLUtil.parseXML(new InputSource(is));
    }

    public static Document parseXML(File file) throws ParserConfigurationException, SAXException, IOException {
        Document doc = null;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = dbf.newDocumentBuilder();
        doc = docBuilder.parse(file);
        docBuilder = null;
        dbf = null;
        return doc;
    }

    private static Document parseXML(InputSource source) throws ParserConfigurationException, SAXException, IOException {
        Document doc = null;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = dbf.newDocumentBuilder();
        doc = docBuilder.parse(source);
        docBuilder = null;
        dbf = null;
        return doc;
    }

    public static void writeDocument(Document doc, File file, boolean format) throws IOException, SAXException {
        try {
            FileOutputStream out = new FileOutputStream(file);
            DOMSource source = new DOMSource(doc);
            StreamResult result = new StreamResult(out);
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("encoding", "UTF-8");
            if (format) {
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            }
            transformer.transform(source, result);
            out.flush();
            ((OutputStream)out).close();
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    public static Document createDocument(String rootTag) throws SAXException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.newDocument();
            doc.appendChild(doc.createElement(rootTag));
            return doc;
        }
        catch (ParserConfigurationException e) {
            throw new SAXException(e);
        }
    }

    public static Element createNode(Document doc, Element parentNode, String nodeName) {
        Element childNode = doc.createElement(nodeName);
        parentNode.appendChild(childNode);
        return childNode;
    }
}

