/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.promotion;

import com.sas.metadata.promotion.ImportItemInterface;
import com.sas.metadata.promotion.ImportOperationInterface;
import com.sas.metadata.promotion.RB;
import com.sas.metadata.remote.Identity;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Tree;
import com.sas.services.ServiceException;
import com.sas.services.information.Filter;
import com.sas.services.information.FilterInterface;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.UserFolderType;
import com.sas.services.information.browse.BrowseMetadataInterface;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.publicobject.PublicObjectInterface;
import com.sas.services.information.sasfolders.SASFoldersUtil;
import com.sas.text.Message;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;

public class UserFolderManager {
    private static final String PROPERTY_METADATA_SETTINGS = "Metadata Repository Policies";
    private static final String PROPERTY_USER_FOLDERS_PATH = "Path to Users Root Folder";
    public static final String FOLDERTYPE_HOME = "Home Folder";
    public static final String FOLDERTYPE_MYFOLDER = "My Folder";
    public static final String FOLDERTYPE_APPDATA = "Application Data";
    private static Map<ImportOperationInterface, UserFolderManager> _instanceCache = new HashMap<ImportOperationInterface, UserFolderManager>(5);
    private ImportOperationInterface _operation;
    private Map<String, UserFolderInfo> _userFolderCache;
    private String _userFoldersPath = null;

    private UserFolderManager(ImportOperationInterface operation) {
        this._operation = operation;
    }

    public static boolean instanceCreated(ImportOperationInterface operation) throws ServiceException, RemoteException {
        if (operation == null) {
            throw new IllegalArgumentException("Invalid import operation");
        }
        return _instanceCache.containsKey(operation);
    }

    public static synchronized UserFolderManager getInstance(ImportOperationInterface operation) {
        if (operation == null) {
            throw new IllegalArgumentException("Invalid operation");
        }
        if (_instanceCache.containsKey(operation)) {
            return _instanceCache.get(operation);
        }
        UserFolderManager instance = new UserFolderManager(operation);
        _instanceCache.put(operation, instance);
        return instance;
    }

    public static synchronized UserFolderManager getNewInstance(ImportOperationInterface operation) {
        if (operation == null) {
            throw new IllegalArgumentException("Invalid operation");
        }
        UserFolderManager instance = new UserFolderManager(operation);
        _instanceCache.put(operation, instance);
        return instance;
    }

    public void dispose() {
        _instanceCache.remove(this._operation);
        this._userFolderCache = null;
        this._userFoldersPath = null;
    }

    public boolean doesUserFolderExistOnServer(String folderType, String identityName) throws ServiceException, RemoteException {
        return this.getUserFolderOnServer(folderType, identityName) != null;
    }

    public boolean doesIdentityExistOnServer(String identityName) throws ServiceException, RemoteException {
        ServerInterface server = this._operation.getServer();
        Filter filter = new Filter();
        filter.setType("Person");
        filter.setExplicitSearchString("omi", "<XMLSelect search=\"*[@Name='" + identityName + "']\"/>");
        List identities = server.browseSearch((FilterInterface)filter);
        return identities == null ? false : !identities.isEmpty();
    }

    public FolderInterface getUserFolderOnServer(String folderType, String identityName) throws ServiceException, RemoteException {
        return this.getUserFolderOnServer(folderType, identityName, false);
    }

    public Set<String> getIdentityNamesOnServer() throws ServiceException, RemoteException {
        ServerInterface server = this._operation.getServer();
        Filter filter = new Filter();
        filter.setType("Person");
        filter.setOMRTemplate("<Templates><Person Name=\"\"/></Templates>");
        filter.setExplicitSearchString("omi", "<XMLSelect search=\"*[@PublicType='User']\"/>");
        List identities = server.browseSearch((FilterInterface)filter);
        if (identities == null || identities.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<String> names = new HashSet<String>(identities.size());
        for (BrowseMetadataInterface browse : identities) {
            names.add(browse.getName());
        }
        return names;
    }

    private FolderInterface getUserFolderOnServer(String folderType, String identityName, boolean create) throws ServiceException, RemoteException {
        UserFolderType type;
        ServerInterface server = this._operation.getServer();
        if (FOLDERTYPE_HOME.equalsIgnoreCase(folderType)) {
            type = UserFolderType.HOMEFOLDER;
        } else if (FOLDERTYPE_MYFOLDER.equalsIgnoreCase(folderType)) {
            type = UserFolderType.MYFOLDER;
        } else if (FOLDERTYPE_APPDATA.equalsIgnoreCase(folderType)) {
            type = UserFolderType.APPFOLDER;
        } else {
            throw new IllegalArgumentException("Invalid folder type");
        }
        FolderInterface folder = server.getHomeFolder(identityName, type, null, create);
        return folder;
    }

    public String getUserFolderNameOnServer(String folderType, String identityName) throws ServiceException, RemoteException {
        MdFactory factory = this._operation.getMetadataFactory();
        return factory.getOMIUtil().getUserHomeFolderName(identityName, folderType);
    }

    public boolean isUserFoldersRoot(PublicObjectInterface folder) throws ServiceException, RemoteException {
        if (folder == null || !"Folder".equalsIgnoreCase(folder.getTypeDescriptor().getTypeName())) {
            return false;
        }
        String userFoldersPath = this.getUserFoldersPath();
        String[] folderPath = SASFoldersUtil.getObjectPath((PublicObjectInterface)folder, (boolean)true);
        List pathList = SASFoldersUtil.parseFolderPath((String)userFoldersPath);
        return SASFoldersUtil.areFolderPathsEqual(Arrays.asList(folderPath), (List)pathList);
    }

    public boolean isUserHomeFolder(PublicObjectInterface folder) throws ServiceException, RemoteException {
        if (folder == null || !"Folder".equalsIgnoreCase(folder.getTypeDescriptor().getTypeName())) {
            return false;
        }
        try {
            String template = "<Templates><Tree><AssociatedIdentity/></Tree></Templates>";
            MdFactory factory = this._operation.getMetadataFactory();
            Tree tree = (Tree)factory.getOMIUtil().getMetadataAllDepths((MdStore)this._operation.getStore(), "Tree", folder.getIdentifier(), null, null, template, 4);
            if (tree == null) {
                return false;
            }
            Identity identity = tree.getAssociatedIdentity();
            if (identity != null) {
                return true;
            }
        }
        catch (MdException e) {
            throw new ServiceException((Throwable)e);
        }
        return false;
    }

    public int createUserFoldersOnServer() throws ServiceException, RemoteException {
        int rc = 0;
        if (this._userFolderCache == null || this._userFolderCache.isEmpty()) {
            return rc;
        }
        if (this._operation.getLogger().isDebugEnabled()) {
            this._operation.getLogger().debug("Creating user folders (if necessary)");
        }
        for (String folderID : this._userFolderCache.keySet()) {
            ImportItemInterface importItem;
            UserFolderInfo info = this._userFolderCache.get(folderID);
            if (!info.isCreateDuringImport() || (importItem = (ImportItemInterface)this._operation.getPromotionItem(folderID)) == null || importItem.getImportState() == 0) continue;
            FolderInterface folder = this.getUserFolderOnServer(info.getType(), info.getIdentityName(), true);
            if (folder == null) {
                rc |= 4;
                this._operation.getLogger().info(Message.format((ResourceBundle)RB.getResources(), (String)"UserFolderManager.CreateFolderError.fmt.txt", (Object)info.getType(), (Object)info.getIdentityName()));
                continue;
            }
            this._operation.getLogger().info(Message.format((ResourceBundle)RB.getResources(), (String)"UserFolderManager.CreateFolder.fmt.txt", (Object)info.getType(), (Object)info.getIdentityName()));
            importItem.setTargetID(folder.getIdentifier());
            importItem.setImportState(0);
        }
        return rc;
    }

    public void addUserFolder(String id) throws ServiceException, RemoteException {
        if (this._userFolderCache == null || !this._userFolderCache.containsKey(id)) {
            return;
        }
        UserFolderInfo info = this._userFolderCache.get(id);
        info.setCreateDuringImport(true);
    }

    public void cacheUserFolderInfo(String id, String userFolderType, String identity) {
        if (this._userFolderCache == null) {
            this._userFolderCache = new LinkedHashMap<String, UserFolderInfo>();
        }
        UserFolderInfo info = new UserFolderInfo(userFolderType, identity);
        this._userFolderCache.put(id, info);
    }

    public boolean isUserFolder(String id) {
        return this._userFolderCache == null ? false : this._userFolderCache.containsKey(id);
    }

    public String getUserFolderType(String id) {
        return this._userFolderCache == null ? null : (this._userFolderCache.containsKey(id) ? this._userFolderCache.get(id).getType() : null);
    }

    public String getUserFolderIdentity(String id) {
        return this._userFolderCache == null ? null : (this._userFolderCache.containsKey(id) ? this._userFolderCache.get(id).getIdentityName() : null);
    }

    public String getUserFoldersPath() throws ServiceException, RemoteException {
        if (this._userFoldersPath != null) {
            return this._userFoldersPath;
        }
        MdFactory factory = this._operation.getMetadataFactory();
        try {
            String pathValue = null;
            String repos = factory.getOMIUtil().getFoundationReposID();
            String template = "<Templates><PropertySet Name=\"\" PropertySetName=\"\"><SetProperties/></PropertySet><Property PropertyName=\"\" DefaultValue=\"\"/></Templates>";
            String search = "<XMLSelect search=\"*[@PropertySetName='Metadata Repository Policies']\"/>";
            List propertySets = factory.getOMIUtil().getMetadataObjectsNoCache("PropertySet", repos, search + template, 388);
            if (propertySets != null && !propertySets.isEmpty()) {
                Map propSet = (Map)propertySets.get(0);
                List properties = (List)propSet.get("SetProperties");
                for (Map property : properties) {
                    if (!PROPERTY_USER_FOLDERS_PATH.equals(property.get("PropertyName"))) continue;
                    pathValue = (String)property.get("DefaultValue");
                }
            }
            if (pathValue == null || pathValue.length() == 0) {
                this._operation.getLogger().warn(RB.getStringResource("UserFolderManager.MissingPath.txt"));
            }
            this._userFoldersPath = pathValue;
            return this._userFoldersPath;
        }
        catch (MdException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    protected class UserFolderInfo {
        private String _type;
        private String _identityName;
        private boolean _create = false;

        public UserFolderInfo(String userFolderType, String identityName) {
            this._type = userFolderType;
            this._identityName = identityName;
        }

        public String getType() {
            return this._type;
        }

        public String getIdentityName() {
            return this._identityName;
        }

        public void setCreateDuringImport(boolean create) {
            this._create = create;
        }

        public boolean isCreateDuringImport() {
            return this._create;
        }
    }

    public static enum ImportLocationState {
        ROOT_FOLDER,
        USER_FOLDERS_ROOT,
        USER_HOME_FOLDER,
        DEFAULT;

    }
}

