/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.promotion;

import com.sas.metadata.logical.TransportableTypeInterface;
import com.sas.metadata.promotion.ImportItemInterface;
import com.sas.metadata.promotion.ImportOperationInterface;
import com.sas.metadata.promotion.MetadataPromotionException;
import com.sas.metadata.promotion.NotificationEvent;
import com.sas.metadata.promotion.PromotionUtil;
import com.sas.metadata.promotion.RB;
import com.sas.metadata.promotion.XMLUtil;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.PrimaryType;
import com.sas.services.ServiceException;
import com.sas.services.information.ChildServerInterface;
import com.sas.services.information.OMIServer;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.util.ProcessStatus;
import com.sas.services.util.UpgradeInterface;
import com.sas.text.Message;
import java.io.IOException;
import java.io.InputStream;
import java.rmi.RemoteException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.logging.log4j.LogManager;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class UpgradeManager {
    private static final String TAG_UPGRADE = "Upgrade";
    private static final String ATTRIBUTE_PUBLIC_TYPE = "PublicType";
    private static final String ATTRIBUTE_USAGE_VERSION = "UsageVersion";
    private static final String ATTRIBUTE_CONECTIONPOINT_METADATATYPE = "ConnectionPointMetadataType";
    private static final String ATTRIBUTE_PREVIOUS_METADATA = "PreviousMetadataType";
    private static final String ATTRIBUTE_PREVIOUS_PUBLIC = "PreviousPublicType";
    private static final String ATTRIBUTE_CUSTOM_UPGRADE = "RequiresCustomUpgrade";
    private static final String ATTRIBUTE_IS_UPGRADEABLE = "IsUpgradeable";
    private static final String ATTRIBUTE_VALUE_TRUE = "true";
    private static final String UPGRADE_TEMPLATE = "<Templates><PrimaryType Name=\"\" PublicType=\"\" UsageVersion=\"\"/></Templates>";
    private static UpgradeManager _instance = null;
    private Map<String, UpgradeRule> _rulesMap = new LinkedHashMap<String, UpgradeRule>();
    private boolean _initialized = false;

    private UpgradeManager() {
    }

    public static synchronized UpgradeManager getInstance() {
        if (_instance == null) {
            _instance = new UpgradeManager();
        }
        return _instance;
    }

    public String getMetadataType(ImportItemInterface importItem, ImportOperationInterface operation) throws MetadataPromotionException {
        if (operation.getPackageFileVersion() < 9200) {
            this.initialize();
            String publicType = importItem.getTypeInterface().getPublicType();
            if (publicType == null || publicType.length() == 0) {
                return null;
            }
            for (Map.Entry<String, UpgradeRule> entry : this._rulesMap.entrySet()) {
                UpgradeRule rule = entry.getValue();
                if (!publicType.equals(rule.getPublicType())) continue;
                String previousType = rule.getPreviousMetadataType();
                return previousType != null ? previousType : importItem.getTypeInterface().getMetadataType();
            }
        }
        return importItem.getTypeInterface().getMetadataType();
    }

    public String getCurrentPublicType(String oldTypeName) throws MetadataPromotionException {
        this.initialize();
        if (oldTypeName == null || oldTypeName.length() == 0) {
            return null;
        }
        for (Map.Entry<String, UpgradeRule> entry : this._rulesMap.entrySet()) {
            UpgradeRule rule = entry.getValue();
            if (oldTypeName.equals(rule.getPublicType())) {
                return oldTypeName;
            }
            String previousType = rule.getPreviousPublicType();
            if (previousType == null || !oldTypeName.equals(previousType)) continue;
            return rule.getPublicType();
        }
        return null;
    }

    public String getPublicTypeFromMetadataType(String metadataType) throws MetadataPromotionException {
        this.initialize();
        if (metadataType == null || metadataType.length() == 0) {
            return null;
        }
        for (Map.Entry<String, UpgradeRule> entry : this._rulesMap.entrySet()) {
            UpgradeRule rule = entry.getValue();
            if (!metadataType.equals(rule.getConnectionPointMetadataType())) continue;
            return rule.getPublicType();
        }
        return null;
    }

    public int upgradeObjects(Map importItems, ImportOperationInterface operation) throws MetadataPromotionException {
        this.initialize();
        int rc = 0;
        ChildServerInterface childTransaction = null;
        ProcessStatus globalStatus = null;
        boolean bStatusLogged = false;
        try {
            int objectCount = 0;
            ServerInterface parentServer = operation.getServer();
            globalStatus = new ProcessStatus(LogManager.getLogger((String)"com.sas.metadata.promotion"), RB.getStringResource("UpgradeManager.UpgradeProcessName.txt"));
            ProcessStatus.setGlobalStatus((ProcessStatus)globalStatus);
            for (String publicType : this._rulesMap.keySet()) {
                UpgradeRule rule;
                if (!importItems.containsKey(publicType) || (rule = this._rulesMap.get(publicType)) == null || !rule.isUpgradeable()) continue;
                List objects = (List)importItems.get(publicType);
                TransportableTypeInterface type = operation.getTransportableType(publicType);
                if (type == null) continue;
                Iterator objectIter = objects.iterator();
                while (objectIter.hasNext()) {
                    ++objectCount;
                    if (childTransaction == null) {
                        childTransaction = ((OMIServer)parentServer).newChild(true);
                    } else if (objectCount > 25) {
                        childTransaction.destroy();
                        childTransaction = ((OMIServer)parentServer).newChild(true);
                        objectCount = 0;
                    }
                    ImportItemInterface importItem = (ImportItemInterface)objectIter.next();
                    rc |= this.upgradeObject(importItem, (ServerInterface)childTransaction, operation, rule);
                }
            }
        }
        catch (Exception e) {
            if (globalStatus != null) {
                bStatusLogged = true;
                globalStatus.logStatus();
            }
            throw new MetadataPromotionException(e);
        }
        finally {
            if (childTransaction != null) {
                try {
                    childTransaction.destroy();
                }
                catch (Exception exception) {}
            }
            if (globalStatus != null) {
                if (globalStatus.hasWarnings()) {
                    rc |= 4;
                } else if (globalStatus.hasErrors()) {
                    rc |= 8;
                }
                if (!bStatusLogged) {
                    globalStatus.logStatus();
                    bStatusLogged = true;
                }
                ProcessStatus.clearGlobalStatus();
            }
        }
        return rc;
    }

    private int upgradeObject(ImportItemInterface importItem, ServerInterface server, ImportOperationInterface operation, UpgradeRule rule) {
        int rc = 0;
        if (importItem.getImportState() == 0) {
            return rc;
        }
        MdFactory factory = null;
        MdObjectStore store = null;
        if (server instanceof OMIServer) {
            factory = ((OMIServer)server).getMdFactory();
            store = ((OMIServer)server).getObjectStore();
        } else {
            factory = operation.getMetadataFactory();
            store = operation.getStore();
        }
        String metadataType = null;
        metadataType = rule.getPreviousMetadataType() != null ? rule.getPreviousMetadataType() : importItem.getTypeInterface().getMetadataType();
        String targetID = importItem.getTargetID();
        if (targetID == null) {
            return rc;
        }
        try {
            PrimaryType meta;
            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"UpgradeManager.UpgradingObject.fmt.txt", (Object)importItem.getTypeInterface().getDisplayType(), (Object)importItem.getName());
            operation.fireNotification(new NotificationEvent(this, operation, 210, msg));
            if (operation.getLogger().isDebugEnabled()) {
                operation.getLogger().debug(msg);
            }
            if ((meta = (PrimaryType)factory.getOMIUtil().getMetadataAllDepths((MdStore)store, metadataType, targetID, null, null, UPGRADE_TEMPLATE, 20)) != null) {
                String publicType = meta.getPublicType();
                if (publicType == null || publicType.length() == 0) {
                    meta.setPublicType(rule.getPublicType());
                }
                if (rule.getUsageVersion() != null) {
                    double objectVersion = meta.getUsageVersion();
                    double ruleVersion = Double.parseDouble(rule.getUsageVersion());
                    if (objectVersion > 0.0 && objectVersion >= ruleVersion) {
                        if (operation.getLogger().isDebugEnabled()) {
                            msg = Message.format((ResourceBundle)RB.getResources(), (String)"UpgradeManager.AlreadyUpgraded.fmt.txt", (Object)importItem.getTypeInterface().getDisplayType(), (Object)importItem.getName());
                            operation.getLogger().debug(msg);
                        }
                        return rc;
                    }
                    meta.setUsageVersion(ruleVersion);
                }
                meta.updateMetadataAll();
                if (rule.isCustomUpgradeRequired()) {
                    this.performCustomUpgrade(server, meta);
                }
            }
        }
        catch (Exception e) {
            String publicType = importItem.getTypeInterface().getDisplayType();
            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"UpgradeManager.UpgradeFailed.fmt.txt", (Object)publicType, (Object)importItem, (Object)e.getLocalizedMessage());
            operation.getLogger().error(msg);
            if (operation.getLogger().isDebugEnabled()) {
                operation.getLogger().debug((Object)"Upgrade error", e);
            }
            rc = 8;
        }
        return rc;
    }

    private void performCustomUpgrade(ServerInterface server, PrimaryType meta) throws MetadataPromotionException {
        try {
            MetadataInterface smartObject = PromotionUtil.getSmartObject(server, meta.getId(), meta.getCMetadataType());
            if (smartObject != null && smartObject instanceof UpgradeInterface) {
                UpgradeInterface upgrade = (UpgradeInterface)smartObject;
                upgrade.upgradeFromPreviousVersion();
                smartObject.update();
            }
        }
        catch (ServiceException e) {
            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"UpgradeManager.CustomUpgradeFailed.fmt.txt", (Object)e.getLocalizedMessage());
            throw new MetadataPromotionException(e, msg);
        }
        catch (RemoteException e) {
            throw new MetadataPromotionException(e);
        }
    }

    private void initialize() throws MetadataPromotionException {
        if (!this._initialized) {
            try {
                this.loadRules();
            }
            catch (Exception e) {
                throw new MetadataPromotionException(e);
            }
            finally {
                this._initialized = true;
            }
        }
    }

    private void loadRules() throws ParserConfigurationException, SAXException, IOException {
        InputStream is = this.getClass().getResourceAsStream("UpgradeRules.xml");
        if (is == null) {
            throw new IllegalStateException("Unable to load upgrade rules file");
        }
        Document doc = XMLUtil.parseXML(is);
        NodeList nodes = doc.getElementsByTagName(TAG_UPGRADE);
        Node upgradeNode = nodes.item(0);
        if (upgradeNode == null) {
            return;
        }
        NodeList nodeList = upgradeNode.getChildNodes();
        int length = nodeList.getLength();
        for (int index = 0; index < length; ++index) {
            String value;
            Node upgradeable;
            String value2;
            Node requiresCustom;
            Node previousTypeNode;
            Node previousMetadataNode;
            Node metadataNode;
            NamedNodeMap attrs;
            Node publicTypeNode;
            Node node = nodeList.item(index);
            if (node.getNodeType() != 1 || (publicTypeNode = (attrs = node.getAttributes()).getNamedItem(ATTRIBUTE_PUBLIC_TYPE)) == null) continue;
            UpgradeRule rule = new UpgradeRule();
            rule.setPublicType(publicTypeNode.getNodeValue());
            Node versionNode = attrs.getNamedItem(ATTRIBUTE_USAGE_VERSION);
            if (versionNode != null) {
                rule.setUsageVersion(versionNode.getNodeValue());
            }
            if ((metadataNode = attrs.getNamedItem(ATTRIBUTE_CONECTIONPOINT_METADATATYPE)) != null) {
                rule.setConnectionPointMetadataType(metadataNode.getNodeValue());
            }
            if ((previousMetadataNode = attrs.getNamedItem(ATTRIBUTE_PREVIOUS_METADATA)) != null) {
                rule.setPreviousMetadataType(previousMetadataNode.getNodeValue());
            }
            if ((previousTypeNode = attrs.getNamedItem(ATTRIBUTE_PREVIOUS_PUBLIC)) != null) {
                rule.setPreviousPublicType(previousTypeNode.getNodeValue());
            }
            if ((requiresCustom = attrs.getNamedItem(ATTRIBUTE_CUSTOM_UPGRADE)) != null && ATTRIBUTE_VALUE_TRUE.equalsIgnoreCase(value2 = requiresCustom.getNodeValue())) {
                rule.setCustomUpgradeRequired(true);
            }
            if ((upgradeable = attrs.getNamedItem(ATTRIBUTE_IS_UPGRADEABLE)) != null && (value = upgradeable.getNodeValue()) != null) {
                if (value.equalsIgnoreCase(Boolean.FALSE.toString())) {
                    rule.setIsUpgradeable(false);
                } else if (value.equalsIgnoreCase(Boolean.TRUE.toString())) {
                    rule.setIsUpgradeable(true);
                }
            }
            this._rulesMap.put(publicTypeNode.getNodeValue(), rule);
        }
    }

    protected class UpgradeRule {
        private String _publicType;
        private String _usageVersion;
        private String _metadataType;
        private String _previousPublicType;
        private String _previousMetadataType;
        private boolean _requiresCustomUpgrade = false;
        private boolean _isUpgradeable = true;

        protected UpgradeRule() {
        }

        public String getPreviousMetadataType() {
            return this._previousMetadataType;
        }

        public String getPreviousPublicType() {
            return this._previousPublicType;
        }

        public String getPublicType() {
            return this._publicType;
        }

        public boolean isCustomUpgradeRequired() {
            return this._requiresCustomUpgrade;
        }

        public String getUsageVersion() {
            return this._usageVersion;
        }

        public void setPreviousMetadataType(String metadataType) {
            this._previousMetadataType = metadataType;
        }

        public void setPreviousPublicType(String publicType) {
            this._previousPublicType = publicType;
        }

        public void setPublicType(String type) {
            this._publicType = type;
        }

        public void setCustomUpgradeRequired(boolean customUpgrade) {
            this._requiresCustomUpgrade = customUpgrade;
        }

        public void setUsageVersion(String version) {
            this._usageVersion = version;
        }

        public String getConnectionPointMetadataType() {
            return this._metadataType;
        }

        public void setConnectionPointMetadataType(String metadataType) {
            this._metadataType = metadataType;
        }

        public boolean isUpgradeable() {
            return this._isUpgradeable;
        }

        public void setIsUpgradeable(boolean isUpgradeable) {
            this._isUpgradeable = isUpgradeable;
        }
    }
}

