/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.promotion;

import com.sas.metadata.logical.SimpleLogicalObjectInterface;
import com.sas.metadata.logical.TransportableTypeInterface;
import com.sas.metadata.promotion.BIPTreeUtil;
import com.sas.metadata.promotion.ExportItemInterface;
import com.sas.metadata.promotion.ImportItemInterface;
import com.sas.metadata.promotion.ImportListener;
import com.sas.metadata.promotion.ImportOperationInterface;
import com.sas.metadata.promotion.Log;
import com.sas.metadata.promotion.MetadataPromotionException;
import com.sas.metadata.promotion.ObjectMoveManager;
import com.sas.metadata.promotion.ObjectsSelectedListener;
import com.sas.metadata.promotion.PromotionInterface;
import com.sas.metadata.promotion.PromotionUtil;
import com.sas.metadata.promotion.PropertiesManager;
import com.sas.metadata.promotion.RB;
import com.sas.metadata.promotion.Substitution;
import com.sas.metadata.promotion.SubstitutionContextInterface;
import com.sas.metadata.promotion.SubstitutionInterface;
import com.sas.metadata.promotion.SubstitutionPropertyValue;
import com.sas.metadata.promotion.SubstitutionTypeInterface;
import com.sas.metadata.promotion.ValidationResponse;
import com.sas.services.ServiceException;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.PathUrl;
import com.sas.services.information.publicobject.ContentImportStatusInterface;
import com.sas.storage.editableproperties.LocalizableProperties;
import com.sas.storage.editableproperties.MultiLocaleProperties;
import com.sas.storage.editableproperties.PropertyList;
import com.sas.storage.editableproperties.PropertyMap;
import com.sas.storage.editableproperties.SectionedPropertyList;
import com.sas.storage.editableproperties.SectionedPropertyMap;
import com.sas.storage.editableproperties.SubstitutionProperties;
import com.sas.storage.editableproperties.UnexpectedLocalizationException;
import com.sas.storage.editableproperties.UnexpectedSubstitutionException;
import com.sas.text.Message;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;

public class SubstitutionPropertiesHandler
implements ObjectsSelectedListener {
    private static final String PROPERTY_FRAMEWORK = "Framework";
    private static final String PROPERTY_FOLDER_PATH = "FolderPath";
    private PropertiesManager _propManager;
    private PromotionInterface _operation;
    private Log _log;
    private Map<String, SubstitutionTypeInterface> _substitutionTypeMap;
    private Map<SubstitutionTypeInterface, List<SubstitutionInterface>> _substitutionValueMap;
    private SectionedPropertyMap _customDefinedSubstitutions;

    public SubstitutionPropertiesHandler(PropertiesManager propManager) {
        this._propManager = propManager;
        this._operation = propManager.getPromotionOperation();
        this._operation.addObjectsSelectedListener(this);
        this._log = propManager.getPromotionOperation().getLogger();
    }

    protected void reInitialize() {
        this._substitutionValueMap = null;
        this._substitutionTypeMap = null;
    }

    protected void exportSubstitutions(SectionedPropertyList localizedProperties, SectionedPropertyList substitutionProperties) {
        this._log.info(RB.getStringResource("SubstitutionPropertiesHandler.BeginExportProperties.Log.txt"));
        Map promotionItems = this._operation.getPromotionItems();
        for (String type : promotionItems.keySet()) {
            List objects = (List)promotionItems.get(type);
            TransportableTypeInterface pi = this._operation.getTransportableType(type);
            if (objects == null || pi == null) continue;
            Iterator iterObj = objects.iterator();
            while (iterObj.hasNext()) {
                try {
                    String msg;
                    PropertyList list;
                    ExportItemInterface obj = (ExportItemInterface)iterObj.next();
                    MetadataInterface smartObject = PromotionUtil.getSmartObject(this._operation, (SimpleLogicalObjectInterface)obj);
                    String objPath = BIPTreeUtil.pathToString(obj.getSourcePath(), obj.getName(), obj.getTypeInterface().getPublicType());
                    if (this._propManager.isProcessingLocalizableProperties() && smartObject instanceof LocalizableProperties) {
                        try {
                            list = ((LocalizableProperties)smartObject).getLocalizableProperties();
                            if (list != null && !list.isEmpty()) {
                                localizedProperties.addSection(objPath, list);
                            }
                        }
                        catch (UnexpectedLocalizationException e) {
                            msg = Message.format((ResourceBundle)RB.getResources(), (String)"SubstitutionPropertiesHandler.LocalizationExportException.fmt.txt", (Object)objPath);
                            this._log.error(msg);
                            this.logNestedException(e);
                        }
                        catch (RuntimeException e) {
                            msg = Message.format((ResourceBundle)RB.getResources(), (String)"SubstitutionPropertiesHandler.LocalizationExportException.fmt.txt", (Object)objPath);
                            this._log.error(msg);
                            this.logNestedException(e);
                        }
                    }
                    if (!this._propManager.isProcessingSubstitutionProperties() || !(smartObject instanceof SubstitutionProperties)) continue;
                    try {
                        list = ((SubstitutionProperties)smartObject).getSubstitutionProperties();
                        if (list == null || list.isEmpty()) continue;
                        substitutionProperties.addSection(objPath, list);
                    }
                    catch (UnexpectedSubstitutionException e) {
                        msg = Message.format((ResourceBundle)RB.getResources(), (String)"SubstitutionPropertiesHandler.SubstitutionExportException.fmt.txt", (Object)objPath);
                        this._log.error(msg);
                        this.logNestedException(e);
                    }
                    catch (RuntimeException e) {
                        msg = Message.format((ResourceBundle)RB.getResources(), (String)"SubstitutionPropertiesHandler.SubstitutionExportException.fmt.txt", (Object)objPath);
                        this._log.error(msg);
                        this.logNestedException(e);
                    }
                }
                catch (Exception e) {
                    this._log.error(RB.getStringResource("SubstitutionPropertiesHandler.PropertiesExportException.txt"));
                    this.logNestedException(e);
                }
            }
        }
    }

    protected int importSubstitutions(SectionedPropertyMap localizedProperties, SectionedPropertyMap substitutionProperties, Map<Locale, SectionedPropertyMap> multiLocaleProperties) {
        int rc = 0;
        this._log.info(RB.getStringResource("SubstitutionPropertiesHandler.BeginImportProperties.Log.txt"));
        if (substitutionProperties != null) {
            this.updateSubstitutions();
        }
        boolean importingLocalizableProperties = this.isImportingLocalizableProperties(localizedProperties, multiLocaleProperties);
        boolean importingSubstitutionProperties = this.isImportingSubstitutionProperties(substitutionProperties);
        if (!importingLocalizableProperties && !importingSubstitutionProperties) {
            return rc;
        }
        MetadataInterface smartObject = null;
        int objCount = 0;
        int locObjCount = 0;
        int subsObjCount = 0;
        Map promotionItems = this._operation.getPromotionItems();
        for (String type : promotionItems.keySet()) {
            List objects = (List)promotionItems.get(type);
            TransportableTypeInterface pi = this._operation.getTransportableType(type);
            if (objects == null || pi == null) continue;
            for (ImportItemInterface obj : objects) {
                block27: {
                    String targetID = obj.getTargetID();
                    if (targetID == null) continue;
                    try {
                        String msg;
                        String sectionName = this.getSectionNameForObject(obj);
                        if (!this.isObjectContainedInProperties(sectionName, localizedProperties, multiLocaleProperties, substitutionProperties)) continue;
                        smartObject = PromotionUtil.getSmartObject(this._operation, targetID, obj.getTypeInterface().getMetadataType());
                        if (smartObject == null) {
                            throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"SubstitutionPropertiesHandler.NoTargetObject.fmt.txt", (Object)obj.getTypeInterface().getDisplayType(), (Object)obj.toString()));
                        }
                        ++objCount;
                        if (smartObject instanceof ContentImportStatusInterface) {
                            ((ContentImportStatusInterface)smartObject).setContentAvailable(false);
                        }
                        if (importingLocalizableProperties) {
                            String msg2;
                            boolean objectLocalized = false;
                            try {
                                Object map;
                                if (localizedProperties != null && (map = localizedProperties.getSection(sectionName)) != null && smartObject instanceof LocalizableProperties) {
                                    ((LocalizableProperties)smartObject).setLocalizableProperties((PropertyMap)map);
                                    objectLocalized = true;
                                }
                                if (multiLocaleProperties != null && smartObject instanceof MultiLocaleProperties) {
                                    map = multiLocaleProperties.keySet().iterator();
                                    while (map.hasNext()) {
                                        Locale locale = (Locale)map.next();
                                        SectionedPropertyMap maps = multiLocaleProperties.get(locale);
                                        PropertyMap localeMap = maps.getSection(sectionName);
                                        if (localeMap == null) continue;
                                        ((MultiLocaleProperties)smartObject).setLocalizableProperties(locale, localeMap);
                                        objectLocalized = true;
                                    }
                                }
                            }
                            catch (UnexpectedLocalizationException e) {
                                msg2 = Message.format((ResourceBundle)RB.getResources(), (String)"SubstitutionPropertiesHandler.LocalizationImportException.fmt.txt", (Object)sectionName);
                                this._log.error(msg2);
                                this.logNestedException(e);
                                rc |= 4;
                            }
                            catch (RuntimeException e) {
                                msg2 = Message.format((ResourceBundle)RB.getResources(), (String)"SubstitutionPropertiesHandler.LocalizationImportException.fmt.txt", (Object)sectionName);
                                this._log.error(msg2);
                                this.logNestedException(e);
                                rc |= 4;
                            }
                            if (objectLocalized) {
                                ++locObjCount;
                            }
                        }
                        if (!importingSubstitutionProperties) break block27;
                        try {
                            PropertyMap map = substitutionProperties.getSection(sectionName);
                            if (map != null && smartObject instanceof SubstitutionProperties) {
                                ((SubstitutionProperties)smartObject).setSubstitutionProperties(map);
                                ++subsObjCount;
                            }
                        }
                        catch (UnexpectedSubstitutionException e) {
                            msg = Message.format((ResourceBundle)RB.getResources(), (String)"SubstitutionPropertiesHandler.SubstitutionImportException.fmt.txt", (Object)sectionName);
                            this._log.error(msg);
                            this.logNestedException(e);
                            rc |= 4;
                        }
                        catch (RuntimeException e) {
                            msg = Message.format((ResourceBundle)RB.getResources(), (String)"SubstitutionPropertiesHandler.SubstitutionImportException.fmt.txt", (Object)sectionName);
                            this._log.error(msg);
                            this.logNestedException(e);
                            rc |= 4;
                        }
                    }
                    catch (Exception e) {
                        this._log.error(Message.format((ResourceBundle)RB.getResources(), (String)"SubstitutionPropertiesHandler.PropertiesImportException.fmt.txt", (Object)obj.toString()));
                        this.logNestedException(e);
                        rc |= 4;
                    }
                }
                if (objCount < 25 || smartObject == null) continue;
                try {
                    smartObject.update();
                    objCount = 0;
                }
                catch (Exception e) {
                    this._log.warn(RB.getStringResource("SubstitutionPropertiesHandler.PropertiesUpdateException.txt"));
                    this.logNestedException(e);
                    rc |= 4;
                }
            }
        }
        if (objCount > 0 && smartObject != null) {
            try {
                smartObject.update();
            }
            catch (Exception e) {
                this._log.warn(RB.getStringResource("SubstitutionPropertiesHandler.PropertiesUpdateException.txt"));
                this.logNestedException(e);
                rc |= 4;
            }
        }
        if (importingLocalizableProperties) {
            this._log.info(Message.format((ResourceBundle)RB.getResources(), (String)"SubstitutionPropertiesHandler.ImportedLocalizableProperties.fmt.txt", (Object)new Integer(locObjCount)));
        }
        if (importingSubstitutionProperties) {
            this._log.info(Message.format((ResourceBundle)RB.getResources(), (String)"SubstitutionPropertiesHandler.ImportedSubstitutionProperties.fmt.txt", (Object)new Integer(subsObjCount)));
        }
        return rc;
    }

    private boolean isObjectContainedInProperties(String sectionName, SectionedPropertyMap localizedProperties, Map<Locale, SectionedPropertyMap> multiLocaleProperties, SectionedPropertyMap substitutionProperties) {
        if (substitutionProperties != null && substitutionProperties.containsSection(sectionName)) {
            return true;
        }
        if (localizedProperties != null && localizedProperties.containsSection(sectionName)) {
            return true;
        }
        if (multiLocaleProperties != null) {
            for (Map.Entry<Locale, SectionedPropertyMap> entry : multiLocaleProperties.entrySet()) {
                SectionedPropertyMap map = entry.getValue();
                if (map == null || !map.containsSection(sectionName)) continue;
                return true;
            }
        }
        return false;
    }

    private void logNestedException(Throwable throwable) {
        for (Throwable t = throwable; t != null; t = t.getCause()) {
            String msg = t.getLocalizedMessage();
            if (msg == null || msg.length() <= 0) continue;
            this._log.error("  " + msg);
        }
        this._log.debug((Object)"Cause:", throwable);
    }

    private boolean isImportingLocalizableProperties(SectionedPropertyMap localizedProperties, Map<Locale, SectionedPropertyMap> multiLocaleProperties) {
        if (localizedProperties != null && localizedProperties.getSections().size() > 0) {
            return true;
        }
        return multiLocaleProperties != null && multiLocaleProperties.size() > 0;
    }

    private boolean isImportingSubstitutionProperties(SectionedPropertyMap substitutionProperties) {
        Collection sections;
        if (substitutionProperties != null && (sections = substitutionProperties.getSections()).size() > 0) {
            for (String sectionName : sections) {
                if (sectionName.length() <= 0 || sectionName.indexOf("Connections: ") != -1) continue;
                return true;
            }
        }
        return false;
    }

    private void updateSubstitutions() {
        if (this._propManager.isPromptingForSubstitutions() && this._substitutionValueMap != null) {
            this._log.debug("Processing substitution value changes");
            for (SubstitutionTypeInterface type : this._substitutionValueMap.keySet()) {
                List<SubstitutionInterface> substitutions = this._substitutionValueMap.get(type);
                if (substitutions == null || substitutions.size() <= 0) continue;
                for (SubstitutionInterface sub : substitutions) {
                    if (!this.isSubstitutionModified(sub)) continue;
                    String sourceValue = sub.getSourceValue();
                    String targetValue = sub.getTargetValue();
                    Collection<SubstitutionPropertyValue> propertyValues = sub.getAssociatedPropertyValues();
                    for (SubstitutionPropertyValue property : propertyValues) {
                        String propName = property.getPropertyName();
                        PropertyMap propMap = property.getAssociatedPropertyMap();
                        if (propMap == null) continue;
                        if (propMap.containsProperty(propName)) {
                            String contextName;
                            String source = this.getPropertyValue(propMap, propName);
                            if (sourceValue == null || !sourceValue.equals(source)) continue;
                            if (!sourceValue.equals(targetValue)) {
                                propMap.setProperty(propName, targetValue);
                                if (this._log.isDebugEnabled()) {
                                    this._log.debug("Substitution value updated from \"" + sourceValue + "\" to \"" + targetValue + "\".");
                                }
                            }
                            if (sub.getContextValue() == null || sub.getContextValue().equals(sub.getTargetContextValue()) || (contextName = property.getContextName()) == null || !propMap.containsProperty(contextName)) continue;
                            propMap.setProperty(contextName, sub.getTargetContextValue());
                            if (!this._log.isDebugEnabled()) continue;
                            this._log.debug("Context value for substitution has been updated from \"" + sub.getContextValue() + "\" to \"" + sub.getTargetContextValue() + "\".");
                            continue;
                        }
                        propMap.setProperty(propName, targetValue);
                        if (!this._log.isDebugEnabled()) continue;
                        this._log.debug("Substitution value added for \"" + targetValue + "\".");
                    }
                }
            }
        }
    }

    private boolean isSubstitutionModified(SubstitutionInterface sub) {
        if (sub.getSourceValue() != null && !sub.getSourceValue().equals(sub.getTargetValue())) {
            return true;
        }
        return sub.getContextValue() != null && !sub.getContextValue().equals(sub.getTargetContextValue());
    }

    protected int validateSubstitutions(SectionedPropertyMap substitutionProperties) {
        int rc = 0;
        boolean importingSubstitutionProperties = this.isImportingSubstitutionProperties(substitutionProperties);
        if (this._propManager.isPromptingForSubstitutions() || !importingSubstitutionProperties) {
            return rc;
        }
        try {
            this._log.info(RB.getStringResource("SubstitutionPropertiesHandler.Validating.txt"));
            Map<SubstitutionTypeInterface, List<SubstitutionInterface>> substitutionMap = this.getRegisteredSubstitutions(substitutionProperties);
            if (substitutionMap != null) {
                for (SubstitutionTypeInterface type : substitutionMap.keySet()) {
                    List<SubstitutionInterface> substitutions = substitutionMap.get(type);
                    if (substitutions == null || substitutions.size() <= 0) continue;
                    for (SubstitutionInterface sub : substitutions) {
                        sub.setTargetValue(sub.getSourceValue());
                        if (type instanceof SubstitutionContextInterface) {
                            String targetContext = ((SubstitutionContextInterface)((Object)type)).getTargetContextValue(sub, (ImportOperationInterface)this._operation);
                            sub.setTargetContextValue(targetContext);
                        }
                        try {
                            ValidationResponse response = new ValidationResponse();
                            type.validate(response, (ImportOperationInterface)this._operation, sub);
                            switch (response.getReturnCode()) {
                                case 1: {
                                    this._log.warn(response.getMessage());
                                    rc |= 4;
                                    break;
                                }
                                case 2: {
                                    this._log.error(response.getMessage());
                                    rc |= 8;
                                }
                            }
                        }
                        catch (Exception e) {
                            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"SubstitutionPropertiesHandler.ValidateFailure.fmt.txt", (Object)sub.getTargetValue(), (Object)e.getLocalizedMessage());
                            this._log.info(msg);
                            this._log.debug((Object)"Validation error", e);
                        }
                    }
                }
            }
        }
        catch (MetadataPromotionException e) {
            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"SubstitutionPropertiesHandler.ValidateFailureGeneric.fmt.txt", (Object)e.getLocalizedMessage());
            this._log.info(msg);
            this._log.debug((Object)"Validation error", (Throwable)((Object)e));
        }
        return rc;
    }

    protected void createSubstitutionProperty(SectionedPropertyMap substitutionProperties, ImportItemInterface importItem, String propertyName, String propertyValue) {
        String sectionName = this.getSectionNameForObject(importItem);
        PropertyMap propertyMap = null;
        if (substitutionProperties.containsSection(sectionName)) {
            propertyMap = substitutionProperties.getSection(sectionName);
        } else {
            propertyMap = new PropertyMap();
            substitutionProperties.setSection(sectionName, propertyMap);
        }
        propertyMap.setProperty(propertyName, propertyValue);
        if (this._customDefinedSubstitutions == null) {
            this._customDefinedSubstitutions = new SectionedPropertyMap();
        }
        if (!this._customDefinedSubstitutions.containsSection(sectionName)) {
            this._customDefinedSubstitutions.setSection(sectionName, propertyMap);
        }
    }

    protected String getSubstitutionPropertyValue(SectionedPropertyMap substitutionProperties, ImportItemInterface importItem, String propertyName) {
        String sectionName = this.getSectionNameForObject(importItem);
        if (substitutionProperties.containsSection(sectionName)) {
            PropertyMap propertyMap = substitutionProperties.getSection(sectionName);
            return this.getPropertyValue(propertyMap, propertyName);
        }
        return null;
    }

    protected void removeSubstitutionProperty(SectionedPropertyMap substitutionProperties, ImportItemInterface importItem, String propertyName) {
        PropertyMap propertyMap;
        String sectionName = this.getSectionNameForObject(importItem);
        if (substitutionProperties.containsSection(sectionName) && (propertyMap = substitutionProperties.getSection(sectionName)).containsProperty(propertyName)) {
            propertyMap.removeProperty(propertyName);
        }
    }

    protected void addCustomDefinedSubstitutions() throws MetadataPromotionException {
        if (this._customDefinedSubstitutions != null) {
            this.loadRegisteredSubstitutions(this._customDefinedSubstitutions);
        }
    }

    protected Map<SubstitutionTypeInterface, List<SubstitutionInterface>> getRegisteredSubstitutions(SectionedPropertyMap substitutionProperties) throws MetadataPromotionException {
        if (this._substitutionValueMap == null) {
            this._substitutionValueMap = new LinkedHashMap<SubstitutionTypeInterface, List<SubstitutionInterface>>();
            this.loadRegisteredSubstitutions(substitutionProperties);
        }
        return this._substitutionValueMap;
    }

    private void loadRegisteredSubstitutions(SectionedPropertyMap substitutionProperties) throws MetadataPromotionException {
        List<String> sections = this.getSubstitutionSections(substitutionProperties);
        if (sections == null || sections.size() == 0) {
            return;
        }
        List<SubstitutionTypeInterface> substitutionTypes = this.getSubstitutionTypes();
        for (SubstitutionTypeInterface type : substitutionTypes) {
            String propertyName = type.getSubstitutionTypeName();
            if (propertyName == null) continue;
            String contextName = null;
            if (type instanceof SubstitutionContextInterface) {
                contextName = ((SubstitutionContextInterface)((Object)type)).getContextName();
            }
            for (String sectionName : sections) {
                List<SubstitutionPropertyValue> values;
                ImportItemInterface importItem;
                PropertyMap propertyMap = substitutionProperties.getSection(sectionName);
                String[] propertyNames = propertyMap.getPropertiesBySuffix(propertyName);
                if (propertyNames == null || propertyNames.length <= 0) continue;
                sectionName = sectionName.trim();
                PathUrl objectPath = null;
                try {
                    objectPath = PathUrl.newPathUrlFromAbsolutePath((ServerInterface)this._operation.getServer(), (String)sectionName);
                }
                catch (Exception e) {
                    String msg = Message.format((ResourceBundle)RB.getResources(), (String)"SubstitutionPropertiesHandler.InvalidPath.fmt.txt", (Object)sectionName);
                    this._log.warn(msg);
                    continue;
                }
                if (objectPath == null || (importItem = (ImportItemInterface)this._operation.getPromotionItem(objectPath, true)) == null || (values = this.getPropertyValues(propertyNames, propertyMap, contextName)).size() <= 0) continue;
                for (SubstitutionPropertyValue value : values) {
                    String propertyValue = value.getPropertyValue();
                    String contextValue = value.getContextValue();
                    if (propertyValue == null) continue;
                    SubstitutionInterface sub = this.createSubstitution(type, importItem, propertyValue, contextValue);
                    if (sub != null) {
                        sub.addAssociatedObject(importItem, value);
                    }
                    if (!this._log.isDebugEnabled()) continue;
                    this._log.debug("Creating substitution value \"" + value + "\" for \"" + importItem + "\".");
                }
            }
        }
    }

    private List<SubstitutionPropertyValue> getPropertyValues(String[] propertyNames, PropertyMap propertyMap, String contextName) {
        ArrayList<SubstitutionPropertyValue> valuesList = new ArrayList<SubstitutionPropertyValue>(5);
        for (String propName : propertyNames) {
            ContextWrapper context;
            String propValue = this.getPropertyValue(propertyMap, propName);
            if (propValue == null) continue;
            SubstitutionPropertyValue value = null;
            value = contextName == null ? new SubstitutionPropertyValue(propName, propValue) : ((context = this.getContext(propName, contextName, propertyMap)) == null ? new SubstitutionPropertyValue(propName, propValue) : new SubstitutionPropertyValue(propName, propValue, context.getContextPropertyName(), context.getContextPropertyValue()));
            value.setAssociatedPropertyMap(propertyMap);
            valuesList.add(value);
        }
        return valuesList;
    }

    private String getPropertyValue(PropertyMap propertyMap, String propName) {
        String value = propertyMap.getProperty(propName);
        return value == null ? null : value.trim();
    }

    private String getPropertyValue(PropertyMap propertyMap, String propName, int index) {
        String value = propertyMap.getProperty(propName, index);
        return value == null ? null : value.trim();
    }

    private ContextWrapper getContext(String propertyName, String contextName, PropertyMap propertyMap) {
        String name = propertyName + "." + contextName;
        if (propertyMap.containsProperty(name)) {
            return new ContextWrapper(name, this.getPropertyValue(propertyMap, name));
        }
        int[] indexes = propertyMap.getPropertyIndexes(name);
        if (indexes != null && indexes.length > 0) {
            String cn = PropertyMap.makeIndexedPropertyName((String)name, (int)indexes[0]);
            return new ContextWrapper(cn, this.getPropertyValue(propertyMap, name, indexes[0]));
        }
        if (propertyMap.containsProperty(contextName)) {
            return new ContextWrapper(contextName, this.getPropertyValue(propertyMap, contextName));
        }
        if (propertyMap.containsIndexedProperty(contextName, 1)) {
            String cn = PropertyMap.makeIndexedPropertyName((String)contextName, (int)1);
            return new ContextWrapper(cn, this.getPropertyValue(propertyMap, contextName, 1));
        }
        return null;
    }

    private List<SubstitutionTypeInterface> getSubstitutionTypes() throws MetadataPromotionException {
        if (this._substitutionTypeMap != null) {
            return new ArrayList<SubstitutionTypeInterface>(this._substitutionTypeMap.values());
        }
        this._substitutionTypeMap = new LinkedHashMap<String, SubstitutionTypeInterface>();
        ArrayList<SubstitutionTypeInterface> typesList = new ArrayList<SubstitutionTypeInterface>();
        HashSet<String> nameCache = new HashSet<String>();
        Map objectMap = this._operation.getPromotionItems();
        for (String publicType : objectMap.keySet()) {
            Class[] substitutionTypes;
            ImportListener listener;
            TransportableTypeInterface type = this._operation.getTransportableType(publicType);
            if (type == null || (listener = (ImportListener)type.getImportListener()) == null || (substitutionTypes = listener.getSubstitutionTypes()) == null) continue;
            for (int index = 0; index < substitutionTypes.length; ++index) {
                Class c = substitutionTypes[index];
                String className = c.getName();
                if (nameCache.contains(className)) continue;
                SubstitutionTypeInterface substitutionType = this._substitutionTypeMap.get(className);
                if (substitutionType == null) {
                    try {
                        substitutionType = (SubstitutionTypeInterface)c.newInstance();
                        this._substitutionTypeMap.put(className, substitutionType);
                    }
                    catch (Exception e) {
                        String msg = Message.format((ResourceBundle)RB.getResources(), (String)"SubstitutionPropertiesHandler.ClassLoadError.fmt.txt", (Object)substitutionType.getLocalizedTypeName());
                        throw new MetadataPromotionException(e, msg);
                    }
                }
                typesList.add(substitutionType);
                nameCache.add(className);
            }
        }
        return typesList;
    }

    private List<String> getSubstitutionSections(SectionedPropertyMap substitutionProperties) {
        ArrayList<String> propertiesList = new ArrayList<String>();
        Collection sections = substitutionProperties.getSections();
        for (String sectionName : sections) {
            if (sectionName.indexOf("Connections: ") != -1) continue;
            propertiesList.add(sectionName);
        }
        return propertiesList;
    }

    protected SubstitutionInterface createSubstitution(SubstitutionTypeInterface type, ImportItemInterface importItem, String propertyValue, String contextValue) {
        ArrayList<SubstitutionInterface> substitutions;
        if (!this._substitutionValueMap.containsKey(type)) {
            substitutions = new ArrayList();
            this._substitutionValueMap.put(type, substitutions);
        }
        if ((substitutions = this._substitutionValueMap.get(type)) != null) {
            SubstitutionInterface sub = this.getSubstitution(substitutions, propertyValue, contextValue);
            if (sub == null) {
                List<SubstitutionInterface> subList;
                boolean create = true;
                if (this._customDefinedSubstitutions != null && (subList = importItem.getSubstitutions()) != null && !subList.isEmpty()) {
                    for (SubstitutionInterface original : subList) {
                        if (!type.getSubstitutionTypeName().equals(original.getSubstitutionType().getSubstitutionTypeName()) || !propertyValue.equals(original.getSourceValue()) || contextValue == null || !contextValue.equals(original.getContextValue())) continue;
                        sub = original;
                        create = false;
                        break;
                    }
                }
                if (create) {
                    sub = new Substitution(type, propertyValue, contextValue);
                }
                substitutions.add(sub);
            }
            return sub;
        }
        return null;
    }

    private SubstitutionInterface getSubstitution(List<SubstitutionInterface> substitutions, String value, String context) {
        for (SubstitutionInterface sub : substitutions) {
            String subValue = sub.getSourceValue();
            if (!subValue.equals(value) || context != null && !context.equals(sub.getContextValue())) continue;
            return sub;
        }
        return null;
    }

    private String getSectionNameForObject(ImportItemInterface importItem) {
        return BIPTreeUtil.pathToString(importItem.getSourcePath(), importItem.getOriginalName(), importItem.getTypeInterface().getPublicType());
    }

    private boolean containsObjectSubstitutions(SectionedPropertyMap propertyMap) {
        Collection sections = propertyMap.getSections();
        if (sections.size() > 0) {
            for (String sectionName : sections) {
                if (sectionName.indexOf("Connections: ") != -1) continue;
                return true;
            }
        }
        return false;
    }

    public void applyFrameworkSubstitutions(SectionedPropertyMap substitutionPropertyMap, List importItems) throws MetadataPromotionException {
        if (this.containsObjectSubstitutions(substitutionPropertyMap)) {
            this._log.info(RB.getStringResource("SubstitutionPropertiesHandler.ApplyInitial.txt"));
            for (ImportItemInterface importItem : importItems) {
                String targetPath;
                PropertyMap propMap;
                PropertyMap properties;
                String sourcePath = this.getSectionNameForObject(importItem);
                if (!substitutionPropertyMap.containsSection(sourcePath) || (properties = (propMap = substitutionPropertyMap.getSection(sourcePath)).getNestedProperties(PROPERTY_FRAMEWORK)) == null || !properties.containsProperty(PROPERTY_FOLDER_PATH) || (targetPath = properties.getProperty(PROPERTY_FOLDER_PATH)) == null || targetPath.length() <= 0) continue;
                this.moveImportItem(importItem, targetPath);
            }
        }
    }

    private void moveImportItem(ImportItemInterface importItem, String targetPath) throws MetadataPromotionException {
        try {
            MetadataInterface mi;
            ServerInterface server = this._operation.getServer();
            PathUrl path = PathUrl.newPathUrlFromAbsolutePath((ServerInterface)server, (String)targetPath);
            if (path.getType() == null) {
                path.setType("Folder");
            }
            if ((mi = server.getObjectByPath(path)) == null) {
                throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"SubstitutionPropertiesHandler.InvalidTargetPath.fmt.txt", (Object)path.getDisplayPath()));
            }
            if (!(mi instanceof FolderInterface)) {
                throw new ServiceException(RB.getStringResource("SubstitutionPropertiesHandler.InvalidTargetFolderPath.txt"));
            }
            this._log.info(Message.format((ResourceBundle)RB.getResources(), (String)"SubstitutionPropertiesHandler.SettingTargetPath.fmt.txt", (Object)importItem.getTypeInterface().getDisplayType(), (Object)importItem.getName(), (Object)path.getDisplayPath()));
            ObjectMoveManager manager = ObjectMoveManager.getInstance((ImportOperationInterface)this._operation);
            manager.setCustomTargetPath(importItem.getID(), importItem.getName(), importItem.getTypeInterface().getPublicType(), path);
        }
        catch (Exception e) {
            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"SubstitutionPropertiesHandler.PathError.fmt.txt", (Object)importItem.getTypeInterface().getDisplayType(), (Object)importItem.getName(), (Object)targetPath, (Object)e.getLocalizedMessage());
            throw new MetadataPromotionException(e, msg);
        }
    }

    protected void applyNameLocalizationChanges(SectionedPropertyMap localizedProperties, List importItems) {
        this._log.info(RB.getStringResource("SubstitutionPropertiesHandler.RenameObjects.txt"));
        Map<String, String> namePropertyMap = this.getNameProperties(localizedProperties);
        if (namePropertyMap != null) {
            for (ImportItemInterface importItem : importItems) {
                String sourcePath = BIPTreeUtil.pathToString(importItem.getSourcePath(), importItem.getName(), importItem.getTypeInterface().getPublicType());
                if (!namePropertyMap.containsKey(sourcePath)) continue;
                String newName = namePropertyMap.get(sourcePath);
                if (importItem.getName().equals(newName)) continue;
                importItem.rename(newName);
                if (!this._log.isDebugEnabled()) continue;
                String displayType = importItem.getTypeInterface().getDisplayType();
                this._log.debug("Renaming " + displayType + " \"" + importItem.getOriginalName() + "\" to \"" + newName + "\".");
            }
        }
    }

    private Map<String, String> getNameProperties(SectionedPropertyMap localizedProperties) {
        LinkedHashMap<String, String> namePropertyMap = null;
        Collection sections = localizedProperties.getSections();
        if (sections.size() > 0) {
            for (String sectionName : sections) {
                PropertyMap propertyMap = localizedProperties.getSection(sectionName);
                if (!propertyMap.containsProperty("Name")) continue;
                if (namePropertyMap == null) {
                    namePropertyMap = new LinkedHashMap<String, String>();
                }
                namePropertyMap.put(sectionName, propertyMap.getProperty("Name"));
            }
        }
        return namePropertyMap;
    }

    @Override
    public void objectsSelected(Map selectedItems) {
        this._substitutionValueMap = null;
    }

    protected static void generateSubpropInstructions(PropertyList propertyList) {
        String emptyComment = "#";
        propertyList.addBlankLine();
        propertyList.addComment(RB.getStringResource("SubstitutionPropertiesHandler.HeaderBegin.txt"));
        propertyList.addComment("#");
        propertyList.addComment(RB.getStringResource("SubstitutionPropertiesHandler.Header1.txt"));
        propertyList.addComment(RB.getStringResource("SubstitutionPropertiesHandler.Header2.txt"));
        propertyList.addComment(RB.getStringResource("SubstitutionPropertiesHandler.Header3.txt"));
        propertyList.addComment(RB.getStringResource("SubstitutionPropertiesHandler.Header4.txt"));
        propertyList.addComment("#");
        propertyList.addComment(RB.getStringResource("SubstitutionPropertiesHandler.Header5.txt"));
        propertyList.addComment(RB.getStringResource("SubstitutionPropertiesHandler.Header6.txt"));
        propertyList.addComment(RB.getStringResource("SubstitutionPropertiesHandler.Header7.txt"));
        String connectionsKeyword = "[Connections]";
        propertyList.addComment(Message.format((ResourceBundle)RB.getResources(), (String)"SubstitutionPropertiesHandler.Header8.fmt.txt", (Object)"[Connections]"));
        propertyList.addComment("#");
        propertyList.addComment(RB.getStringResource("SubstitutionPropertiesHandler.Header9.txt"));
        propertyList.addComment(RB.getStringResource("SubstitutionPropertiesHandler.Header10.txt"));
        String targetKeyword1 = "TargetName";
        String targetKeyword2 = "TargetPath";
        String targetKeyword3 = "TargetDirectory";
        propertyList.addComment(Message.format((ResourceBundle)RB.getResources(), (String)"SubstitutionPropertiesHandler.Header11.fmt.txt", (Object)"TargetName", (Object)"TargetPath", (Object)"TargetDirectory"));
        propertyList.addComment("#");
        propertyList.addComment(RB.getStringResource("SubstitutionPropertiesHandler.Header12.txt"));
        propertyList.addComment(RB.getStringResource("SubstitutionPropertiesHandler.Header13.txt"));
        String sourceExample = "ApplicationServer[1].SourceName=SASMain";
        String targetExample = "ApplicationServer[1].TargetName=SAS Application Server";
        propertyList.addComment("ApplicationServer[1].SourceName=SASMain");
        propertyList.addComment("ApplicationServer[1].TargetName=SAS Application Server");
        String sourceServerValue = "SASMain";
        String targetServerValue = "SAS Application Server";
        propertyList.addComment("#");
        propertyList.addComment(RB.getStringResource("SubstitutionPropertiesHandler.Header14.txt"));
        propertyList.addComment(Message.format((ResourceBundle)RB.getResources(), (String)"SubstitutionPropertiesHandler.Header15.fmt.txt", (Object)"SASMain"));
        propertyList.addComment(Message.format((ResourceBundle)RB.getResources(), (String)"SubstitutionPropertiesHandler.Header16.fmt.txt", (Object)"SAS Application Server"));
        String dirPathKeyword = "DirPath";
        String pathKeyword = "Path";
        String serverKeyword = "ApplicationServer";
        propertyList.addComment("#");
        propertyList.addComment(RB.getStringResource("SubstitutionPropertiesHandler.Header17.txt"));
        propertyList.addComment(RB.getStringResource("SubstitutionPropertiesHandler.Header18.txt"));
        propertyList.addComment(RB.getStringResource("SubstitutionPropertiesHandler.Header19.txt"));
        propertyList.addComment(RB.getStringResource("SubstitutionPropertiesHandler.Header20.txt"));
        propertyList.addComment("#");
        propertyList.addComment(RB.getStringResource("SubstitutionPropertiesHandler.Header21.txt"));
        propertyList.addComment(RB.getStringResource("SubstitutionPropertiesHandler.Header22.txt"));
        propertyList.addComment(Message.format((ResourceBundle)RB.getResources(), (String)"SubstitutionPropertiesHandler.Header23.fmt.txt", (Object)"DirPath"));
        propertyList.addComment(Message.format((ResourceBundle)RB.getResources(), (String)"SubstitutionPropertiesHandler.Header24.fmt.txt", (Object)"Path"));
        propertyList.addComment(Message.format((ResourceBundle)RB.getResources(), (String)"SubstitutionPropertiesHandler.Header25.fmt.txt", (Object)"ApplicationServer"));
        propertyList.addComment("#");
        propertyList.addComment(RB.getStringResource("SubstitutionPropertiesHandler.HeaderEnd.txt"));
    }

    protected static void generateLocpropInstructions(PropertyList propertyList) {
        String emptyComment = "#";
        propertyList.addBlankLine();
        propertyList.addComment(RB.getStringResource("SubstitutionPropertiesHandler.HeaderBegin.txt"));
        propertyList.addComment("#");
        propertyList.addComment("This property file can be used during a batch import process");
        propertyList.addComment("to apply specific localization changes to the objects being imported.");
        propertyList.addComment("#");
        propertyList.addComment("NOTE: the following restrictions apply when localizing metadata values:");
        propertyList.addComment("1. All Name properties must be limited to 60 characters or less");
        propertyList.addComment("2. All Description properties must be limited to 200 characters or less");
        propertyList.addComment("#");
        propertyList.addComment(RB.getStringResource("SubstitutionPropertiesHandler.HeaderEnd.txt"));
    }

    private class ContextWrapper {
        private String _name;
        private String _value;

        public ContextWrapper(String contextPropName, String contextPropValue) {
            this._name = contextPropName;
            this._value = contextPropValue;
        }

        public String getContextPropertyName() {
            return this._name;
        }

        public String getContextPropertyValue() {
            return this._value;
        }
    }
}

