/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.promotion;

import com.sas.metadata.promotion.ConnectionManagerInterface;
import com.sas.metadata.promotion.ConnectionObjectType;
import com.sas.metadata.promotion.ConnectionPointInterface;
import com.sas.metadata.promotion.ImportItemInterface;
import com.sas.metadata.promotion.ImportOperationInterface;
import com.sas.metadata.promotion.Log;
import com.sas.metadata.promotion.PromotionItemInterface;
import com.sas.metadata.promotion.RB;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Identity;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdResponsibilitiesUtil;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.ResponsibleParty;
import com.sas.metadata.remote.Root;
import com.sas.text.Message;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;

public class ResponsiblePartyHandler {
    private static final String AUTHOR_RESPONSIBILITY_NAME = "Author";
    private static final String AUTHOR_RESPONSIBILITY_ROLE = "owner";
    private static final String PERSON_SEARCH_ATTRIBUTE_PREFIX = "[Persons/";
    private static final String ROLE_SEARCH_ATTRIBUTE_PREFIX = "@Role='";
    private ImportOperationInterface _importOperation;
    private Map<String, Root> _objectCache;
    private Log _log;
    private boolean _logWarnings = true;
    private int _rc = 0;
    private static List<String> _rpAssocList = new ArrayList<String>(1);

    public ResponsiblePartyHandler(ImportOperationInterface operation) {
        this._importOperation = operation;
        this._log = operation.getLogger();
        this._objectCache = new HashMap<String, Root>();
    }

    public void setLogWarnings(boolean logWarnings) {
        this._logWarnings = logWarnings;
    }

    public List<ConnectionPointInterface> getAllResponsiblePartyConnections() {
        ConnectionManagerInterface manager = this._importOperation.getConnectionManager();
        return manager.getConnections(ConnectionObjectType.MetadataType, "ResponsibleParty");
    }

    public int connectResponsibleParties(Map selectedObjectsToImport) throws MdException, RemoteException {
        List<ImportItemInterface> importItems = this.getAllImportedItems(selectedObjectsToImport);
        this.clearExistingResponsibleParties(importItems);
        List<ConnectionPointInterface> connectionPoints = this.getResponsiblePartyConnections(importItems);
        for (ConnectionPointInterface pt : connectionPoints) {
            ResponsibleParty responsibleParty;
            if (this._log.isDebugEnabled()) {
                String msg = Message.format((ResourceBundle)RB.getResources(), (String)"ResponsiblePartyHandler.ProcessingCP.fmt.txt", (Object)pt.getName());
                this._log.debug(msg);
            }
            if ((responsibleParty = this.getResponsibleParty(pt)) == null) continue;
            List<PromotionItemInterface> associatedObjects = pt.getAssociatedObjects();
            for (ImportItemInterface importItemInterface : associatedObjects) {
                if (importItemInterface.getImportState() == 0) continue;
                try {
                    Root metaObject = this.getMetadataObject(this._importOperation.getStore(), importItemInterface);
                    AssociationList assoc = metaObject.getResponsibleParties();
                    if (assoc.contains(responsibleParty)) continue;
                    assoc.add(responsibleParty);
                }
                catch (Exception e) {
                    String msg = Message.format((ResourceBundle)RB.getResources(), (String)"ResponsiblePartyHandler.ObjectNotFound.fmt.txt", (Object)importItemInterface.getTypeInterface().getDisplayType(), (Object)importItemInterface.getName());
                    if (this._logWarnings) {
                        this._log.error(msg);
                        this._rc |= 8;
                        continue;
                    }
                    if (!this._log.isDebugEnabled()) continue;
                    this._log.debug(msg);
                }
            }
            try {
                responsibleParty.updateMetadataAll();
            }
            catch (MdException e) {
                if (!this._logWarnings) continue;
                throw e;
            }
        }
        this.setCreatedModifiedByInfo(importItems);
        this._objectCache.clear();
        return this._rc;
    }

    private List<ImportItemInterface> getAllImportedItems(Map selectedObjectsToImport) {
        ArrayList<ImportItemInterface> allObjects = new ArrayList<ImportItemInterface>();
        if (selectedObjectsToImport != null) {
            Collection collection = selectedObjectsToImport.values();
            for (List items : collection) {
                allObjects.addAll(items);
            }
        }
        return allObjects;
    }

    private List<ConnectionPointInterface> getResponsiblePartyConnections(List<ImportItemInterface> importItems) {
        ArrayList<ConnectionPointInterface> connectionPoints = new ArrayList<ConnectionPointInterface>();
        if (importItems.size() > 0) {
            ConnectionManagerInterface manager = this._importOperation.getConnectionManager();
            List<ConnectionPointInterface> connections = manager.getDirectConnections();
            for (ConnectionPointInterface pt : connections) {
                if (!pt.getMetadataType().equalsIgnoreCase("ResponsibleParty") || !this.isAssociatedToImportedObject(pt, importItems)) continue;
                connectionPoints.add(pt);
            }
        }
        return connectionPoints;
    }

    private void clearExistingResponsibleParties(List<ImportItemInterface> importItems) throws MdException, RemoteException {
        if (this._importOperation.getImportType() == 1) {
            return;
        }
        boolean submitUpdate = false;
        for (ImportItemInterface item : importItems) {
            Root metaObject;
            AssociationList assoc;
            if (item.getImportState() != 2 || (assoc = (metaObject = this.getMetadataObject(this._importOperation.getStore(), item)).getResponsibleParties()).size() <= 0) continue;
            submitUpdate = true;
            Iterator assocIter = assoc.iterator();
            while (assocIter.hasNext()) {
                ResponsibleParty responsibility = (ResponsibleParty)assocIter.next();
                if ("Created By".equalsIgnoreCase(responsibility.getRole()) || "Modified By".equalsIgnoreCase(responsibility.getRole())) continue;
                assocIter.remove();
            }
        }
        if (submitUpdate) {
            this._importOperation.getStore().updatedMetadataAll();
        }
    }

    private boolean isAssociatedToImportedObject(ConnectionPointInterface pt, List<ImportItemInterface> objects) {
        int size = objects.size();
        for (int i = 0; i < size; ++i) {
            ImportItemInterface item = objects.get(i);
            List<ConnectionPointInterface> connections = item.getConnectionPoints();
            for (int k = 0; k < connections.size(); ++k) {
                ConnectionPointInterface conn = connections.get(k);
                if (!conn.getSourceID().equalsIgnoreCase(pt.getSourceID())) continue;
                return true;
            }
        }
        return false;
    }

    public ResponsibleParty getResponsibleParty(ConnectionPointInterface pt) throws MdException, RemoteException {
        ResponsibleParty rp;
        block13: {
            rp = null;
            MdObjectStore store = this._importOperation.getStore();
            if (pt.getTargetID() != null && (rp = (ResponsibleParty)store.getObject(pt.getTargetID())) != null) {
                return rp;
            }
            String identityName = null;
            String responsibility = null;
            try {
                if (pt.getSourceSearchList().size() > 0) {
                    String search = pt.getSourceSearchList().get(0);
                    responsibility = this.getResponsiblePartyRole(search);
                    identityName = this.getIdentityName(search);
                    if ("Created By".equalsIgnoreCase(responsibility) || "Modified By".equalsIgnoreCase(responsibility)) {
                        return null;
                    }
                    if (AUTHOR_RESPONSIBILITY_NAME.equalsIgnoreCase(pt.getName()) && AUTHOR_RESPONSIBILITY_ROLE.equals(responsibility)) {
                        return null;
                    }
                    Identity identity = this.getIdentity(identityName);
                    if (identity != null) {
                        MdFactory factory = this._importOperation.getMetadataFactory();
                        rp = factory.getOMIUtil().getResponsibleParty(store, identityName, responsibility, "", 2056);
                    } else if (this._logWarnings) {
                        this._log.warn(Message.format((ResourceBundle)RB.getResources(), (String)"ResponsiblePartyHandler.NoPersonFound.fmt.txt", (Object)identityName));
                        this._rc |= 4;
                    } else if (this._log.isDebugEnabled()) {
                        this._log.debug(Message.format((ResourceBundle)RB.getResources(), (String)"ResponsiblePartyHandler.NoPersonFound.fmt.txt", (Object)identityName));
                    }
                }
            }
            catch (IllegalArgumentException e) {
                String msg = e.getLocalizedMessage();
                if (this._logWarnings) {
                    this._log.warn(msg);
                    this._rc |= 4;
                }
                if (!this._log.isDebugEnabled()) break block13;
                this._log.debug(msg);
            }
        }
        if (rp != null) {
            pt.setTargetID(rp.getId());
        }
        return rp;
    }

    private String getIdentityName(String search) throws IllegalArgumentException {
        int endExclusive;
        int prefixPos = search.indexOf(PERSON_SEARCH_ATTRIBUTE_PREFIX);
        if (prefixPos < 0 || !search.endsWith("]]")) {
            if (search.indexOf("Persons/*") == -1) {
                return null;
            }
            throw new IllegalArgumentException(Message.format((ResourceBundle)RB.getResources(), (String)"ResponsiblePartyHandler.InvalidSearchAttrib.fmt.txt", (Object)search, (Object)PERSON_SEARCH_ATTRIBUTE_PREFIX));
        }
        int startInclusive = prefixPos + PERSON_SEARCH_ATTRIBUTE_PREFIX.length();
        String nameSearch = search.substring(startInclusive, endExclusive = search.length() - 1);
        if (nameSearch.length() > 0 && (startInclusive = nameSearch.indexOf("@Name=")) > -1) {
            endExclusive = nameSearch.lastIndexOf("'");
            String name = nameSearch.substring(startInclusive += 7, endExclusive);
            return name;
        }
        throw new IllegalArgumentException(RB.getStringResource("ResponsiblePartyHandler.NoIdentityName.txt"));
    }

    private String getResponsiblePartyRole(String search) throws IllegalArgumentException {
        int index = search.indexOf(ROLE_SEARCH_ATTRIBUTE_PREFIX);
        if (index < 0) {
            throw new IllegalArgumentException(RB.getStringResource("ResponsiblePartyHandler.InvalidSearchAttrib.fmt.txt"));
        }
        int start = index + ROLE_SEARCH_ATTRIBUTE_PREFIX.length();
        String role = search.substring(start, search.indexOf(39, start));
        if (role.length() == 0) {
            throw new IllegalArgumentException(RB.getStringResource("ResponsiblePartyHandler.NoRole.txt"));
        }
        return role;
    }

    private Identity getIdentity(String identityName) throws MdException, RemoteException {
        if (identityName == null) {
            return null;
        }
        MdFactory factory = this._importOperation.getMetadataFactory();
        MdObjectStore objectStore = this._importOperation.getStore();
        String repositoriyFQID = this._importOperation.getRepositoryID();
        int flags = 8592;
        StringBuffer sb = new StringBuffer(80);
        sb.append("<XMLSelect search=\"*[@Name='");
        sb.append(identityName);
        sb.append("']\"/>");
        List identityList = factory.getOMIUtil().getMetadataObjectsSubset((MdStore)objectStore, repositoriyFQID, "Identity", flags, sb.toString(), false);
        int listSize = identityList.size();
        if (listSize > 0) {
            if (listSize > 1) {
                String msg = Message.format((ResourceBundle)RB.getResources(), (String)"ResponsiblePartyHandler.MoreThanOnePerson.fmt.txt", (Object)identityName);
                this._log.debug(msg);
            }
            return (Identity)identityList.get(0);
        }
        return null;
    }

    private Root getMetadataObject(MdObjectStore store, ImportItemInterface importItem) throws MdException, RemoteException {
        if (this._objectCache.containsKey(importItem.getID())) {
            return this._objectCache.get(importItem.getID());
        }
        MdFactory factory = store.getFactory();
        Root meta = (Root)factory.getOMIUtil().getMetadataAllDepths((MdStore)store, importItem.getTypeInterface().getMetadataType(), importItem.getTargetID(), null, _rpAssocList, "", 8);
        this._objectCache.put(importItem.getID(), meta);
        return meta;
    }

    private void setCreatedModifiedByInfo(List<ImportItemInterface> importItems) {
        block6: {
            int count = 0;
            Root metaObject = null;
            for (ImportItemInterface importItem : importItems) {
                try {
                    metaObject = this.getMetadataObject(this._importOperation.getStore(), importItem);
                    MdResponsibilitiesUtil.setCreatedModifiedByValues((CMetadata)metaObject, (importItem.getImportState() == 1 ? 1 : 0) != 0);
                    if (++count < 50 || metaObject == null) continue;
                    metaObject.updateMetadataAll();
                    count = 0;
                }
                catch (Exception e) {
                    if (!this._log.isDebugEnabled()) continue;
                    this._log.debug(e.getLocalizedMessage());
                }
            }
            if (count > 0 && metaObject != null) {
                try {
                    metaObject.updateMetadataAll();
                }
                catch (Exception e) {
                    if (!this._log.isDebugEnabled()) break block6;
                    this._log.debug(e.getLocalizedMessage());
                }
            }
        }
    }

    static {
        _rpAssocList.add("ResponsibleParties");
    }
}

