/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.promotion;

import com.sas.meta.SASOMI.IOMI;
import com.sas.meta.SASOMI.IServer;
import com.sas.metadata.logical.Factory;
import com.sas.metadata.logical.LogicalTypeException;
import com.sas.metadata.logical.SimpleLogicalObjectInterface;
import com.sas.metadata.logical.TransportableTypeInterface;
import com.sas.metadata.logical.TypeInterface;
import com.sas.metadata.promotion.ImportItemInterface;
import com.sas.metadata.promotion.ImportOperationInterface;
import com.sas.metadata.promotion.PromotionInterface;
import com.sas.metadata.promotion.RB;
import com.sas.metadata.promotion.TargetSBIPUrl;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdOMRConnection;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdSecurityUtil;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.Tree;
import com.sas.services.ServiceException;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.Folder;
import com.sas.services.information.metadata.FolderUtil;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.PathUrl;
import com.sas.services.information.publicobject.PublicObjectInterface;
import com.sas.services.information.publicobject.TypeDescriptorInterface;
import com.sas.services.information.sasfolders.SASFoldersUtil;
import com.sas.services.session.SessionContextInterface;
import com.sas.services.user.UserContextInterface;
import com.sas.text.Message;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceFile;
import com.sas.workspace.metadata.WsMetadataUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.rmi.RemoteException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.filechooser.FileSystemView;
import org.omg.CORBA.StringHolder;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PromotionUtil {
    private static final char[] INVALID_FILENAME_CHARACTERS = new char[]{'\\', '/', ':', '*', '?', '\"', '|', '<', '>'};
    private static final String PROPERTY_KEY = "PartialPromotionWizards.PackageLocation.path";
    public static final String SBIP_PREFIX = "SBIP://";
    public static final String EMPTY_STRING = "";
    public static final char SBIPURL_PATH_SEPARATOR = '/';
    private static final int SBIPURL_START = 7;
    private static final String RELATIVE_SERVER = ".";
    private static String _logDirectory;
    private static Integer _countInteger;
    private static int _count;
    private static final String BACKUP_FILE_SUFFIX = "BKP.V";
    public static final String METADATA_OBJECT_TYPE = "MetadataObjectType";
    public static final String PACKAGE_FILE_EXTENSION = ".spk";
    public static final String LOCALIZABLE_FILE_EXTENSION = ".locprop";
    public static final String SUBSTITUTION_FILE_EXTENSION = ".subprop";
    public static final int SUPPORTED_VERSION = 9133;
    public static final int SERVER_VERSION_930 = 9300;
    public static final int SERVER_VERSION_920 = 9200;
    public static final int SERVER_VERSION_913 = 9130;
    public static final int SERVER_VERSION_913_SP3 = 9133;
    public static final int SERVER_VERSION_913_SP4 = 9134;
    public static final int PACKAGE_VERSION_930 = 9300;
    public static final int PACKAGE_VERSION_920 = 9200;
    public static final int PACKAGE_VERSION_913_SP4 = 9134;
    public static final int PACKAGE_VERSION_913_SP3 = 9133;
    public static final int PACKAGE_VERSION_913 = 9130;
    public static final int PACKAGE_VERSION_INVALID = -1;
    public static final int CURRENT_PACKAGE_VERSION = 9300;
    public static final String SUPPORTED_SERVER_HOTFIX = "E9BA20";
    public static final String[] TYPES_REQUIRING_HOTFIX;
    static final String[] DI_TYPES_REQUIRING_HOTFIX;
    public static final int EXPORT_TYPE = 0;
    public static final int IMPORT_TYPE = 1;

    static boolean typeRequiresHotfix(String type) {
        for (int i = 0; i < DI_TYPES_REQUIRING_HOTFIX.length; ++i) {
            if (!DI_TYPES_REQUIRING_HOTFIX[i].equalsIgnoreCase(type)) continue;
            return true;
        }
        return false;
    }

    public static void updateProductInfo(Root metaObject, ImportOperationInterface operation) throws RemoteException, MdException {
        if (!operation.isBatchProcess()) {
            WsMetadataUtil.updateModifiedByFor((Root)metaObject);
        }
    }

    public static void removeDuplicatesProductInfo(Root metaObject, ImportOperationInterface operation) throws RemoteException, MdException {
        if (operation.isBatchProcess()) {
            WsMetadataUtil.removeDuplicateModifiedByProductFor((Root)metaObject);
        }
    }

    public static void isFolderWriteAuthorized(MdFactory factory, String folderID) throws MdException, RemoteException {
        PromotionUtil.isFolderWriteAuthorized(factory, folderID, true);
    }

    public static boolean isFolderWriteAuthorized(MdFactory factory, String folderID, boolean throwException) throws MdException, RemoteException {
        MdSecurityUtil securityUtil;
        boolean isAuthorized;
        if (folderID != null && !(isAuthorized = (securityUtil = factory.getSecurityUtil()).isFolderWriteAuthorized(folderID))) {
            if (throwException) {
                throw new MdException(RB.getStringResource("Common.NoPermission.txt"));
            }
            return false;
        }
        return true;
    }

    public static void isWriteAuthorized(MdFactory factory, String metadataType, String objectID) throws MdException, RemoteException {
        PromotionUtil.isWriteAuthorized(factory, metadataType, objectID, true);
    }

    public static boolean isWriteAuthorized(MdFactory factory, String metadataType, String objectID, boolean throwException) throws MdException, RemoteException {
        MdSecurityUtil securityUtil;
        boolean isAuthorized;
        if (objectID != null && !(isAuthorized = (securityUtil = factory.getSecurityUtil()).isWriteAuthorized(metadataType, objectID))) {
            if (throwException) {
                throw new MdException(RB.getStringResource("Common.NoPermission.txt"));
            }
            return false;
        }
        return true;
    }

    public static boolean validateServerVersion(MdFactory factory) throws MdException, RemoteException {
        int version = PromotionUtil.getServerVersion(factory);
        return version >= 9133;
    }

    public static int getServerVersion(MdFactory factory) throws MdException, RemoteException {
        MdOMRConnection connection = factory.getConnection();
        IServer iserver = connection.MakeIServerConnection(connection.getCMRHandle());
        int version = connection.getPlatformVersion(iserver);
        return version;
    }

    public static String getLogDirectory() {
        if (_logDirectory == null) {
            File defaultDirectory = FileSystemView.getFileSystemView().getDefaultDirectory();
            _logDirectory = defaultDirectory.getAbsolutePath();
        }
        return _logDirectory;
    }

    public static void setLogDirectory(String dir) {
        _logDirectory = dir;
    }

    public static String getDefaultDirectory() {
        File defaultDirectory = FileSystemView.getFileSystemView().getDefaultDirectory();
        return defaultDirectory.getAbsolutePath();
    }

    public static String getCurrentDirectory() {
        String defaultPath;
        WorkspaceFile appDefs = Workspace.getWorkspace().getAppDefaultsFile();
        if (appDefs == null) {
            defaultPath = PromotionUtil.getDefaultDirectory();
        } else {
            defaultPath = appDefs.getPropertyString(PROPERTY_KEY);
            if (defaultPath == null || defaultPath.length() == 0) {
                defaultPath = PromotionUtil.getDefaultDirectory();
            }
        }
        return defaultPath;
    }

    public static void setCurrentDirectory(String dir) {
        WorkspaceFile appDefs = Workspace.getWorkspace().getAppDefaultsFile();
        appDefs.setPropertyString(PROPERTY_KEY, dir);
    }

    protected static String getPromotionFileName(String fileName, String fileExtension, String packageFileName) {
        return PromotionUtil.getPromotionFileName(fileName, fileExtension, packageFileName, true);
    }

    protected static String getPromotionFileName(String fileName, String fileExtension, String packageFileName, boolean useDefaultDirectory) {
        String separator = System.getProperty("file.separator");
        if (fileName == null) {
            if (packageFileName == null) {
                StringBuffer sb = new StringBuffer();
                if (useDefaultDirectory) {
                    sb.append(PromotionUtil.getDefaultDirectory());
                    sb.append(separator);
                }
                sb.append("Export_");
                sb.append(new SimpleDateFormat("yyMMddHHmmss").format(new Date()));
                sb.append(fileExtension);
                fileName = sb.toString();
            } else {
                fileName = packageFileName;
                if (fileName.endsWith(PACKAGE_FILE_EXTENSION) || fileName.endsWith(PACKAGE_FILE_EXTENSION.toUpperCase())) {
                    fileName = fileName.substring(0, fileName.length() - PACKAGE_FILE_EXTENSION.length()) + fileExtension;
                }
                if (!fileName.endsWith(fileExtension)) {
                    fileName = fileName + fileExtension;
                }
            }
        } else {
            if (useDefaultDirectory && fileName.indexOf(separator) < 0) {
                fileName = PromotionUtil.getCurrentDirectory() + separator + fileName;
            } else if (fileName.endsWith(separator)) {
                return null;
            }
            if (!fileName.endsWith(fileExtension) && !fileName.endsWith(fileExtension.toUpperCase())) {
                fileName = fileName + fileExtension;
            }
        }
        return fileName;
    }

    protected static File createPromotionFile(String fileName, String fileExtension, String packageFileName, boolean useDefaultDirectory) {
        String name = PromotionUtil.getPromotionFileName(fileName, fileExtension, packageFileName, useDefaultDirectory);
        return name == null ? null : new File(name);
    }

    protected static File createPromotionFile(String fileName, String directoryName, String extension) {
        if (fileName == null) {
            throw new IllegalArgumentException("Invalid file name");
        }
        if (directoryName == null) {
            throw new IllegalArgumentException("Invalid directory location");
        }
        String separator = System.getProperty("file.separator");
        StringBuilder sb = new StringBuilder();
        sb.append(directoryName);
        if (!directoryName.endsWith(separator)) {
            sb.append(separator);
        }
        sb.append(fileName);
        if (!fileName.endsWith(extension) && !fileName.endsWith(extension.toUpperCase())) {
            sb.append(extension);
        }
        return new File(sb.toString());
    }

    public static boolean validatePackageFileName(String fileName, boolean throwException) {
        File parentFile;
        if (fileName == null) {
            throw new IllegalArgumentException(RB.getStringResource("PromotionUtil.InvalidFileName.Missing.txt"));
        }
        if (fileName.length() == 0) {
            if (throwException) {
                throw new IllegalArgumentException(RB.getStringResource("PromotionUtil.InvalidFileName.Missing.txt"));
            }
            return false;
        }
        File file = new File(fileName);
        String name = file.getName();
        for (int i = 0; i < INVALID_FILENAME_CHARACTERS.length; ++i) {
            if (name.indexOf(INVALID_FILENAME_CHARACTERS[i]) == -1) continue;
            if (throwException) {
                throw new IllegalArgumentException(Message.format((ResourceBundle)RB.getResources(), (String)"PromotionUtil.InvalidFileName.fmt.txt", (Object)name));
            }
            return false;
        }
        if (!file.exists() && !(parentFile = file.getParentFile()).exists()) {
            if (throwException) {
                throw new IllegalArgumentException(Message.format((ResourceBundle)RB.getResources(), (String)"PromotionUtil.InvalidDirectory.fmt.txt", (Object)parentFile.getPath()));
            }
            return false;
        }
        return true;
    }

    public static String readFile(String fileName) throws IOException {
        String in;
        String newLine = "\n";
        File file = new File(fileName);
        BufferedReader br = new BufferedReader(new FileReader(file));
        StringBuffer sb = new StringBuffer();
        while ((in = br.readLine()) != null) {
            sb.append(in);
            sb.append("\n");
        }
        br.close();
        return sb.toString();
    }

    public static String getRepositoryID(CMetadata meta) throws RemoteException {
        return meta == null ? null : "A0000001." + meta.getRepositoryID();
    }

    public static String getRepositoryID(String objectID) {
        return objectID == null ? null : "A0000001." + objectID.substring(0, 8);
    }

    public static String getRepositoryName(MdFactory factory, String strReposId) throws Exception {
        Node firstNode;
        NodeList nodeList;
        int i;
        String strName = null;
        int flags = 384;
        String type = "REPOSITORYBASE";
        String options = "<XMLSELECT search = \"@Id = '" + strReposId + "'\"/>";
        IOMI connectionHandle = factory.getConnection().getCMRHandle();
        StringHolder outXML = new StringHolder();
        connectionHandle.GetMetadataObjects(strReposId, type, outXML, "REPOS", flags, options);
        String outXMLString = outXML.value;
        Document mainDoc = factory.getOMIUtil().parseXML(outXMLString);
        if (mainDoc != null && (i = 0) < (nodeList = (firstNode = mainDoc.getFirstChild()).getChildNodes()).getLength()) {
            Node currentNode = nodeList.item(i);
            NamedNodeMap nodeMap = currentNode.getAttributes();
            strName = nodeMap.getNamedItem("Name").getNodeValue();
        }
        return strName;
    }

    public static String createStatusMessage(String objectType) {
        return objectType;
    }

    public static String createStatusMessage(String objectType, String detailMessage) {
        return Message.format((ResourceBundle)RB.getResources(), (String)"PromotionUtil.Progress.Message.fmt.txt", (Object)objectType, (Object)detailMessage);
    }

    public static String createStatusMessage(String objectType, String objectName, int index, int totalNumObjects) {
        if (totalNumObjects != _count) {
            _countInteger = new Integer(totalNumObjects);
            _count = totalNumObjects;
        }
        return Message.format((ResourceBundle)RB.getResources(), (String)"PromotionUtil.Progress.Counter.fmt.txt", (Object)objectType, (Object)new Integer(index), (Object)_countInteger, (Object)objectName);
    }

    public static String getObjectPath(ServerInterface server, String objectID, String metadataType) throws ServiceException, RemoteException {
        PathUrl path;
        String objectKey = objectID + "/" + metadataType;
        MetadataInterface meta = server.fetch(objectKey, true);
        if (meta != null && (path = meta.getPathUrl()) != null) {
            return path.getAbsolutePath();
        }
        return null;
    }

    public static MetadataInterface getObjectFromPath(ServerInterface server, PathUrl path) throws ServiceException, RemoteException {
        return server.getObjectByPath(path);
    }

    public static MetadataInterface getObjectFromPath(ServerInterface server, String absolutePath) throws ServiceException, RemoteException {
        PathUrl path = PathUrl.newPathUrlFromAbsolutePath((ServerInterface)server, (String)absolutePath);
        return server.getObjectByPath(path);
    }

    public static MetadataInterface getObjectFromPath(SessionContextInterface session, String absolutePath) throws ServiceException, RemoteException {
        UserContextInterface user = session.getUserContext();
        if (user != null) {
            ServerInterface server = user.getAuthServer();
            return PromotionUtil.getObjectFromPath(server, absolutePath);
        }
        return null;
    }

    public static MetadataInterface getSmartObject(ServerInterface server, String objectID, String metadataType) throws ServiceException, RemoteException {
        if (server != null) {
            String infoSvcsKey = objectID + "/" + metadataType;
            return server.fetch(infoSvcsKey, true);
        }
        return null;
    }

    public static MetadataInterface getSmartObject(PromotionInterface operation, String objectID, String metadataType) throws ServiceException, RemoteException {
        ServerInterface server = operation.getServer();
        return PromotionUtil.getSmartObject(server, objectID, metadataType);
    }

    public static MetadataInterface getSmartObject(PromotionInterface operation, SimpleLogicalObjectInterface logicalObject) throws ServiceException, RemoteException {
        ServerInterface server = operation.getServer();
        return PromotionUtil.getSmartObject(server, logicalObject);
    }

    public static MetadataInterface getSmartObject(ServerInterface server, SimpleLogicalObjectInterface logicalObject) throws ServiceException, RemoteException {
        if (logicalObject == null) {
            throw new IllegalArgumentException("Invalid logical object");
        }
        return PromotionUtil.getSmartObject(server, logicalObject.getID(), logicalObject.getTypeInterface().getMetadataType());
    }

    public static MetadataInterface getSmartObject(PromotionInterface operation, CMetadata meta) throws ServiceException, RemoteException {
        if (meta == null) {
            throw new IllegalArgumentException("Invalid metadata object");
        }
        return PromotionUtil.getSmartObject(operation, meta.getId(), meta.getCMetadataType());
    }

    public static MetadataInterface getSmartObject(PromotionInterface operation, PublicObjectInterface publicObject) throws ServiceException, RemoteException {
        ServerInterface server = operation.getServer();
        return PromotionUtil.getSmartObject(server, publicObject);
    }

    public static MetadataInterface getSmartObject(ServerInterface server, PublicObjectInterface publicObject) throws ServiceException, RemoteException {
        if (publicObject == null) {
            throw new IllegalArgumentException("Invalid public object");
        }
        if (publicObject.getTypeDescriptor() == null) {
            throw new IllegalArgumentException("Invalid public type");
        }
        return PromotionUtil.getSmartObject(server, publicObject.getIdentifier(), publicObject.getTypeDescriptor().getMetadataType());
    }

    public static Tree createFolder(MdObjectStore store, String folderName, String reposID) throws RemoteException {
        MdFactory factory = store.getFactory();
        Tree folder = (Tree)factory.createComplexMetadataObject(store, folderName, "Tree", reposID);
        folder.setTreeType("BIPTree");
        folder.setPublicType("Folder");
        folder.setUsageVersion(Folder.CURRENT_VERSION.encode());
        return folder;
    }

    public static List<String> getSupportedTypeValues(PromotionInterface operation) throws ServiceException, LogicalTypeException, RemoteException {
        ArrayList<String> typesList = new ArrayList<String>();
        Factory factory = Factory.getInstance();
        ServerInterface server = operation.getServer();
        TypeInterface[] supportedTypes = operation.getUserDefinedSupportedTypes();
        if (supportedTypes == null) {
            supportedTypes = factory.getTypesSupported();
        }
        if (supportedTypes != null) {
            for (TypeInterface type : supportedTypes) {
                String publicType = type.getPublicType();
                if (FolderUtil.isFolder((String)publicType) || "RootFolder".equalsIgnoreCase(publicType) || !(type instanceof TransportableTypeInterface) || !SASFoldersUtil.isContainedByFolder((String)publicType, (ServerInterface)server) && !SASFoldersUtil.isContainedByVirtualFolder((String)publicType, (ServerInterface)server)) continue;
                typesList.add(type.getPublicType());
            }
        }
        return typesList;
    }

    public static List getSupportedTypes(PromotionInterface operation) throws ServiceException, LogicalTypeException, RemoteException {
        ArrayList<TransportableTypeInterface> typesList = new ArrayList<TransportableTypeInterface>();
        Factory factory = Factory.getInstance();
        TypeInterface[] supportedTypes = operation.getUserDefinedSupportedTypes();
        if (supportedTypes == null) {
            supportedTypes = factory.getTypesSupported();
        }
        if (supportedTypes != null) {
            for (TypeInterface type : supportedTypes) {
                TypeDescriptorInterface descriptor;
                String publicType = type.getPublicType();
                if ("Folder".equalsIgnoreCase(publicType) || "RootFolder".equalsIgnoreCase(publicType) || !(type instanceof TransportableTypeInterface) || ((descriptor = factory.getTypeDescriptorFromTypeDictionary(publicType)) == null || !"Folder".equalsIgnoreCase(descriptor.getContainerType())) && !SASFoldersUtil.isContainedByVirtualFolder((String)publicType, (ServerInterface)factory.getMetadataServerInterface())) continue;
                typesList.add((TransportableTypeInterface)type);
            }
            Collections.sort(typesList, new TypesSorter());
        }
        return typesList;
    }

    public static boolean isTypeContainedByFolder(String publicType) throws ServiceException, RemoteException {
        Factory factory;
        TypeDescriptorInterface descriptor;
        return publicType != null && (descriptor = (factory = Factory.getInstance()).getTypeDescriptorFromTypeDictionary(publicType)) != null && FolderUtil.isFolder((String)descriptor.getContainerType());
    }

    public static boolean isFolder(PublicObjectInterface publicObject) throws ServiceException, RemoteException {
        return FolderUtil.isFolder((PublicObjectInterface)publicObject);
    }

    public static boolean isRootFolder(PublicObjectInterface publicObject) throws ServiceException, RemoteException {
        TypeDescriptorInterface type = publicObject.getTypeDescriptor();
        return type == null ? false : "RootFolder".equalsIgnoreCase(type.getTypeName());
    }

    public static String getMetadataTypeForPublicType(String publicType) throws ServiceException, RemoteException {
        Factory factory;
        TypeDescriptorInterface descriptor;
        if (publicType != null && (descriptor = (factory = Factory.getInstance()).getTypeDescriptorFromTypeDictionary(publicType)) != null) {
            return descriptor.getMetadataType();
        }
        return null;
    }

    public static String getAbsolutePathForSBIPUrl(PathUrl url) {
        StringBuffer sb = new StringBuffer();
        sb.append('/');
        if (url.getRootTree() != null) {
            sb.append(url.getRootTree()).append('/');
        }
        if (url.getPath() != null) {
            sb.append(url.getPath()).append('/');
        }
        if (url.getName() != null) {
            sb.append(url.getName());
        }
        return sb.toString();
    }

    public static String getNewSBIPUrl(String oldUrl, String targetReposName, List objectsImporting) {
        TargetSBIPUrl sbipUrl = PromotionUtil.getTargetSBIPUrl(oldUrl, targetReposName, objectsImporting);
        return sbipUrl.getTargetUrl();
    }

    public static TargetSBIPUrl getTargetSBIPUrl(String oldUrl, String targetReposName, List objectsImporting) {
        TargetSBIPUrl sbipUrl = new TargetSBIPUrl();
        int endIndex = oldUrl.lastIndexOf(40);
        if (endIndex == -1) {
            endIndex = oldUrl.length();
        }
        boolean isAbsolute = false;
        int startIndex = 0;
        int sbipIndex = oldUrl.indexOf(SBIP_PREFIX);
        if (sbipIndex > -1) {
            startIndex = 7;
        } else if (oldUrl.charAt(0) == '/') {
            isAbsolute = true;
            startIndex = 1;
        } else {
            return sbipUrl;
        }
        if (endIndex > startIndex) {
            String path = oldUrl.substring(startIndex, endIndex);
            ArrayList<String> treeList = new ArrayList<String>();
            int index = -1;
            int treeIndex = 0;
            while ((index = path.indexOf(47, treeIndex)) > -1) {
                treeList.add(path.substring(treeIndex, index));
                treeIndex = index + 1;
            }
            String objectName = path.substring(treeIndex);
            if (treeList.size() > 1 || isAbsolute && treeList.size() >= 1) {
                StringBuffer sb = new StringBuffer(oldUrl);
                if (!isAbsolute) {
                    String name = sb.substring(7, sb.indexOf("/", 7));
                    if (!RELATIVE_SERVER.equals(name)) {
                        sb.replace(7, sb.indexOf("/", 7), targetReposName);
                    }
                    treeList.remove(0);
                }
                for (ImportItemInterface importItem : objectsImporting) {
                    String[] sourcePath = importItem.getSourcePath();
                    int size = sourcePath.length;
                    if (treeList.size() != size) continue;
                    boolean pathsMatch = true;
                    for (int i = 0; i < size; ++i) {
                        String sourceTree;
                        String tree = (String)treeList.get(i);
                        if (tree.equals(sourceTree = sourcePath[i])) continue;
                        pathsMatch = false;
                        break;
                    }
                    if (!pathsMatch || !objectName.equals(importItem.getOriginalName())) continue;
                    int pathStart = isAbsolute ? 1 : sb.indexOf(targetReposName, 7) + targetReposName.length() + 1;
                    int pathEnd = sb.lastIndexOf(objectName);
                    StringBuffer newPath = new StringBuffer();
                    String[] targetPath = importItem.getTargetPath();
                    int length = targetPath.length;
                    for (int i = 0; i < length; ++i) {
                        newPath.append(targetPath[i]);
                        newPath.append("/");
                    }
                    sb.replace(pathStart, pathEnd, newPath.toString());
                    if (importItem.isRenamed()) {
                        pathEnd = sb.lastIndexOf(objectName);
                        int nameEnd = pathEnd + objectName.length();
                        sb.replace(pathEnd, nameEnd, importItem.getName());
                    }
                    sbipUrl.setObjectBeingImported(true);
                    break;
                }
                sbipUrl.setTargetUrl(sb.toString());
            }
        }
        return sbipUrl;
    }

    public static String getTargetPathForSourceId(String oldId, List objectsImporting) {
        for (ImportItemInterface item : objectsImporting) {
            if (!oldId.equals(item.getID())) continue;
            return item.toString();
        }
        return null;
    }

    public static String getAttrValue(String attrStr, String key) {
        return PromotionUtil.getValue(attrStr, "@" + key);
    }

    public static String getValue(String attrStr, String key) {
        Search search = new Search(attrStr, key);
        return search.next();
    }

    public static File backUpPackageFile(String packageFileName) throws IOException {
        if (packageFileName != null) {
            String tok1 = null;
            File packageFile = null;
            int index = packageFileName.lastIndexOf(PACKAGE_FILE_EXTENSION);
            if (index > 0) {
                packageFile = new File(packageFileName);
                tok1 = packageFileName.substring(0, index);
            } else {
                packageFile = new File(packageFileName + PACKAGE_FILE_EXTENSION);
                tok1 = packageFileName;
            }
            if (tok1 != null) {
                boolean uniqeNameFound = false;
                File uniquefile = null;
                int i = 1;
                while (!uniqeNameFound) {
                    uniquefile = new File(tok1 + BACKUP_FILE_SUFFIX + i + PACKAGE_FILE_EXTENSION);
                    uniqeNameFound = !uniquefile.exists();
                    ++i;
                }
                if (!packageFile.renameTo(uniquefile)) {
                    PromotionUtil.copyFile(packageFile, uniquefile);
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File src, File dst) throws IOException {
        InputStream in = null;
        OutputStream out = null;
        byte[] buf = new byte[2048];
        int len = 0;
        try {
            in = new FileInputStream(src);
            out = new FileOutputStream(dst);
            while ((len = in.read(buf)) > 0) {
                out.write(buf, 0, len);
            }
        }
        finally {
            in.close();
            out.close();
        }
    }

    static {
        _count = 0;
        TYPES_REQUIRING_HOTFIX = new String[]{"StoredProcess", "Job", "Table", "ExternalFile", "GeneratedTransform"};
        DI_TYPES_REQUIRING_HOTFIX = new String[]{"Job", "Table", "ExternalFile", "GeneratedTransform"};
    }

    private static class Search {
        String _string;
        String _search;
        int _start = 0;
        String _nextValue;

        Search(String string, String search) {
            this._string = string;
            this._search = search;
        }

        String next() {
            this._start = this._string.indexOf(this._search, this._start);
            if (this._start == -1) {
                return null;
            }
            this._start += this._search.length();
            if (this._string.length() < this._start + 3) {
                return null;
            }
            if (this._string.charAt(this._start) != '=') {
                return null;
            }
            ++this._start;
            if (this._string.charAt(this._start) != '\'') {
                return null;
            }
            ++this._start;
            if (this._string.charAt(this._start) == '\'') {
                return PromotionUtil.EMPTY_STRING;
            }
            int endIndex = this._string.indexOf(39, this._start);
            String ret = this._string.substring(this._start, endIndex);
            this._start = endIndex;
            return ret;
        }
    }

    private static class TypesSorter
    implements Comparator {
        private TypesSorter() {
        }

        public int compare(Object obj1, Object obj2) {
            if (obj1 == obj2) {
                return 0;
            }
            if (obj1 == null) {
                return -1;
            }
            if (obj2 == null) {
                return 1;
            }
            return this.runCompare(obj1, obj2);
        }

        private int runCompare(Object obj1, Object obj2) {
            TypeInterface type1 = null;
            TypeInterface type2 = null;
            if (!(obj1 instanceof TypeInterface)) {
                return -1;
            }
            type1 = (TypeInterface)obj1;
            if (!(obj2 instanceof TypeInterface)) {
                return 1;
            }
            type2 = (TypeInterface)obj2;
            return type1.getDisplayType().compareToIgnoreCase(type2.getDisplayType());
        }
    }
}

