/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.promotion;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Set;

public class PromotionPropertiesFile {
    private static final String FILE_NAME = "PromotionSettings.properties";
    private static final String FILE_SEPARATOR = System.getProperty("file.separator");
    private Properties _props = new Properties();

    public String getProperty(String key) {
        return this._props.getProperty(key);
    }

    public Enumeration getProperties() {
        return this._props.elements();
    }

    public Set getPropertyKeys() {
        return this._props.keySet();
    }

    public void removeProperty(String key) {
        this._props.remove(key);
    }

    public void addProperty(String key, String value) {
        this._props.put(key, value);
    }

    public void setProperty(String key, String value) {
        this._props.put(key, value);
    }

    public String getFileName() {
        return FILE_NAME;
    }

    public boolean isEmpty() {
        return this._props.isEmpty();
    }

    public boolean containsKey(String key) {
        return this._props.containsKey(key);
    }

    protected void read(InputStream is) throws IOException {
        try {
            if (is != null) {
                this._props.clear();
                this._props.load(is);
            }
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected File write(String dir) throws IOException {
        if (this._props.size() == 0) {
            return null;
        }
        FileOutputStream fos = null;
        try {
            if (dir != null && !dir.endsWith(FILE_SEPARATOR)) {
                dir = dir + FILE_SEPARATOR;
            }
            String fileName = dir + FILE_NAME;
            File file = new File(fileName);
            fos = new FileOutputStream(file);
            String header = "Properties file created on: " + new Date();
            this._props.store(fos, header);
            File file2 = file;
            return file2;
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

