/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.promotion;

import com.sas.metadata.logical.TransportableTypeInterface;
import com.sas.metadata.promotion.BIPTreeUtil;
import com.sas.metadata.promotion.ImportItemInterface;
import com.sas.metadata.promotion.ImportListener;
import com.sas.metadata.promotion.ImportNameExtensionProvider;
import com.sas.metadata.promotion.ImportNameValidatorInterface;
import com.sas.metadata.promotion.ImportOperationInterface;
import com.sas.metadata.promotion.ImportRenameInterface;
import com.sas.metadata.promotion.MetadataPromotionException;
import com.sas.metadata.promotion.MetadataTreeUtil;
import com.sas.metadata.promotion.NestedImportItemInterface;
import com.sas.metadata.promotion.RB;
import com.sas.metadata.promotion.persistence.ImportMetadataManagementInterface;
import com.sas.metadata.promotion.persistence.MetadataManagementInterface;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdSecurityUtil;
import com.sas.metadata.remote.SoftwareComponent;
import com.sas.services.ServiceException;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.PathUrl;
import com.sas.services.information.sasfolders.SASFoldersUtil;
import com.sas.text.Message;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;

public class ObjectRenameManager {
    private static Map<ImportOperationInterface, ObjectRenameManager> _instanceCache = new HashMap<ImportOperationInterface, ObjectRenameManager>(5);
    private static final int MAX_NAME_LENGTH = 60;
    private ImportOperationInterface _importOperation;
    private Map _topLevelFoldersMap;
    private Map<ImportItemInterface, CurrentObjectName> _renamedObjectMap;
    private List<ImportItemInterface> _failedValidationList = null;
    private int _rc = 0;

    public ObjectRenameManager(ImportOperationInterface operation) {
        this._importOperation = operation;
        this._renamedObjectMap = new HashMap<ImportItemInterface, CurrentObjectName>(10);
    }

    public static synchronized ObjectRenameManager getInstance(ImportOperationInterface operation) {
        if (operation == null) {
            throw new IllegalArgumentException("Invalid operation");
        }
        if (_instanceCache.containsKey(operation)) {
            return _instanceCache.get(operation);
        }
        ObjectRenameManager instance = new ObjectRenameManager(operation);
        _instanceCache.put(operation, instance);
        return instance;
    }

    public static synchronized ObjectRenameManager getNewInstance(ImportOperationInterface operation) {
        if (operation == null) {
            throw new IllegalArgumentException("Invalid operation");
        }
        ObjectRenameManager instance = new ObjectRenameManager(operation);
        _instanceCache.put(operation, instance);
        return instance;
    }

    public static String generateDefaultCopyName(String originalName) {
        return ObjectRenameManager.generateDefaultCopyName(originalName, 1);
    }

    public static String generateDefaultCopyName(String originalName, int copyIndex) {
        return ObjectRenameManager.generateDefaultCopyName(originalName, copyIndex, false);
    }

    public static String generateDefaultCopyName(String originalName, int copyIndex, boolean extensionsSupported) {
        int index;
        if (copyIndex < 0) {
            throw new IllegalArgumentException("Invalid index used to generate object's name.");
        }
        if (copyIndex == 0) {
            return originalName;
        }
        if (extensionsSupported && (index = originalName.lastIndexOf(46)) > -1) {
            String name = originalName.substring(0, index);
            String extension = originalName.substring(index);
            return name + "(" + copyIndex + ")" + extension;
        }
        return originalName + "(" + copyIndex + ")";
    }

    public void dispose() {
        _instanceCache.remove(this._importOperation);
        this._topLevelFoldersMap = null;
        this._renamedObjectMap = null;
        this._failedValidationList = null;
    }

    public int getObjectRenameCounter(ImportItemInterface importItem) {
        int counter = 0;
        if (this._renamedObjectMap != null && this._renamedObjectMap.containsKey(importItem)) {
            CurrentObjectName name = this._renamedObjectMap.get(importItem);
            counter = name.getCopyIndex();
        }
        return counter;
    }

    public int performRenameOperation(List<ImportItemInterface> objectsToBeRenamed) throws MdException {
        try {
            LinkedHashSet<ImportItemInterface> renamedItems = new LinkedHashSet<ImportItemInterface>();
            if (objectsToBeRenamed != null) {
                renamedItems.addAll(objectsToBeRenamed);
            }
            Map importItems = this._importOperation.getImportItems();
            for (String type : importItems.keySet()) {
                List objects;
                ImportNameValidatorInterface nameValidator = this.getImportNameValidator(type);
                if (nameValidator == null || (objects = (List)importItems.get(type)) == null) continue;
                for (ImportItemInterface item : objects) {
                    if (item.getImportState() != 1) continue;
                    this.renameAndValidate(nameValidator, item, renamedItems);
                    if (!item.containsNestedItems()) continue;
                    this.renameNestedImportItems(item, renamedItems);
                }
            }
            if (renamedItems != null && !renamedItems.isEmpty()) {
                this.renameObjects(renamedItems);
                renamedItems.clear();
            }
        }
        catch (Exception e) {
            throw new MdException(Message.format((ResourceBundle)RB.getResources(), (String)"ObjectRenameManager.RenameFailure.fmt.txt", (Object)e.getMessage()));
        }
        return this._rc;
    }

    private void renameNestedImportItems(ImportItemInterface item, Set<ImportItemInterface> objectsToBeRenamed) {
        List childItems = item.getNestedItems();
        for (NestedImportItemInterface childItem : childItems) {
            if (childItem.isRenamed() && !objectsToBeRenamed.contains(childItem)) {
                objectsToBeRenamed.add(childItem);
            }
            if (!childItem.containsNestedItems()) continue;
            this.renameNestedImportItems(childItem, objectsToBeRenamed);
        }
    }

    public void renameNestedImportItem(NestedImportItemInterface childItem, String newName) {
        if (newName == null) {
            throw new IllegalArgumentException("Invalid object name");
        }
        if (newName.length() > 60) {
            String originalName = childItem.getName();
            int numChars = newName.length() - originalName.length();
            String suffix = newName.substring(newName.length() - numChars);
            newName = newName.substring(0, 60 - numChars).trim();
            newName = newName + suffix;
            this._importOperation.getLogger().debug("Truncating new name so that it does not exceed 60 characters");
        }
        childItem.rename(newName);
    }

    private ImportNameValidatorInterface getImportNameValidator(String publicType) {
        ImportListener listener = this.getImportListener(publicType);
        return listener == null ? null : listener.getNameValidatorInterface();
    }

    private ImportListener getImportListener(String publicType) {
        TransportableTypeInterface type = this._importOperation.getTransportableType(publicType);
        return type == null ? null : (ImportListener)type.getImportListener();
    }

    private void renameObjects(Set<ImportItemInterface> objects) throws MetadataPromotionException {
        MetadataManagementInterface metaManager = this._importOperation.getMetadataManager();
        if (metaManager instanceof ImportMetadataManagementInterface) {
            ImportMetadataManagementInterface manager = (ImportMetadataManagementInterface)metaManager;
            for (ImportItemInterface importItem : objects) {
                String msg;
                manager.renameItem(importItem);
                if (importItem instanceof NestedImportItemInterface) {
                    String msg2 = Message.format((ResourceBundle)RB.getResources(), (String)"ObjectRenameManager.RenamedObject.fmt.txt", (Object)importItem.getTypeInterface().getDisplayType(), (Object)importItem.getOriginalName(), (Object)importItem.getName());
                    this._importOperation.getLogger().info(msg2);
                    continue;
                }
                String displayType = importItem.getTypeInterface().getDisplayType();
                String originalPath = BIPTreeUtil.pathToString(importItem.getTargetPath(), importItem.getOriginalName());
                if (this.objectFailedValidation(importItem)) {
                    msg = Message.format((ResourceBundle)RB.getResources(), (String)"ObjectRenameManager.RenamedObjectConflict.fmt.txt", (Object)displayType, (Object)originalPath, (Object)importItem.getName());
                    this._importOperation.getLogger().warn(msg);
                    continue;
                }
                msg = Message.format((ResourceBundle)RB.getResources(), (String)"ObjectRenameManager.RenamedObject.fmt.txt", (Object)displayType, (Object)originalPath, (Object)importItem.getName());
                this._importOperation.getLogger().info(msg);
            }
        }
    }

    private boolean objectFailedValidation(ImportItemInterface importItem) {
        return this._failedValidationList != null && this._failedValidationList.contains(importItem);
    }

    private void renameAndValidate(ImportNameValidatorInterface nameValidator, ImportItemInterface item, Set<ImportItemInterface> objectsToBeRenamed) throws MdException, RemoteException {
        Set<String> names = null;
        int renameCount = 0;
        boolean validated = false;
        while (!validated) {
            validated = nameValidator.validateName(item, this._importOperation);
            if (!validated) {
                if (names == null) {
                    names = this.getNamesAlreadyInUse(item);
                }
                renameCount = this.renameObject(item, names, renameCount, objectsToBeRenamed);
                continue;
            }
            if (objectsToBeRenamed.size() <= 1 || !this.duplicateObjectExists(item, objectsToBeRenamed)) continue;
            if (names == null) {
                names = this.getNamesAlreadyInUse(item);
            }
            int originalCount = renameCount;
            if ((renameCount = this.renameObject(item, names, renameCount, objectsToBeRenamed)) <= originalCount) continue;
            validated = false;
        }
    }

    private int renameObject(ImportItemInterface item, Set<String> names, int renameCount, Set<ImportItemInterface> objectsToBeRenamed) throws RemoteException, MdException {
        boolean renamed = this.generateNewName(item, names, renameCount);
        if (renamed) {
            this._rc |= 4;
            ++renameCount;
            if (!objectsToBeRenamed.contains(item)) {
                objectsToBeRenamed.add(item);
            }
            if (this._failedValidationList == null) {
                this._failedValidationList = new ArrayList<ImportItemInterface>();
            }
            if (!this._failedValidationList.contains(item)) {
                this._failedValidationList.add(item);
            }
        }
        return renameCount;
    }

    private boolean duplicateObjectExists(ImportItemInterface item, Set<ImportItemInterface> objectsToBeRenamed) {
        for (ImportItemInterface otherItem : objectsToBeRenamed) {
            String[] path2;
            String[] path1;
            String thisType;
            String otherType;
            if (otherItem == item || !(otherType = otherItem.getTypeInterface().getPublicType()).equalsIgnoreCase(thisType = item.getTypeInterface().getPublicType()) || !otherItem.getName().equalsIgnoreCase(item.getName()) || !MetadataTreeUtil.arePathsEqual(path1 = otherItem.getTargetPath(), path2 = item.getTargetPath())) continue;
            return true;
        }
        return false;
    }

    public boolean generateNewName(ImportItemInterface importItem) throws MdException, RemoteException {
        Set<String> names = this.getNamesAlreadyInUse(importItem);
        return this.generateNewName(importItem, names, 0);
    }

    public boolean generateNewName(ImportItemInterface importItem, Set<String> objectNames) throws MdException, RemoteException {
        return this.generateNewName(importItem, objectNames, 0);
    }

    public boolean generateNewName(ImportItemInterface importItem, Set<String> names, int renameCount) throws MdException, RemoteException {
        if (importItem == null || importItem.getTypeInterface() == null) {
            return false;
        }
        String originalName = null;
        CurrentObjectName con = this._renamedObjectMap.get(importItem);
        if (con == null) {
            originalName = importItem.getOriginalName();
        } else {
            originalName = con.getCurrentName();
            int index = con.getCopyIndex();
            if (renameCount < index) {
                renameCount = index;
            }
        }
        String newName = null;
        boolean isOverridingNameGen = importItem instanceof ImportRenameInterface;
        boolean extensionsSupported = false;
        String publicType = importItem.getTypeInterface().getPublicType();
        ImportListener importListener = this.getImportListener(publicType);
        if (importListener instanceof ImportNameExtensionProvider) {
            extensionsSupported = true;
        }
        int count = 1000;
        for (int index = renameCount + 1; index < count; ++index) {
            String name;
            newName = ObjectRenameManager.generateDefaultCopyName(originalName, index, extensionsSupported);
            if (isOverridingNameGen && (name = ((ImportRenameInterface)((Object)importItem)).generateNewName(newName)) != null) {
                newName = name;
            }
            if (newName.length() > 60) {
                int numChars = newName.length() - originalName.length();
                if (extensionsSupported && newName.lastIndexOf(46) > -1) {
                    int extensionIndex = newName.lastIndexOf(46);
                    String extension = newName.substring(extensionIndex);
                    String name2 = newName.substring(0, newName.length() - (numChars += extension.length()));
                    String copyCounter = newName.substring(newName.length() - numChars, extensionIndex);
                    newName = name2.substring(0, 60 - numChars).trim();
                    newName = newName + copyCounter + extension;
                } else {
                    String copyCounter = newName.substring(newName.length() - numChars);
                    newName = newName.substring(0, 60 - numChars).trim();
                    newName = newName + copyCounter;
                }
                this._importOperation.getLogger().debug("Truncating new name so that it does not exceed 60 characters");
            }
            if (names.contains(newName)) continue;
            if (this.getCountNoSecurityForImportItem(importItem, newName) == 0) {
                this.renameItem(importItem, newName, true);
                return true;
            }
            String displayType = importItem.getTypeInterface().getDisplayType();
            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"ObjectRenameManager.RenameFailed.fmt.txt", (Object)displayType, (Object)importItem.toString(), (Object)newName);
            this._importOperation.getLogger().info(msg);
        }
        if (newName == null) {
            newName = Message.format((ResourceBundle)RB.getResources(), (String)"ObjectRenameManager.CopyNOf.fmt.txt", (Object)String.valueOf(renameCount), (Object)originalName);
        }
        String msg = Message.format((ResourceBundle)RB.getResources(), (String)"ObjectRenameManager.SameName.fmt.txt", (Object)newName);
        throw new IllegalStateException(msg);
    }

    public void renameItem(ImportItemInterface importItem, String newName) {
        this.renameItem(importItem, newName, false);
    }

    public void renameItem(ImportItemInterface importItem, String newName, boolean isCopy) {
        CurrentObjectName con = this._renamedObjectMap.get(importItem);
        if (con == null) {
            con = isCopy ? new CurrentObjectName(importItem.getName(), isCopy) : new CurrentObjectName(newName);
            this._renamedObjectMap.put(importItem, con);
        } else if (isCopy) {
            con.incrementCopyIndex();
        } else {
            con.setCurrentName(newName);
        }
        importItem.rename(newName);
    }

    private Set<String> getNamesAlreadyInUse(ImportItemInterface importItem) throws MdException, RemoteException {
        Map parentFolderMap;
        String[] targetPath;
        String rootFolderID;
        String reposID;
        if (this._topLevelFoldersMap == null) {
            this._topLevelFoldersMap = BIPTreeUtil.getMapOfRootFolders(this._importOperation.getMetadataFactory());
        }
        String publicType = importItem.getTypeInterface().getPublicType();
        List members = null;
        if ("Folder".equals(publicType)) {
            if (this._importOperation.importIntoRoot()) {
                Map topLevelFolders = BIPTreeUtil.loadRootFolders(this._importOperation.getMetadataFactory());
                if (topLevelFolders != null) {
                    members = (List)topLevelFolders.get("SoftwareTrees");
                }
            } else {
                reposID = this._importOperation.getRepositoryID();
                rootFolderID = this.getTopLevelFolderID(importItem);
                targetPath = importItem.getTargetPath();
                parentFolderMap = BIPTreeUtil.getMapOfParentFolder(this._importOperation.getMetadataFactory(), reposID, rootFolderID, targetPath, false, true);
                if (parentFolderMap != null) {
                    members = (List)parentFolderMap.get("SubTrees");
                }
            }
        } else {
            reposID = this._importOperation.getRepositoryID();
            rootFolderID = this.getTopLevelFolderID(importItem);
            targetPath = importItem.getTargetPath();
            parentFolderMap = BIPTreeUtil.getMapOfParentFolder(this._importOperation.getMetadataFactory(), reposID, rootFolderID, targetPath, true, false);
            if (parentFolderMap != null) {
                members = (List)parentFolderMap.get("Members");
            }
        }
        HashSet<String> namesAlreadyInUse = new HashSet<String>();
        if (members != null) {
            for (Map map : members) {
                String type = (String)map.get("PublicType");
                if (!publicType.equalsIgnoreCase(type)) continue;
                namesAlreadyInUse.add((String)map.get("Name"));
            }
        }
        return namesAlreadyInUse;
    }

    private int getCountNoSecurityForImportItem(ImportItemInterface importItem, String newName) throws MdException, RemoteException {
        String publicType = importItem.getTypeInterface().getPublicType();
        try {
            ServerInterface server = this._importOperation.getServer();
            if (SASFoldersUtil.isContainedByVirtualFolder((String)publicType, (ServerInterface)server)) {
                return this.getCountNoSecurityForVirtualFolderMember(importItem, newName);
            }
            if (SASFoldersUtil.isContainedByFolder((String)publicType, (ServerInterface)server)) {
                return this.getCountNoSecurityForFolderMember(importItem, newName);
            }
        }
        catch (ServiceException e) {
            throw new MdException((Throwable)e);
        }
        return 0;
    }

    private int getCountNoSecurityForVirtualFolderMember(ImportItemInterface importItem, String newName) throws ServiceException, MdException, RemoteException {
        String folderPath;
        ServerInterface server;
        PathUrl url;
        String[] path = importItem.getTargetPath();
        if (path != null && path.length > 0 && (url = PathUrl.newPathUrlFromAbsolutePath((ServerInterface)(server = this._importOperation.getServer()), (String)(folderPath = BIPTreeUtil.pathToString(path)))) != null) {
            url.setType("Folder");
            MetadataInterface mi = server.getObjectByPath(url);
            if (mi != null) {
                OMIRepositoryInterface repos = (OMIRepositoryInterface)mi.getRepository();
                String reposId = repos.getDefaultRepositoryId();
                String publicType = importItem.getTypeInterface().getPublicType();
                String xmlSelect = BIPTreeUtil.buildXMLSelectForVirtualFolderMember(newName, publicType);
                MdSecurityUtil securityUtil = this._importOperation.getMetadataFactory().getSecurityUtil();
                return securityUtil.getCountNoSecurity(reposId, xmlSelect, importItem.getTypeInterface().getMetadataType());
            }
        }
        return 0;
    }

    private int getCountNoSecurityForFolderMember(ImportItemInterface importItem, String newName) throws MdException, RemoteException {
        String rootFolderID;
        String[] path = importItem.getTargetPath();
        if (path.length == 0) {
            String reposID = this._importOperation.getFoundationRepositoryID();
            SoftwareComponent sc = BIPTreeUtil.getBIPService(this._importOperation.getMetadataFactory(), this._importOperation.getStore(), reposID);
            String xmlSelect = BIPTreeUtil.buildXMLSelectForRootFolder(newName, sc.getId());
            MdSecurityUtil securityUtil = this._importOperation.getMetadataFactory().getSecurityUtil();
            return securityUtil.getCountNoSecurity(reposID, xmlSelect, importItem.getTypeInterface().getMetadataType());
        }
        if (this._topLevelFoldersMap == null) {
            this._topLevelFoldersMap = BIPTreeUtil.getMapOfRootFolders(this._importOperation.getMetadataFactory());
        }
        if ((rootFolderID = this.getTopLevelFolderID(importItem)) == null) {
            if (this.isImportingFolder(importItem.getSourcePath())) {
                return 0;
            }
            throw new IllegalStateException(Message.format((ResourceBundle)RB.getResources(), (String)"ObjectRenameManager.NoRootFolder.fmt.txt", (Object)importItem.toString()));
        }
        String[] objectPath = new String[path.length + 1];
        System.arraycopy(path, 0, objectPath, 0, path.length);
        objectPath[path.length] = newName;
        String reposID = "A0000001." + rootFolderID.substring(0, 8);
        String publicType = importItem.getTypeInterface().getPublicType();
        String xmlSelect = "Folder".equalsIgnoreCase(publicType) ? BIPTreeUtil.buildXMLSelectForFolder(objectPath, rootFolderID) : BIPTreeUtil.buildXMLSelectForObject(objectPath, publicType, rootFolderID);
        MdSecurityUtil securityUtil = this._importOperation.getMetadataFactory().getSecurityUtil();
        return securityUtil.getCountNoSecurity(reposID, xmlSelect, importItem.getTypeInterface().getMetadataType());
    }

    private String getTopLevelFolderID(ImportItemInterface importItem) throws RemoteException, MdException {
        String[] path = importItem.getTargetPath();
        if (path != null && path.length > 0) {
            String topLevelFolderName = path[0];
            return this.getTopLevelFolderID(topLevelFolderName);
        }
        return this.getTopLevelFolderID(importItem.getName());
    }

    private String getTopLevelFolderID(String folderName) throws RemoteException, MdException {
        SoftwareComponent sc;
        if (this._topLevelFoldersMap == null) {
            return null;
        }
        for (Map.Entry entry : this._topLevelFoldersMap.entrySet()) {
            String name = (String)entry.getValue();
            if (!name.equals(folderName)) continue;
            return (String)entry.getKey();
        }
        if (this._importOperation.isProjectRepository() && (sc = BIPTreeUtil.getBIPService(this._importOperation.getMetadataFactory(), this._importOperation.getStore(), this._importOperation.getFoundationRepositoryID())) != null) {
            String xmlSelect = BIPTreeUtil.buildXMLSelectForRootFolder(folderName, sc.getId());
            Map projectReposTree = BIPTreeUtil.searchForObject(this._importOperation.getMetadataFactory(), xmlSelect, this._importOperation.getRepositoryID(), "Tree", true);
            if (projectReposTree != null) {
                return (String)projectReposTree.get("Id");
            }
        }
        return null;
    }

    private boolean isImportingFolder(String[] folderPath) throws MdException, RemoteException {
        String sPath = null;
        if (folderPath != null && folderPath.length > 0) {
            sPath = BIPTreeUtil.pathToString(folderPath);
        }
        if (sPath != null) {
            try {
                PathUrl path = PathUrl.newPathUrlFromAbsolutePath((ServerInterface)this._importOperation.getServer(), (String)sPath);
                if (path != null) {
                    ImportItemInterface item;
                    if (path.getType() == null) {
                        path.setType("Folder");
                    }
                    if ((item = (ImportItemInterface)this._importOperation.getPromotionItem(path)) != null && item.getImportState() != 0) {
                        return true;
                    }
                }
            }
            catch (ServiceException e) {
                throw new MdException((Throwable)e);
            }
        }
        return false;
    }

    class CurrentObjectName {
        private String _currentName;
        private int _copyIndex;

        public CurrentObjectName(String name) {
            this._currentName = name;
        }

        public CurrentObjectName(String name, boolean isCopy) {
            this._currentName = name;
            this.incrementCopyIndex();
        }

        public void incrementCopyIndex() {
            ++this._copyIndex;
        }

        public void setCurrentName(String name) {
            this._currentName = name;
        }

        public String getCurrentName() {
            return this._currentName;
        }

        public int getCopyIndex() {
            return this._copyIndex;
        }
    }
}

