/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.promotion;

import com.sas.metadata.promotion.BIPTreeUtil;
import com.sas.metadata.promotion.ImportItemInterface;
import com.sas.metadata.promotion.ImportOperationInterface;
import com.sas.metadata.promotion.MetadataPromotionException;
import com.sas.metadata.promotion.NotificationEvent;
import com.sas.metadata.promotion.NotificationListener;
import com.sas.metadata.promotion.PromotionItemInterface;
import com.sas.metadata.promotion.PromotionUtil;
import com.sas.metadata.promotion.RB;
import com.sas.metadata.promotion.UpgradeManager;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.Tree;
import com.sas.services.ServiceException;
import com.sas.services.information.metadata.FolderUtil;
import com.sas.services.information.metadata.PathUrl;
import com.sas.services.information.publicobject.PublicObjectContainerInterface;
import com.sas.services.information.publicobject.PublicObjectInterface;
import com.sas.services.information.publicobject.TypeDescriptorInterface;
import com.sas.services.information.sasfolders.ContainerNodeInterface;
import com.sas.services.information.sasfolders.FolderNodeInterface;
import com.sas.services.information.sasfolders.PublicObjectNodeInterface;
import com.sas.services.information.sasfolders.SASFoldersUtil;
import com.sas.text.Message;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;

public class ObjectMoveManager
implements NotificationListener {
    private static Map<ImportOperationInterface, ObjectMoveManager> _instanceCache = new HashMap<ImportOperationInterface, ObjectMoveManager>(5);
    private ImportOperationInterface _operation;
    private Set<String> _orphanedObjectCache;
    private Map<String, ContainerNodeInterface> _preservePathCache;
    private Map<String, PathUrl> _parentFolderCache;
    private Map<String, ObjectPathInfo> _updatedPathCache;
    private Set<String> _objectIds;

    private ObjectMoveManager(ImportOperationInterface operation) {
        this._operation = operation;
    }

    public static boolean instanceCreated(ImportOperationInterface operation) throws ServiceException, RemoteException {
        if (operation == null) {
            throw new IllegalArgumentException("Invalid import operation");
        }
        return _instanceCache.containsKey(operation);
    }

    public static synchronized ObjectMoveManager getInstance(ImportOperationInterface operation) {
        if (operation == null) {
            throw new IllegalArgumentException("Invalid operation");
        }
        if (_instanceCache.containsKey(operation)) {
            return _instanceCache.get(operation);
        }
        ObjectMoveManager instance = new ObjectMoveManager(operation);
        operation.addNotificationListener(instance);
        _instanceCache.put(operation, instance);
        return instance;
    }

    public static synchronized ObjectMoveManager getNewInstance(ImportOperationInterface operation) {
        if (operation == null) {
            throw new IllegalArgumentException("Invalid operation");
        }
        ObjectMoveManager instance = new ObjectMoveManager(operation);
        operation.addNotificationListener(instance);
        _instanceCache.put(operation, instance);
        return instance;
    }

    public void dispose() {
        this._operation.removeNotificationListener(this);
        _instanceCache.remove(this._operation);
        this._parentFolderCache = null;
        this._orphanedObjectCache = null;
        this._preservePathCache = null;
        this._updatedPathCache = null;
    }

    public PathUrl getNewParentFolder(String id) {
        return this.isParentFolderModified(id) ? this._parentFolderCache.get(id) : null;
    }

    public boolean containsDirectlyMovedObjects() {
        return this._parentFolderCache == null ? false : this._parentFolderCache.size() > 0;
    }

    public List<String> getDirectlyMovedObjects() {
        if (this._parentFolderCache == null) {
            return Collections.emptyList();
        }
        return new ArrayList<String>(this._parentFolderCache.keySet());
    }

    public boolean isParentFolderModified(String id) {
        return this._parentFolderCache == null ? false : this._parentFolderCache.containsKey(id);
    }

    public boolean isTargetPathModified(String id) {
        return this._updatedPathCache == null ? false : this._updatedPathCache.containsKey(id);
    }

    public PathUrl getCustomTargetPath(String id) {
        return this.isTargetPathModified(id) ? this._updatedPathCache.get(id).getNewPath() : null;
    }

    public PathUrl getOriginalTargetPath(PublicObjectNodeInterface node) throws ServiceException, RemoteException {
        String id = node.getIdentifier();
        return this.isTargetPathModified(id) ? this._updatedPathCache.get(id).getOriginalPath() : node.getPathUrl();
    }

    public void setCustomTargetPath(String id, String name, String publicType, PathUrl parentPath) throws ServiceException, RemoteException {
        this._objectIds = new LinkedHashSet<String>();
        this.setCustomTargetPath(id, name, publicType, parentPath, true);
    }

    private void setCustomTargetPath(String id, String name, String publicType, PathUrl parentPath, boolean direct) throws ServiceException, RemoteException {
        ImportItemInterface thisItem;
        this.initializeCaches();
        if (direct) {
            TypeDescriptorInterface type = this._operation.getServer().getTypeDescriptor(publicType);
            this._operation.getLogger().info(Message.format((ResourceBundle)RB.getResources(), (String)"ObjectMoveManager.MovingObject.fmt.txt", (Object)(type == null ? publicType : type.getType()), (Object)name, (Object)parentPath.getDisplayPath()));
        }
        this.removeObjectFromPreserveCache(id);
        this._objectIds.add(id);
        String extendedPath = name + "(" + publicType + ")";
        PathUrl objectPath = new PathUrl(parentPath, extendedPath);
        ObjectPathInfo paths = this._updatedPathCache.get(id);
        if (paths == null) {
            paths = new ObjectPathInfo(null, objectPath);
            this._updatedPathCache.put(id, paths);
        } else {
            paths.setNewPath(objectPath);
        }
        if (direct) {
            this._parentFolderCache.put(id, parentPath);
        } else if (this._parentFolderCache.containsKey(id)) {
            this._parentFolderCache.remove(id);
        }
        if (FolderUtil.isFolder((String)publicType) && (thisItem = (ImportItemInterface)this._operation.getMetadataManager().getPromotionItem(id)) != null) {
            String[] folderPath = BIPTreeUtil.getFolderPathWithName(name, thisItem.getSourcePath());
            List<? extends PromotionItemInterface> importItems = this._operation.getMetadataManager().getPromotionItems();
            for (ImportItemInterface importItemInterface : importItems) {
                String[] itemPath = importItemInterface.getSourcePath();
                if (!SASFoldersUtil.areFolderPathsEqual((String[])itemPath, (String[])folderPath) || this.isTargetPathModified(importItemInterface.getID())) continue;
                this.setCustomTargetPath(importItemInterface.getID(), importItemInterface.getName(), importItemInterface.getTypeInterface().getPublicType(), objectPath, false);
            }
        }
    }

    public void setCustomTargetPath(PublicObjectNodeInterface node, PathUrl parentPath) throws ServiceException, RemoteException {
        this._objectIds = new LinkedHashSet<String>();
        this.setCustomTargetPath(node, parentPath, true);
    }

    private void setCustomTargetPath(PublicObjectNodeInterface node, PathUrl parentPath, boolean direct) throws ServiceException, RemoteException {
        this.initializeCaches();
        if (direct) {
            this._operation.getLogger().info(Message.format((ResourceBundle)RB.getResources(), (String)"ObjectMoveManager.MovingObject.fmt.txt", (Object)node.getTypeDescriptor().getType(), (Object)node.getDisplayPath(), (Object)parentPath.getDisplayPath()));
        }
        String id = node.getIdentifier();
        this.removeObjectFromPreserveCache(id);
        this._objectIds.add(id);
        String extendedPath = node.getName() + "(" + node.getTypeDescriptor().getTypeName() + ")";
        PathUrl objectPath = new PathUrl(parentPath, extendedPath);
        ObjectPathInfo paths = this._updatedPathCache.get(id);
        if (paths == null) {
            paths = new ObjectPathInfo(node.getPathUrl(), objectPath);
            this._updatedPathCache.put(id, paths);
        } else {
            paths.setNewPath(objectPath);
        }
        if (direct) {
            this._parentFolderCache.put(id, parentPath);
        } else if (this._parentFolderCache.containsKey(id)) {
            this._parentFolderCache.remove(id);
        }
        if (node instanceof FolderNodeInterface) {
            List children = ((FolderNodeInterface)node).getChildren();
            for (PublicObjectNodeInterface child : children) {
                this.setCustomTargetPath(child, objectPath, false);
            }
        }
    }

    private void initializeCaches() {
        if (this._updatedPathCache == null) {
            this._updatedPathCache = new LinkedHashMap<String, ObjectPathInfo>();
        }
        if (this._parentFolderCache == null) {
            this._parentFolderCache = new LinkedHashMap<String, PathUrl>(5);
        }
    }

    public List<String> getObjectsToPreserve() {
        if (this._preservePathCache == null) {
            return null;
        }
        ArrayList<String> items = new ArrayList<String>(this._preservePathCache.size());
        for (String id : this._preservePathCache.keySet()) {
            items.add(id);
        }
        return items;
    }

    public boolean isPreservingFolderPath(String id) {
        return this._preservePathCache == null ? false : this._preservePathCache.containsKey(id);
    }

    public void removeObjectFromPreserveCache(String id) {
        if (this._preservePathCache != null && this._preservePathCache.containsKey(id)) {
            this._preservePathCache.remove(id);
        }
    }

    public void preserveFolderPath(String id, ContainerNodeInterface parentNode) throws ServiceException, RemoteException {
        if (this._preservePathCache == null) {
            this._preservePathCache = new LinkedHashMap<String, ContainerNodeInterface>();
        }
        this._preservePathCache.put(id, parentNode);
    }

    public void addOrphanedObject(String id) throws ServiceException, RemoteException {
        if (this._orphanedObjectCache == null) {
            this._orphanedObjectCache = new HashSet<String>();
        }
        this._orphanedObjectCache.add(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int moveOrphanedObjects() throws RemoteException {
        if (this._orphanedObjectCache == null || this._orphanedObjectCache.isEmpty()) {
            return 0;
        }
        int rc = 0;
        MdObjectStore store = null;
        try {
            PublicObjectContainerInterface targetContainer;
            store = this._operation.getMetadataFactory().createObjectStore(null, "PartialPromotion:OrphanedObjectStore");
            PublicObjectContainerInterface parentFolder = null;
            if (!this._operation.importIntoRoot() && PromotionUtil.isFolder((PublicObjectInterface)(targetContainer = this._operation.getTargetContainer()))) {
                parentFolder = targetContainer;
            }
            if (parentFolder != null) {
                this._operation.getLogger().info(Message.format((ResourceBundle)RB.getResources(), (String)"ObjectMoveManager.MoveToTargetFolder.fmt.txt", (Object)parentFolder.getName()));
                Tree targetFolder = BIPTreeUtil.getFolder(this._operation.getMetadataFactory(), store, parentFolder.getIdentifier());
                for (String objectID : this._orphanedObjectCache) {
                    ImportItemInterface importItem = this._operation.getImportItem(objectID);
                    if (importItem == null || importItem.getImportState() != 1) continue;
                    try {
                        this.moveItem(importItem, targetFolder);
                    }
                    catch (Exception e) {
                        this._operation.getLogger().error(Message.format((ResourceBundle)RB.getResources(), (String)"ObjectMoveManager.FailureMovingObject.fmt.txt", (Object)importItem.getTypeInterface().getDisplayType(), (Object)importItem.toString()));
                        if (this._operation.getLogger().isDebugEnabled()) {
                            this._operation.getLogger().debug((Object)"Error moving objects", e);
                        }
                        rc |= 8;
                    }
                }
            }
        }
        catch (Exception e) {
            this._operation.getLogger().error(RB.getStringResource("ObjectMoveManager.FailureMovingObjects.txt"));
            rc |= 8;
        }
        finally {
            if (store != null) {
                store.dispose();
            }
        }
        return rc;
    }

    private void moveItem(ImportItemInterface importItem, Tree targetFolder) throws MetadataPromotionException, MdException, RemoteException {
        if (importItem.getTargetID() == null || targetFolder == null) {
            return;
        }
        Root meta = this.getObjectFromServer((MdObjectStore)targetFolder.getObjectStore(), importItem);
        AssociationList trees = meta.getTrees();
        trees.clear();
        this._operation.getLogger().info(Message.format((ResourceBundle)RB.getResources(), (String)"ObjectMoveManager.MovingObject.fmt.txt", (Object)importItem.getTypeInterface().getDisplayType(), (Object)(importItem.isOrphaned() ? importItem.getName() : BIPTreeUtil.pathToString(importItem.getSourcePath(), importItem.getName())), (Object)BIPTreeUtil.pathToString(importItem.getTargetPath())));
        trees.add(targetFolder);
        meta.updateMetadataAll();
    }

    private Root getObjectFromServer(MdObjectStore store, ImportItemInterface importItem) throws MetadataPromotionException, MdException, RemoteException {
        int flags = 404;
        if (this._operation.importIntoRoot()) {
            flags |= 0x2000;
        }
        String targetID = importItem.getTargetID();
        String metadataType = UpgradeManager.getInstance().getMetadataType(importItem, this._operation);
        String options = "<XMLSelect search=\"*[@Id='" + targetID + "']\"/><Templates><Root><Trees/></Root></Templates>";
        List objects = this._operation.getMetadataFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)store, this._operation.getRepositoryID(), metadataType, flags, options);
        if (objects != null && objects.size() > 0) {
            return (Root)objects.get(0);
        }
        throw new MdException(Message.format((ResourceBundle)RB.getResources(), (String)"ObjectMoveManager.ObjectNotFound.fmt.txt", (Object)importItem.getTypeInterface().getDisplayType(), (Object)importItem));
    }

    public void fireObjectPathNotificationEvent() {
        if (this._objectIds == null || this._objectIds.isEmpty()) {
            return;
        }
        this.fireObjectPathNotificationEvent(this._objectIds);
    }

    private void fireObjectPathNotificationEvent(Set<String> ids) {
        if (ids == null) {
            return;
        }
        ArrayList<ImportItemInterface> items = new ArrayList<ImportItemInterface>(this._objectIds.size());
        for (String id : ids) {
            ImportItemInterface importItem = (ImportItemInterface)this._operation.getMetadataManager().getPromotionItem(id);
            if (importItem == null) continue;
            items.add(importItem);
        }
        NotificationEvent event = new NotificationEvent(this, this._operation, 260);
        event.setAssociatedPromotionItems(items);
        this._operation.fireNotification(event);
    }

    @Override
    public void notify(NotificationEvent event) {
        switch (event.getEventType()) {
            case 201: {
                if (this._updatedPathCache != null) {
                    this._updatedPathCache.clear();
                }
                if (this._parentFolderCache != null) {
                    this._parentFolderCache.clear();
                }
                if (this._orphanedObjectCache != null) {
                    this._orphanedObjectCache.clear();
                }
                if (this._preservePathCache == null) break;
                this._preservePathCache.clear();
            }
        }
    }

    class ObjectPathInfo {
        private PathUrl _originalPath;
        private PathUrl _newPath;

        public ObjectPathInfo(PathUrl originalPath, PathUrl newPath) {
            this._originalPath = originalPath;
            this._newPath = newPath;
        }

        public PathUrl getOriginalPath() {
            return this._originalPath;
        }

        public PathUrl getNewPath() {
            return this._newPath;
        }

        public void setNewPath(PathUrl newPath) {
            this._newPath = newPath;
        }
    }
}

