/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.promotion;

import com.sas.codepolicy.SASScope;
import com.sas.metadata.logical.RelatedObjectsInterface;
import com.sas.metadata.logical.SimpleLogicalObject;
import com.sas.metadata.logical.SimpleLogicalObjectInterface;
import com.sas.metadata.logical.TransportableTypeInterface;
import com.sas.metadata.logical.TypeInterface;
import com.sas.metadata.promotion.BIPTreeUtil;
import com.sas.metadata.promotion.DefaultExportItem;
import com.sas.metadata.promotion.ExportItemInterface;
import com.sas.metadata.promotion.ExportOperationInterface;
import com.sas.metadata.promotion.Log;
import com.sas.metadata.promotion.MetadataFilterInterface;
import com.sas.metadata.promotion.MetadataNode;
import com.sas.metadata.promotion.MetadataNodeInterface;
import com.sas.metadata.promotion.MetadataTreeInterface;
import com.sas.metadata.promotion.MetadataTreeUtil;
import com.sas.metadata.promotion.ObjectTypeFilter;
import com.sas.metadata.promotion.PromotionItemInterface;
import com.sas.metadata.promotion.PromotionUtil;
import com.sas.metadata.promotion.RB;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.SoftwareComponent;
import com.sas.metadata.remote.Tree;
import com.sas.text.Message;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;

@SASScope
public class MetadataExportTree
implements MetadataTreeInterface {
    protected ExportTreeComparator _treeComparator = new ExportTreeComparator();
    private ExportOperationInterface _exportOperation;
    private Map _selectedObjects;
    private Map _duplicateNameMap;
    private List _objectIDCache;
    private List _dependenciesList;
    private MetadataNodeInterface _rootNode;
    private MetadataFilterInterface[] _filters = null;
    private boolean _includeDependencies = false;
    private boolean _includeUnknownTypes = true;
    private boolean _allowFolderExport = true;
    private boolean _searchInProjectOnly = false;
    private boolean _includeEmptyFolders = false;

    public MetadataExportTree(ExportOperationInterface exportOperation) {
        this._exportOperation = exportOperation;
        this._objectIDCache = new ArrayList();
    }

    @Override
    public Map getPromotionItems() {
        if (this._selectedObjects == null) {
            this._selectedObjects = new LinkedHashMap();
            this.loadPromotionItems(this._rootNode);
        }
        return this._selectedObjects;
    }

    @Override
    public MetadataNodeInterface getRootNode() {
        return this._rootNode;
    }

    public void setIncludeEmptyFolders(boolean include) {
        this._includeEmptyFolders = include;
    }

    public boolean isIncludingEmptyFolders() {
        return this._includeEmptyFolders;
    }

    public void setIncludeUnknownTypes(boolean ignore) {
        this._includeUnknownTypes = ignore;
    }

    public void setIncludeDependencies(boolean include) {
        this._includeDependencies = include;
    }

    public MetadataFilterInterface[] getFilters() {
        return this._filters;
    }

    public void setFilters(MetadataFilterInterface[] filters) {
        ObjectTypeFilter filter;
        TypeInterface[] availableTypes = this._exportOperation.getUserDefinedSupportedTypes();
        if (availableTypes != null) {
            if (filters == null) {
                this._filters = new MetadataFilterInterface[1];
                this._filters[0] = new ObjectTypeFilter(availableTypes, true);
            } else {
                filter = this.getObjectTypeFilter(filters);
                if (filter != null) {
                    boolean includeFolders = filter.isIncludingEmptyFolders();
                    this.setIncludeEmptyFolders(includeFolders);
                    this._filters = filters;
                } else {
                    int newLength = filters.length + 1;
                    MetadataFilterInterface[] newFilters = new MetadataFilterInterface[newLength];
                    System.arraycopy(filters, 0, newFilters, 0, filters.length);
                    ObjectTypeFilter typeFilter = new ObjectTypeFilter(availableTypes, true);
                    newFilters[newLength - 1] = typeFilter;
                    this._filters = newFilters;
                }
            }
        } else {
            this._filters = filters;
            filter = this.getObjectTypeFilter(filters);
            if (filter != null) {
                boolean excludeFolders = filter.isIncludingEmptyFolders();
                this.setIncludeEmptyFolders(excludeFolders);
            }
        }
        if (this._filters != null && this._filters.length > 0) {
            for (int i = 0; i < this._filters.length; ++i) {
                MetadataFilterInterface filter2 = this._filters[i];
                String desc = filter2.getFilterDescription();
                if (desc == null || desc.length() <= 0) continue;
                this._exportOperation.getLogger().info(desc);
            }
        }
    }

    private ObjectTypeFilter getObjectTypeFilter(MetadataFilterInterface[] filters) {
        if (filters == null) {
            return null;
        }
        for (int i = 0; i < filters.length; ++i) {
            MetadataFilterInterface filter = filters[i];
            if (!(filter instanceof ObjectTypeFilter)) continue;
            return (ObjectTypeFilter)filter;
        }
        return null;
    }

    public List getDependencies() {
        return this._dependenciesList;
    }

    public void allowExportOfSingleFolder(boolean allow) {
        this._allowFolderExport = allow;
    }

    public Map getDuplicateObjectMap() {
        return this._duplicateNameMap;
    }

    public void searchInProjectRepositoryOnly(boolean search) {
        this._searchInProjectOnly = search;
    }

    public void populateTree(SoftwareComponent sc) throws MdException, RemoteException {
        this._rootNode = new MetadataExportNode("SAS Folders");
        Map rootFoldersMap = BIPTreeUtil.loadRootFolders(this._exportOperation.getMetadataFactory(), sc.getId());
        List rootFolders = (List)rootFoldersMap.get("SoftwareTrees");
        if (rootFolders != null && rootFolders.size() > 0) {
            Collections.sort(rootFolders, this._treeComparator);
            int length = rootFolders.size();
            for (int i = 0; i < length; ++i) {
                Map rootFolder = (Map)rootFolders.get(i);
                String name = (String)rootFolder.get("Name");
                String id = (String)rootFolder.get("Id");
                String publicType = (String)rootFolder.get("PublicType");
                SimpleLogicalObjectInterface folder = this.createSimpleLogicalObject(name, id, publicType);
                this.populateFolder(folder, this._rootNode);
            }
        }
        if (!this._includeEmptyFolders) {
            this.pruneChildNodes();
        }
    }

    public void populateTree(Tree tree) throws MdException, RemoteException {
        String publicType = tree.getPublicType();
        if (!"Folder".equals(publicType)) {
            throw new IllegalStateException(RB.getStringResource("MetadataExportTree.MissingPublicType.txt"));
        }
        SimpleLogicalObjectInterface folder = this.createSimpleLogicalObject(tree.getName(), tree.getId(), publicType);
        this.populateFolder(folder, null);
        if (!this._includeEmptyFolders) {
            this.pruneChildNodes();
        }
        if (this._includeDependencies) {
            this.includeDependentObjects();
        }
    }

    public void populateTree(SimpleLogicalObjectInterface[] selectedObjects) throws MdException, RemoteException {
        boolean foldersExist = false;
        boolean exportingRoot = false;
        if (selectedObjects != null) {
            int length = selectedObjects.length;
            if (length == 1 && this._allowFolderExport) {
                SimpleLogicalObjectInterface logicalObject = selectedObjects[0];
                String pType = logicalObject.getTypeInterface().getPublicType();
                if ("RootFolder".equals(pType)) {
                    exportingRoot = true;
                    this._rootNode = new MetadataExportNode("SAS Folders");
                    Map rootFoldersMap = BIPTreeUtil.loadRootFolders(this._exportOperation.getMetadataFactory(), logicalObject.getID());
                    List rootFolders = (List)rootFoldersMap.get("SoftwareTrees");
                    for (int i = 0; i < rootFolders.size(); ++i) {
                        Map rootFolder = (Map)rootFolders.get(i);
                        String name = (String)rootFolder.get("Name");
                        String id = (String)rootFolder.get("Id");
                        String publicType = (String)rootFolder.get("PublicType");
                        SimpleLogicalObjectInterface folder = this.createSimpleLogicalObject(name, id, publicType);
                        this.populateFolder(folder, this._rootNode);
                    }
                } else if ("Folder".equals(pType)) {
                    this.populateFolder(logicalObject, null);
                } else {
                    this._rootNode = new MetadataExportNode("ROOT");
                    String[] sourcePath = BIPTreeUtil.getObjectPathFromServer(this._exportOperation.getStore(), logicalObject.getID(), logicalObject.getTypeInterface().getMetadataType());
                    this.parseFolderMember(this._rootNode, logicalObject, sourcePath);
                }
            } else {
                if (selectedObjects.length > 1) {
                    Arrays.sort(selectedObjects, new ObjectTypeSorter());
                }
                this._rootNode = new MetadataExportNode("ROOT");
                for (int index = 0; index < length; ++index) {
                    SimpleLogicalObjectInterface item = selectedObjects[index];
                    String id = item.getID();
                    String publicType = item.getTypeInterface().getPublicType();
                    if ("Folder".equals(publicType) && !this._objectIDCache.contains(id)) {
                        SimpleLogicalObjectInterface logicalObject = selectedObjects[index];
                        this.populateFolder(logicalObject, this._rootNode);
                        foldersExist = true;
                        continue;
                    }
                    if (this._objectIDCache.contains(id)) continue;
                    String[] sourcePath = BIPTreeUtil.getObjectPathFromServer(this._exportOperation.getStore(), item.getID(), item.getTypeInterface().getMetadataType());
                    this.parseFolderMember(this._rootNode, item, sourcePath);
                }
            }
        }
        if (!this._includeEmptyFolders || foldersExist) {
            this.pruneChildNodes();
        }
        if (!exportingRoot && this._includeDependencies) {
            this.includeDependentObjects();
        }
    }

    private void populateFolder(SimpleLogicalObjectInterface logicalObject, MetadataNodeInterface rootNode) throws MdException, RemoteException {
        String type = logicalObject.getTypeInterface().getPublicType();
        if ("Folder".equals(type)) {
            String id = logicalObject.getID();
            String[] path = BIPTreeUtil.getObjectPathFromServer(this._exportOperation.getStore(), id, "Tree");
            Map treeMap = this._searchInProjectOnly ? BIPTreeUtil.loadObjectsUnderFolderProjectOnly(this._exportOperation.getMetadataFactory(), id, this._exportOperation.getUserDefinedSupportedTypes(), true) : BIPTreeUtil.loadObjectsUnderFolder(this._exportOperation.getMetadataFactory(), id, this._filters);
            this.parseFolder(rootNode, treeMap, path);
        }
    }

    private void parseFolder(MetadataNodeInterface parentNode, Map tree, String[] sourcePath) {
        String publicType = (String)tree.get("PublicType");
        if (publicType != null && publicType.equalsIgnoreCase("Folder")) {
            List members;
            String name = (String)tree.get("Name");
            String id = (String)tree.get("Id");
            MetadataExportNode node = new MetadataExportNode(name, id, publicType, sourcePath);
            this.cacheObjectID(id);
            if (this._rootNode == null) {
                this._rootNode = node;
            } else {
                parentNode.addChild(node);
            }
            String[] startingPath = BIPTreeUtil.getFolderPathWithName(name, sourcePath);
            List subtrees = (List)tree.get("SubTrees");
            if (subtrees != null) {
                Collections.sort(subtrees, this._treeComparator);
                int treesize = subtrees.size();
                for (int i = 0; i < treesize; ++i) {
                    Map subtree = (Map)subtrees.get(i);
                    this.parseFolder(node, subtree, startingPath);
                }
            }
            if ((members = (List)tree.get("Members")) != null && members.size() > 0) {
                Collections.sort(members, this._treeComparator);
                int membersize = members.size();
                for (int i = 0; i < membersize; ++i) {
                    Map member = (Map)members.get(i);
                    this.parseFolderMember((MetadataNodeInterface)node, member, startingPath);
                }
            }
        }
    }

    private void parseFolderMember(MetadataNodeInterface parentNode, Map member, String[] sourcePath) {
        String id = (String)member.get("Id");
        String objectName = (String)member.get("Name");
        String publicType = (String)member.get("PublicType");
        this.parseFolderMember(parentNode, objectName, publicType, id, sourcePath);
    }

    private void parseFolderMember(MetadataNodeInterface parentNode, SimpleLogicalObjectInterface logicalObject, String[] sourcePath) {
        String id = logicalObject.getID();
        String objectName = logicalObject.getName();
        String publicType = logicalObject.getTypeInterface().getPublicType();
        this.parseFolderMember(parentNode, objectName, publicType, id, sourcePath);
    }

    private void parseFolderMember(MetadataNodeInterface parentNode, String objectName, String publicType, String id, String[] path) {
        if (objectName != null && publicType != null) {
            if (this._exportOperation.isTypeSupported(publicType)) {
                MetadataExportNode node = new MetadataExportNode(objectName, id, publicType, path);
                PromotionItemInterface promotionItem = node.getPromotionItem();
                this.cacheObjectID(id);
                if (!this._exportOperation.isUsedForChangeManagement()) {
                    if (!MetadataTreeUtil.isUnique(parentNode, objectName, publicType)) {
                        if (promotionItem != null) {
                            this.addObjectToDuplicateNameMap(promotionItem);
                        }
                    } else {
                        parentNode.addChild(node);
                    }
                } else {
                    parentNode.addChild(node);
                }
            } else if (!this._includeUnknownTypes) {
                String msg = Message.format((ResourceBundle)RB.getResources(), (String)"MetadataExportTree.CannotCopyUnknown.fmt.txt", (Object)BIPTreeUtil.pathToString(path));
                throw new IllegalStateException(msg);
            }
        }
    }

    private void cacheObjectID(String objectID) {
        if (this._objectIDCache != null) {
            this._objectIDCache.add(objectID);
        }
    }

    private void pruneChildNodes() {
        MetadataNodeInterface node = this._rootNode;
        ArrayList children = new ArrayList(node.getChildCount());
        children.addAll(node.getChildren());
        Collections.sort(children, new ChildSorter());
        this.pruneChildren(node, children, new HashSet());
    }

    private void pruneChildren(MetadataNodeInterface node, List childrenList, Set nodeCache) {
        if (childrenList != null) {
            MetadataNodeInterface parent;
            Object[] children = childrenList.toArray();
            int numChildren = children.length;
            for (int i = 0; i < numChildren; ++i) {
                MetadataNodeInterface childNode = (MetadataNodeInterface)children[i];
                String objectID = childNode.getObjectID();
                if (nodeCache.contains(objectID)) {
                    node.removeChild(childNode);
                } else {
                    nodeCache.add(objectID);
                }
                if (!childNode.isFolder()) continue;
                this.pruneChildren(childNode, childNode.getChildren(), nodeCache);
            }
            if (!this._includeEmptyFolders && node.getChildCount() == 0 && (parent = node.getParent()) != null) {
                parent.removeChild(node);
            }
        }
    }

    private void loadPromotionItems(MetadataNodeInterface node) {
        List children;
        if (node == null) {
            return;
        }
        if (node.getPromotionItem() != null) {
            this.addObjectToMap(node.getPromotionItem());
        }
        if ((children = node.getChildren()) != null) {
            for (MetadataNodeInterface childNode : children) {
                if (childNode.getPromotionItem() != null) {
                    this.addObjectToMap(childNode.getPromotionItem());
                }
                if (!childNode.isFolder()) continue;
                this.loadPromotionItems(childNode);
            }
        }
    }

    private void addObjectToMap(SimpleLogicalObjectInterface logicalObject) {
        String logicalType = logicalObject.getTypeInterface().getPublicType();
        ArrayList<SimpleLogicalObjectInterface> items = (ArrayList<SimpleLogicalObjectInterface>)this._selectedObjects.get(logicalType);
        if (items == null) {
            items = new ArrayList<SimpleLogicalObjectInterface>();
            this._selectedObjects.put(logicalType, items);
        }
        if (!items.contains(logicalObject)) {
            items.add(logicalObject);
        }
    }

    private void addObjectToDuplicateNameMap(SimpleLogicalObjectInterface exportItem) {
        if (this._duplicateNameMap == null) {
            this._duplicateNameMap = new LinkedHashMap();
        }
        if (exportItem instanceof ExportItemInterface) {
            this._duplicateNameMap.put(exportItem.getID(), exportItem);
        }
    }

    private SimpleLogicalObjectInterface createSimpleLogicalObject(String name, String id, String type) {
        TransportableTypeInterface ti = this._exportOperation.getTransportableType(type);
        return ti == null ? null : new SimpleLogicalObject(name, id, (TypeInterface)ti);
    }

    private void includeDependentObjects() {
        if (this._rootNode == null) {
            return;
        }
        Log log = this._exportOperation.getLogger();
        log.info(RB.getStringResource("MetadataExportTree.RetrieveDependencies.txt"));
        ArrayList dependentObjectsList = new ArrayList();
        ArrayList<String> objectCache = new ArrayList<String>(this._objectIDCache);
        Map promotionItems = this.getPromotionItems();
        for (String publicType : promotionItems.keySet()) {
            if ("Folder".equalsIgnoreCase(publicType)) continue;
            List items = (List)promotionItems.get(publicType);
            for (ExportItemInterface exportItem : items) {
                if (!objectCache.contains(exportItem.getID())) {
                    objectCache.add(exportItem.getID());
                }
                this.retrieveDependencies(exportItem, dependentObjectsList, objectCache);
            }
        }
        if (dependentObjectsList.size() > 0) {
            for (ExportItemInterface exportItem : dependentObjectsList) {
                this.addObjectToMap(exportItem);
            }
            this._dependenciesList = new ArrayList(dependentObjectsList);
        }
    }

    private void retrieveDependencies(ExportItemInterface exportItem, List dependentObjectsList, List objectCache) {
        block7: {
            if (exportItem instanceof RelatedObjectsInterface) {
                try {
                    List relatedItems;
                    Log log = this._exportOperation.getLogger();
                    if (log.isDebugEnabled()) {
                        log.debug("Retrieving dependencies for \"" + exportItem.toString() + "\"");
                    }
                    if ((relatedItems = ((RelatedObjectsInterface)exportItem).getRelatedObjects(0)) != null && relatedItems.size() > 0) {
                        for (Object item : relatedItems) {
                            String[] path;
                            String name;
                            MetadataExportNode node;
                            TypeInterface type;
                            SimpleLogicalObjectInterface logicalObject;
                            String id;
                            if (!(item instanceof SimpleLogicalObjectInterface) || objectCache.contains(id = (logicalObject = (SimpleLogicalObjectInterface)item).getID()) || (type = logicalObject.getTypeInterface()) == null) continue;
                            String pt = type.getPublicType();
                            if (!this._exportOperation.isTypeSupported(type.getPublicType()) || !PromotionUtil.isTypeContainedByFolder(pt) || (node = new MetadataExportNode(name = logicalObject.getName(), id, pt, path = BIPTreeUtil.getObjectPathFromServer(this._exportOperation.getStore(), id, type.getMetadataType()))).getPromotionItem() == null) continue;
                            ExportItemInterface ei = (ExportItemInterface)node.getPromotionItem();
                            if (!MetadataTreeUtil.isUnique(this._rootNode, name, pt)) {
                                this.addObjectToDuplicateNameMap(ei);
                                continue;
                            }
                            this._rootNode.addChild(node);
                            dependentObjectsList.add(ei);
                            objectCache.add(id);
                            this.retrieveDependencies(ei, dependentObjectsList, objectCache);
                        }
                    }
                }
                catch (Exception e) {
                    Log log = this._exportOperation.getLogger();
                    String type = exportItem.getTypeInterface().getDisplayType();
                    String msg = Message.format((ResourceBundle)RB.getResources(), (String)"MetadataExportTree.DependencyFailure.fmt.txt", (Object)type, (Object)exportItem);
                    log.warn(msg);
                    if (!log.isDebugEnabled()) break block7;
                    log.debug((Object)"Error retrieving dependencies", e);
                }
            }
        }
    }

    @SASScope
    class MetadataExportNode
    extends MetadataNode {
        public MetadataExportNode(String name) {
            super(name, null);
        }

        public MetadataExportNode(String name, String id, String publicType, String[] path) {
            super(name, publicType, id);
            this._promotionItem = MetadataExportTree.this._exportOperation.createExportItem(name, publicType, id);
            if (this._promotionItem instanceof DefaultExportItem) {
                ((DefaultExportItem)this._promotionItem).setSourcePath(path);
            }
        }

        @Override
        public String[] getPath() {
            return this._promotionItem == null ? null : ((ExportItemInterface)this._promotionItem).getSourcePath();
        }
    }

    @SASScope
    class ChildSorter
    implements Comparator {
        ChildSorter() {
        }

        public int compare(Object obj1, Object obj2) {
            int level2;
            MetadataNodeInterface node1 = (MetadataNodeInterface)obj1;
            MetadataNodeInterface node2 = (MetadataNodeInterface)obj2;
            int level1 = node1.getLevel();
            if (level1 == (level2 = node2.getLevel())) {
                String name1 = node1.getName();
                String name2 = node2.getName();
                if (name1 != null && name2 != null) {
                    return name1.compareToIgnoreCase(name2);
                }
                return 0;
            }
            if (level1 < level2) {
                return -1;
            }
            return 1;
        }
    }

    @SASScope
    class ObjectTypeSorter
    implements Comparator {
        ObjectTypeSorter() {
        }

        public int compare(Object obj1, Object obj2) {
            SimpleLogicalObjectInterface publicObject1 = (SimpleLogicalObjectInterface)obj1;
            SimpleLogicalObjectInterface publicObject2 = (SimpleLogicalObjectInterface)obj2;
            String type1 = publicObject1.getTypeInterface().getPublicType();
            String type2 = publicObject2.getTypeInterface().getPublicType();
            if ("Folder".equalsIgnoreCase(type1)) {
                return -1;
            }
            if ("Folder".equalsIgnoreCase(type2)) {
                return 1;
            }
            if (type1 != null && type2 != null) {
                return type1.compareToIgnoreCase(type2);
            }
            return 0;
        }
    }

    @SASScope
    class ExportTreeComparator
    implements Comparator {
        ExportTreeComparator() {
        }

        public int compare(Object obj1, Object obj2) {
            Map map1 = (Map)obj1;
            Map map2 = (Map)obj2;
            String name1 = (String)map1.get("Name");
            String name2 = (String)map2.get("Name");
            if (name1 != null && name2 != null) {
                return name1.compareToIgnoreCase(name2);
            }
            return 0;
        }
    }
}

