/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.promotion;

import com.sas.metadata.promotion.ConnectionTypeInterface;
import com.sas.metadata.promotion.DependentConnectionMapping;
import com.sas.metadata.promotion.DependentConnectionTypeInterface;
import com.sas.metadata.promotion.ExportOperationInterface;
import com.sas.metadata.promotion.ImportHandler;
import com.sas.metadata.promotion.ImportItemInterface;
import com.sas.metadata.promotion.ImportOperationInterface;
import com.sas.metadata.promotion.Log;
import com.sas.metadata.promotion.MetadataPromotionException;
import com.sas.metadata.promotion.PropertiesManager;
import com.sas.metadata.promotion.RB;
import com.sas.metadata.promotion.SourceConnectionInterface;
import com.sas.metadata.promotion.SubstitutionInterface;
import com.sas.metadata.promotion.SubstitutionTypeInterface;
import com.sas.metadata.promotion.TargetConnectionInterface;
import com.sas.services.ServiceException;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.publicobject.TypeDescriptorInterface;
import com.sas.services.user.UserContextInterface;
import com.sas.services.user.UserIdentityInterface;
import com.sas.text.Message;
import java.rmi.RemoteException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;

public class LoggingUtil {
    protected static final String NEW_LINE = "\r\n";
    private static final String INDENT = "   ";
    private static final char SPACE = ' ';
    private static final String COLON = ":";
    private static final String MAP_TO = RB.getStringResource("LoggingUtil.MapToArrow.txt");
    private static final String MAP_START = RB.getStringResource("LoggingUtil.LineStart.txt");
    private static final DateFormat _dateFormat = DateFormat.getDateInstance(1);
    private static final DateFormat _dateTimeFormat = DateFormat.getDateTimeInstance(1, 1);

    public static void logServerInformation(UserContextInterface user, Log log, boolean source) throws ServiceException, RemoteException {
        ServerInterface server = user.getAuthServer();
        if (server == null) {
            return;
        }
        String serverName = server.getHost();
        String port = String.valueOf(server.getPort());
        String domain = server.getDomain();
        String userName = null;
        if (user != null) {
            UserIdentityInterface ident = user.getIdentityByDomain(domain);
            userName = ident == null ? user.getResolvedUserId() : (String)ident.getPrincipal();
        }
        LoggingUtil.logServerInformation(serverName, port, userName, log, source);
    }

    public static void logServerInformation(String host, String port, String userName, Log log, boolean source) {
        String time = LoggingUtil.getFormattedDate(new Date());
        log.info(Message.format((ResourceBundle)RB.getResources(), (String)"LoggingUtil.CurrentTime.fmt.txt", (Object)time));
        if (userName != null) {
            log.info(Message.format((ResourceBundle)RB.getResources(), (String)"LoggingUtil.CurrentUser.fmt.txt", (Object)userName));
        } else {
            String unknown = RB.getStringResource("LoggingUtil.Unknown.txt");
            log.info(Message.format((ResourceBundle)RB.getResources(), (String)"LoggingUtil.CurrentUser.fmt.txt", (Object)unknown));
        }
        if (host != null) {
            if (source) {
                log.info(Message.format((ResourceBundle)RB.getResources(), (String)"LoggingUtil.SourceServer.fmt.txt", (Object)host, (Object)port));
            } else {
                log.info(Message.format((ResourceBundle)RB.getResources(), (String)"LoggingUtil.TargetServer.fmt.txt", (Object)host, (Object)port));
            }
        } else if (source) {
            log.info(RB.getStringResource("LoggingUtil.SourceServerUnknown.txt"));
        } else {
            log.info(RB.getStringResource("LoggingUtil.TargetServerUnknown.txt"));
        }
    }

    public static String displayExportedObjects(Map exportItems, ServerInterface server, boolean includeObjects) throws ServiceException, RemoteException {
        StringBuffer sb = new StringBuffer();
        Iterator iter = exportItems.keySet().iterator();
        if (server != null) {
            while (iter.hasNext()) {
                String type = (String)iter.next();
                List items = (List)exportItems.get(type);
                int size = items.size();
                if (items == null || size <= 0) continue;
                TypeDescriptorInterface td = server.getTypeDescriptor(type);
                String displayName = td == null ? type : td.getType().trim();
                String numObjects = Message.format((ResourceBundle)RB.getResources(), (String)"LoggingUtil.NumberOfObjectsOfType.fmt.txt", (Object)size, (Object)displayName);
                if (includeObjects) {
                    sb.append(NEW_LINE).append(numObjects).append(COLON);
                    for (int i = 0; i < size; ++i) {
                        sb.append(NEW_LINE).append(INDENT);
                        sb.append(items.get(i));
                    }
                    continue;
                }
                sb.append(INDENT).append(MAP_START).append(' ');
                sb.append(numObjects);
                sb.append(NEW_LINE);
            }
        }
        if (sb.length() > 0) {
            sb.append(NEW_LINE);
        }
        return sb.toString();
    }

    public static String displayImportedObjects(Map importItems, ServerInterface server, boolean includeObjects) throws ServiceException, RemoteException {
        StringBuffer sb = new StringBuffer();
        Iterator iter = importItems.keySet().iterator();
        if (server != null) {
            while (iter.hasNext()) {
                int updateCount;
                String type = (String)iter.next();
                TypeDescriptorInterface td = server.getTypeDescriptor(type);
                String displayName = td == null ? type : td.getType().trim();
                List items = (List)importItems.get(type);
                int size = items.size();
                if (items == null || size <= 0) continue;
                ArrayList<ImportItemInterface> newItems = new ArrayList<ImportItemInterface>();
                ArrayList<ImportItemInterface> updatedItems = new ArrayList<ImportItemInterface>();
                block5: for (int i = 0; i < size; ++i) {
                    ImportItemInterface item = (ImportItemInterface)items.get(i);
                    switch (item.getImportState()) {
                        case 1: {
                            newItems.add(item);
                            continue block5;
                        }
                        case 2: {
                            updatedItems.add(item);
                        }
                    }
                }
                int newCount = newItems.size();
                if (newCount > 0) {
                    String msg = Message.format((ResourceBundle)RB.getResources(), (String)"LoggingUtil.CreateObjects.fmt.txt", (Object)newCount, (Object)displayName);
                    if (includeObjects) {
                        sb.append(NEW_LINE).append(msg).append(COLON);
                        for (int i = 0; i < newCount; ++i) {
                            ImportItemInterface item = (ImportItemInterface)newItems.get(i);
                            sb.append(NEW_LINE).append(INDENT);
                            sb.append(item);
                        }
                    } else {
                        sb.append(INDENT).append(MAP_START).append(' ').append(msg).append(NEW_LINE);
                    }
                }
                if ((updateCount = updatedItems.size()) <= 0) continue;
                String msg = Message.format((ResourceBundle)RB.getResources(), (String)"LoggingUtil.OverwriteObjects.fmt.txt", (Object)updateCount, (Object)displayName);
                if (includeObjects) {
                    sb.append(NEW_LINE).append(msg).append(COLON);
                    for (int i = 0; i < updateCount; ++i) {
                        ImportItemInterface item = (ImportItemInterface)updatedItems.get(i);
                        sb.append(NEW_LINE).append(INDENT);
                        sb.append(item);
                    }
                    continue;
                }
                sb.append(INDENT).append(MAP_START).append(' ').append(msg).append(NEW_LINE);
            }
        }
        if (sb.length() > 0) {
            sb.append(NEW_LINE);
        }
        return sb.toString();
    }

    public static String displaySourceConnections(ExportOperationInterface exportOperation) {
        List<ConnectionTypeInterface> connectionTypes = null;
        try {
            connectionTypes = exportOperation.getConnectionTypes();
        }
        catch (MetadataPromotionException e) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        if (connectionTypes != null && connectionTypes.size() > 0) {
            int count = 0;
            for (ConnectionTypeInterface type : connectionTypes) {
                int size;
                List<SourceConnectionInterface> sourceConnections = type.getSourceConnections();
                if (sourceConnections == null || sourceConnections.size() <= 0 || (size = sourceConnections.size()) <= 0) continue;
                if (++count > 1) {
                    sb.append(NEW_LINE);
                }
                String typeName = type.getLocalizedTypeName();
                sb.append(Message.format((ResourceBundle)RB.getResources(), (String)"LoggingUtil.Mapping.fmt.txt", (Object)size, (Object)typeName));
                sb.append(COLON).append(NEW_LINE);
                if (type instanceof DependentConnectionTypeInterface) {
                    DependentConnectionTypeInterface depType = (DependentConnectionTypeInterface)type;
                    DependentConnectionMapping map = depType.getDependentConnectionMapping();
                    for (SourceConnectionInterface childSource : sourceConnections) {
                        SourceConnectionInterface parentSource = map.getDependentConnection(childSource);
                        sb.append(INDENT).append(MAP_START).append(' ');
                        if (parentSource != null) {
                            sb.append(parentSource.getDisplayName() + '.');
                        }
                        sb.append(childSource.getDisplayName());
                        sb.append(NEW_LINE);
                    }
                    continue;
                }
                for (SourceConnectionInterface source : sourceConnections) {
                    sb.append(INDENT).append(MAP_START).append(' ');
                    sb.append(source.getDisplayName()).append(NEW_LINE);
                }
            }
        }
        return sb.toString();
    }

    public static String displayConnectionMapping(ImportOperationInterface importOperation) {
        List<ConnectionTypeInterface> connectionTypes = null;
        try {
            connectionTypes = importOperation.getConnectionTypes();
        }
        catch (MetadataPromotionException e) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        if (connectionTypes != null && connectionTypes.size() > 0) {
            int count = 0;
            for (ConnectionTypeInterface type : connectionTypes) {
                Map<SourceConnectionInterface, TargetConnectionInterface> connectionMap = type.getConnectionMapping();
                int mappingSize = connectionMap.size();
                if (mappingSize <= 0) continue;
                if (++count > 1) {
                    sb.append(NEW_LINE);
                }
                String typeName = type.getLocalizedTypeName();
                sb.append(Message.format((ResourceBundle)RB.getResources(), (String)"LoggingUtil.Mapping.fmt.txt", (Object)new Integer(mappingSize), (Object)typeName));
                sb.append(COLON).append(NEW_LINE);
                if (type instanceof DependentConnectionTypeInterface) {
                    DependentConnectionTypeInterface depType = (DependentConnectionTypeInterface)type;
                    ConnectionTypeInterface parentType = depType.getDependentType();
                    DependentConnectionMapping map = depType.getDependentConnectionMapping();
                    for (SourceConnectionInterface childSource : connectionMap.keySet()) {
                        TargetConnectionInterface childTarget = connectionMap.get(childSource);
                        SourceConnectionInterface parentSource = map.getDependentConnection(childSource);
                        TargetConnectionInterface parentTarget = parentType.getTargetConnection(parentSource);
                        sb.append(INDENT).append(MAP_START).append(' ');
                        if (parentSource != null) {
                            sb.append(parentSource.getDisplayName() + '.');
                        }
                        sb.append(childSource.getDisplayName());
                        sb.append(' ').append(MAP_TO).append(' ');
                        if (parentTarget != null) {
                            sb.append(childTarget == null ? RB.getStringResource("LoggingUtil.NoneSelection.txt") : parentTarget.getDisplayName() + '.');
                        }
                        sb.append(childTarget == null ? RB.getStringResource("LoggingUtil.NoneSelection.txt") : childTarget.getDisplayName());
                        sb.append(NEW_LINE);
                    }
                    continue;
                }
                for (SourceConnectionInterface source : connectionMap.keySet()) {
                    TargetConnectionInterface target = connectionMap.get(source);
                    LoggingUtil.mapConnection(source.getDisplayName(), target == null ? null : target.getDisplayName(), sb);
                }
            }
        }
        if (!importOperation.isBatchProcess()) {
            sb.append(LoggingUtil.displaySubstitutionMapping(importOperation));
        }
        return sb.toString();
    }

    private static String displaySubstitutionMapping(ImportOperationInterface importOperation) {
        Map<SubstitutionTypeInterface, List<SubstitutionInterface>> substitutionsMap = null;
        try {
            PropertiesManager propManager = ((ImportHandler)importOperation).getPropertiesManager();
            substitutionsMap = propManager.getSubstitutions();
        }
        catch (Exception e) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        if (substitutionsMap != null && substitutionsMap.size() > 0) {
            sb.append(NEW_LINE);
            int count = 0;
            for (SubstitutionTypeInterface type : substitutionsMap.keySet()) {
                List<SubstitutionInterface> substitutions = substitutionsMap.get(type);
                int mappingSize = substitutions.size();
                if (mappingSize <= 0) continue;
                if (++count > 1) {
                    sb.append(NEW_LINE);
                }
                String typeName = type.getLocalizedTypeName();
                sb.append(Message.format((ResourceBundle)RB.getResources(), (String)"LoggingUtil.Mapping.fmt.txt", (Object)new Integer(mappingSize), (Object)typeName));
                sb.append(COLON).append(NEW_LINE);
                for (SubstitutionInterface substitution : substitutions) {
                    LoggingUtil.mapConnection(substitution.getSourceValue(), substitution.getTargetValue(), sb);
                }
            }
        }
        return sb.toString();
    }

    private static void mapConnection(String sourceValue, String targetValue, StringBuffer buffer) {
        buffer.append(INDENT).append(MAP_START).append(' ');
        buffer.append(sourceValue == null || sourceValue.length() == 0 ? RB.getStringResource("LoggingUtil.NoneSelection.txt") : sourceValue);
        buffer.append(' ').append(MAP_TO).append(' ');
        buffer.append(targetValue == null || targetValue.length() == 0 ? RB.getStringResource("LoggingUtil.NoneSelection.txt") : targetValue);
        buffer.append(NEW_LINE);
    }

    public static String getFormattedDate(Date date) {
        return LoggingUtil.getFormattedDate(date, true);
    }

    public static String getFormattedDate(Date date, boolean includeTime) {
        return includeTime ? _dateTimeFormat.format(date) : _dateFormat.format(date);
    }
}

