/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.promotion;

import com.sas.metadata.logical.batch.BatchDriver2;
import com.sas.metadata.promotion.PromotionInterface;
import com.sas.metadata.promotion.RB;
import com.sas.text.Message;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.ResourceBundle;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.FileAppender;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.layout.PatternLayout;

public class Log {
    public static final String LOGGING_CONTEXT = "com.sas.metadata.promotion";
    private static final String PATTERN_WITH_TIMESTAMP = "%d{yyyy-MM-dd HH:mm:ss} %-5p - %m%n";
    private static final String PATTERN_NO_TIMESTAMP = "%-5p - %m%n";
    private Logger _logger;
    private Appender _appender;
    private Level _currentLevel = Level.INFO;
    private boolean _previouslyConfigured = false;
    private String _name;
    private String _fileName;
    private static Log _logInstance;
    public static final String LOG_EXTENSION = ".log";
    public static final String INFO = "INFO";
    public static final String DEBUG = "DEBUG";
    public static final String WARN = "WARN";
    public static final String ERROR = "ERROR";
    public static final String FATAL = "FATAL";
    public static final String OFF = "OFF";

    private Log(String name) {
        this._name = name;
        this.initLogger();
    }

    private Log(String name, String filename, Logger logger) {
        this._name = name;
        this._fileName = filename;
        this._logger = logger;
    }

    public static void initAlreadyConfiguredLogger(String name, String filename) {
        if (_logInstance != null) {
            return;
        }
        try {
            Logger logger = LogManager.getLogger((String)name);
            if (logger != null) {
                _logInstance = new Log(name, filename, logger);
                _logInstance.setPreviouslyConfigured(true);
            }
        }
        catch (Exception e) {
            System.out.println("ERROR Unable to initialize logging service.  Using System.out for logging.");
        }
    }

    public static Log getInstance(String name) {
        if (_logInstance == null) {
            _logInstance = new Log(name);
        }
        return _logInstance;
    }

    @Deprecated
    public static Log getInstance(String name, PromotionInterface promotion) {
        return Log.getInstance(name);
    }

    @Deprecated
    public static Log getInstance(String name, int promotionType) {
        return Log.getInstance(name);
    }

    private void setPreviouslyConfigured(boolean configured) {
        this._previouslyConfigured = configured;
    }

    protected boolean isPreviouslyConfigured() {
        return this._previouslyConfigured;
    }

    private void initLogger() {
        if (this._logger != null) {
            return;
        }
        try {
            this._logger = LogManager.getLogger((String)this._name);
            if (this._logger != null) {
                String value = System.getProperty("promotion.log.level");
                if (value != null) {
                    if ((value = value.toUpperCase()).equalsIgnoreCase(INFO)) {
                        Configurator.setLevel((String)this._name, (Level)Level.INFO);
                    } else if (value.equalsIgnoreCase(WARN)) {
                        Configurator.setLevel((String)this._name, (Level)Level.WARN);
                    } else if (value.equalsIgnoreCase(DEBUG)) {
                        Configurator.setLevel((String)this._name, (Level)Level.DEBUG);
                    } else if (value.equalsIgnoreCase(ERROR)) {
                        Configurator.setLevel((String)this._name, (Level)Level.ERROR);
                    } else if (value.equalsIgnoreCase(FATAL)) {
                        Configurator.setLevel((String)this._name, (Level)Level.FATAL);
                    } else {
                        Configurator.setLevel((String)this._name, (Level)Level.INFO);
                    }
                } else {
                    Level level = this._logger.getLevel();
                    if (level.isMoreSpecificThan(this._currentLevel)) {
                        Configurator.setLevel((String)this._name, (Level)this._currentLevel);
                    }
                }
            }
        }
        catch (Exception e) {
            System.out.println("WARNING: Unable to retrieve logging service.  Using System.out for logging.");
            this._logger = null;
        }
    }

    protected void initializeLogger(String filePrefix, boolean includeTimestamp) {
        if (this.isPreviouslyConfigured() || this._fileName != null) {
            return;
        }
        boolean debug = this.isDebugEnabled();
        LoggerContext lc = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration config = lc.getConfiguration();
        PatternLayout layout = PatternLayout.newBuilder().withConfiguration(config).withPattern(debug ? PATTERN_WITH_TIMESTAMP : PATTERN_NO_TIMESTAMP).build();
        StringBuilder sb = new StringBuilder(75);
        String dir = System.getProperty("promotion.log.dir");
        String fileSep = System.getProperty("file.separator");
        if (dir == null || dir.length() == 0) {
            sb.append(BatchDriver2.getDefaultLogDirectory(null, null));
            sb.append(fileSep);
        } else {
            sb.append(dir);
            if (!dir.endsWith(fileSep)) {
                sb.append(fileSep);
            }
        }
        if (filePrefix == null) {
            filePrefix = "Promotion";
        }
        sb.append(filePrefix);
        if (includeTimestamp) {
            SimpleDateFormat sdf = new SimpleDateFormat("_yyMMddHHmmss");
            sb.append(sdf.format(new Date()));
        }
        sb.append(LOG_EXTENSION);
        this._fileName = sb.toString();
        this._appender = ((FileAppender.Builder)((FileAppender.Builder)((FileAppender.Builder)FileAppender.newBuilder().setName(this._fileName)).withFileName(this._fileName).withAppend(false).setLayout((Layout)layout)).setConfiguration(config)).build();
        this._appender.start();
        config.addAppender(this._appender);
        config.addAppender(this._appender);
        lc.getLogger(this._logger.getName()).setAdditive(false);
        lc.getLogger(this._logger.getName()).addAppender(this._appender);
        lc.updateLoggers();
        this.setPreviouslyConfigured(true);
    }

    public String getName() {
        return this._name;
    }

    public String toString() {
        return this._name;
    }

    public String getLogFileName() {
        return this._fileName;
    }

    public Logger getLog4JLogger() {
        return this._logger;
    }

    private void log(Level level, Object message, Throwable cause) {
        if (this._logger != null) {
            this._logger.log(level, message, cause);
        } else {
            String msg = this.getLogMessage(level, message);
            System.out.println(msg);
            if (cause != null) {
                System.out.println("causing exception: " + cause.toString());
            }
        }
    }

    private String getLogMessage(Level level, Object message) {
        String key = null;
        switch (level.name()) {
            case "DEBUG": {
                key = "Log.DebugMessage.fmt.txt";
                break;
            }
            case "INFO": {
                key = "Log.InfoMessage.fmt.txt";
                break;
            }
            case "WARN": {
                key = "Log.WarnMessage.fmt.txt";
                break;
            }
            case "ERROR": {
                key = "Log.ErrorMessage.fmt.txt";
                break;
            }
            case "FATAL": {
                key = "Log.FatalMessage.fmt.txt";
            }
        }
        return key == null ? null : Message.format((ResourceBundle)RB.getResources(), (String)key, (Object)message);
    }

    public void fatal(Object message) {
        this.log(Level.ERROR, message, null);
    }

    public void fatal(Object message, Throwable cause) {
        this.log(Level.FATAL, message, cause);
    }

    public void error(Object message) {
        this.log(Level.ERROR, message, null);
    }

    public void error(Object message, Throwable cause) {
        this.log(Level.ERROR, message, cause);
    }

    public void warn(Object message) {
        this.log(Level.WARN, message, null);
    }

    public void warn(Object message, Throwable cause) {
        this.log(Level.WARN, message, cause);
    }

    public void info(Object message) {
        this.log(Level.INFO, message, null);
    }

    public void info(Object message, Throwable cause) {
        this.log(Level.INFO, message, cause);
    }

    public void debug(Object message) {
        this.log(Level.DEBUG, message, null);
    }

    public void debug(Object message, Throwable cause) {
        this.log(Level.DEBUG, message, cause);
    }

    public void debug(Object arg1, String msg) {
        this.debug(MessageFormat.format(msg, arg1));
    }

    public void debug(String msg, Object arg1, Object arg2) {
        this.debug(MessageFormat.format(msg, arg1, arg2));
    }

    public void debug(String msg, Object arg1, Object arg2, Object arg3) {
        this.debug(MessageFormat.format(msg, arg1, arg2, arg3));
    }

    public boolean isDebugEnabled() {
        return this._logger == null ? false : this._logger.isEnabled(Level.DEBUG);
    }

    public boolean isInfoEnabled() {
        return this._logger == null ? false : this._logger.isEnabled(Level.INFO);
    }

    public boolean isWarnEnabled() {
        return this._logger == null ? false : this._logger.isEnabled(Level.WARN);
    }

    public boolean isErrorEnabled() {
        return this._logger == null ? false : this._logger.isEnabled(Level.ERROR);
    }

    public void destroy() {
        if (this._logger == null) {
            return;
        }
        if (this._appender != null) {
            LoggerContext lc = (LoggerContext)LogManager.getContext((boolean)false);
            Configuration config = lc.getConfiguration();
            LoggerConfig loggerConfig = config.getLoggerConfig(this._logger.getName());
            if (loggerConfig.getName().equals(this._logger.getName())) {
                loggerConfig.removeAppender(this._appender.getName());
            }
            lc.updateLoggers();
            this._appender.stop();
        }
        _logInstance = null;
        this._fileName = null;
        this._logger = null;
    }
}

