/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.promotion;

import com.sas.metadata.logical.TransportableTypeInterface;
import com.sas.metadata.logical.TypeInterface;
import com.sas.metadata.promotion.BIPTreeUtil;
import com.sas.metadata.promotion.BatchImporter;
import com.sas.metadata.promotion.ConnectionManager;
import com.sas.metadata.promotion.ConnectionObjectType;
import com.sas.metadata.promotion.ConnectionPointInterface;
import com.sas.metadata.promotion.DefaultImportItem;
import com.sas.metadata.promotion.ImportItemInterface;
import com.sas.metadata.promotion.ImportListener;
import com.sas.metadata.promotion.ImportOperationInterface;
import com.sas.metadata.promotion.ImportSummary;
import com.sas.metadata.promotion.ImportSummaryInterface;
import com.sas.metadata.promotion.ImportUtil;
import com.sas.metadata.promotion.LoggingUtil;
import com.sas.metadata.promotion.MetadataPromotionException;
import com.sas.metadata.promotion.MissingResourceHandler;
import com.sas.metadata.promotion.MissingResourceInterface;
import com.sas.metadata.promotion.NestedImportItemInterface;
import com.sas.metadata.promotion.NoObjectsToImportException;
import com.sas.metadata.promotion.NotificationEvent;
import com.sas.metadata.promotion.ObjectMoveManager;
import com.sas.metadata.promotion.ObjectRenameManager;
import com.sas.metadata.promotion.PromotionHandler;
import com.sas.metadata.promotion.PromotionItemInterface;
import com.sas.metadata.promotion.PromotionPropertiesFile;
import com.sas.metadata.promotion.PromotionUtil;
import com.sas.metadata.promotion.RB;
import com.sas.metadata.promotion.ResponsiblePartyHandler;
import com.sas.metadata.promotion.StatusMessageUtil;
import com.sas.metadata.promotion.UpgradeManager;
import com.sas.metadata.promotion.UserFolderManager;
import com.sas.metadata.promotion.model.ImportElementInterface;
import com.sas.metadata.promotion.model.ImportFolderModelInterface;
import com.sas.metadata.promotion.model.ImportModelConfiguration;
import com.sas.metadata.promotion.model.ModelFactory;
import com.sas.metadata.promotion.persistence.AbstractImportMetadataManager;
import com.sas.metadata.promotion.persistence.ImportMetadataManagementInterface;
import com.sas.metadata.promotion.persistence.ImportMetadataManager_913;
import com.sas.metadata.promotion.persistence.ImportMetadataManager_920;
import com.sas.metadata.promotion.persistence.ImportMetadataManager_930;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SoftwareComponent;
import com.sas.metadata.remote.Tree;
import com.sas.services.ServiceException;
import com.sas.services.TransportException;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.PathUrl;
import com.sas.services.information.metadata.RootFolderInterface;
import com.sas.services.information.publicobject.BasePublicObject;
import com.sas.services.information.publicobject.PublicObjectContainerInterface;
import com.sas.services.information.publicobject.PublicObjectInterface;
import com.sas.services.information.publicobject.TypeDescriptorInterface;
import com.sas.services.information.sasfolders.ContainerNodeInterface;
import com.sas.services.information.sasfolders.FolderNodeInterface;
import com.sas.services.information.sasfolders.PublicObjectNodeInterface;
import com.sas.services.session.SessionContextInterface;
import com.sas.text.Message;
import com.sas.util.UsageVersion;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ImportHandler
extends PromotionHandler
implements ImportOperationInterface {
    protected static final String PRESERVED_FOLDER_PREFIX = "PreservedFolder_";
    private Tree _parentFolder;
    private SoftwareComponent _bipService;
    private boolean _isOldStylePromotion = false;
    private ImportMetadataManagementInterface _metadataManager;
    private ImportFolderModelInterface _importModel = null;
    private ImportSummaryInterface _summary;
    private MdObjectStore _importStore;
    private MissingResourceHandler _resourceHandler;
    private String _targetFolderPath;
    private String _targetContainerPath;
    private PublicObjectContainerInterface _targetContainer;
    private boolean _importingIntoRoot = false;
    private boolean _importSecurity = false;
    private boolean _metadataImported = false;
    private boolean _preservePaths = false;
    private boolean _reposIDChanged = false;
    private boolean _dryRun = false;
    private List<String> _dependentObjects;
    private List _exportedFolderPath;
    private List _exportedFolderPaths;
    private List<ImportItemInterface> _objectsToBeRenamed;
    private int _importType = 0;
    private Set<ImportItemInterface> _deselectedImportItems;
    private Map _deselectedItems;

    public ImportHandler(PublicObjectContainerInterface container, List<String> supportedTypes, int type) throws RemoteException, ServiceException {
        super(supportedTypes, type);
        this._targetContainer = container;
        this.initialize();
        TypeDescriptorInterface typeDesc = this._targetContainer.getTypeDescriptor();
        if (typeDesc == null) {
            throw new ServiceException("Invalid container object");
        }
        if ("RootFolder".equalsIgnoreCase(typeDesc.getTypeName())) {
            this._importingIntoRoot = true;
        }
        this.setRepositoryID(container);
    }

    private void setRepositoryID(PublicObjectContainerInterface container) throws ServiceException, RemoteException {
        String id = this._targetContainer.getIdentifier();
        if (id != null) {
            this._reposID = PromotionUtil.getRepositoryID(id);
        }
        if (this._reposID == null) {
            throw new IllegalStateException(RB.getStringResource("ImportHandler.InvalidRepos.txt"));
        }
    }

    private ImportHandler(MdFactory factory, int type, TypeInterface[] availableTypes) throws RemoteException {
        super(factory, type, availableTypes);
        this.initialize();
        this._isOldStylePromotion = true;
    }

    public ImportHandler(MdFactory factory, com.sas.metadata.logical.FolderInterface folder, int type, TypeInterface[] availableTypes) throws RemoteException {
        this(factory, type, availableTypes);
        this._importStore = factory.createObjectStore(null, "ImportStore");
        if (folder.isRoot()) {
            this._bipService = BIPTreeUtil.getBIPServiceObject(folder, this._importStore);
            this._reposID = PromotionUtil.getRepositoryID((CMetadata)this._bipService);
            this._importingIntoRoot = true;
            if (type == 1) {
                this._log.info(RB.getStringResource("ImportHandler.RootFolder.txt"));
            }
        } else {
            this._parentFolder = BIPTreeUtil.getFolderObject(folder, this._importStore);
            this._reposID = PromotionUtil.getRepositoryID((CMetadata)this._parentFolder);
            if (type == 1) {
                this._log.info(Message.format((ResourceBundle)RB.getResources(), (String)"ImportHandler.ParentFolder.txt", (Object)BIPTreeUtil.getTreePathToDisplay(this._parentFolder)));
            }
        }
    }

    @Override
    public void setSessionContext(SessionContextInterface session, boolean createDetachedTransaction) throws ServiceException, RemoteException {
        super.setSessionContext(session, createDetachedTransaction);
        if (this._isOldStylePromotion) {
            if (this._parentFolder != null) {
                String key = this._parentFolder.getId() + "/" + this._parentFolder.getCMetadataType();
                FolderInterface folder = (FolderInterface)this._server.fetch(key, true);
                if (folder == null) {
                    throw new ServiceException("Unable to retrieve folder from the server.");
                }
                this._targetContainer = folder;
            } else if (this._bipService != null) {
                this._targetContainer = this._server.getRootFolder();
            }
        }
    }

    @Override
    protected void initialize() {
        super.initialize();
        this._resourceHandler = new MissingResourceHandler();
        this._summary = new ImportSummary();
    }

    @Override
    public ImportFolderModelInterface getImportModel() {
        return this._importModel;
    }

    @Override
    public ImportMetadataManagementInterface getMetadataManager() {
        return this._metadataManager;
    }

    @Override
    protected boolean isSecurityIncluded() {
        return this._importSecurity;
    }

    public void changeRepositoryID(String repositoryID) {
        this._reposID = repositoryID;
        this._reposIDChanged = true;
    }

    @Override
    public boolean hasRepositoryChanged() {
        return this._reposIDChanged;
    }

    @Override
    public int getImportType() {
        return this._importType;
    }

    public void setImportType(int type) {
        this._importType = type;
    }

    public void setPreservePaths(boolean preserve) {
        this._preservePaths = preserve && this._importingIntoRoot;
    }

    @Override
    public boolean isPreservingPaths() {
        return this._preservePaths;
    }

    protected void setDryRun(boolean value) {
        this._dryRun = value;
    }

    @Override
    public MissingResourceHandler getResourceHandler() {
        return this._resourceHandler;
    }

    @Override
    public boolean importIntoRoot() {
        return this._importingIntoRoot;
    }

    @Override
    public String getTargetContainerPath() {
        return this._targetContainerPath;
    }

    @Override
    public PublicObjectContainerInterface getTargetContainer() {
        return this._targetContainer;
    }

    @Override
    public List<ImportItemInterface> getFoldersImporting() {
        ArrayList<ImportItemInterface> folders = new ArrayList<ImportItemInterface>();
        if (this._metadataManager == null) {
            return folders;
        }
        List<? extends PromotionItemInterface> items = this._metadataManager.getPromotionItems();
        for (PromotionItemInterface promotionItemInterface : items) {
            if (!(promotionItemInterface instanceof ImportItemInterface) || !"Folder".equalsIgnoreCase(promotionItemInterface.getTypeInterface().getPublicType())) continue;
            folders.add((ImportItemInterface)promotionItemInterface);
        }
        return folders;
    }

    @Override
    public ImportListener getImportListener(String logicalType) {
        TransportableTypeInterface type = (TransportableTypeInterface)this._supportedTypesMap.get(logicalType);
        return type == null ? null : (ImportListener)type.getImportListener();
    }

    @Override
    public ImportItemInterface createImportItem(String name, String publicType, String id) {
        ImportItemInterface item = (ImportItemInterface)this.getPromotionItem(id);
        if (item != null) {
            return item;
        }
        TransportableTypeInterface type = this.getTransportableType(publicType);
        if (type != null) {
            ImportListener listener = (ImportListener)type.getImportListener();
            item = listener != null ? listener.createImportItem(name, id, type) : new DefaultImportItem(name, id, type);
            item.setImportOperation(this);
        }
        return item;
    }

    @Override
    public ImportItemInterface getImportItem(String id) {
        return (ImportItemInterface)this.getPromotionItem(id);
    }

    @Override
    public ImportItemInterface getImportItem(String id, String publicType) {
        return (ImportItemInterface)this.getPromotionItem(id);
    }

    @Override
    public List getImportItems(String publicType) {
        return this.getPromotionItems(publicType);
    }

    @Override
    protected String getOriginalObjectName(PromotionItemInterface item) {
        if (item instanceof ImportItemInterface) {
            return ((ImportItemInterface)item).getOriginalName();
        }
        return item.getName();
    }

    public void clearImportItems() {
        this.clearPromotionItems();
    }

    public void setImportItems(Map importMap) {
        this.setPromotionItems(importMap);
    }

    @Override
    public Map getImportItems() {
        return this._selectedObjects == null ? new HashMap() : this._selectedObjects;
    }

    public void setDeselectedItems(Map deselectedItemsMap) {
        this._deselectedItems = deselectedItemsMap;
    }

    @Override
    public Map getDeselectedItems() {
        if (this._deselectedImportItems != null) {
            LinkedHashMap<String, ArrayList<ImportItemInterface>> importItems = new LinkedHashMap<String, ArrayList<ImportItemInterface>>();
            try {
                for (ImportItemInterface importItem : this._deselectedImportItems) {
                    String publicType = importItem.getTypeInterface().getPublicType();
                    ArrayList<ImportItemInterface> items = (ArrayList<ImportItemInterface>)importItems.get(publicType);
                    if (items == null) {
                        items = new ArrayList<ImportItemInterface>();
                        importItems.put(publicType, items);
                    }
                    items.add(importItem);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return importItems;
        }
        return null;
    }

    private void setDeselectedImportItems(Set<ImportItemInterface> deselectedItems) {
        this._deselectedImportItems = deselectedItems;
    }

    public void importSecurityMetadata(boolean importSecurity) {
        this._importSecurity = importSecurity;
    }

    @Override
    public boolean isSecurityMetadataIncluded() {
        return this._importSecurity;
    }

    @Override
    public List<String> getExportedDependentObjects() {
        return this._dependentObjects;
    }

    @Override
    public List getExportedFolderPath() {
        return this._exportedFolderPath == null ? null : new ArrayList(this._exportedFolderPath);
    }

    @Override
    public List getExportedFolderPaths() {
        return this._exportedFolderPaths == null ? null : new ArrayList(this._exportedFolderPaths);
    }

    @Override
    public Map<String, String> getTargetObjectIDs() {
        if (this._selectedObjects != null && this._metadataImported) {
            HashMap<String, String> targetIDMap = new HashMap<String, String>();
            List items = this.getAllItemsInMap(this._selectedObjects);
            for (ImportItemInterface item : items) {
                if (item.getTargetID() == null) continue;
                targetIDMap.put(item.getTargetID(), item.getTypeInterface().getMetadataType());
            }
            return targetIDMap;
        }
        return null;
    }

    @Override
    public ImportSummaryInterface getImportSummary() {
        return this._summary;
    }

    private void resetImportProcess(boolean newPackageFile) {
        if (newPackageFile) {
            this._exportedFolderPath = null;
            this._exportedFolderPaths = null;
        }
        this.clearImportItems();
        this._connectionTypes = null;
        this._securityType = null;
        if (this._deselectedItems != null) {
            this._deselectedItems.clear();
        }
    }

    @Override
    public void dispose() {
        block8: {
            this.fireNotification(new NotificationEvent(this, this, 200));
            super.dispose();
            if (this._importStore != null) {
                try {
                    this._importStore.dispose();
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
            try {
                for (PublicObjectInterface po : this._summary.getImportedObjects()) {
                    if (!(po instanceof BasePublicObject)) continue;
                    ((BasePublicObject)po).setServer(null);
                }
            }
            catch (Exception e) {
                if (this._log == null || !this._log.isDebugEnabled()) break block8;
                this._log.debug("Error updating summary items");
            }
        }
        if (this._metadataManager instanceof AbstractImportMetadataManager) {
            ((AbstractImportMetadataManager)this._metadataManager).dispose();
        }
        this._contentHandler.closePackage();
        ObjectRenameManager.getInstance(this).dispose();
        ObjectMoveManager.getInstance(this).dispose();
        UserFolderManager.getInstance(this).dispose();
        this._importModel = null;
        if (this._log != null) {
            this._log.destroy();
        }
    }

    public int runImport() throws Exception {
        return this.runImport(0);
    }

    public int runImport(int autoMapState) throws Exception {
        int rc = 0;
        long startTime = 0L;
        long endTime = 0L;
        if (this._selectedObjects != null && this._selectedObjects.size() > 0) {
            this._log.info(RB.getStringResource("ImportHandler.Begin.Log.txt"));
            if (this.isBatchProcess()) {
                this._log.info(RB.getStringResource("PromotionHandler.Batch.txt"));
            }
            if (this._log.isInfoEnabled()) {
                startTime = System.currentTimeMillis();
            }
            if (this._resourceHandler.getResourceCount() > 0) {
                rc |= 4;
            }
            rc |= this.importMetadata(autoMapState);
            if (this._dryRun) {
                return rc;
            }
            if (!this._metadataImported) {
                throw new MetadataPromotionException(RB.getStringResource("ImportHandler.InvalidState.NoMetadata.txt"));
            }
            rc |= this.upgradeObjects();
            rc |= this._propManager.importSubstitutions();
            rc |= this.updateImportedItems();
            rc |= this.importContent();
            if (this._log.isInfoEnabled()) {
                String command;
                if (this.getPromotionType() == 1 && !this.isBatchProcess() && (command = BatchImporter.generateBatchCommand(this)) != null && command.length() > 0) {
                    StringBuilder sb = new StringBuilder();
                    sb.append(RB.getStringResource("ImportHandler.BatchCommand.txt"));
                    sb.append("\r\n");
                    sb.append(RB.getStringResource("ImportHandler.BatchCommand2.txt"));
                    sb.append("\r\n").append("\r\n");
                    sb.append(command);
                    sb.append("\r\n");
                    this._log.info(sb.toString());
                }
                endTime = System.currentTimeMillis();
                this._log.info(Message.format((ResourceBundle)RB.getResources(), (String)"ImportHandler.TotalTime.txt", (Object)new Double((double)(endTime - startTime) / 1000.0)));
            }
        }
        return rc;
    }

    private int importMetadata(int autoMapState) throws MetadataPromotionException, ServiceException, MdException, RemoteException {
        NotificationEvent event = new NotificationEvent(this, this, 205);
        this.fireNotification(event);
        int rc = 0;
        ConnectionManager connectionManager = (ConnectionManager)this._metadataManager.getConnectionManager();
        connectionManager.resetReturnCode();
        if (autoMapState == 3) {
            if (this._propManager.loadedSubstitutionProperties()) {
                this._propManager.readConnections();
            } else {
                autoMapState = 2;
            }
        }
        rc |= UserFolderManager.getInstance(this).createUserFoldersOnServer();
        rc |= connectionManager.resolveConnections(this, autoMapState);
        rc |= this._propManager.validateSubstitutions();
        if (this._log.isInfoEnabled()) {
            String str = LoggingUtil.displayImportedObjects(this._selectedObjects, this._server, true);
            this._log.info(Message.format((ResourceBundle)RB.getResources(), (String)"ImportHandler.ImportingObjects.Log.txt", (Object)str));
            String mappings = LoggingUtil.displayConnectionMapping(this);
            if (mappings.length() > 0) {
                this._log.info(Message.format((ResourceBundle)RB.getResources(), (String)"ImportHandler.ConnectionMappings.txt", (Object)mappings));
            }
            this._log.info(RB.getStringResource("ImportHandler.BeginMetadata.Log.txt"));
        }
        if (this._dryRun) {
            this._log.debug("noExecute option specified, aborting import");
            return rc;
        }
        rc |= this.updateConnectionPoints();
        if (this._log.isDebugEnabled()) {
            this._log.debug("Renaming objects (if necessary)");
        }
        ObjectRenameManager renameManager = ObjectRenameManager.getInstance(this);
        rc |= renameManager.performRenameOperation(this._objectsToBeRenamed);
        if (this._importSecurity) {
            this._log.info(RB.getStringResource("ImportHandler.ImportSecurity.txt"));
        } else {
            this._log.debug("Removing security metadata from the import request.");
        }
        this._metadataManager.importMetadata();
        if (ObjectMoveManager.instanceCreated(this)) {
            ObjectMoveManager moveManager = ObjectMoveManager.getInstance(this);
            rc |= moveManager.moveOrphanedObjects();
        }
        this._log.info(RB.getStringResource("ImportHandler.MetadataImportSuccess.txt"));
        this._metadataImported = true;
        return rc;
    }

    private int upgradeObjects() throws MetadataPromotionException {
        int rc = 0;
        int version = this.getPackageFileVersion();
        if (version < 9200) {
            this._log.info(RB.getStringResource("ImportHandler.UpgradingObjects.txt"));
            UpgradeManager upgrade = UpgradeManager.getInstance();
            rc = upgrade.upgradeObjects(this._selectedObjects, this);
        }
        return rc;
    }

    public int fireAnalyzeObjects() throws MetadataPromotionException {
        int rc = 0;
        if (this._selectedObjects == null || this._selectedObjects.size() == 0) {
            return rc;
        }
        this._log.info(RB.getStringResource("ImportHandler.BeginAnalyze.Log.txt"));
        this.initializeListeners();
        this._resourceHandler.clearResources();
        this._propManager.getSubstitutions();
        if (this._supportedTypesMap.size() > 0) {
            try {
                for (String type : this._selectedObjects.keySet()) {
                    List objects = (List)this._selectedObjects.get(type);
                    TransportableTypeInterface pt = (TransportableTypeInterface)this._supportedTypesMap.get(type);
                    if (pt == null) continue;
                    ImportListener listener = (ImportListener)pt.getImportListener();
                    if (objects == null || listener == null) continue;
                    String statusMessage = StatusMessageUtil.createDefaultAnalyzingMessage((TypeInterface)pt);
                    this.fireDisplayMessageForListener(listener, statusMessage);
                    if (this._log.isInfoEnabled()) {
                        this._log.info(Message.format((ResourceBundle)RB.getResources(), (String)"ImportHandler.Analyze.Log.txt", (Object)pt.getDisplayType()));
                    }
                    rc |= listener.analyzeObjectsToImport(this, objects);
                }
                this._propManager.addCustomDefinedSubstitutions();
                if (this._resourceHandler.getResourceCount() > 0) {
                    this._log.warn(RB.getStringResource("ImportHandler.MissingResources.txt"));
                    Map resources = this._resourceHandler.getMissingResources();
                    for (String path : resources.keySet()) {
                        MissingResourceInterface resource = (MissingResourceInterface)resources.get(path);
                        List objectList = resource.getDependentObjects();
                        if (objectList != null && objectList.size() == 1) {
                            ImportItemInterface item = (ImportItemInterface)objectList.get(0);
                            String objectType = item.getTypeInterface().getDisplayType();
                            this._log.warn(Message.format((ResourceBundle)RB.getResources(), (String)"ImportHandler.MissingResourceForObject.fmt.txt", (Object)resource.getType(), (Object)path, (Object)objectType, (Object)item.toString()));
                            continue;
                        }
                        this._log.warn(Message.format((ResourceBundle)RB.getResources(), (String)"ImportHandler.MissingResource.fmt.txt", (Object)resource.getType(), (Object)path));
                    }
                }
            }
            catch (Exception e) {
                if (this._log.isDebugEnabled()) {
                    this._log.debug((Object)"Analyze exception:", e);
                }
                throw new MetadataPromotionException(e);
            }
        }
        return rc;
    }

    private void initializeListeners() {
        if (this._supportedTypesMap.size() > 0) {
            for (Map.Entry entry : this._supportedTypesMap.entrySet()) {
                TransportableTypeInterface type = (TransportableTypeInterface)entry.getValue();
                ImportListener listener = (ImportListener)type.getImportListener();
                if (listener == null) continue;
                listener.initialize(this);
            }
        }
    }

    private int updateConnectionPoints() throws MetadataPromotionException {
        int rc = 0;
        if (this._supportedTypesMap.size() > 0) {
            for (String type : this._selectedObjects.keySet()) {
                List objects = (List)this._selectedObjects.get(type);
                TransportableTypeInterface pt = (TransportableTypeInterface)this._supportedTypesMap.get(type);
                if (pt == null) continue;
                ArrayList connections = new ArrayList();
                ImportListener listener = (ImportListener)pt.getImportListener();
                if (objects == null || listener == null) continue;
                rc |= listener.updateConnectionPoints(this, objects, connections);
            }
        }
        return rc;
    }

    private int updateImportedItems() throws MetadataPromotionException {
        NotificationEvent event = new NotificationEvent(this, this, 220);
        this.fireNotification(event);
        this._log.info(RB.getStringResource("ImportHandler.BeginUpdate.Log.txt"));
        int rc = 0;
        if (this._supportedTypesMap.size() > 0) {
            for (String type : this._selectedObjects.keySet()) {
                List objects = (List)this._selectedObjects.get(type);
                TransportableTypeInterface pt = (TransportableTypeInterface)this._supportedTypesMap.get(type);
                if (pt == null) continue;
                ImportListener listener = (ImportListener)pt.getImportListener();
                if (objects == null || listener == null) continue;
                String statusMessage = StatusMessageUtil.createDefaultUpdatingMessage((TypeInterface)pt);
                this.fireDisplayMessageForListener(listener, statusMessage);
                if (this._log.isInfoEnabled()) {
                    this._log.info(Message.format((ResourceBundle)RB.getResources(), (String)"ImportHandler.Updating.Log.txt", (Object)pt.getDisplayType()));
                }
                rc |= listener.updateObjects(this, objects);
            }
            rc |= this.updateResponsibleParties();
        }
        return rc;
    }

    private int updateResponsibleParties() {
        try {
            ResponsiblePartyHandler rpHandler = new ResponsiblePartyHandler(this);
            if (this.getPromotionType() == 1) {
                rpHandler.setLogWarnings(false);
            }
            return rpHandler.connectResponsibleParties(this._selectedObjects);
        }
        catch (Exception e) {
            String errorMsg = Message.format((ResourceBundle)RB.getResources(), (String)"ImportHandler.RespParties.GeneralError.txt", (Object)e.getMessage());
            this._log.error(errorMsg);
            this._log.debug((Object)"Failure updating responsible parties", e);
            return 8;
        }
    }

    private int importContent() throws TransportException, IOException {
        NotificationEvent event = new NotificationEvent(this, this, 230);
        this.fireNotification(event);
        int rc = 0;
        this._log.info(RB.getStringResource("ImportHandler.BeginContent.Log.txt"));
        if (this._supportedTypesMap.size() > 0) {
            for (String type : this._selectedObjects.keySet()) {
                List objects = (List)this._selectedObjects.get(type);
                TransportableTypeInterface pt = (TransportableTypeInterface)this._supportedTypesMap.get(type);
                if (pt == null) continue;
                ImportListener listener = (ImportListener)pt.getImportListener();
                if (objects == null || listener == null) continue;
                if (this._log.isInfoEnabled()) {
                    this._log.info(Message.format((ResourceBundle)RB.getResources(), (String)"ImportHandler.Content.Log.txt", (Object)pt.getDisplayType()));
                }
                rc |= listener.importContent(this, objects);
            }
        }
        return rc;
    }

    public int loadExportPackage(String packageFileName) throws MetadataPromotionException, TransportException, RemoteException {
        if (packageFileName == null || packageFileName.length() == 0) {
            String msg = RB.getStringResource("ImportHandler.NoFile.txt");
            throw new TransportException(msg);
        }
        return this.loadExportPackage(new File(packageFileName));
    }

    public int loadExportPackage(File packageFile) throws MetadataPromotionException, TransportException, RemoteException {
        int rc = 0;
        this._packageVersion = -1;
        try {
            if (this._log.isDebugEnabled()) {
                this._log.debug("Reading package file");
            }
            this._packageFile = packageFile;
            if (this._packageFile == null || !this._packageFile.exists()) {
                String msg = Message.format((ResourceBundle)RB.getResources(), (String)"ImportHandler.FileNotFound.fmt.txt", (Object)this._packageFile.getAbsolutePath());
                throw new TransportException(msg);
            }
            String packageFileName = this._packageFile.getName();
            String extension = packageFileName.substring(packageFileName.lastIndexOf(46), packageFileName.length());
            if (!extension.equalsIgnoreCase(".spk")) {
                String msg = Message.format((ResourceBundle)RB.getResources(), (String)"ImportHandler.InvalidFileType.txt", (Object)packageFileName);
                throw new TransportException(msg);
            }
            this._log.info(Message.format((ResourceBundle)RB.getResources(), (String)"ImportHandler.SelectedFile.Log.txt", (Object)packageFile.getAbsolutePath()));
            if (this.getPromotionType() == 1) {
                if (this._importingIntoRoot) {
                    this._log.info(RB.getStringResource("ImportHandler.RootFolder.txt"));
                } else if (this._targetContainer != null) {
                    String path = this._targetContainer.getName();
                    PathUrl pathUrl = this._targetContainer.getPathUrl();
                    if (pathUrl != null) {
                        path = pathUrl.getDisplayPath();
                    }
                    this._log.info(Message.format((ResourceBundle)RB.getResources(), (String)"ImportHandler.ParentFolder.txt", (Object)path));
                }
            }
            this.resetImportProcess(true);
            super.registerTypes();
            if (this._log.isDebugEnabled()) {
                this._log.debug("Loading metadata in package");
            }
            this._contentHandler.loadExistingPackage(this._packageFile);
            int version = this.getPackageFileVersion();
            switch (version) {
                case -1: {
                    throw new TransportException(RB.getStringResource("ImportHandler.InvalidPackageFile.txt"));
                }
                case 9300: {
                    this._metadataManager = new ImportMetadataManager_930(this);
                    break;
                }
                case 9200: {
                    this._metadataManager = new ImportMetadataManager_920(this);
                    break;
                }
                default: {
                    this._metadataManager = new ImportMetadataManager_913(this);
                    this._packageVersion = version = this._metadataManager.getPackageFileVersion();
                }
            }
            this._log.info(Message.format((ResourceBundle)RB.getResources(), (String)"ImportHandler.PackageFileVersion.fmt.txt", (Object)String.valueOf(version)));
            if (!this._metadataManager.isPackageValid()) {
                throw new TransportException(RB.getStringResource("ImportHandler.InvalidPackageFile.txt"));
            }
            this.loadPackageProperties();
            this._metadataManager.loadPackageMetadata();
            this.addObjectsSelectedListener((ConnectionManager)this.getConnectionManager());
            this.parseImportSettings();
            this.fireNotification(new NotificationEvent(this, this, 201));
            this._propManager.applyInitialSubstitutions(this._metadataManager.getPromotionItems());
        }
        catch (Exception e) {
            throw new TransportException(e.getMessage());
        }
        return rc |= this._propManager.readProperties();
    }

    private void parseImportSettings() throws MetadataPromotionException {
        String userData;
        int version;
        if (this._log.isDebugEnabled()) {
            this._log.debug("Parsing import settings");
        }
        if ((version = this.getPackageFileVersion()) >= 9200) {
            String exportFolder;
            if (this._propertiesFile.containsKey("DependentObjects")) {
                this._dependentObjects = new ArrayList<String>();
                String s = this._propertiesFile.getProperty("DependentObjects");
                StringTokenizer st = new StringTokenizer(s, ",");
                while (st.hasMoreTokens()) {
                    this._dependentObjects.add(st.nextToken());
                }
            }
            if ((exportFolder = this.getPropertiesFile().getProperty("ExportFolder")) != null) {
                this._exportedFolderPath = BIPTreeUtil.getFolderPathAsList(exportFolder);
            } else {
                this._exportedFolderPaths = new ArrayList();
                PromotionPropertiesFile props = this.getPropertiesFile();
                Set keys = props.getPropertyKeys();
                for (String key : keys) {
                    String value;
                    if (key.indexOf("ExportFolders") <= -1 || (value = props.getProperty(key)) == null || value.length() <= 0) continue;
                    this._exportedFolderPaths.add(BIPTreeUtil.getFolderPathAsList(value));
                }
            }
        } else if (this._metadataManager instanceof ImportMetadataManager_913 && (userData = ((ImportMetadataManager_913)this._metadataManager).getUserDefinedData()) != null && userData.length() > 0) {
            int endIndex;
            int endIndex2;
            String DEPENDENT_OBJECTS_TAG = "<DependentObjects Objects=\"";
            int index = userData.indexOf("<DependentObjects Objects=\"");
            if (index > -1 && (endIndex2 = userData.indexOf("\"", index += "<DependentObjects Objects=\"".length())) > index) {
                String objects = userData.substring(index, endIndex2);
                this._dependentObjects = new ArrayList<String>();
                StringTokenizer st = new StringTokenizer(objects, ",");
                while (st.hasMoreTokens()) {
                    this._dependentObjects.add(st.nextToken());
                }
            }
            String FOLDER_PATH = "<TreePath>";
            index = userData.indexOf("<TreePath>");
            if (index > -1 && (endIndex = userData.indexOf("</TreePath>", index += "<TreePath>".length())) > index) {
                String path = userData.substring(index, endIndex);
                int pathIndex = -1;
                int startIndex = -1;
                String searchString = "<Name>";
                while ((pathIndex = path.indexOf(searchString, startIndex)) > -1) {
                    int end;
                    if (this._exportedFolderPath == null) {
                        this._exportedFolderPath = new ArrayList();
                    }
                    if ((end = path.indexOf("</", pathIndex)) <= pathIndex) continue;
                    String pathEntry = path.substring(pathIndex + searchString.length(), end);
                    this._exportedFolderPath.add(pathEntry);
                    startIndex = end;
                    searchString = "<ParentName>";
                }
                if (this._exportedFolderPath != null && this._exportedFolderPath.size() > 1) {
                    Collections.reverse(this._exportedFolderPath);
                }
            }
        }
    }

    private void loadPackageProperties() {
        File propFile = null;
        try {
            propFile = this._contentHandler.getFileFromPackage(this._propertiesFile.getFileName());
            if (propFile != null) {
                FileInputStream is = new FileInputStream(propFile);
                this._propertiesFile.read(is);
            }
        }
        catch (Exception e) {
            this._log.debug((Object)"Unable to read properties file.", e);
        }
        finally {
            if (propFile != null) {
                propFile.delete();
            }
        }
    }

    @Override
    public Map getAssociationsForObject(PromotionItemInterface promotionItem, String template) throws MetadataPromotionException {
        return this._metadataManager.getAssociationsForObject(promotionItem, template);
    }

    @Override
    public Map getAssociationsForObjects(List promotionItems, String template) throws MetadataPromotionException {
        return this._metadataManager.getAssociationsForObjects(promotionItems, template);
    }

    public void loadObjectsToImport(boolean overwrite) throws ServiceException, MetadataPromotionException {
        try {
            ImportFolderModelInterface importModel = ModelFactory.createImportFolderModel(this);
            ImportModelConfiguration config = (ImportModelConfiguration)importModel.getConfiguration();
            config.setAllowObjectOverwrites(overwrite);
            importModel.populateModel(this._metadataManager.getPromotionItems(), this._targetContainer);
            List<ImportElementInterface> importItems = importModel.getImportElements();
            this.loadObjectsToImport(importModel, importItems);
            if (this.isImportingDuplicates(importModel)) {
                String msg = this.getPromotionType() == 1 ? RB.getStringResource("ImportHandler.DuplicateNames.txt") : RB.getStringResource("ImportHandler.DuplicateNames.CopyPaste.txt");
                throw new MetadataPromotionException(msg);
            }
        }
        catch (NoObjectsToImportException e) {
            throw e;
        }
        catch (ServiceException e) {
            throw new MetadataPromotionException(e);
        }
        catch (RemoteException re) {
            throw new MetadataPromotionException(re);
        }
        if (this._selectedObjects != null && this._selectedObjects.size() == 0) {
            throw new NoObjectsToImportException(RB.getStringResource("ImportHandler.NoObjectsToImport.txt"));
        }
    }

    public void loadObjectsToImport(ImportFolderModelInterface model, List<ImportElementInterface> selectedItems) throws MetadataPromotionException {
        this._importModel = model;
        if (model.getRenamedObjects() != null) {
            this._objectsToBeRenamed = model.getRenamedObjects();
        }
        LinkedHashMap<String, ArrayList<ImportItemInterface>> importMap = new LinkedHashMap<String, ArrayList<ImportItemInterface>>();
        try {
            ContainerNodeInterface target;
            PathUrl path;
            for (ImportElementInterface importNode : selectedItems) {
                ImportItemInterface importItem = importNode.getImportItem();
                if (importItem == null) continue;
                String publicType = importItem.getTypeInterface().getPublicType();
                ArrayList<ImportItemInterface> items = (ArrayList<ImportItemInterface>)importMap.get(publicType);
                if (items == null) {
                    items = new ArrayList<ImportItemInterface>();
                    importMap.put(publicType, items);
                }
                items.add(importItem);
            }
            this.resetImportProcess(false);
            this.fireObjectsSelected(importMap);
            this.handleDeselectedItems(model, selectedItems);
            this.setImportItems(importMap);
            if (!importMap.isEmpty()) {
                this.verifySelectedObjects();
                this._metadataManager.initializeRepositoryMappings();
            }
            if ((path = (target = model.getTargetContainer()).getPathUrl()) != null) {
                this._targetContainerPath = "RootFolder".equalsIgnoreCase(target.getTypeDescriptor().getTypeName()) ? path.getDisplayPath() : path.getAbsolutePath();
                if (target instanceof FolderNodeInterface) {
                    this._targetFolderPath = path.getDisplayPath();
                }
            }
        }
        catch (MetadataPromotionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MetadataPromotionException(e);
        }
    }

    private void verifySelectedObjects() throws MetadataPromotionException {
        if (this.getPackageFileVersion() < 9200) {
            this.validateContentsInOlderPackage();
        }
        if (this.isProjectRepository()) {
            List items = this.getAllPromotionItems();
            for (ImportItemInterface item : items) {
                String thisReposID;
                String targetID;
                if (item.getImportState() != 2 || (targetID = item.getTargetID()) == null || (thisReposID = PromotionUtil.getRepositoryID(targetID)).equalsIgnoreCase(this._reposID)) continue;
                String type = item.getTypeInterface().getDisplayType();
                String msg = Message.format((ResourceBundle)RB.getResources(), (String)"ImportHandler.ProjectRepos.NoUpdate.fmt.txt", (Object)type, (Object)item.getName());
                throw new MetadataPromotionException(msg);
            }
        }
    }

    private boolean isImportingDuplicates(ImportFolderModelInterface model) throws MetadataPromotionException {
        List<PublicObjectNodeInterface> duplicateNamedObjects = model.getDuplicateNamedObjects();
        if (duplicateNamedObjects != null && !duplicateNamedObjects.isEmpty()) {
            try {
                for (PublicObjectNodeInterface node : duplicateNamedObjects) {
                    ImportItemInterface importItem;
                    ImportElementInterface element = (ImportElementInterface)node.getProcessorInterface("com.sas.metadata.promotion.model.ImportElementInterface");
                    if (element == null || (importItem = element.getImportItem()) == null || importItem.getImportState() == 0) continue;
                    return true;
                }
            }
            catch (Exception e) {
                throw new MetadataPromotionException(e);
            }
        }
        return false;
    }

    private void validateContentsInOlderPackage() throws MetadataPromotionException {
        int packageVersion = this.getPackageFileVersion();
        if (packageVersion < 9200 && this._selectedObjects != null && this._metadataManager instanceof ImportMetadataManager_913 && !((ImportMetadataManager_913)this._metadataManager).containsHotfix()) {
            String[] types = PromotionUtil.DI_TYPES_REQUIRING_HOTFIX;
            for (int i = 0; i < types.length; ++i) {
                String type = types[i];
                if (!this._selectedObjects.containsKey(type)) continue;
                this._log.error(RB.getStringResource("ImportHandler.HotfixLocation.txt"));
                String msg = RB.getStringResource("ImportHandler.InvalidPackage.NoHotfix.txt");
                throw new MetadataPromotionException(msg);
            }
            if (this._selectedObjects.containsKey("StoredProcess") && packageVersion == 9134) {
                List objects = (List)this._selectedObjects.get("StoredProcess");
                UsageVersion oldVersion = new UsageVersion(0, 0);
                ArrayList<String> attr = new ArrayList<String>(1);
                attr.add("UsageVersion");
                for (ImportItemInterface item : objects) {
                    String targetID;
                    if (item.getImportState() != 2 || (targetID = item.getTargetID()) == null) continue;
                    String metadataType = item.getTypeInterface().getMetadataType();
                    try {
                        Root meta = (Root)this._factory.getOMIUtil().getMetadataAllDepths((MdStore)this._store, metadataType, targetID, attr, null, "", 0);
                        UsageVersion version = UsageVersion.decode((double)meta.getUsageVersion());
                        if (!version.equals((Object)oldVersion)) continue;
                        this._log.error(RB.getStringResource("ImportHandler.HotfixLocation.txt"));
                        String msg = RB.getStringResource("ImportHandler.CannotOverwriteObject.txt");
                        throw new MetadataPromotionException(msg);
                    }
                    catch (MdException e) {
                        throw new MetadataPromotionException(e);
                    }
                    catch (RemoteException e) {
                        throw new MetadataPromotionException(e);
                    }
                }
            }
        }
    }

    private void handleDeselectedItems(ImportFolderModelInterface model, List<ImportElementInterface> selectedItems) throws ServiceException, RemoteException {
        List<? extends PromotionItemInterface> originalItemsList;
        ArrayList<ImportItemInterface> originalDeselectedItems = null;
        if (this._deselectedImportItems != null) {
            originalDeselectedItems = new ArrayList<ImportItemInterface>(this._deselectedImportItems);
        }
        ArrayList<ImportItemInterface> deseletedList = null;
        if (originalDeselectedItems != null) {
            deseletedList = new ArrayList<ImportItemInterface>(originalDeselectedItems);
        }
        if ((originalItemsList = this._metadataManager.getPromotionItems()).size() == selectedItems.size()) {
            this.setDeselectedImportItems(null);
            if (deseletedList != null) {
                for (ImportItemInterface importItemInterface : deseletedList) {
                    this.objectReselected(importItemInterface);
                }
            }
        } else {
            block1: for (ImportItemInterface importItemInterface : originalItemsList) {
                ImportElementInterface importElement = model.getImportElement(importItemInterface.getID());
                if (importElement == null) {
                    this.objectUnselected(model, null, importItemInterface);
                    continue;
                }
                if (!selectedItems.contains(importElement)) {
                    this.objectUnselected(model, importElement, importItemInterface);
                    continue;
                }
                if (deseletedList == null) continue;
                for (ImportItemInterface deselectedItem : deseletedList) {
                    if (deselectedItem != importItemInterface) continue;
                    this.objectReselected(deselectedItem);
                    continue block1;
                }
            }
            this.setDeselectedItems(this._deselectedItems);
        }
    }

    private void objectUnselected(ImportFolderModelInterface model, ImportElementInterface importElement, ImportItemInterface importItem) throws ServiceException, RemoteException {
        if (importItem == null) {
            return;
        }
        if (this._deselectedImportItems == null) {
            this._deselectedImportItems = new LinkedHashSet<ImportItemInterface>();
        }
        if (!this._deselectedImportItems.contains(importItem)) {
            this._deselectedImportItems.add(importItem);
            if (importElement != null) {
                model.excludeNode(importElement);
            }
            if ("Folder".equalsIgnoreCase(importItem.getTypeInterface().getPublicType())) {
                String targetID = importItem.getTargetID();
                if (targetID != null) {
                    this.addObjectToCache("ResetTargetID:" + importItem.getID(), targetID);
                }
                importItem.setTargetID(null);
                return;
            }
            this.resetNestedItems(importItem, 0);
            this.resetConnection(importItem, true);
        } else if (importElement != null) {
            model.excludeNode(importElement);
        }
    }

    private void objectReselected(ImportItemInterface importItem) throws ServiceException, RemoteException {
        String targetID;
        if (importItem == null) {
            return;
        }
        if ("Folder".equalsIgnoreCase(importItem.getTypeInterface().getPublicType()) && (targetID = (String)this.getObjectFromCache("ResetTargetID:" + importItem.getID())) != null) {
            importItem.setTargetID(targetID);
        }
        this.resetNestedItems(importItem, -1);
        this.resetConnection(importItem, false);
    }

    private void resetNestedItems(ImportItemInterface importItem, int state) {
        if (importItem.containsNestedItems()) {
            List nestedItems = importItem.getNestedItems();
            for (NestedImportItemInterface nestedItem : nestedItems) {
                nestedItem.setImportState(state);
                if (state == -1) {
                    this.resetConnection(nestedItem, false);
                } else if (state == 0) {
                    this.resetConnection(nestedItem, true);
                }
                this.resetNestedItems(nestedItem, state);
            }
        }
    }

    private void resetConnection(ImportItemInterface importItem, boolean active) {
        boolean found = false;
        String id = importItem.getID();
        String metadataType = importItem.getTypeInterface().getMetadataType();
        List<ConnectionPointInterface> connections = this._metadataManager.getConnectionManager().getConnections(ConnectionObjectType.MetadataType, metadataType, true);
        for (ConnectionPointInterface pt : connections) {
            if (!pt.getSourceID().equals(id)) continue;
            if (active && !pt.isActive() || !active && pt.isActive()) {
                pt.setActive(active);
            }
            found = true;
            break;
        }
        if (!found && "Library".equalsIgnoreCase(importItem.getTypeInterface().getPublicType())) {
            List<ConnectionPointInterface> schemaConnections = this._metadataManager.getConnectionManager().getConnections(ConnectionObjectType.MetadataType, "DatabaseSchema", true);
            for (ConnectionPointInterface pt : schemaConnections) {
                try {
                    Document doc = ImportUtil.getObjectDocument(this, id);
                    if (doc == null) continue;
                    Node topLevelNode = doc.getFirstChild();
                    NodeList childNodes = topLevelNode.getChildNodes();
                    for (int i = 0; i < childNodes.getLength(); ++i) {
                        Node childNode = childNodes.item(i);
                        if (!"UsingPackages".equalsIgnoreCase(childNode.getNodeName())) continue;
                        NodeList schemaNodes = childNode.getChildNodes();
                        for (int j = 0; j < schemaNodes.getLength(); ++j) {
                            Node schemaNode = schemaNodes.item(j);
                            NamedNodeMap attrs = schemaNode.getAttributes();
                            Node idNode = attrs.getNamedItem("Id");
                            if (idNode == null || !pt.getSourceID().equalsIgnoreCase(idNode.getNodeValue()) || (!active || pt.isActive()) && (active || !pt.isActive())) continue;
                            pt.setActive(active);
                        }
                    }
                }
                catch (Exception e) {
                    this._log.warn("Unable to reset database schema connections. " + e.getMessage());
                }
            }
        }
    }

    private List getAllItemsInMap(Map map) {
        ArrayList allItems = new ArrayList();
        if (map != null) {
            Collection values = map.values();
            for (List list : values) {
                allItems.addAll(list);
            }
        }
        return allItems;
    }

    public ImportHandler(MdFactory factory, Tree parentFolder, int type, TypeInterface[] availableTypes) throws RemoteException {
        this(factory, type, availableTypes);
        this._parentFolder = parentFolder;
        this._reposID = PromotionUtil.getRepositoryID((CMetadata)parentFolder);
        this._log.info(Message.format((ResourceBundle)RB.getResources(), (String)"ImportHandler.ParentFolder.txt", (Object)BIPTreeUtil.getTreePathToDisplay(parentFolder)));
    }

    public ImportHandler(MdFactory factory, SoftwareComponent bipService, int type, TypeInterface[] availableTypes) throws RemoteException {
        this(factory, type, availableTypes);
        this._bipService = bipService;
        this._reposID = PromotionUtil.getRepositoryID((CMetadata)bipService);
        this._importingIntoRoot = true;
        this._log.info(RB.getStringResource("ImportHandler.RootFolder.txt"));
    }

    @Override
    public void addNameSubstitutions(List importObjects) {
        if (this._objectsToBeRenamed == null) {
            this._objectsToBeRenamed = new ArrayList<ImportItemInterface>(importObjects);
        } else {
            this._objectsToBeRenamed.addAll(importObjects);
        }
    }

    @Override
    public Tree[] getFolderImportingInto() {
        if (this._targetContainer != null) {
            try {
                if (PromotionUtil.isFolder((PublicObjectInterface)this._targetContainer)) {
                    FolderInterface folder = (FolderInterface)PromotionUtil.getSmartObject(this, this._targetContainer.getIdentifier(), this._targetContainer.getTypeDescriptor().getMetadataType());
                    return new Tree[]{(Tree)folder.getRepositoryEntity()};
                }
                if (PromotionUtil.isRootFolder((PublicObjectInterface)this._targetContainer)) {
                    RootFolderInterface rootFolder = this._server.getRootFolder();
                    List topLevelFolders = rootFolder.getSASFolders();
                    Tree[] trees = new Tree[topLevelFolders.size()];
                    for (int index = 0; index < topLevelFolders.size(); ++index) {
                        FolderInterface folder = (FolderInterface)topLevelFolders.get(index);
                        trees[index] = (Tree)folder.getRepositoryEntity();
                    }
                    return trees;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public String getTargetFolderPath() {
        return this._targetFolderPath;
    }
}

