/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.promotion;

import com.sas.metadata.promotion.DependentConnectionInterface;
import com.sas.metadata.promotion.SourceConnectionInterface;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class DependentConnectionMapping {
    private Map _connectionMap = new LinkedHashMap();

    public SourceConnectionInterface getDependentConnection(SourceConnectionInterface child) {
        for (SourceConnectionInterface key : this._connectionMap.keySet()) {
            DependentConnectionInterface parent = (DependentConnectionInterface)this._connectionMap.get(key);
            if (parent == null || !parent.containsChild(child)) continue;
            return parent.getDependentConnection();
        }
        return null;
    }

    public void addDependentConnection(SourceConnectionInterface parent, SourceConnectionInterface child) {
        if (this._connectionMap.containsKey(parent)) {
            DependentConnectionInterface connection = (DependentConnectionInterface)this._connectionMap.get(parent);
            connection.addChildConnection(child);
        } else {
            DependentConnection connection = new DependentConnection(parent);
            connection.addChildConnection(child);
            this._connectionMap.put(parent, connection);
        }
    }

    public void addDependentConnections(SourceConnectionInterface parent, List childList) {
        if (this._connectionMap.containsKey(parent)) {
            DependentConnectionInterface connection = (DependentConnectionInterface)this._connectionMap.get(parent);
            connection.addChildConnections(childList);
        } else {
            DependentConnection connection = new DependentConnection(parent);
            connection.addChildConnections(childList);
            this._connectionMap.put(parent, connection);
        }
    }

    public int size() {
        return this._connectionMap.size();
    }

    public DependentConnectionInterface getDependentConnection(int index) {
        int counter = 0;
        Collection col = this._connectionMap.values();
        for (DependentConnectionInterface connection : col) {
            if (counter == index) {
                return connection;
            }
            ++counter;
        }
        return null;
    }

    public List getDependentConnections() {
        return new ArrayList(this._connectionMap.values());
    }

    class DependentConnection
    implements DependentConnectionInterface {
        private SourceConnectionInterface _parentConnection;
        private List _childList;

        public DependentConnection(SourceConnectionInterface parent) {
            this._parentConnection = parent;
            this._childList = new ArrayList();
        }

        @Override
        public List getChildConnections() {
            return this._childList;
        }

        @Override
        public SourceConnectionInterface getDependentConnection() {
            return this._parentConnection;
        }

        @Override
        public void addChildConnection(SourceConnectionInterface child) {
            if (!this._childList.contains(child)) {
                this._childList.add(child);
            }
        }

        @Override
        public void addChildConnections(List children) {
            this._childList.addAll(children);
        }

        @Override
        public int getChildCount() {
            return this._childList.size();
        }

        @Override
        public boolean containsChild(SourceConnectionInterface child) {
            return this._childList.contains(child);
        }
    }
}

